<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CB\Database\Table\UserTable;
use CBLib\Language\CBTxt;
use CB\Plugin\Activity\CBActivity;
use CB\Plugin\Activity\Table\ActivityTable;
use CB\Plugin\Activity\Activity;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * @var ActivityTable[]   $rows
 * @var cbPageNav         $pageNav
 * @var UserTable         $viewer
 * @var Activity          $stream
 * @var CBplug_cbactivity $this
 * @var string            $output
 *
 * @var string            $rowsHashtag
 * @var string            $rowsFilter
 * @var string            $rowsSearch
 * @var array             $integrations
 * @var bool              $canCreate
 * @var bool              $searching
 * @var string            $direction
 */

global $_CB_framework, $_PLUGINS;

$autoUpdate				=	false;
$attributes				=	' data-cbactivity-stream="' . htmlspecialchars( $stream->id() ) . '" data-cbactivity-direction="' . htmlspecialchars( $direction ) . '"';

if ( $output !== 'modal' ) {
	if ( ( ! $searching ) && $rows && $stream->getBool( 'auto_update', false ) ) {
		$autoUpdate		=	true;

		$attributes		.=	' data-cbactivity-autoupdate="true"';
	}

	if ( $stream->getBool( 'auto_load', false ) ) {
		$attributes		.=	' data-cbactivity-autoload="true"';
	}
}

$filters				=	$stream->filters();
?>
<div class="<?php echo ( $output === 'modal' ? 'm-2 d-flex flex-column h-100 mh-100 ' : null ); ?>activityStream streamBind streamContainer streamContainer<?php echo htmlspecialchars( ucfirst( $direction ) ) . ( $output === 'modal' ? ' streamContainerModal' : null ); ?> stream<?php echo htmlspecialchars( $stream->id() ); ?>"<?php echo $attributes; ?>>
	<?php echo implode( '', $integrations ); ?>
	<?php if ( $output === 'modal' ) { ?>
	<div class="<?php echo ( $output === 'modal' ? 'flex-shrink-0 ' : null ); ?>row no-gutters activityStreamToolbar streamToolbar">
		<div class="col-12 col-sm text-center text-sm-left">
			<a href="<?php echo $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'activity', 'func' => 'show', 'stream' => $stream->id() ) ); ?>" class="btn btn-light btn-sm border btn-sm-block activityButton activityButtonSeeAll"><?php echo CBTxt::T( 'See All' ); ?></a>
		</div>
		<div class="col-12 col-sm mt-1 mt-sm-0 text-center text-sm-right">
			<a href="javascript:void(0);" class="align-middle activityButton activityButtonClose cbTooltipClose"><span class="fa fa-times"></span> <span class="d-inline-block d-sm-none"><?php echo CBTxt::T( 'Close' ); ?></span></a>
		</div>
	</div>
	<?php } ?>
	<?php if ( ( $direction === 'down' ) && $canCreate ) { ?>
		<?php $this->showActivityEdit( 0, $viewer, $stream, $output ); ?>
	<?php } ?>
	<?php if ( $autoUpdate ) { ?>
	<div class="activityStreamToolbar streamToolbar hidden">
		<a href="javascript: void(0);" data-cbactivity-update-url="<?php echo $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'activity', 'func' => 'update', 'stream' => $stream->id(), 'hashtag' => $rowsHashtag, $pageNav->getInputNamePrefix() . 'filter' => $rowsFilter, $pageNav->getInputNamePrefix() . 'search' => $rowsSearch ), 'raw', 0, true ); ?>" class="btn btn-primary btn-sm activityButton activityButtonUpdate streamUpdate hidden"><span class="fa fa-refresh"></span></a>
	</div>
	<?php } ?>
	<?php if ( $filters ) { ?>
	<div class="p-1 bg-light text-small activityStreamToolbar streamFilters streamToolbar">
		<a href="javascript: void(0);" data-cbactivity-load-url="<?php echo $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'activity', 'func' => 'load', 'stream' => $stream->id(), 'hashtag' => $rowsHashtag, $pageNav->getInputNamePrefix() . 'filter' => 0, $pageNav->getInputNamePrefix() . 'search' => $rowsSearch ), 'raw', 0, true ); ?>" class="activityFilter activityFilter0 streamFilter streamLoad<?php echo ( ! $rowsFilter ? ' text-muted text-plain disabled' : null ); ?>"><?php echo CBTxt::T( 'All' ); ?></a>
		<?php foreach ( $filters as $filterId => $filter ) { ?>
		 - <a href="javascript: void(0);" data-cbactivity-load-url="<?php echo $_CB_framework->pluginClassUrl( 'cbactivity', true, array( 'action' => 'activity', 'func' => 'load', 'stream' => $stream->id(), 'hashtag' => $rowsHashtag, $pageNav->getInputNamePrefix() . 'filter' => $filterId, $pageNav->getInputNamePrefix() . 'search' => $rowsSearch ), 'raw', 0, true ) ?>" class="activityFilter activityFilter<?php echo $filterId; ?> streamFilter streamLoad<?php echo ( $rowsFilter === $filterId ? ' text-muted text-plain disabled' : null ); ?>">
				<?php echo CBuser::getInstance( $stream->user()->getInt( 'id', 0 ), false )->replaceUserVars( $filter['filter'], true, false ); ?>
			</a>
		<?php } ?>
	</div>
	<?php } ?>
	<?php if ( ( $direction === 'up' ) && $stream->getBool( 'paging', true ) && ( $pageNav->total > $pageNav->limit ) ) { ?>
	<div class="activityStreamToolbar streamToolbar streamMoreContainer">
		<a href="javascript: void(0);" data-cbactivity-more-url="<?php echo $pageNav->limitstartUrl( $pageNav->limitstart ); ?>" class="btn btn-info btn-sm btn-block activityButton activityButtonMore streamMore"><?php echo CBTxt::T( 'Previous' ); ?></a>
	</div>
	<?php } ?>
	<div class="<?php echo ( $output === 'modal' ? 'ml-n2 mr-n2 pl-2 pr-2 flex-grow-1 ' : null ); ?>activityStreamItems streamItems"><?php require CBActivity::getTemplate( $stream->getString( 'template' ), 'activity/rows', false ); ?></div>
	<?php if ( ( $direction === 'up' ) && $canCreate ) { ?>
		<?php $this->showActivityEdit( 0, $viewer, $stream, $output ); ?>
	<?php } ?>
	<?php if ( ( $direction === 'down' ) && $stream->getBool( 'paging', true ) && ( $pageNav->total > $pageNav->limit ) ) { ?>
	<div class="activityStreamToolbar streamToolbar streamMoreContainer">
		<a href="javascript: void(0);" data-cbactivity-more-url="<?php echo $pageNav->limitstartUrl( $pageNav->limitstart ); ?>" class="btn btn-info btn-sm btn-block activityButton activityButtonMore streamMore"><?php echo CBTxt::T( 'More' ); ?></a>
	</div>
	<?php } ?>
	<?php echo implode( '', $_PLUGINS->trigger( 'activity_onAfterDisplayActivityStream', array( $rows, $pageNav, $searching, $viewer, $stream, $output ) ) ); ?>
	<?php echo ( in_array( $output, array( 'modal', 'toggle' ), true ) ? CBActivity::reloadHeaders() : null ); ?>
</div>