<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\Activity\Table;

use CBLib\Database\Table\OrderedTable;
use CBLib\Language\CBTxt;
use CBLib\Registry\Registry;
use CBLib\Application\Application;
use CB\Plugin\Activity\CBActivity;

defined('CBLIB') or die();

// Stored Language Strings:
// CBTxt::T( 'Blue' )
// CBTxt::T( 'Purple' )
// CBTxt::T( 'Black' )
// CBTxt::T( 'Flowers' )
// CBTxt::T( 'Love' )
// CBTxt::T( 'Celebrate' )
// CBTxt::T( 'Glitter' )
// CBTxt::T( 'Space' )

class ThemeTable extends OrderedTable
{
	/** @var int  */
	public $id				=	null;
	/** @var string  */
	public $value			=	null;
	/** @var string  */
	public $background		=	null;
	/** @var string  */
	public $class			=	null;
	/** @var int  */
	public $published		=	null;
	/** @var int  */
	public $access			=	null;
	/** @var int  */
	public $ordering		=	null;
	/** @var string  */
	public $params			=	null;

	/** @var Registry  */
	protected $_params		=	null;

	/**
	 * Table name in database
	 *
	 * @var string
	 */
	protected $_tbl			=	'#__comprofiler_plugin_activity_themes';

	/**
	 * Primary key(s) of table
	 *
	 * @var string
	 */
	protected $_tbl_key		=	'id';

	/**
	 * Ordering keys and for each their ordering groups.
	 * E.g.; array( 'ordering' => array( 'tab' ), 'ordering_registration' => array() )
	 * @var array
	 */
	protected $_orderings	=	array( 'ordering' => array() );

	/**
	 * @return bool
	 */
	public function check()
	{
		if ( ! $this->getString( 'value' ) ) {
			$this->setError( CBTxt::T( 'Theme not specified!' ) );

			return false;
		}

		if ( ( ! $this->getString( 'background' ) ) && ( ! $this->getString( 'class' ) ) ) {
			$this->setError( CBTxt::T( 'Background or Class not specified!' ) );

			return false;
		}

		return true;
	}

	/**
	 * @param bool $updateNulls
	 * @return bool
	 */
	public function store( $updateNulls = false )
	{
		global $_PLUGINS;

		$new	=	( ! $this->getInt( 'id', 0 ) );
		$old	=	new self();

		if ( ! $new ) {
			$old->load( $this->getInt( 'id', 0 ) );

			if ( in_array( false, $_PLUGINS->trigger( 'activity_onBeforeUpdateTheme', array( &$this, $old ) ), true ) ) {
				return false;
			}
		} elseif ( in_array( false, $_PLUGINS->trigger( 'activity_onBeforeCreateTheme', array( &$this ) ), true ) ) {
			return false;
		}

		if ( ! parent::store( $updateNulls ) ) {
			return false;
		}

		if ( ! $new ) {
			$_PLUGINS->trigger( 'activity_onAfterUpdateTheme', array( $this, $old ) );
		} else {
			$_PLUGINS->trigger( 'activity_onAfterCreateTheme', array( $this ) );
		}

		return true;
	}

	/**
	 * @param null|int $id
	 * @return bool
	 */
	public function delete( $id = null )
	{
		global $_PLUGINS;

		if ( in_array( false, $_PLUGINS->trigger( 'activity_onBeforeDeleteTheme', array( &$this ) ), true ) ) {
			return false;
		}

		if ( ! parent::delete( $id ) ) {
			return false;
		}

		$_PLUGINS->trigger( 'activity_onAfterDeleteTheme', array( $this ) );

		return true;
	}

	/**
	 * @return Registry
	 */
	public function params()
	{
		if ( ! ( $this->getRaw( '_params' ) instanceof Registry ) ) {
			$this->set( '_params', new Registry( $this->getRaw( 'params' ) ) );
		}

		return $this->getRaw( '_params' );
	}

	/**
	 * @param string|null $sample
	 * @return string
	 */
	public function preview( $sample = null )
	{
		if ( Application::Application()->isClient( 'administrator' ) ) {
			CBActivity::getTemplate();
		}

		$background		=	$this->background();
		$class			=	$this->getString( 'class' );

		return '<div class="streamThemePreview' . ( $class ? ' ' . htmlspecialchars( $class ) : null ) . '"' . ( $background ? ' style="background-image: url(' . htmlspecialchars( $background ) . ')"' : null ) . '>' . $sample . '</div>';
	}

	/**
	 * @return string
	 */
	public function background()
	{
		global $_CB_framework;

		if ( ! $this->getString( 'background' ) ) {
			return null;
		}

		$template		=	CBActivity::getGlobalParams()->getString( 'general_template', 'default' );

		if ( ! $template ) {
			$template	=	'default';
		}

		$background		=	'/components/com_comprofiler/plugin/user/plug_cbactivity/templates/' . $template . '/images/' . $this->getString( 'background' );

		if ( ( $template !== 'default' ) && ( ! file_exists( $_CB_framework->getCfg( 'absolute_path' ) . $background ) ) ) {
			$background	=	'/components/com_comprofiler/plugin/user/plug_cbactivity/templates/default/images/' . $this->getString( 'background' );
		}

		return $_CB_framework->getCfg( 'live_site' ) . $background;
	}
}