<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\Activity\Field;

use CBLib\Application\Application;
use CB\Database\Table\UserTable;
use CB\Database\Table\FieldTable;
use CB\Plugin\Activity\CBActivity;
use CB\Plugin\Activity\Activity;

defined('CBLIB') or die();

class ActivityField extends \cbFieldHandler
{

	/**
	 * Accessor:
	 * Returns a field in specified format
	 *
	 * @param  FieldTable  $field
	 * @param  UserTable   $user
	 * @param  string      $output               'html', 'xml', 'json', 'php', 'csvheader', 'csv', 'rss', 'fieldslist', 'htmledit'
	 * @param  string      $reason               'profile' for user profile view, 'edit' for profile edit, 'register' for registration, 'search' for searches
	 * @param  int         $list_compare_types   IF reason == 'search' : 0 : simple 'is' search, 1 : advanced search with modes, 2 : simple 'any' search
	 * @return mixed
	 */
	public function getField( &$field, &$user, $output, $reason, $list_compare_types )
	{
		if ( $output === 'htmledit' ) {
			return null;
		}

		$asset				=	str_replace( '[field_id]', $field->getInt( 'fieldid', 0 ), $field->params->getString( 'activity_asset' ) );

		if ( ! $asset ) {
			$asset			=	'profile.' . $user->getInt( 'id', 0 ) . '.field.' . $field->getInt( 'fieldid', 0 );
		}

		$activity			=	new Activity( $asset, $user );

		$activity->parse( $field->getRaw( 'params' ), 'activity_' );

		$activity->set( 'field', $field->getInt( 'fieldid', 0 ) );

		$layout				=	$field->params->getString( 'activity_layout', 'stream' );

		if ( ( $output === 'html' ) && ( ( ( $reason === 'list' ) && ( $layout === 'button' ) ) || ( $reason !== 'list' ) ) && ( $layout !== 'count' ) ) {
			if ( ( ! Application::Config()->getInt( 'showEmptyFields', 1 ) ) && ( ! CBActivity::canCreate( 'activity', $activity ) ) && ( ! $activity->rows() ) ) {
				return null;
			}

			if ( in_array( $layout, array( 'button', 'toggle' ), true ) ) {
				$return		=	$activity->activity( 'button' );
			} else {
				$return		=	$activity->activity();
			}

			if ( ! $return ) {
				return null;
			}

			return $this->formatFieldValueLayout( $this->_formatFieldOutput( $field->getString( 'name' ), $return, $output, false ), $reason, $field, $user );
		}

		$return				=	$this->_formatFieldOutput( $field->getString( 'name' ), CBActivity::prefetchAssets( 'activity', array(), $activity ), $output, false );

		if ( $output === 'html' ) {
			$return			=	$this->formatFieldValueLayout( $return, $reason, $field, $user );
		}

		return $return;
	}
}