<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C)2005-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Core\AutoLoader;
use CB\Database\Table\PluginTable;
use CBLib\Registry\Registry;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

AutoLoader::registerExactMap( '%^CB/Plugin/GroupJiveVideo/(.+)%i', __DIR__ . '/library/$1.php' );

function plug_cbgroupjivevideo_install()
{
	// Grab GJ params to migrate the legacy params:
	$plugin				=	new PluginTable();

	$plugin->load( array( 'element' => 'cbgroupjive' ) );

	$pluginParams		=	new Registry( $plugin->getRaw( 'params', array() ) );

	if ( ( ! $pluginParams->has( 'video_captcha' ) ) || ( $pluginParams->getInt( 'video_captcha' ) === null ) ) {
		return;
	}

	// Migrate video integration parameters:
	$video				=	new PluginTable();

	$video->load( array( 'element' => 'cbgroupjivevideo' ) );

	$videoParams		=	new Registry( $video->getRaw( 'params', array() ) );

	if ( $videoParams->getBool( 'migrated', false ) ) {
		return;
	}

	$videoParams->set( 'groups_video_captcha', $pluginParams->getInt( 'video_captcha', 0 ) );
	$videoParams->set( 'groups_video_paging', $pluginParams->getInt( 'video_paging', 0 ) );
	$videoParams->set( 'groups_video_limit', $pluginParams->getInt( 'video_limit' ) );
	$videoParams->set( 'groups_video_search', $pluginParams->getInt( 'video_search', 0 ) );
	$videoParams->set( 'migrated', true );

	$video->set( 'params', $videoParams->asJson() );

	$video->store();
}