<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\ProfileUpdateLogger\Tab;

use CBLib\Application\Application;
use CB\Database\Table\UserTable;
use CB\Database\Table\TabTable;
use CBLib\Language\CBTxt;
use CBLib\Registry\Registry;
use CBLib\Registry\ParamsInterface;
use CB\Plugin\ProfileUpdateLogger\CBProfileUpdateLogger;
use CB\Plugin\ProfileUpdateLogger\Table\UpdateLogTable;

defined('CBLIB') or die();

class UpdateLogTab extends \cbTabHandler
{

	/**
	 * prepare frontend tab render
	 *
	 * @param TabTable  $tab
	 * @param UserTable $user
	 * @param int       $ui
	 * @return null|string
	 */
	public function getDisplayTab( $tab, $user, $ui )
	{
		global $_CB_framework, $_CB_database;

		if ( ! ( $tab->getRaw( 'params' ) instanceof ParamsInterface ) ) {
			$tab->set( 'params', new Registry( $tab->getRaw( 'params' ) ) );
		}

		$viewer						=	\CBuser::getMyUserDataInstance();
		$profileOwner				=	( $viewer->getInt( 'id', 0 ) === $user->getInt( 'id', 0 ) );

		if ( ( ! Application::MyUser()->isGlobalModerator() ) && ( ( ! $profileOwner ) || ( ! $tab->params->getBool( 'pulEnableTabUserView', false ) ) ) ) {
			return null;
		}

		$prefix						=	'tab_log_';
		$canSearch					=	$tab->params->getBool( 'tab_search', true );
		$limit						=	$tab->params->getInt( 'pulEntriesPerPageFE', 20 );
		$limitstart					=	$_CB_framework->getUserStateFromRequest( $prefix . 'limitstart{com_comprofiler}', $prefix . 'limitstart' );
		$search						=	$_CB_framework->getUserStateFromRequest( $prefix . 'search{com_comprofiler}', $prefix . 'search' );
		$where						=	null;

		if ( $search && $canSearch ) {
			$where					.=	"\n AND ( " . $_CB_database->NameQuote( 'fieldname' ) . " LIKE " . $_CB_database->Quote( '%' . $_CB_database->getEscaped( $search, true ) . '%', false )
									.	" OR " . $_CB_database->NameQuote( 'oldvalue' ) . " LIKE " . $_CB_database->Quote( '%' . $_CB_database->getEscaped( $search, true ) . '%', false )
									.	" OR " . $_CB_database->NameQuote( 'newvalue' ) . " LIKE " . $_CB_database->Quote( '%' . $_CB_database->getEscaped( $search, true ) . '%', false ) . " )";
		}

		$searching					=	(bool) $where;

		$query						=	"SELECT COUNT(*)"
									.	"\n FROM " . $_CB_database->NameQuote( '#__comprofiler_plug_pulogger' )
									.	"\n WHERE " . $_CB_database->NameQuote( 'profileid' ) . " = " . $user->getInt( 'id', 0 )
									.	$where;
		$_CB_database->setQuery( $query );
		$total						=	$_CB_database->loadResult();

		if ( ( ! $total ) && ( ! $searching ) && ( ! Application::Config()->getBool( 'showEmptyTabs', true ) ) ) {
			return null;
		}

		if ( $total <= $limitstart ) {
			$limitstart				=	0;
		}

		$pageNav					=	new \cbPageNav( $total, $limitstart, $limit );

		$pageNav->setInputNamePrefix( $prefix );
		$pageNav->setStaticLimit( true );
		$pageNav->setBaseURL( $_CB_framework->userProfileUrl( $user->getInt( 'id', 0 ), false, $tab->getInt( 'tabid', 0 ), 'html', 0, array( $prefix . 'search' => ( $searching ? $search : null ) ) ) );

		$rows						=	array();

		if ( $total ) {
			$query					=	"SELECT *"
									.	"\n FROM " . $_CB_database->NameQuote( '#__comprofiler_plug_pulogger' )
									.	"\n WHERE " . $_CB_database->NameQuote( 'profileid' ) . " = " . $user->getInt( 'id', 0 )
									.	$where
									.	"\n ORDER BY " . $_CB_database->NameQuote( 'changedate' ) . " DESC";
			if ( $tab->params->getBool( 'pulEnablePagingFE', true ) ) {
				$_CB_database->setQuery( $query, $pageNav->limitstart, $pageNav->limit );
			} else {
				$_CB_database->setQuery( $query );
			}
			$rows					=	$_CB_database->loadObjectList( 'id', '\CB\Plugin\ProfileUpdateLogger\Table\UpdateLogTable', array( $_CB_database ) );

			$userIds				=	array();

			/** @var UpdateLogTable[] $rows */
			foreach ( $rows as $row ) {
				$editedBy			=	$row->getInt( 'editedbyid', 0 );

				if ( $editedBy ) {
					$userIds[]		=	$editedBy;
				}
			}

			if ( $userIds ) {
				\CBuser::advanceNoticeOfUsersNeeded( $userIds );
			}
		}

		$input						=	array();
		$input['search_url']		=	$_CB_framework->userProfileUrl( $user->getInt( 'id', 0 ), true, $tab->getInt( 'tabid', 0 ) );
		$input['search']			=	'<input type="text" name="' . htmlspecialchars( $prefix ) . 'search" value="' . htmlspecialchars( $search ) . '" placeholder="' . htmlspecialchars( CBTxt::T( 'Search Changes...' ) ) . '" class="form-control" />';
		$input['paging']			=	null;

		if ( $searching ) {
			$input['results']		=	CBTxt::T( 'No change search results found.' );
		} elseif ( $profileOwner ) {
			$input['results']		=	CBTxt::T( 'You currently have no changes.' );
		} else {
			$input['results']		=	CBTxt::T( 'This user currently has no changes.' );
		}

		if ( $tab->params->getBool( 'pulEnablePagingFE', true ) && ( $pageNav->total > $pageNav->limit ) ) {
			$input['paging']		=	$pageNav->getListLinks();
		}

		ob_start();
		require CBProfileUpdateLogger::getTemplate( null, 'tab' );
		$html						=	ob_get_clean();

		$class						=	$this->params->getString( 'general_class' );

		return	$this->_writeTabDescription( $tab, $user )
			.	'<div class="cbProfileUpdateLogger' . ( $class ? ' ' . htmlspecialchars( $class ) : null ) . '">'
			.		$html
			.	'</div>';
	}
}
