<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\AutoActions\Action;

use CB\Database\Table\UserTable;
use CBLib\Language\CBTxt;
use CBLib\Registry\ParamsInterface;

\defined( 'CBLIB' ) or die();

class RegistrationAction extends Action
{

	/**
	 * @param UserTable $user
	 */
	public function execute( UserTable $user ): void
	{
		global $_CB_framework, $_PLUGINS, $ueConfig;

		$params						=	$this->autoaction()->getParams()->subTree( 'registration' );

		$approve					=	$params->getInt( 'approve', 0 );
		$confirm					=	$params->getInt( 'confirm', 0 );
		$approval					=	( $approve === 2 ? $ueConfig['reg_admin_approval'] : $approve );
		$confirmation				=	( $confirm === 2 ? $ueConfig['reg_confirmation'] : $confirm );
		$usergroup					=	$params->getString( 'usergroup', '' );
		$password					=	$this->string( $user, $params->getString( 'password', '' ) );
		$name						=	[];

		if ( ! $usergroup ) {
			$gids					=	[ $_CB_framework->getCfg( 'new_usertype' ) ];
		} else {
			$gids					=	explode( '|*|', $usergroup );
		}

		cbArrayToInts( $gids );

		$newUser					=	new UserTable();

		$newUser->set( 'gids', $gids );
		$newUser->set( 'sendEmail', 0 );
		$newUser->set( 'registerDate', $_CB_framework->getUTCDate() );
		$newUser->set( 'username', $this->string( $user, $params->getString( 'username', '' ) ) );
		$newUser->set( 'firstname', $this->string( $user, $params->getString( 'firstname', '' ) ) );
		$newUser->set( 'middlename', $this->string( $user, $params->getString( 'middlename', '' ) ) );
		$newUser->set( 'lastname', $this->string( $user, $params->getString( 'lastname', '' ) ) );

		if ( $newUser->getString( 'firstname', '' ) ) {
			$name[]					=	$newUser->getString( 'firstname', '' );
		}

		if ( $newUser->getString( 'middlename', '' ) ) {
			$name[]					=	$newUser->getString( 'middlename', '' );
		}

		if ( $newUser->getString( 'lastname', '' ) ) {
			$name[]					=	$newUser->getString( 'lastname', '' );
		}

		$newUser->set( 'name', implode( ' ', $name ) );
		$newUser->set( 'email', $this->string( $user, $params->getString( 'email', '' ) ) );

		if ( $password ) {
			$newUser->set( 'password', $newUser->hashAndSaltPassword( $password ) );
		} else {
			$newUser->setRandomPassword();

			$newUser->set( 'password', $newUser->hashAndSaltPassword( $newUser->getString( 'password', '' ) ) );
		}

		$newUser->set( 'registeripaddr', cbGetIPlist() );

		if ( $approval === 0 ) {
			$newUser->set( 'approved', 1 );
		} else {
			$newUser->set( 'approved', 0 );
		}

		if ( $confirmation === 0 ) {
			$newUser->set( 'confirmed', 1 );
		} else {
			$newUser->set( 'confirmed', 0 );
		}

		if ( ( $newUser->getInt( 'confirmed', 1 ) === 1 ) && ( $newUser->getInt( 'approved', 1 ) === 1 ) ) {
			$newUser->set( 'block', 0 );
		} else {
			$newUser->set( 'block', 1 );
		}

		foreach ( $params->subTree( 'fields' ) as $row ) {
			/** @var ParamsInterface $row */
			$field					=	$row->getString( 'field', '' );

			if ( $field ) {
				$newUser->set( $field, $this->string( $user, $row->getRaw( 'value', '' ), false, $row->getBool( 'translate', false ) ) );
			}
		}

		$_PLUGINS->trigger( 'onBeforeUserRegistration', [ &$newUser, &$newUser ] );

		if ( ! $newUser->store() ) {
			$this->error( CBTxt::T( 'AUTO_ACTION_REGISTRATION_FAILED', ':: Action [action] :: Registration failed to save. Error: [error]', [ '[action]' => $this->autoaction()->getId(), '[error]' => $newUser->getError() ] ) );
			return;
		}

		if ( ( $newUser->getInt( 'confirmed', 1 ) === 0 ) && ( $confirmation !== 0 ) && ( ! $newUser->store() ) ) {
			$this->error( CBTxt::T( 'AUTO_ACTION_REGISTRATION_FAILED', ':: Action [action] :: Registration failed to save. Error: [error]', [ '[action]' => $this->autoaction()->getId(), '[error]' => $newUser->getError() ] ) );
			return;
		}

		if ( $params->getBool( 'supress', true ) ) {
			$emails					=	false;
		} else {
			$emails					=	true;
		}

		activateUser( $newUser, 1, 'UserRegistration', $emails, $emails );

		$_PLUGINS->trigger( 'onAfterUserRegistration', [ &$newUser, &$newUser, true ] );
	}
}