<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Core\AutoLoader;
use CBLib\Application\Application;
use CBLib\Registry\ParamsInterface;
use CBLib\Registry\Registry;
use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;
use CB\Database\Table\TabTable;
use CB\Plugin\GroupJive\CBGroupJive;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

global $_PLUGINS;

AutoLoader::registerExactMap( '%^CB/Plugin/GroupJive/(.+)%i', __DIR__ . '/library/$1.php' );

$_PLUGINS->loadPluginGroup( 'user' );
$_PLUGINS->loadPluginGroup( 'user/plug_cbgroupjive/plugins' );

$_PLUGINS->registerFunction( 'mod_onCBAdminMenu', 'adminMenu', '\CB\Plugin\GroupJive\Trigger\AdminTrigger' );

$_PLUGINS->registerFunction( 'onAfterDeleteUser', 'deleteGroups', '\CB\Plugin\GroupJive\Trigger\UserTrigger' );
$_PLUGINS->registerFunction( 'onAfterUserRegistration', 'acceptInvites', '\CB\Plugin\GroupJive\Trigger\UserTrigger' );
$_PLUGINS->registerFunction( 'onAfterNewUser', 'acceptInvites', '\CB\Plugin\GroupJive\Trigger\UserTrigger' );

$_PLUGINS->registerFunction( 'onBuildRoute', 'build', '\CB\Plugin\GroupJive\Trigger\RouterTrigger' );
$_PLUGINS->registerFunction( 'onParseRoute', 'parse', '\CB\Plugin\GroupJive\Trigger\RouterTrigger' );

$_PLUGINS->registerFunction( 'activity_onActivity', 'activityBuild', '\CB\Plugin\GroupJive\Trigger\ActivityTrigger' );
$_PLUGINS->registerFunction( 'activity_onNotifications', 'activityBuild', '\CB\Plugin\GroupJive\Trigger\ActivityTrigger' );
$_PLUGINS->registerFunction( 'activity_onStreamCreateAccess', 'createAccess', '\CB\Plugin\GroupJive\Trigger\ActivityTrigger' );
$_PLUGINS->registerFunction( 'activity_onStreamModerateAccess', 'moderateAccess', '\CB\Plugin\GroupJive\Trigger\ActivityTrigger' );
$_PLUGINS->registerFunction( 'activity_onQueryActivityStream', 'activityQuery', '\CB\Plugin\GroupJive\Trigger\ActivityTrigger' );
$_PLUGINS->registerFunction( 'activity_onQueryNotificationsStream', 'activityQuery', '\CB\Plugin\GroupJive\Trigger\ActivityTrigger' );
$_PLUGINS->registerFunction( 'activity_onLoadActivityStream', 'activityPrefetch', '\CB\Plugin\GroupJive\Trigger\ActivityTrigger' );
$_PLUGINS->registerFunction( 'activity_onLoadNotificationsStream', 'activityPrefetch', '\CB\Plugin\GroupJive\Trigger\ActivityTrigger' );
$_PLUGINS->registerFunction( 'activity_onDisplayStreamActivity', 'activityDisplay', '\CB\Plugin\GroupJive\Trigger\ActivityTrigger' );
$_PLUGINS->registerFunction( 'activity_onDisplayStreamNotification', 'activityDisplay', '\CB\Plugin\GroupJive\Trigger\ActivityTrigger' );
$_PLUGINS->registerFunction( 'activity_onStreamAsset', 'assetPrepare', '\CB\Plugin\GroupJive\Trigger\ActivityTrigger' );
$_PLUGINS->registerFunction( 'activity_onAssetSource', 'assetSource', '\CB\Plugin\GroupJive\Trigger\ActivityTrigger' );

$_PLUGINS->registerFunction( 'gallery_onGalleryFoldersCreateAccess', 'createFolderAccess', '\CB\Plugin\GroupJive\Trigger\GalleryTrigger' );
$_PLUGINS->registerFunction( 'gallery_onGalleryItemsCreateAccess', 'createItemAccess', '\CB\Plugin\GroupJive\Trigger\GalleryTrigger' );
$_PLUGINS->registerFunction( 'gallery_onGalleryModerateAccess', 'moderateAccess', '\CB\Plugin\GroupJive\Trigger\GalleryTrigger' );
$_PLUGINS->registerFunction( 'gallery_onAssetSource', 'assetSource', '\CB\Plugin\GroupJive\Trigger\GalleryTrigger' );

$_PLUGINS->registerUserFieldParams();
$_PLUGINS->registerUserFieldTypes( array(	'groupautojoin'			=>	'\CB\Plugin\GroupJive\Field\AutoJoinField',
											'groupmultiautojoin'	=>	'\CB\Plugin\GroupJive\Field\AutoJoinField'
										));

class cbgjTab extends cbTabHandler
{

	/**
	 * prepare frontend tab render
	 *
	 * @param TabTable  $tab
	 * @param UserTable $user
	 * @param int       $ui
	 * @return null|string
	 */
	public function getDisplayTab( $tab, $user, $ui )
	{
		global $_CB_framework, $_CB_database;

		if ( ! ( $tab->params instanceof ParamsInterface ) ) {
			$tab->params		=	new Registry( $tab->params );
		}

		$viewer					=	CBuser::getMyUserDataInstance();
		$isModerator			=	CBGroupJive::isModerator( $viewer->getInt( 'id', 0 ) );
		$isOwner				=	( $viewer->getInt( 'id', 0 ) === $user->getInt( 'id', 0 ) );

		CBGroupJive::getTemplate( 'tab' );

		$limit					=	$tab->params->getInt( 'tab_limit', 30 );
		$limitstart				=	$_CB_framework->getUserStateFromRequest( 'gj_tab_limitstart{com_comprofiler}', 'gj_tab_limitstart' );
		$search					=	$_CB_framework->getUserStateFromRequest( 'gj_tab_search{com_comprofiler}', 'gj_tab_search' );
		$where					=	null;

		if ( $search && $tab->params->getInt( 'tab_search', 1 ) ) {
			$where				.=	"\n AND ( g." . $_CB_database->NameQuote( 'name' ) . " LIKE " . $_CB_database->Quote( '%' . $_CB_database->getEscaped( $search, true ) . '%', false )
								.	" OR g." . $_CB_database->NameQuote( 'description' ) . " LIKE " . $_CB_database->Quote( '%' . $_CB_database->getEscaped( $search, true ) . '%', false ) . " )";
		}

		$searching				=	( $where ? true : false );


		$sqlModes				=	( $isOwner ? array( 'owned', 'joined', 'invited' ) : array( 'owned', 'joined' ) );
		$queries				=	array();

		foreach ( $sqlModes as $sqlMode ) {
			$query				=	'SELECT COUNT(*) AS total'
								.	"\n FROM " . $_CB_database->NameQuote( '#__groupjive_groups' ) . " AS g";

			if ( ! $isModerator ) {
				$query			.=	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__groupjive_categories' ) . " AS c"
								.	' ON c.' . $_CB_database->NameQuote( 'id' ) . ' = g.' . $_CB_database->NameQuote( 'category' );

				if ( ( ! $isOwner ) && $viewer->getInt( 'id', 0 ) ) {
					$query		.=	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__groupjive_users' ) . " AS mu"
								.	' ON mu.' . $_CB_database->NameQuote( 'user_id' ) . ' = ' . $viewer->getInt( 'id', 0 )
								.	' AND mu.' . $_CB_database->NameQuote( 'group' ) . ' = g.' . $_CB_database->NameQuote( 'id' )
								.	' AND mu.' . $_CB_database->NameQuote( 'status' ) . ' BETWEEN 0 AND 3'
								.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__groupjive_invites' ) . " AS mi"
								.	' ON mi.' . $_CB_database->NameQuote( 'group' ) . ' = g.' . $_CB_database->NameQuote( 'id' )
								.	' AND mi.' . $_CB_database->NameQuote( 'accepted' ) . ' IS NULL'
								.	' AND ( mi.' . $_CB_database->NameQuote( 'email' ) . ' = ' . $_CB_database->Quote( $viewer->getString( 'email' ) )
								.	' OR mi.' . $_CB_database->NameQuote( 'user' ) . ' = ' . $viewer->getInt( 'id', 0 ) . ' )';
				}
			}

			switch ( $sqlMode ) {
				case 'invited':
					$query		.=	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__groupjive_invites' ) . " AS i"
								.	' ON i.' . $_CB_database->NameQuote( 'group' ) . ' = g.' . $_CB_database->NameQuote( 'id' )
								.	' AND i.' . $_CB_database->NameQuote( 'accepted' ) . ' IS NULL'
								.	' AND ( i.' . $_CB_database->NameQuote( 'email' ) . ' = ' . $_CB_database->Quote( $user->getString( 'email' ) )
								.	' OR i.' . $_CB_database->NameQuote( 'user' ) . ' = ' . $user->getInt( 'id', 0 ) . ' )'
								.	"\n WHERE i." . $_CB_database->NameQuote( 'id' ) . " IS NOT NULL";

					if ( ! $isModerator ) {
						$query	.=	"\n AND g." . $_CB_database->NameQuote( 'published' ) . " = 1"
								.	"\n AND ( ( c." . $_CB_database->NameQuote( 'published' ) . " = 1"
								.		' AND c.' . $_CB_database->NameQuote( 'access' ) . ' IN ' . $_CB_database->safeArrayOfIntegers( CBGroupJive::getAccess( $user->getInt( 'id', 0 ) ) ) . ' )'
								.		( $this->params->getInt( 'groups_uncategorized', 1 ) ? ' OR g.' . $_CB_database->NameQuote( 'category' ) . ' = 0 )' : ' )' );
					}
					break;
				case 'joined':
					$query		.=	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__groupjive_users' ) . " AS u"
								.	' ON u.' . $_CB_database->NameQuote( 'user_id' ) . ' = ' . $user->getInt( 'id', 0 )
								.	' AND u.' . $_CB_database->NameQuote( 'group' ) . ' = g.' . $_CB_database->NameQuote( 'id' )
								.	' AND u.' . $_CB_database->NameQuote( 'status' ) . ( $isOwner ? ' BETWEEN 0 AND 3' : ' BETWEEN 1 AND 3' )
								.	"\n WHERE u." . $_CB_database->NameQuote( 'id' ) . " IS NOT NULL";

					if ( ! $isModerator ) {
						$query	.=	"\n AND g." . $_CB_database->NameQuote( 'published' ) . " = 1"
								.	"\n AND ( ( c." . $_CB_database->NameQuote( 'published' ) . " = 1"
								.		' AND c.' . $_CB_database->NameQuote( 'access' ) . ' IN ' . $_CB_database->safeArrayOfIntegers( CBGroupJive::getAccess( $user->getInt( 'id', 0 ) ) )
								.		' AND c.' . $_CB_database->NameQuote( 'access' ) . ' IN ' . $_CB_database->safeArrayOfIntegers( CBGroupJive::getAccess( $viewer->getInt( 'id', 0 ) ) ) . ' )'
								.		( $this->params->getInt( 'groups_uncategorized', 1 ) ? ' OR g.' . $_CB_database->NameQuote( 'category' ) . ' = 0 )' : ' )' );
					}
					break;
				case 'owned':
					$query		.=	"\n WHERE g." . $_CB_database->NameQuote( 'user_id' ) . " = " . $user->getInt( 'id', 0 );

					if ( ! $isModerator ) {
						$query	.=	"\n AND ( ( c." . $_CB_database->NameQuote( 'published' ) . " = 1"
								.		' AND c.' . $_CB_database->NameQuote( 'access' ) . ' IN ' . $_CB_database->safeArrayOfIntegers( CBGroupJive::getAccess( $user->getInt( 'id', 0 ) ) )
								.		' AND c.' . $_CB_database->NameQuote( 'access' ) . ' IN ' . $_CB_database->safeArrayOfIntegers( CBGroupJive::getAccess( $viewer->getInt( 'id', 0 ) ) ) . ' )'
								.		( $this->params->getInt( 'groups_uncategorized', 1 ) ? ' OR g.' . $_CB_database->NameQuote( 'category' ) . ' = 0 )' : ' )' );
					}
					break;
			}

			if ( ( ! $isModerator ) && ( ! $isOwner ) ) {
				if ( $viewer->getInt( 'id', 0 ) ) {
					$query		.=	"\n AND ( g." . $_CB_database->NameQuote( 'user_id' ) . " = " . $viewer->getInt( 'id', 0 )
								.		' OR ( g.' . $_CB_database->NameQuote( 'published' ) . ' = 1'
								.		' AND ( g.' . $_CB_database->NameQuote( 'type' ) . ' != 3'
								.		' OR mu.' . $_CB_database->NameQuote( 'id' ) . ' IS NOT NULL'
								.		' OR mi.' . $_CB_database->NameQuote( 'id' ) . ' IS NOT NULL ) ) )';
				} else {
					$query		.=	"\n AND g." . $_CB_database->NameQuote( 'published' ) . " = 1"
								.	"\n AND g." . $_CB_database->NameQuote( 'type' ) . " != 3";
				}
			}

			$query				.=	$where;

			$queries[]			=	$query;
		}

		if ( count( $queries ) > 1 ) {
			$query				=	"SELECT SUM( " . $_CB_database->NameQuote( 'total' ) . " ) FROM ( " . implode( " UNION ALL ", $queries ) . " ) AS g";
		} else {
			$query				=	$queries[0];
		}

		$_CB_database->setQuery( $query );
		$total					=	(int) $_CB_database->loadResult();

		if ( ( ! $total ) && ( ! $searching ) && ( ( ! $isOwner ) || ( $isOwner && ( ! CBGroupJive::canCreateGroup( $user ) ) ) ) && ( ! Application::Config()->getInt( 'showEmptyTabs', 1 ) ) ) {
			return null;
		}

		$pageNav				=	new cbPageNav( $total, $limitstart, $limit );

		$pageNav->setInputNamePrefix( 'gj_tab_' );
		$pageNav->setStaticLimit( true );
		$pageNav->setBaseURL( $_CB_framework->userProfileUrl( $user->getInt( 'id', 0 ), false, $tab->getInt( 'tabid', 0 ), 'html', 0, array( 'gj_tab_search' => ( $searching ? $search : null ) ) ) );

		switch( $tab->params->getInt( 'tab_orderby', 4 ) ) {
			case 2:
				$orderBy		=	'g.' . $_CB_database->NameQuote( 'ordering' ) . ' DESC';
				break;
			case 3:
				$orderBy		=	'g.' . $_CB_database->NameQuote( 'date' ) . ' ASC';
				break;
			case 4:
				$orderBy		=	'g.' . $_CB_database->NameQuote( 'date' ) . ' DESC';
				break;
			case 5:
				$orderBy		=	'g.' . $_CB_database->NameQuote( 'name' ) . ' ASC';
				break;
			case 6:
				$orderBy		=	'g.' . $_CB_database->NameQuote( 'name' ) . ' DESC';
				break;
			case 7:
				$orderBy		=	$_CB_database->NameQuote( '_users' ) . ' ASC';
				break;
			case 8:
				$orderBy		=	$_CB_database->NameQuote( '_users' ) . ' DESC';
				break;
			case 1:
			default:
				$orderBy		=	'g.' . $_CB_database->NameQuote( 'ordering' ) . ' ASC';
				break;
		}

		$users					=	'SELECT COUNT(*)'
								.	"\n FROM " . $_CB_database->NameQuote( '#__groupjive_users' ) . " AS uc"
								.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__comprofiler' ) . " AS uccb"
								.	' ON uccb.' . $_CB_database->NameQuote( 'id' ) . ' = uc.' . $_CB_database->NameQuote( 'user_id' )
								.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__users' ) . " AS ucj"
								.	' ON ucj.' . $_CB_database->NameQuote( 'id' ) . ' = uccb.' . $_CB_database->NameQuote( 'id' )
								.	"\n WHERE uc." . $_CB_database->NameQuote( 'group' ) . " = g." . $_CB_database->NameQuote( 'id' )
								.	"\n AND uccb." . $_CB_database->NameQuote( 'approved' ) . " = 1"
								.	"\n AND uccb." . $_CB_database->NameQuote( 'confirmed' ) . " = 1"
								.	"\n AND ucj." . $_CB_database->NameQuote( 'block' ) . " = 0";

		if ( ! $isModerator ) {
			if ( $viewer->getInt( 'id', 0 ) ) {
				$users			.=	"\n AND ( g." . $_CB_database->NameQuote( 'user_id' ) . " = " . $viewer->getInt( 'id', 0 )
								.		( ! $isOwner ? ' OR mu.' . $_CB_database->NameQuote( 'status' ) . ' >= 2' : null )
								.		' OR uc.' . $_CB_database->NameQuote( 'status' ) . ' >= 1 )';
			} else {
				$users			.=	"\n AND uc." . $_CB_database->NameQuote( 'status' ) . " >= 1";
			}
		}

		if ( ! $this->params->getInt( 'groups_users_owner', 1 ) ) {
			$users				.=	"\n AND uc." . $_CB_database->NameQuote( 'status' ) . " != 4";
		}

		$queries				=	array();

		foreach ( $sqlModes as $sqlMode ) {
			$query				=	'SELECT g.*'
								.	', c.' . $_CB_database->NameQuote( 'name' ) . ' AS _category_name';

			if ( $isOwner ) {
				$query			.=	', ' . ( $sqlMode === 'joined' ? 'u.' . $_CB_database->NameQuote( 'status' ) : 'NULL' ) . ' AS _user_status'
								.	', ' . ( $sqlMode === 'invited' ? 'i.' . $_CB_database->NameQuote( 'id' ) : 'NULL' ) . ' AS _invite_id';
			} elseif ( $viewer->getInt( 'id', 0 ) ) {
				$query			.=	', mu.' . $_CB_database->NameQuote( 'status' ) . ' AS _user_status'
								.	', mi.' . $_CB_database->NameQuote( 'id' ) . ' AS _invite_id';
			} else {
				$query			.=	', NULL AS _user_status'
								.	', NULL AS _invite_id';
			}

			$query				.=	', ( ' . $users . ' ) AS _users'
								.	"\n FROM " . $_CB_database->NameQuote( '#__groupjive_groups' ) . " AS g"
								.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__groupjive_categories' ) . " AS c"
								.	' ON c.' . $_CB_database->NameQuote( 'id' ) . ' = g.' . $_CB_database->NameQuote( 'category' );

			if ( ( ! $isOwner ) && $viewer->getInt( 'id', 0 ) ) {
				$query			.=	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__groupjive_users' ) . " AS mu"
								.	' ON mu.' . $_CB_database->NameQuote( 'user_id' ) . ' = ' . $viewer->getInt( 'id', 0 )
								.	' AND mu.' . $_CB_database->NameQuote( 'group' ) . ' = g.' . $_CB_database->NameQuote( 'id' )
								.	' AND mu.' . $_CB_database->NameQuote( 'status' ) . ' BETWEEN 0 AND 3'
								.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__groupjive_invites' ) . " AS mi"
								.	' ON mi.' . $_CB_database->NameQuote( 'group' ) . ' = g.' . $_CB_database->NameQuote( 'id' )
								.	' AND mi.' . $_CB_database->NameQuote( 'accepted' ) . ' IS NULL'
								.	' AND ( mi.' . $_CB_database->NameQuote( 'email' ) . ' = ' . $_CB_database->Quote( $viewer->getString( 'email' ) )
								.	' OR mi.' . $_CB_database->NameQuote( 'user' ) . ' = ' . $viewer->getInt( 'id', 0 ) . ' )';
			}

			switch ( $sqlMode ) {
				case 'invited':
					$query		.=	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__groupjive_invites' ) . " AS i"
								.	' ON i.' . $_CB_database->NameQuote( 'group' ) . ' = g.' . $_CB_database->NameQuote( 'id' )
								.	' AND i.' . $_CB_database->NameQuote( 'accepted' ) . ' IS NULL'
								.	' AND ( i.' . $_CB_database->NameQuote( 'email' ) . ' = ' . $_CB_database->Quote( $user->getString( 'email' ) )
								.	' OR i.' . $_CB_database->NameQuote( 'user' ) . ' = ' . $user->getInt( 'id', 0 ) . ' )'
								.	"\n WHERE i." . $_CB_database->NameQuote( 'id' ) . " IS NOT NULL";

					if ( ! $isModerator ) {
						$query	.=	"\n AND g." . $_CB_database->NameQuote( 'published' ) . " = 1"
								.	"\n AND ( ( c." . $_CB_database->NameQuote( 'published' ) . " = 1"
								.		' AND c.' . $_CB_database->NameQuote( 'access' ) . ' IN ' . $_CB_database->safeArrayOfIntegers( CBGroupJive::getAccess( $user->getInt( 'id', 0 ) ) ) . ' )'
								.		( $this->params->getInt( 'groups_uncategorized', 1 ) ? ' OR g.' . $_CB_database->NameQuote( 'category' ) . ' = 0 )' : ' )' );
					}
					break;
				case 'joined':
					$query		.=	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__groupjive_users' ) . " AS u"
								.	' ON u.' . $_CB_database->NameQuote( 'user_id' ) . ' = ' . $user->getInt( 'id', 0 )
								.	' AND u.' . $_CB_database->NameQuote( 'group' ) . ' = g.' . $_CB_database->NameQuote( 'id' )
								.	' AND u.' . $_CB_database->NameQuote( 'status' ) . ( $isOwner ? ' BETWEEN 0 AND 3' : ' BETWEEN 1 AND 3' )
								.	"\n WHERE u." . $_CB_database->NameQuote( 'id' ) . " IS NOT NULL";

					if ( ! $isModerator ) {
						$query	.=	( $isOwner ? "\n AND g." . $_CB_database->NameQuote( 'published' ) . " = 1" : null )
								.	"\n AND ( ( c." . $_CB_database->NameQuote( 'published' ) . " = 1"
								.		' AND c.' . $_CB_database->NameQuote( 'access' ) . ' IN ' . $_CB_database->safeArrayOfIntegers( CBGroupJive::getAccess( $user->getInt( 'id', 0 ) ) )
								.		' AND c.' . $_CB_database->NameQuote( 'access' ) . ' IN ' . $_CB_database->safeArrayOfIntegers( CBGroupJive::getAccess( $viewer->getInt( 'id', 0 ) ) ) . ' )'
								.		( $this->params->getInt( 'groups_uncategorized', 1 ) ? ' OR g.' . $_CB_database->NameQuote( 'category' ) . ' = 0 )' : ' )' );
					}
					break;
				case 'owned':
					$query		.=	"\n WHERE g." . $_CB_database->NameQuote( 'user_id' ) . " = " . $user->getInt( 'id', 0 );

					if ( ! $isModerator ) {
						$query	.=	"\n AND ( ( c." . $_CB_database->NameQuote( 'published' ) . " = 1"
								.		' AND c.' . $_CB_database->NameQuote( 'access' ) . ' IN ' . $_CB_database->safeArrayOfIntegers( CBGroupJive::getAccess( $user->getInt( 'id', 0 ) ) )
								.		' AND c.' . $_CB_database->NameQuote( 'access' ) . ' IN ' . $_CB_database->safeArrayOfIntegers( CBGroupJive::getAccess( $viewer->getInt( 'id', 0 ) ) ) . ' )'
								.		( $this->params->getInt( 'groups_uncategorized', 1 ) ? ' OR g.' . $_CB_database->NameQuote( 'category' ) . ' = 0 )' : ' )' );
					}
					break;
			}

			if ( ( ! $isModerator ) && ( ! $isOwner ) ) {
				if ( $viewer->getInt( 'id', 0 ) ) {
					$query		.=	"\n AND ( g." . $_CB_database->NameQuote( 'user_id' ) . " = " . $viewer->getInt( 'id', 0 )
								.		' OR ( g.' . $_CB_database->NameQuote( 'published' ) . ' = 1'
								.		' AND ( g.' . $_CB_database->NameQuote( 'type' ) . ' != 3'
								.		' OR mu.' . $_CB_database->NameQuote( 'id' ) . ' IS NOT NULL'
								.		' OR mi.' . $_CB_database->NameQuote( 'id' ) . ' IS NOT NULL ) ) )';
				} else {
					$query		.=	"\n AND g." . $_CB_database->NameQuote( 'published' ) . " = 1"
								.	"\n AND g." . $_CB_database->NameQuote( 'type' ) . " != 3";
				}
			}

			$query				.=	$where;

			$queries[]			=	$query;
		}

		if ( count( $queries ) > 1 ) {
			$query				=	"SELECT * FROM ( " . implode( " UNION ALL ", $queries ) . " ) AS g";
		} else {
			$query				=	$queries[0];
		}

		$query					.=	"\n ORDER BY " . $orderBy;
		if ( $tab->params->getInt( 'tab_paging', 1 ) ) {
			$_CB_database->setQuery( $query, $pageNav->limitstart, $pageNav->limit );
		} else {
			$_CB_database->setQuery( $query );
		}
		$rows					=	$_CB_database->loadObjectList( null, '\CB\Plugin\GroupJive\Table\GroupTable', array( $_CB_database ) );

		$input['search']		=	'<input type="text" name="gj_tab_search" value="' . htmlspecialchars( $search ) . '" placeholder="' . htmlspecialchars( CBTxt::T( 'Search Groups...' ) ) . '" class="form-control" />';

		CBGroupJive::prefetchGroups( $rows );
		CBGroupJive::prefetchUsers( $rows );

		$class					=	$this->params->getString( 'general_class' );

		$return					=	'<div class="cbGroupJive' . ( $class ? ' ' . htmlspecialchars( $class ) : null ) . '">'
								.		HTML_groupjiveTab::showTab( $rows, $pageNav, $searching, $input, $viewer, $user, $tab, $this )
								.	'</div>';

		return $return;
	}
}