<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;
use CB\Plugin\Gallery\Table\FolderTable;
use CB\Plugin\Gallery\Table\ItemTable;
use CB\Plugin\Gallery\Gallery;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_cbgalleryItems
{

	/**
	 * @param FolderTable|null $folder
	 * @param ItemTable[]      $rows
	 * @param cbPageNav        $pageNav
	 * @param UserTable        $viewer
	 * @param Gallery          $gallery
	 * @param CBplug_cbgallery $plugin
	 * @param string           $output
	 * @return string
	 */
	public static function showItems( $folder, $rows, $pageNav, $viewer, $gallery, $plugin, $output = null )
	{
		$return					=	'<div class="galleryItemsContainer">';

		if ( $rows ) {
			$return				.=		'<div class="d-flex flex-wrap no-gutters galleryItemsRows">';

			$i					=	0;

			foreach ( $rows as $row ) {
				if ( $pageNav->total > 1 ) {
					$row->set( '_previous', ( $i === 0 ? ( count( $rows ) - 1 ) : ( $i - 1 ) ) );
					$row->set( '_next', ( ( $i + 1 ) <= ( count( $rows ) - 1 )  ? ( $i + 1 ) : 0 ) );
				}

				$return			.=			HTML_cbgalleryItemContainer::showItemContainer( $row, $viewer, $gallery, $plugin, $output );

				$i++;
			}

			$return				.=		'</div>';


			if ( $gallery->getBool( ( $folder ? 'folders_' : null ) . 'items_paging', true ) && ( $pageNav->total > $pageNav->limit ) ) {
				$return			.=		'<div class="mt-3 galleryItemsPaging">'
								.			$pageNav->getListLinks()
								.		'</div>';
			}
		} else {
			$return				.=		'<div class="galleryItemsEmpty">';

			if ( $gallery->getString( 'search' ) !== '' ) {
				$return			.=			CBTxt::T( 'No gallery search results found.' );
			} else {
				if ( $gallery->getInt( 'folder', 0 ) ) {
					$return		.=			CBTxt::T( 'This album is currently empty.' );
				} else {
					$return		.=			CBTxt::T( 'This gallery is currently empty.' );
				}
			}

			$return				.=		'</div>';
		}

		$return					.=		$pageNav->getLimitBox( false )
								.	'</div>';

		return $return;
	}
}