<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;
use CB\Plugin\GroupJiveEvents\Table\EventTable;
use CB\Plugin\GroupJiveEvents\Table\AttendanceTable;
use CB\Plugin\GroupJive\CBGroupJive;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_groupjiveAttending
{

	/**
	 * render frontend event attending
	 *
	 * @param AttendanceTable[]        $rows
	 * @param cbPageNav                $pageNav
	 * @param bool                     $searching
	 * @param array                    $input
	 * @param EventTable               $event
	 * @param UserTable                $user
	 * @param CBplug_cbgroupjiveevents $plugin
	 */
	public static function showAttending( $rows, $pageNav, $searching, $input, $event, $user, $plugin )
	{
		global $_CB_framework, $_PLUGINS;

		initToolTip();

		$canSearch						=	( $plugin->params->getBool( 'groups_events_attending_search', false ) && ( $searching || $pageNav->total ) );
		$returnUrl						=	CBGroupJive::getReturn( true, true );

		if ( ! $returnUrl ) {
			$returnUrl					=	$_CB_framework->pluginClassUrl( 'cbgroupjive', false, array( 'action' => 'groups', 'func' => 'show', 'id' => $event->group()->getInt( 'id', 0 ) ) );
		}

		$return							=	null;

		$_PLUGINS->trigger( 'gj_onBeforeDisplayAttending', array( &$return, &$rows, $event, $user ) );

		$return							.=	'<div class="gjEventAttending">'
										.		'<div class="mb-3 border-bottom cb-page-header gjEventAttendingTitle"><h3 class="m-0 p-0 mb-2 cb-page-header-title">' . htmlspecialchars( $event->getString( 'title' ) ) . '</h3></div>';

		if ( $canSearch ) {
			$return						.=		'<div class="row no-gutters mb-3 gjHeader gjEventAttendingHeader">'
										.			'<div class="col-12 offset-sm-6 col-sm-6 text-right">'
										.				'<form action="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'events', 'func' => 'attending', 'id' => $event->getInt( 'id', 0 ) ) ) . '" method="post" name="gjEventAttendingSearchForm" class="m-0 gjEventAttendingSearchForm">'
										.					'<div class="input-group">'
										.						$input['search']
										.						'<div class="input-group-append">'
										.							'<button type="submit" class="btn btn-light border" aria-label="' . htmlspecialchars( CBTxt::T( 'Search' ) ) . '"><span class="fa fa-search"></span></button>'
										.						'</div>'
										.					'</div>'
										.				'</form>'
										.			'</div>'
										.		'</div>';
		}

		if ( $rows ) {
			$return						.=		'<div class="ml-n2 mr-n2 mb-n3 row no-gutters gjEventAttendingRows">';

			foreach ( $rows as $row ) {
				$cbUser					=	CBuser::getInstance( $row->getInt( 'user_id', 0 ), false );

				$return					.=			'<div class="col-12 col-md-6 col-lg-4 pb-3 pl-2 pr-2 gjEventAttendingUser">'
										.				'<div class="h-100 card no-overflow cbCanvasLayout cbCanvasLayoutSm">'
										.					'<div class="card-header p-0 position-relative cbCanvasLayoutTop">'
										.						'<div class="position-absolute cbCanvasLayoutBackground">'
										.							$cbUser->getField( 'canvas', null, 'html', 'none', 'profile', 0, true )
										.						'</div>'
										.					'</div>'
										.					'<div class="position-relative cbCanvasLayoutBottom">'
										.						'<div class="position-absolute cbCanvasLayoutPhoto">'
										.							$cbUser->getField( 'avatar', null, 'html', 'none', 'list', 0, true )
										.						'</div>'
										.					'</div>'
										.					'<div class="card-body p-2 position-relative cbCanvasLayoutBody">'
										.						'<div class="text-truncate cbCanvasLayoutContent">'
										.							$cbUser->getField( 'onlinestatus', null, 'html', 'none', 'profile', 0, true, array( 'params' => array( 'displayMode' => 1 ) ) )
										.							' <span class="text-large">' . $cbUser->getField( 'formatname', null, 'html', 'none', 'list', 0, true, array( 'params' => array( 'fieldHoverCanvas' => false ) ) ) . '</span>'
										.						'</div>'
										.					'</div>'
										.				'</div>'
										.			'</div>';
			}

			$return						.=		'</div>';

			if ( $plugin->params->getBool( 'groups_events_attending_paging', true ) && ( $pageNav->total > $pageNav->limit ) ) {
				$return					.=		'<div class="mt-3 gjEventAttendingPaging">'
										.			$pageNav->getListLinks()
										.		'</div>';
			}
		} else {
			$return						.=		'<div class="gjEventAttendingEmpty">';

			if ( $searching ) {
				$return					.=			CBTxt::T( 'No event guest search results found.' );
			} else {
				$return					.=			CBTxt::T( 'This event currently has no guests.' );
			}

			$return						.=		'</div>';
		}

		$return							.=	'</div>';

		$_PLUGINS->trigger( 'gj_onAfterDisplayAttending', array( &$return, &$rows, $event, $user ) );

		echo $return;
	}
}