<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Application\Application;
use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;
use CB\Database\Table\TabTable;
use CB\Plugin\GroupJive\CBGroupJive;
use CB\Plugin\GroupJiveEvents\CBGroupJiveEvents;
use CB\Plugin\GroupJiveEvents\Table\AttendanceTable;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

global $_PLUGINS;

$_PLUGINS->loadPluginGroup( 'user' );

class CBplug_cbgroupjiveevents extends cbPluginHandler
{

	/**
	 * @param  TabTable   $tab       Current tab
	 * @param  UserTable  $user      Current user
	 * @param  int        $ui        1 front, 2 admin UI
	 * @param  array      $postdata  Raw unfiltred POST data
	 */
	public function getCBpluginComponent( $tab, $user, $ui, $postdata )
	{
		$format					=	$this->getInput()->getString( 'format' );

		if ( $format !== 'raw' ) {
			outputCbJs();
			outputCbTemplate();
		}

		$action					=	$this->getInput()->getString( 'action' );
		$function				=	$this->getInput()->getString( 'func' );
		$id						=	$this->getInput()->getInt( 'id', 0 );

		if ( $user === null ) {
			$user				=	CBuser::getMyUserDataInstance();
		}

		if ( $format !== 'raw' ) {
			ob_start();
		}

		if ( $action === 'events' ) {
			switch ( $function ) {
				case 'attending':
					$this->showEventAttending( $id, $user );
					break;
				case 'attend':
					$this->attendEvent( $id, $user );
					break;
				case 'unattend':
					$this->unattendEvent( $id, $user );
					break;
				case 'publish':
					$this->stateEvent( 1, $id, $user );
					break;
				case 'unpublish':
					$this->stateEvent( 0, $id, $user );
					break;
				case 'delete':
					$this->deleteEvent( $id, $user );
					break;
				case 'new':
					$this->showEventEdit( null, $user );
					break;
				case 'edit':
					$this->showEventEdit( $id, $user );
					break;
				case 'save':
					cbSpoofCheck( 'plugin' );
					$this->saveEventEdit( $id, $user );
					break;
				case 'message':
					$this->showEventMessage( $id, $user );
					break;
				case 'send':
					cbSpoofCheck( 'plugin' );
					$this->sendEventMessage( $id, $user );
					break;
			}
		}

		if ( $format !== 'raw' ) {
			$html				=	ob_get_clean();

			$gjClass			=	CBGroupJive::getGlobalParams()->getString( 'general_class' );

			$return				=	'<div class="cbGroupJive' . ( $gjClass ? ' ' . htmlspecialchars( $gjClass ) : null ) . '">'
								.		$html
								.	'</div>';

			echo $return;
		}
	}

	/**
	 * prepare frontend event attending render
	 *
	 * @param int       $id
	 * @param UserTable $user
	 */
	private function showEventAttending( $id, $user )
	{
		global $_CB_framework, $_CB_database;

		$event			=	CBGroupJiveEvents::getEvent( (int) $id );
		$returnUrl		=	$_CB_framework->pluginClassUrl( 'cbgroupjive', false, array( 'action' => 'groups', 'func' => 'show', 'id' => $event->getInt( 'group', 0 ) ) );

		if ( $event->getInt( 'id', 0 ) ) {
			if ( ! CBGroupJive::canAccessGroup( $event->group(), $user ) ) {
				CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'Group does not exist.' ), 'error' );
			} elseif ( ! CBGroupJive::isModerator( $user->getInt( 'id', 0 ) ) ) {
				if ( ( $event->getInt( 'published', 1 ) !== 1 ) && ( CBGroupJive::getGroupStatus( $user, $event->group() ) < 2 ) ) {
					CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'You do not have access to this event.' ), 'error' );
				}
			}
		} else {
			CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'Event does not exist.' ), 'error' );
		}

		CBGroupJive::getTemplate( 'attending', true, true, $this->element );

		$canModerate			=	( CBGroupJive::isModerator( $user->getInt( 'id', 0 ) ) || ( CBGroupJive::getGroupStatus( $user, $event->group() ) >= 2 ) );
		$prefix					=	'gj_event_' . $event->getInt( 'id', 0 ) . '_attending_';
		$limit					=	$this->params->getInt( 'groups_events_attending_limit', 30 );
		$limitstart				=	$_CB_framework->getUserStateFromRequest( $prefix . 'limitstart{com_comprofiler}', $prefix . 'limitstart' );
		$search					=	$_CB_framework->getUserStateFromRequest( $prefix . 'search{com_comprofiler}', $prefix . 'search' );
		$where					=	null;

		if ( $search && $this->params->getBool( 'groups_events_attending_search', false ) ) {
			$where				.=	"\n AND ( j." . $_CB_database->NameQuote( 'name' ) . " LIKE " . $_CB_database->Quote( '%' . $_CB_database->getEscaped( $search, true ) . '%', false )
								.	" OR j." . $_CB_database->NameQuote( 'username' ) . " LIKE " . $_CB_database->Quote( '%' . $_CB_database->getEscaped( $search, true ) . '%', false ) . " )";
		}

		$searching				=	( $where ? true : false );

		$query					=	'SELECT COUNT(*)'
								.	"\n FROM " . $_CB_database->NameQuote( '#__groupjive_plugin_events_attendance' ) . " AS a"
								.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__groupjive_plugin_events' ) . " AS e"
								.	' ON e.' . $_CB_database->NameQuote( 'id' ) . ' = a.' . $_CB_database->NameQuote( 'event' )
								.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__comprofiler' ) . " AS cb"
								.	' ON cb.' . $_CB_database->NameQuote( 'id' ) . ' = a.' . $_CB_database->NameQuote( 'user_id' )
								.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__users' ) . " AS j"
								.	' ON j.' . $_CB_database->NameQuote( 'id' ) . ' = a.' . $_CB_database->NameQuote( 'user_id' )
								.	"\n WHERE a." . $_CB_database->NameQuote( 'event' ) . " = " . $event->getInt( 'id', 0 )
								.	"\n AND cb." . $_CB_database->NameQuote( 'approved' ) . " = 1"
								.	"\n AND cb." . $_CB_database->NameQuote( 'confirmed' ) . " = 1"
								.	"\n AND j." . $_CB_database->NameQuote( 'block' ) . " = 0";

		if ( ! $canModerate ) {
			$query				.=	"\n AND ( e." . $_CB_database->NameQuote( 'user_id' ) . " = " . $user->getInt( 'id', 0 )
								.		' OR e.' . $_CB_database->NameQuote( 'published' ) . ' = 1 )';
		}

		$query					.=	$where;
		$_CB_database->setQuery( $query );
		$total					=	(int) $_CB_database->loadResult();

		$pageNav				=	new cbPageNav( $total, $limitstart, $limit );

		$pageNav->setInputNamePrefix( $prefix );
		$pageNav->setStaticLimit( true );
		$pageNav->setBaseURL( $_CB_framework->pluginClassUrl( $this->element, false, array( 'action' => 'events', 'func' => 'attending', 'id' => $event->getInt( 'id', 0 ), $prefix . 'search' => ( $searching ? $search : null ) ) ) );

		$query					=	'SELECT a.*'
								.	"\n FROM " . $_CB_database->NameQuote( '#__groupjive_plugin_events_attendance' ) . " AS a"
								.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__groupjive_plugin_events' ) . " AS e"
								.	' ON e.' . $_CB_database->NameQuote( 'id' ) . ' = a.' . $_CB_database->NameQuote( 'event' )
								.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__comprofiler' ) . " AS cb"
								.	' ON cb.' . $_CB_database->NameQuote( 'id' ) . ' = a.' . $_CB_database->NameQuote( 'user_id' )
								.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__users' ) . " AS j"
								.	' ON j.' . $_CB_database->NameQuote( 'id' ) . ' = a.' . $_CB_database->NameQuote( 'user_id' )
								.	"\n WHERE a." . $_CB_database->NameQuote( 'event' ) . " = " . $event->getInt( 'id', 0 )
								.	"\n AND cb." . $_CB_database->NameQuote( 'approved' ) . " = 1"
								.	"\n AND cb." . $_CB_database->NameQuote( 'confirmed' ) . " = 1"
								.	"\n AND j." . $_CB_database->NameQuote( 'block' ) . " = 0";

		if ( ! $canModerate ) {
			$query				.=	"\n AND ( e." . $_CB_database->NameQuote( 'user_id' ) . " = " . $user->getInt( 'id', 0 )
								.		' OR e.' . $_CB_database->NameQuote( 'published' ) . ' = 1 )';
		}

		$query					.=	$where
								.	"\n ORDER BY a." . $_CB_database->NameQuote( 'date' ) . " DESC";
		if ( $this->params->getBool( 'groups_events_attending_paging', true ) ) {
			$_CB_database->setQuery( $query, $pageNav->limitstart, $pageNav->limit );
		} else {
			$_CB_database->setQuery( $query );
		}
		$rows					=	$_CB_database->loadObjectList( null, '\CB\Plugin\GroupJiveEvents\Table\AttendanceTable', array( $_CB_database ) );

		$input					=	array();

		$input['search']		=	'<input type="text" name="' . htmlspecialchars( $prefix ) . 'search" value="' . htmlspecialchars( $search ) . '" placeholder="' . htmlspecialchars( CBTxt::T( 'Search Attending...' ) ) . '" class="form-control" />';

		CBGroupJive::prefetchUsers( $rows );

		HTML_groupjiveAttending::showAttending( $rows, $pageNav, $searching, $input, $event, $user, $this );
	}

	/**
	 * prepare frontend event message render
	 *
	 * @param int       $id
	 * @param UserTable $user
	 */
	private function showEventMessage( $id, $user )
	{
		global $_CB_framework;

		$row					=	CBGroupJiveEvents::getEvent( (int) $id );
		$returnUrl				=	$_CB_framework->pluginClassUrl( 'cbgroupjive', false, array( 'action' => 'groups', 'func' => 'show', 'id' => $row->getInt( 'group', 0 ) ) );

		if ( $row->getInt( 'id', 0 ) ) {
			if ( ! CBGroupJive::canAccessGroup( $row->group(), $user ) ) {
				cbRedirect( $returnUrl, CBTxt::T( 'Group does not exist.' ), 'error' );
			} elseif ( ! CBGroupJive::isModerator( $user->getInt( 'id', 0 ) ) ) {
				if ( ! $this->params->getBool( 'groups_events_message', false ) ) {
					cbRedirect( $returnUrl, CBTxt::T( 'You do not have access to messaging for this event.' ), 'error' );
				} elseif ( ( $row->status() === 1 )
						   || ( $row->getInt( 'published', 1 ) === -1 )
						   || ( CBGroupJive::getGroupStatus( $user, $row->group() ) < 1 )
						   || ( ( $user->getInt( 'id', 0 ) !== $row->getInt( 'user_id', 0 ) ) && ( CBGroupJive::getGroupStatus( $user, $row->group() ) < 3 ) )
				) {
					cbRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to messaging for this event.' ), 'error' );
				} elseif ( $row->params()->getString( 'messaged' ) ) {
					$seconds	=	$this->params->getInt( 'groups_events_message_delay', 60 );

					if ( $seconds && ( Application::Date( $row->params()->getString( 'messaged' ), 'UTC' )->add( $seconds . ' SECONDS' )->getTimestamp() >= Application::Date( 'now', 'UTC' )->getTimestamp() ) ) {
						cbRedirect( $returnUrl, CBTxt::T( 'You can not send a message to this event at this time. Please wait awhile and try again.' ), 'error' );
					}
				}
			}
		} else {
			cbRedirect( $returnUrl, CBTxt::T( 'Event does not exist.' ), 'error' );
		}

		CBGroupJive::getTemplate( 'message', true, true, $this->element );

		$input					=	array();

		$subjectTooltip			=	cbTooltip( null, CBTxt::T( 'Optionally input a message subject.' ), null, null, null, null, null, 'data-hascbtooltip="true"' );

		$input['subject']		=	'<input type="text" id="subject" name="subject" value="' . htmlspecialchars( $this->getInput()->getString( 'post/subject' ) ) . '" class="form-control input-block"' . $subjectTooltip . ' />';

		$messageTooltip			=	cbTooltip( null, CBTxt::T( 'Input a message to send to this events guests.' ), null, null, null, null, null, 'data-hascbtooltip="true"' );

		$input['message']		=	'<textarea id="message" name="message" class="form-control input-block required" rows="10"' . $messageTooltip . '>' . htmlspecialchars( ( $this->params->getBool( 'groups_message_html', false ) ? $this->getInput()->getHtml( 'post/message' ) : $this->getInput()->getString( 'post/message' ) ) ) . '</textarea>';

		HTML_groupjiveEventMessage::showMessage( $row, $input, $row->group(), $user, $this );
	}

	/**
	 * prepare frontend event edit render
	 *
	 * @param int       $id
	 * @param UserTable $user
	 */
	private function showEventEdit( $id, $user )
	{
		global $_CB_framework;

		$row					=	CBGroupJiveEvents::getEvent( (int) $id );
		$isModerator			=	CBGroupJive::isModerator( $user->getInt( 'id', 0 ) );
		$groupId				=	$this->getInput()->getInt( 'group' );

		if ( $groupId === null ) {
			$group				=	$row->group();
		} else {
			$group				=	CBGroupJive::getGroup( $groupId );
		}

		$returnUrl				=	$_CB_framework->pluginClassUrl( 'cbgroupjive', false, array( 'action' => 'groups', 'func' => 'show', 'id' => $group->getInt( 'id', 0 ) ) );

		if ( ! CBGroupJive::canAccessGroup( $group, $user ) ) {
			cbRedirect( $returnUrl, CBTxt::T( 'Group does not exist.' ), 'error' );
		} elseif ( ! $isModerator ) {
			if ( ( ! $row->getInt( 'id', 0 ) ) && ( ! CBGroupJive::canCreateGroupContent( $user, $group, 'events' ) ) ) {
				cbRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to schedule an event in this group.' ), 'error' );
			} elseif ( $row->getInt( 'id', 0 )
					   && ( CBGroupJive::getGroupStatus( $user, $group ) < 2 )
					   && ( $user->getInt( 'id', 0 ) !== $row->getInt( 'user_id', 0 ) )
			) {
				cbRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to edit this event.' ), 'error' );
			}
		}

		CBGroupJive::getTemplate( 'event_edit', true, true, $this->element );

		$input					=	array();

		$publishedTooltip		=	cbTooltip( null, CBTxt::T( 'Select publish state of this event. Unpublished events will not be visible to the public.' ), null, null, null, null, null, 'data-hascbtooltip="true"' );

		$input['published']		=	moscomprofilerHTML::yesnoButtonList( 'published', $publishedTooltip, $this->getInput()->getInt( 'post/published', $row->getInt( 'published', 1 ) ) );

		$titleTooltup			=	cbTooltip( null, CBTxt::T( 'Input the event title. This is the title that will distinguish this event from others. Suggested to input something to uniquely identify your event.' ), null, null, null, null, null, 'data-hascbtooltip="true"' );

		$input['title']			=	'<input type="text" id="title" name="title" value="' . htmlspecialchars( $this->getInput()->getString( 'post/title', $row->getString( 'title' ) ) ) . '" class="form-control required" size="35"' . $titleTooltup . ' />';

		$event					=	Application::Cms()->displayCmsEditor( 'event', $this->getInput()->getHtml( 'post/event', $row->getHtml( 'event' ) ), '100%', null, 40, 10 );

		$input['event']			=	cbTooltip( null, CBTxt::T( 'Input a detailed description about this event.' ), null, null, null, $event, null, 'class="d-block clearfix"' );

		$locationTooltup		=	cbTooltip( null, CBTxt::T( 'Input the location for this event (e.g. My House, The Park, Restaurant Name, etc..).' ), null, null, null, null, null, 'data-hascbtooltip="true"' );

		$input['location']		=	'<input type="text" id="location" name="location" value="' . htmlspecialchars( $this->getInput()->getString( 'post/location', $row->getString( 'location' ) ) ) . '" class="form-control required" size="35"' . $locationTooltup . ' />';

		if ( isset( $_SERVER['HTTPS'] ) && ( ! empty( $_SERVER['HTTPS'] ) ) && ( $_SERVER['HTTPS'] !== 'off' ) ) {
			$addressTooltup		=	cbTooltip( null, CBTxt::T( 'Optionally input the address for this event or click the map button to attempt to find your current location.' ), null, null, null, null, null, 'data-hascbtooltip="true"' );
		} else {
			$addressTooltup		=	cbTooltip( null, CBTxt::T( 'Optionally input the address for this event.' ), null, null, null, null, null, 'data-hascbtooltip="true"' );
		}

		$input['address']		=	'<input type="text" id="address" name="address" value="' . htmlspecialchars( $this->getInput()->getString( 'post/address', $row->getString( 'address' ) ) ) . '" class="form-control" size="45"' . $addressTooltup . ' />';

		$calendars				=	new cbCalendars( 1 );
		$minYear				=	(int) Application::Date( ( $row->getInt( 'id', 0 ) ? $row->getString( 'start' ) : 'now' ), 'UTC' )->format( 'Y' );

		$startTooltup			=	cbTooltip( null, CBTxt::T( 'Select the date and time this event starts.' ), null, null, null, null, null, 'data-hascbtooltip="true"' );

		$input['start']			=	$calendars->cbAddCalendar( 'start', null, true, $this->getInput()->getString( 'post/start', $row->getString( 'start' ) ), false, true, $minYear, ( $minYear + 30 ), $startTooltup );

		$endTooltup				=	cbTooltip( null, CBTxt::T( 'Optionally select the end date and time for this event.' ), null, null, null, null, null, 'data-hascbtooltip="true"' );

		$input['end']			=	$calendars->cbAddCalendar( 'end', null, false, $this->getInput()->getString( 'post/end', $row->getString( 'end' ) ), false, true, $minYear, ( $minYear + 30 ), $endTooltup );

		$limitTooltip			=	cbTooltip( null, CBTxt::T( 'Optionally input a guest limit for this event.' ), null, null, null, null, null, 'data-hascbtooltip="true"' );

		$input['limit']			=	'<input type="text" id="limit" name="limit" value="' . $this->getInput()->getInt( 'post/limit', $row->getInt( 'limit', 0 ) ) . '" class="digits form-control" size="6"' . $limitTooltip . ' />';

		$ownerTooltip			=	cbTooltip( null, CBTxt::T( 'Input the event owner id. Event owner determines the creator of the event specified as User ID.' ), null, null, null, null, null, 'data-hascbtooltip="true"' );

		$input['user_id']		=	'<input type="text" id="user_id" name="user_id" value="' . $this->getInput()->getInt( 'post/user_id', $this->getInput()->getInt( 'user', $row->getInt( 'user_id', $user->getInt( 'id', 0 ) ) ) ) . '" class="digits required form-control" size="6"' . $ownerTooltip . ' />';

		HTML_groupjiveEventEdit::showEventEdit( $row, $input, $group, $user, $this );
	}

	/**
	 * save event
	 *
	 * @param int       $id
	 * @param UserTable $user
	 */
	private function saveEventEdit( $id, $user )
	{
		global $_CB_framework, $_PLUGINS;

		$row					=	CBGroupJiveEvents::getEvent( (int) $id );
		$isModerator			=	CBGroupJive::isModerator( $user->getInt( 'id', 0 ) );
		$groupId				=	$this->getInput()->getInt( 'group' );

		if ( $groupId === null ) {
			$group				=	$row->group();
		} else {
			$group				=	CBGroupJive::getGroup( $groupId );
		}

		$returnUrl				=	$_CB_framework->pluginClassUrl( 'cbgroupjive', false, array( 'action' => 'groups', 'func' => 'show', 'id' => $group->getInt( 'id', 0 ) ) );

		if ( ! CBGroupJive::canAccessGroup( $group, $user ) ) {
			cbRedirect( $returnUrl, CBTxt::T( 'Group does not exist.' ), 'error' );
		} elseif ( ! $isModerator ) {
			if ( ( ! $row->getInt( 'id', 0 ) ) && ( ! CBGroupJive::canCreateGroupContent( $user, $group, 'events' ) ) ) {
				cbRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to schedule an event in this group.' ), 'error' );
			} elseif ( $row->getInt( 'id', 0 )
					   && ( CBGroupJive::getGroupStatus( $user, $group ) < 2 )
					   && ( $user->getInt( 'id', 0 ) !== $row->getInt( 'user_id', 0 ) )
			) {
				cbRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to edit this event.' ), 'error' );
			}
		}

		if ( $isModerator ) {
			$row->set( 'user_id', $this->getInput()->getInt( 'post/user_id', $row->getInt( 'user_id', $user->getInt( 'id', 0 ) ) ) );
		} else {
			$row->set( 'user_id', $row->getInt( 'user_id', $user->getInt( 'id', 0 ) ) );
		}

		$canModerate			=	( CBGroupJive::getGroupStatus( $user, $group ) >= 2 );

		$currentTitle			=	$row->getString( 'title' );
		$currentEvent			=	$row->getHtml( 'event' );
		$currentLocation		=	$row->getString( 'location' );
		$currentAddress			=	$row->getString( 'address' );
		$currentStart			=	$row->getString( 'start' );
		$currentEnd				=	$row->getString( 'end' );

		$newStart				=	$this->getInput()->getString( 'post/start', $currentStart );
		$newEnd					=	$this->getInput()->getString( 'post/end', $currentEnd );

		$row->set( 'published', ( $isModerator || $canModerate || ( $row->getInt( 'id', 0 ) && ( $row->getInt( 'published', 1 ) !== -1 ) ) || ( $group->params()->getInt( 'events', 1 ) !== 2 ) ? $this->getInput()->getInt( 'post/published', $row->getInt( 'published', 1 ) ) : -1 ) );
		$row->set( 'group', $group->getInt( 'id', 0 ) );
		$row->set( 'title', $this->getInput()->getString( 'post/title', $currentTitle ) );
		$row->set( 'event', $this->getInput()->getHtml( 'post/event', $currentEvent ) );
		$row->set( 'location', $this->getInput()->getString( 'post/location', $currentLocation ) );
		$row->set( 'address', $this->getInput()->getString( 'post/address', $currentAddress ) );
		$row->set( 'start', $newStart );
		$row->set( 'end', $newEnd );
		$row->set( 'limit', $this->getInput()->getInt( 'post/limit', $row->getInt( 'limit', 0 ) ) );

		if ( ( ! $isModerator ) && $this->params->getBool( 'groups_events_captcha', false ) ) {
			$_PLUGINS->loadPluginGroup( 'user' );

			$_PLUGINS->trigger( 'onCheckCaptchaHtmlElements', array() );

			if ( $_PLUGINS->is_errors() ) {
				$row->setError( $_PLUGINS->getErrorMSG() );
			}
		}

		$new					=	( ! $row->getInt( 'id', 0 ) );

		if ( $row->getError() || ( ! $row->check() ) ) {
			$_CB_framework->enqueueMessage( CBTxt::T( 'GROUP_EVENT_FAILED_TO_SAVE', 'Event failed to save! Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );

			$this->showEventEdit( $id, $user );
			return;
		}

		if ( $row->getError() || ( ! $row->store() ) ) {
			$_CB_framework->enqueueMessage( CBTxt::T( 'GROUP_EVENT_FAILED_TO_SAVE', 'Event failed to save! Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );

			$this->showEventEdit( $id, $user );
			return;
		}

		if ( $new ) {
			$attend				=	new AttendanceTable();

			$attend->set( 'user_id', $row->getInt( 'user_id', 0 ) );
			$attend->set( 'event', $row->getInt( 'id', 0 ) );

			$attend->store();
		}

		$extras					=	array(	'event_id'			=>	$row->getInt( 'id', 0 ),
											'event_title'		=>	$row->getString( 'title' ),
											'event_details'		=>	$row->getHtml( 'event' ),
											'event_address'		=>	$row->getString( 'address' ),
											'event_location'	=>	$row->getString( 'location' ),
											'event_date'		=>	$row->date(),
											'event'				=>	'<a href="' . $_CB_framework->pluginClassUrl( 'cbgroupjive', false, array( 'action' => 'groups', 'func' => 'show', 'id' => $row->getInt( 'group', 0 ), 'tab' => 'grouptabevents' ) ) . '">' . htmlspecialchars( $row->getString( 'title' ) ) . '</a>' );

		if ( $new ) {
			if ( $row->getInt( 'published', 1 ) === 1 ) {
				CBGroupJive::sendNotifications( 'event_new', CBTxt::T( 'New group event' ), CBTxt::T( '[user] has scheduled the event [event] in the group [group]!' ), $row->group(), $row->getInt( 'user_id', 0 ), null, array( $user->getInt( 'id', 0 ) ), 1, $extras );
			} elseif ( ( $row->getInt( 'published', 1 ) === -1 ) && ( $row->group()->params()->getInt( 'events', 1 ) === 2 ) ) {
				CBGroupJive::sendNotifications( 'event_approve', CBTxt::T( 'New group event awaiting approval' ), CBTxt::T( '[user] has scheduled the event [event] in the group [group] and is awaiting approval!' ), $row->group(), $row->getInt( 'user_id', 0 ), null, array( $user->getInt( 'id', 0 ) ), 2, $extras );

				cbRedirect( $returnUrl, CBTxt::T( 'Event scheduled successfully and awaiting approval!' ) );
			}

			cbRedirect( $returnUrl, CBTxt::T( 'Event scheduled successfully!' ) );
		} else {
			if ( ( $row->getInt( 'published', 1 ) === 1 )
				 && (
				 		( $row->getString( 'title' ) !== $currentTitle )
						|| ( $row->getHtml( 'event' ) !== $currentEvent )
						|| ( $row->getString( 'location' ) !== $currentLocation )
						|| ( $row->getString( 'address' ) !== $currentAddress )
						|| ( $row->getString( 'start' ) !== $currentStart )
						|| ( $row->getString( 'end' ) !== $currentEnd )
				 )
			) {
				CBGroupJive::sendNotifications( 'event_edit', CBTxt::T( 'Group event changed' ), CBTxt::T( '[user] has changed the scheduled event [event] in the group [group]!' ), $row->group(), $row->getInt( 'user_id', 0 ), null, array( $user->getInt( 'id', 0 ) ), 1, $extras );
			}

			cbRedirect( $returnUrl, CBTxt::T( 'Event saved successfully!' ) );
		}
	}

	/**
	 * set event publish state status
	 *
	 * @param int       $state
	 * @param int       $id
	 * @param UserTable $user
	 */
	private function stateEvent( $state, $id, $user )
	{
		global $_CB_framework;

		$row				=	CBGroupJiveEvents::getEvent( (int) $id );
		$returnUrl			=	$_CB_framework->pluginClassUrl( 'cbgroupjive', false, array( 'action' => 'groups', 'func' => 'show', 'id' => $row->getInt( 'group', 0 ) ) );

		if ( $row->getInt( 'id', 0 ) ) {
			if ( ! CBGroupJive::canAccessGroup( $row->group(), $user ) ) {
				cbRedirect( $returnUrl, CBTxt::T( 'Group does not exist.' ), 'error' );
			} elseif ( ! CBGroupJive::isModerator( $user->getInt( 'id', 0 ) ) ) {
				if ( CBGroupJive::getGroupStatus( $user, $row->group() ) < 2 ) {
					if ( ( $row->getInt( 'published', 1 ) === -1 )
						 && ( $user->getInt( 'id', 0 ) === $row->getInt( 'user_id', 0 ) )
						 && ( $row->group()->params()->getInt( 'events', 1 ) === 2 )
					) {
						cbRedirect( $returnUrl, CBTxt::T( 'Your event is awaiting approval.' ), 'error' );
					} elseif ( ( $user->getInt( 'id', 0 ) !== $row->getInt( 'user_id', 0 ) ) ) {
						cbRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to publish or unpublish this event.' ), 'error' );
					}
				}
			}
		} else {
			cbRedirect( $returnUrl, CBTxt::T( 'Event does not exist.' ), 'error' );
		}

		$currentState		=	$row->getInt( 'published', 1 );

		$row->set( 'published', (int) $state );

		if ( $row->getError() || ( ! $row->store() ) ) {
			cbRedirect( $returnUrl, CBTxt::T( 'GROUP_EVENT_STATE_FAILED_TO_SAVE', 'Event state failed to saved. Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );
		}

		if ( $state && ( $currentState === -1 ) ) {
			$extras			=	array(	'event_id'			=>	$row->getInt( 'id', 0 ),
										'event_title'		=>	$row->getString( 'title' ),
										'event_details'		=>	$row->getHtml( 'event' ),
										'event_address'		=>	$row->getString( 'address' ),
										'event_location'	=>	$row->getString( 'location' ),
										'event_date'		=>	$row->date(),
										'event'				=>	'<a href="' . $_CB_framework->pluginClassUrl( 'cbgroupjive', false, array( 'action' => 'groups', 'func' => 'show', 'id' => $row->getInt( 'group', 0 ), 'tab' => 'grouptabevents' ) ) . '">' . htmlspecialchars( $row->getString( 'title' ) ) . '</a>' );

			if ( $row->getInt( 'user_id', 0 ) !== $user->getInt( 'id', 0 ) ) {
				CBGroupJive::sendNotification( 'event_approved', 4, $user, $row->getInt( 'user_id', 0 ), CBTxt::T( 'Event schedule request accepted' ), CBTxt::T( 'Your event [event] schedule request in the group [group] has been accepted!' ), $row->group(), $extras );
			}

			CBGroupJive::sendNotifications( 'event_new', CBTxt::T( 'New group event' ), CBTxt::T( '[user] has scheduled the event [event] in the group [group]!' ), $row->group(), $row->getInt( 'user_id', 0 ), null, array( $user->getInt( 'id', 0 ) ), 1, $extras );
		}

		cbRedirect( $returnUrl, CBTxt::T( 'Event state saved successfully!' ) );
	}

	/**
	 * delete event
	 *
	 * @param int       $id
	 * @param UserTable $user
	 */
	private function deleteEvent( $id, $user )
	{
		global $_CB_framework;

		$row			=	CBGroupJiveEvents::getEvent( (int) $id );
		$returnUrl		=	$_CB_framework->pluginClassUrl( 'cbgroupjive', false, array( 'action' => 'groups', 'func' => 'show', 'id' => $row->getInt( 'group', 0 ) ) );

		if ( $row->getInt( 'id', 0 ) ) {
			if ( ! CBGroupJive::canAccessGroup( $row->group(), $user ) ) {
				cbRedirect( $returnUrl, CBTxt::T( 'Group does not exist.' ), 'error' );
			} elseif ( ! CBGroupJive::isModerator( $user->getInt( 'id', 0 ) ) ) {
				if ( ( $user->getInt( 'id', 0 ) !== $row->getInt( 'user_id', 0 ) ) && ( CBGroupJive::getGroupStatus( $user, $row->group() ) < 2 ) ) {
					cbRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to delete this event.' ), 'error' );
				}
			}
		} else {
			cbRedirect( $returnUrl, CBTxt::T( 'Event does not exist.' ), 'error' );
		}

		if ( ! $row->canDelete() ) {
			cbRedirect( $returnUrl, CBTxt::T( 'GROUP_EVENT_FAILED_TO_DELETE', 'Event failed to delete. Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );
		}

		if ( ! $row->delete() ) {
			cbRedirect( $returnUrl, CBTxt::T( 'GROUP_EVENT_FAILED_TO_DELETE', 'Event failed to delete. Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );
		}

		cbRedirect( $returnUrl, CBTxt::T( 'Event deleted successfully!' ) );
	}

	/**
	 * attend event
	 *
	 * @param int       $id
	 * @param UserTable $user
	 */
	private function attendEvent( $id, $user )
	{
		global $_CB_framework, $_CB_database;

		$event						=	CBGroupJiveEvents::getEvent( (int) $id );
		$returnUrl					=	$_CB_framework->pluginClassUrl( 'cbgroupjive', false, array( 'action' => 'groups', 'func' => 'show', 'id' => $event->getInt( 'group', 0 ) ) );

		if ( $event->getInt( 'id', 0 ) ) {
			if ( ! CBGroupJive::canAccessGroup( $event->group(), $user ) ) {
				CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'Group does not exist.' ), 'error' );
			} elseif ( ! CBGroupJive::isModerator( $user->getInt( 'id', 0 ) ) ) {
				if ( ( $event->getInt( 'published', 1 ) !== 1 ) && ( CBGroupJive::getGroupStatus( $user, $event->group() ) < 2 ) ) {
					CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'You do not have access to this event.' ), 'error' );
				} elseif ( ( ! $user->getInt( 'id', 0 ) ) || ( ( $event->group()->getInt( 'type', 0 ) !== 4 ) && ( CBGroupJive::getGroupStatus( $user, $event->group() ) < 1 ) ) ) {
					CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to attend this event.' ), 'error' );
				} elseif ( $event->status() === 1 ) {
					CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'You can not attend an expired event.' ), 'error' );
				} elseif ( $event->getInt( 'limit', 0 ) && ( $event->getInt( 'user_id', 0 ) !== $user->getInt( 'id', 0 ) ) ) {
					$query			=	'SELECT COUNT(*)'
									.	"\n FROM " . $_CB_database->NameQuote( '#__groupjive_plugin_events_attendance' ) . " AS a"
									.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__comprofiler' ) . " AS cb"
									.	' ON cb.' . $_CB_database->NameQuote( 'id' ) . ' = a.' . $_CB_database->NameQuote( 'user_id' )
									.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__users' ) . " AS j"
									.	' ON j.' . $_CB_database->NameQuote( 'id' ) . ' = a.' . $_CB_database->NameQuote( 'user_id' )
									.	"\n WHERE a." . $_CB_database->NameQuote( 'event' ) . " = " . $event->getInt( 'id', 0 )
									.	"\n AND cb." . $_CB_database->NameQuote( 'approved' ) . " = 1"
									.	"\n AND cb." . $_CB_database->NameQuote( 'confirmed' ) . " = 1"
									.	"\n AND j." . $_CB_database->NameQuote( 'block' ) . " = 0";
					$_CB_database->setQuery( $query );
					$guests			=	(int) $_CB_database->loadResult();

					if ( $guests >= $event->getInt( 'limit', 0 ) ) {
						CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'This event is full.' ), 'error' );
					}
				}
			}
		} else {
			CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'Event does not exist.' ), 'error' );
		}

		$row						=	new AttendanceTable();

		$row->load( array( 'user_id' => $user->getInt( 'id', 0 ), 'event' => $event->getInt( 'id', 0 ) ) );

		if ( $row->getInt( 'id', 0 ) ) {
			CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'You are already attending this event.' ), 'error' );
		}

		$row->set( 'user_id', $user->getInt( 'id', 0 ) );
		$row->set( 'event', $event->getInt( 'id', 0 ) );

		if ( $row->getError() || ( ! $row->check() ) ) {
			CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'GROUP_EVENT_ATTEND_FAILED', 'Event attend failed. Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );
		}

		if ( $row->getError() || ( ! $row->store() ) ) {
			CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'GROUP_EVENT_ATTEND_FAILED', 'Event attend failed. Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );
		}

		$extras						=	array(	'event_id'			=>	$event->getInt( 'id', 0 ),
												'event_title'		=>	$event->getString( 'title' ),
												'event_details'		=>	$event->getHtml( 'event' ),
												'event_address'		=>	$event->getString( 'address' ),
												'event_location'	=>	$event->getString( 'location' ),
												'event_date'		=>	$event->date(),
												'event'				=>	'<a href="' . $_CB_framework->pluginClassUrl( 'cbgroupjive', false, array( 'action' => 'groups', 'func' => 'show', 'id' => $event->getInt( 'group', 0 ), 'tab' => 'grouptabevents' ) ) . '">' . htmlspecialchars( CBTxt::T( $event->getString( 'title' ) ) ) . '</a>' );

		CBGroupJive::sendNotifications( 'event_attend', CBTxt::T( 'User attending your group event' ), CBTxt::T( '[user] will be attending your event [event] in the group [group]!' ), $event->group(), $user, $event->getInt( 'user_id', 0 ), array(), 1, $extras );

		CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'Event attended successfully!' ) );
	}

	/**
	 * unattend event
	 *
	 * @param int       $id
	 * @param UserTable $user
	 */
	private function unattendEvent( $id, $user )
	{
		global $_CB_framework;

		$event				=	CBGroupJiveEvents::getEvent( (int) $id );
		$returnUrl			=	$_CB_framework->pluginClassUrl( 'cbgroupjive', false, array( 'action' => 'groups', 'func' => 'show', 'id' => $event->getInt( 'group', 0 ) ) );

		if ( $event->getInt( 'id', 0 ) ) {
			if ( ! CBGroupJive::canAccessGroup( $event->group(), $user ) ) {
				CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'Group does not exist.' ), 'error' );
			} elseif ( ! CBGroupJive::isModerator( $user->getInt( 'id', 0 ) ) ) {
				if ( ( $event->getInt( 'published', 1 ) !== 1 ) && ( CBGroupJive::getGroupStatus( $user, $event->group() ) < 2 ) ) {
					CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'You do not have access to this event.' ), 'error' );
				} elseif ( ( ! $user->getInt( 'id', 0 ) ) || ( ( $event->group()->getInt( 'type', 0 ) !== 4 ) && ( CBGroupJive::getGroupStatus( $user, $event->group() ) < 1 ) ) ) {
					CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to unattend this event.' ), 'error' );
				} elseif ( $event->status() === 1 ) {
					CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'You can not unattend an expired event.' ), 'error' );
				}
			}
		} else {
			CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'Event does not exist.' ), 'error' );
		}

		$row				=	new AttendanceTable();

		$row->load( array( 'user_id' => $user->getInt( 'id', 0 ), 'event' => $event->getInt( 'id', 0 ) ) );

		if ( ! $row->getInt( 'id', 0 ) ) {
			CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'You can not unattend an event you are not attending.' ), 'error' );
		}

		if ( ! $row->canDelete() ) {
			CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'GROUP_EVENT_FAILED_TO_UNATTEND', 'Event failed to unattend. Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );
		}

		if ( ! $row->delete() ) {
			CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'GROUP_EVENT_FAILED_TO_UNATTEND', 'Event failed to unattend. Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );
		}

		$extras				=	array(	'event_id'			=>	$event->getInt( 'id', 0 ),
										'event_title'		=>	$event->getString( 'title' ),
										'event_details'		=>	$event->getHtml( 'event' ),
										'event_address'		=>	$event->getString( 'address' ),
										'event_location'	=>	$event->getString( 'location' ),
										'event_date'		=>	$event->date(),
										'event'				=>	'<a href="' . $_CB_framework->pluginClassUrl( 'cbgroupjive', false, array( 'action' => 'groups', 'func' => 'show', 'id' => $event->getInt( 'group', 0 ), 'tab' => 'grouptabevents' ) ) . '">' . htmlspecialchars( CBTxt::T( $event->getString( 'title' ) ) ) . '</a>' );

		CBGroupJive::sendNotifications( 'event_unattend', CBTxt::T( 'User unattended your group event' ), CBTxt::T( '[user] will no longer be attending your event [event] in the group [group]!' ), $event->group(), $user, $event->getInt( 'user_id', 0 ), array(), 1, $extras );

		CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'Event unattended successfully!' ) );
	}

	/**
	 * send event message
	 *
	 * @param int       $id
	 * @param UserTable $user
	 */
	private function sendEventMessage( $id, $user )
	{
		global $_CB_framework, $_CB_database;

		$row					=	CBGroupJiveEvents::getEvent( (int) $id );
		$returnUrl				=	$_CB_framework->pluginClassUrl( 'cbgroupjive', false, array( 'action' => 'groups', 'func' => 'show', 'id' => $row->getInt( 'group', 0 ) ) );

		if ( $row->getInt( 'id', 0 ) ) {
			if ( ! CBGroupJive::canAccessGroup( $row->group(), $user ) ) {
				cbRedirect( $returnUrl, CBTxt::T( 'Group does not exist.' ), 'error' );
			} elseif ( ! CBGroupJive::isModerator( $user->getInt( 'id', 0 ) ) ) {
				if ( ! $this->params->getBool( 'groups_events_message', false ) ) {
					cbRedirect( $returnUrl, CBTxt::T( 'You do not have access to messaging for this event.' ), 'error' );
				} elseif ( ( $row->status() === 1 )
						   || ( $row->getInt( 'published', 1 ) === -1 )
						   || ( CBGroupJive::getGroupStatus( $user, $row->group() ) < 1 )
						   || ( ( $user->getInt( 'id', 0 ) !== $row->getInt( 'user_id', 0 ) ) && ( CBGroupJive::getGroupStatus( $user, $row->group() ) < 3 ) )
				) {
					cbRedirect( $returnUrl, CBTxt::T( 'You do not have sufficient permissions to messaging for this event.' ), 'error' );
				} elseif ( $row->params()->getString( 'messaged' ) ) {
					$seconds	=	$this->params->getInt( 'groups_events_message_delay', 60 );

					if ( $seconds && ( Application::Date( $row->params()->getString( 'messaged' ), 'UTC' )->add( $seconds . ' SECONDS' )->getTimestamp() >= Application::Date( 'now', 'UTC' )->getTimestamp() ) ) {
						cbRedirect( $returnUrl, CBTxt::T( 'You can not send a message to this event at this time. Please wait awhile and try again.' ), 'error' );
					}
				}
			}
		} else {
			cbRedirect( $returnUrl, CBTxt::T( 'Event does not exist.' ), 'error' );
		}

		$message				=	( $this->params->getBool( 'groups_events_message_html', false ) ? $this->getInput()->getHtml( 'post/message' ) : $this->getInput()->getString( 'post/message' ) );

		if ( ! $message ) {
			$_CB_framework->enqueueMessage( CBTxt::T( 'GROUP_EVENT_MESSAGE_FAILED_TO_SEND', 'Event message failed to send! Error: [error]', array( '[error]' => CBTxt::T( 'Message not specified!' ) ) ), 'error' );

			$this->showEventMessage( $id, $user );
			return;
		}

		$query					=	'SELECT cb.*, j.*'
								.	"\n FROM " . $_CB_database->NameQuote( '#__groupjive_plugin_events_attendance' ) . " AS a"
								.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__groupjive_plugin_events' ) . " AS e"
								.	' ON e.' . $_CB_database->NameQuote( 'id' ) . ' = a.' . $_CB_database->NameQuote( 'event' )
								.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__comprofiler' ) . " AS cb"
								.	' ON cb.' . $_CB_database->NameQuote( 'id' ) . ' = a.' . $_CB_database->NameQuote( 'user_id' )
								.	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__users' ) . " AS j"
								.	' ON j.' . $_CB_database->NameQuote( 'id' ) . ' = a.' . $_CB_database->NameQuote( 'user_id' )
								.	"\n WHERE a." . $_CB_database->NameQuote( 'event' ) . " = " . $row->getInt( 'id', 0 )
								.	"\n AND cb." . $_CB_database->NameQuote( 'approved' ) . " = 1"
								.	"\n AND cb." . $_CB_database->NameQuote( 'confirmed' ) . " = 1"
								.	"\n AND j." . $_CB_database->NameQuote( 'block' ) . " = 0";
		$_CB_database->setQuery( $query );
		$users					=	$_CB_database->loadObjectList( null, '\CB\Database\Table\UserTable', array( $_CB_database ) );

		if ( ! $users ) {
			CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'This event has no guests to message.' ) );
		} else {
			$subject			=	$this->getInput()->getString( 'post/subject' );

			if ( $subject && ( $this->params->getInt( 'groups_events_message_type', 2 ) === 1 ) && $this->params->getBool( 'groups_events_message_subject', false ) ) {
				$subject		=	CBTxt::T( 'GROUP_EVENT_MESSAGE_SUBJECT', 'Event message - [subject]', array( '[subject]' => $subject ) );
			} else {
				$subject		=	CBTxt::T( 'Event message' );
			}

			$extras				=	array(	'event_id'			=>	$row->getInt( 'id', 0 ),
											'event_title'		=>	$row->getString( 'title' ),
											'event_details'		=>	$row->getHtml( 'event' ),
											'event_address'		=>	$row->getString( 'address' ),
											'event_location'	=>	$row->getString( 'location' ),
											'event_date'		=>	$row->date(),
											'event'				=>	'<a href="' . $_CB_framework->pluginClassUrl( 'cbgroupjive', false, array( 'action' => 'groups', 'func' => 'show', 'id' => $row->getInt( 'group', 0 ), 'tab' => 'grouptabevents' ) ) . '">' . htmlspecialchars( $row->getString( 'title' ) ) . '</a>' );

			CBGroupJive::prefetchUsers( $users );

			foreach ( $users as $usr ) {
				CBGroupJive::sendNotification( 'event_message', $this->params->getInt( 'groups_events_message_type', 2 ), $user, $usr, $subject, CBTxt::T( 'GROUP_EVENT_MESSAGE', 'Event [event] has sent the following message.<p>[message]</p>', array( '[message]' => $message ) ), $row->group(), $extras );
			}
		}

		$row->params()->set( 'messaged', Application::Database()->getUtcDateTime() );

		$row->set( 'params', $row->params()->asJson() );

		if ( $row->getError() || ( ! $row->store() ) ) {
			$_CB_framework->enqueueMessage( CBTxt::T( 'GROUP_EVENT_FAILED_TO_SAVE', 'Event failed to save! Error: [error]', array( '[error]' => $row->getError() ) ), 'error' );

			$this->showEventMessage( $id, $user );
			return;
		}

		CBGroupJive::returnRedirect( $returnUrl, CBTxt::T( 'Event messaged successfully!' ) );
	}
}