<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_notifly
 *
 * @copyright   Copyright (C) 2005 - 2017 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\Utilities\ArrayHelper;

/**
 * Design controller class.
 *
 * @since  1.6
 */
class NotiflyControllerDesign extends JControllerAdmin {

	function __construct () {

		parent::__construct();

		$this->registerTask("apply", "save");
		$this->registerTask("save", "save");

		$this->_model = $this->getModel("Design");
		$this->app = JFactory::getApplication();

	}

	function cancel() {
		$this->setRedirect('index.php?option=com_notifly');
	}


	function save () {

		// Check for request forgeries.
		if (!JSession::checkToken())
		{
			$this->app->enqueueMessage(JText::_('JINVALID_TOKEN'));
			$this->setRedirect('index.php?option=com_notifly&view=design');
		}

		$form   = $this->_model->getForm();
		$data   = $this->input->get('jform', array(), 'array');
		$id     = $this->input->getInt('id');
		$option = $this->input->get('com_notifly');
		$task = $this->input->get('task','apply');

		// Check if the user is authorized to do this.
		if (!JFactory::getUser()->authorise('core.admin', $option))
		{
			$this->app->enqueueMessage(JText::_('JERROR_ALERTNOAUTHOR'));
			$this->setRedirect('index.php?option=com_notifly&view=design');
		}

		// Validate the posted data.
		$return = $this->_model->validate($form, $data);

		// Check for validation errors.
		if ($return === false)
		{
			/*
			 * The validate method enqueued all messages for us, so we just need to redirect back.
			 */

			// Save the data in the session.
			$this->app->setUserState('com_notifly.design.global.data', $data);

			// Redirect back to the edit screen.
			$this->app->redirect(JRoute::_('index.php?option=com_notifly&view=design' . $redirect, false));
		}

		// Attempt to save the configuration.
		$data = array(
			'params' => $return,
			'id'     => $id,
			'option' => $option
		);

		try
		{
			$this->_model->save($data);
		}
		catch (RuntimeException $e)
		{
			// Save the data in the session.
			$this->app->setUserState('com_notifly.design.global.data', $data);

			// Save failed, go back to the screen and display a notice.
			$this->app->enqueueMessage(JText::sprintf('JERROR_SAVE_FAILED', $e->getMessage()), 'error');
			$this->app->redirect(JRoute::_('index.php?option=com_notifly&view=design' . $redirect, false));
		}

		// Set the redirect based on the task.
		switch ($task)
		{
			case 'apply':
				$this->app->enqueueMessage(JText::_('COM_COM_NOTIFLY_CONFIG_SAVED_SUCCESSFULLY'));
				$this->app->redirect(JRoute::_('index.php?option=com_notifly&view=design', false));

				break;

			case 'save':
			default:
				$redirect = 'index.php?option=com_notifly';
				$this->app->enqueueMessage(JText::_('COM_COM_NOTIFLY_CONFIG_SAVED_SUCCESSFULLY'));
				$this->app->redirect(JRoute::_($redirect, false));

				break;
		}

		return true;
	}
}
