<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_notifly
 *
 * @copyright   Copyright (C) 2005 - 2017 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

/**
 * Notifly component helper.
 *
 * @since  1.6
 */
class NotiflyHelper extends JHelperContent
{
	public static $extension = 'com_notifly';

	/**
	 * Configure the Linkbar.
	 *
	 * @param   string  $vName  The name of the active view.
	 *
	 * @return  void
	 *
	 * @since   1.6
	 */
	public static function addSubmenu($vName)
	{
		JHtmlSidebar::addEntry(
			JText::_('COM_NOTIFLY_SUBMENU_DASHBOARD'),
			'index.php?option=com_notifly&view=dashboard',
			$vName == 'dashboard'
		);
		JHtmlSidebar::addEntry(
			JText::_('COM_NOTIFLY_SUBMENU_TEMPLATES'),
			'index.php?option=com_notifly&view=templates',
			$vName == 'templates'
		);

		JHtmlSidebar::addEntry(
			JText::_('COM_NOTIFLY_SUBMENU_INTEGRATIONS'),
			'index.php?option=com_notifly&view=integrations',
			$vName == 'integrations'
		);

		JHtmlSidebar::addEntry(
			JText::_('COM_NOTIFLY_SUBMENU_EVENTS'),
			'index.php?option=com_notifly&view=events',
			$vName == 'events'
		);

		JHtmlSidebar::addEntry(
			JText::_('COM_NOTIFLY_SUBMENU_DESIGN'),
			'index.php?option=com_notifly&view=design',
			$vName == 'design'
		);
	}

	/**
	 * Applies the content tag filters to arbitrary text as per settings for current user group
	 *
	 * @param   text  $text  The string to filter
	 *
	 * @return  string  The filtered string
	 *
	 * @deprecated  4.0  Use JComponentHelper::filterText() instead.
	 */
	public static function filterText($text)
	{
		try
		{
			JLog::add(
				sprintf('%s() is deprecated. Use JComponentHelper::filterText() instead', __METHOD__),
				JLog::WARNING,
				'deprecated'
			);
		}
		catch (RuntimeException $exception)
		{
			// Informational log only
		}

		return JComponentHelper::filterText($text);
	}

	/**
	 * Returns valid contexts
	 *
	 * @return  array
	 *
	 * @since   3.7.0
	 */
	public static function getContexts()
	{
		JFactory::getLanguage()->load('com_notifly', JPATH_ADMINISTRATOR);

		$contexts = array(
			'com_notifly.template'    => JText::_('COM_NOTIFLY_SUBMENU_TEMPLATES'),
			'com_notifly.integration' => JText::_('COM_NOTIFLY_SUBMENU_INTEGRATIONS')
		);

		return $contexts;
	}

	/**
	 * Returns all notifly group plugins list
	 *
	 * @return  object
	 *
	 * @since   1.0.0
	 */
	public static function getGroupPlugins()
	{
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select("*")
			  ->from('#__extensions')
			  ->where($db->quoteName('type') . ' = ' . $db->quote('plugin'))
			  ->where($db->quoteName('folder') . ' = ' . $db->quote('notifly'))
			  ->setLimit('20');
		$db->setQuery($query);
		$result = $db->loadObjectList();

		return $result;
	}

	/*
	* to get update info
	* use layout to get alert structure
	*/

	public static function getUpdateStatus(){

		$update = self::checkUpdate();
		
		// if(isset($update->update_id) && $update->update_id)
		// {
		// 	$credentials = self::hasCredentials();
		// 	// Instantiate a new JLayoutFile instance and render the layout
		// 	$layout = new JLayoutFile('toolbar.update');
		// 	return $layout->render(array('info' => $update, 'credentials' => $credentials));		
		// }

		return $update;
	}

	/*
	* to get update info
	* use layout to get alert structure
	*/

	public static function checkUpdate(){
		// Get a database object.
		$return = [];
		$db = JFactory::getDbo();

		// get extensionid
		$query = $db->getQuery(true)
					->select('*')
					->from('#__extensions')
					->where($db->quoteName('type') . ' = ' . $db->quote('package'))
					->where($db->quoteName('element') . ' = ' . $db->quote('pkg_notifly'));

		$db->setQuery($query);
		
		$result1 = $db->loadObject();
		$extensionid = $result1->extension_id;

		$manifest_cache 	= json_decode($result1->manifest_cache);
		$return['old'] 		= $manifest_cache->version;

		// get update_site_id
		$query = $db->getQuery(true)
					->select('*')
					->from('#__updates')
					->where($db->quoteName('extension_id') . ' = ' . $db->quote($extensionid))
					->where($db->quoteName('element') . ' = ' . $db->quote('pkg_notifly'))
					->where($db->quoteName('type') . ' = ' . $db->quote('package'));
		$db->setQuery($query);
		
		$return2 = $db->loadObject();
		$return['new'] 	= (isset($return2->version) ? $return2->version : $manifest_cache->version);

		return $return;
		
	}

	public static function showWarning()
	{
		$layout = new JLayoutFile('notifly.warning');
		return $layout->render();
	}
}
