<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				Lmskaran 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.77
	@build			6th April, 2022
	@created		22nd July, 2020
	@package		Moojla
	@subpackage		enrolments.php
	@author			Lmskaran <http://Lmskaran.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\Utilities\ArrayHelper;

/**
 * Enrolments Controller
 */
class MoojlaControllerEnrolments extends JControllerAdmin
{
	/**
	 * The prefix to use with controller messages.
	 *
	 * @var    string
	 * @since  1.6
	 */
	protected $text_prefix = 'COM_MOOJLA_ENROLMENTS';

	/**
	 * Method to get a model object, loading it if required.
	 *
	 * @param   string  $name    The model name. Optional.
	 * @param   string  $prefix  The class prefix. Optional.
	 * @param   array   $config  Configuration array for model. Optional.
	 *
	 * @return  JModelLegacy  The model.
	 *
	 * @since   1.6
	 */
	public function getModel($name = 'Enrolment', $prefix = 'MoojlaModel', $config = array('ignore_request' => true))
	{
		return parent::getModel($name, $prefix, $config);
	}


/***[JCBGUI.admin_view.php_controller_list.139.$$$$]***/
  public function fetchEnrolments()
  {


      $params = JComponentHelper::getParams('com_moojla');
      $total_fetch_enrolment = $params->get('total_fetch_enrolment', 1000);
      $number_per_request_fetch_enrolment = $params->get('number_per_request_fetch_enrolment', 50);

      if (isset($_GET['c'])) {
          $c = $_GET['c'];
      } else {
          $c = 0;
      }

      $progress_percent = (($c / $total_fetch_enrolment) * 100);
      echo '<div class="progress">
                    <div class="progress-bar" role="progressbar" aria-valuenow="70"
                         aria-valuemin="0" aria-valuemax="100" style="
                         width:' . $progress_percent . '%;
                        float: left;
                        height: 100%;
                        font-size: 12px;
                        line-height: 20px;
                        color: #fff;
                        text-align: center;
                        background-color: #337ab7;
                        -webkit-box-shadow: inset 0 -1px 0 rgba(0,0,0,.15);
                        box-shadow: inset 0 -1px 0 rgba(0,0,0,.15);
                        -webkit-transition: width .6s ease;
                        -o-transition: width .6s ease;
                        transition: width .6s ease;">
                        ' . floor($progress_percent) . '%
                    </div>
                </div>';

    require_once JPATH_ADMINISTRATOR . "/components/com_moojla/models/enrolment.php";
    JLoader::register('MoojlaHelper', JPATH_ADMINISTRATOR.'/components/com_moojla/helpers/moojla.php');

    $user = JFactory::getUser();

    $dataObj = array(
      "wsfunction"          => "moojla_get_multiple_course_users",
      "moodlewsrestformat"  => "json",
    );

    $db = JFactory::getDbo(); 
    $query = $db->getQuery(true);
    $query->select($db->quoteName('remoteid', 'id'));
    $query->from($db->quoteName('#__moojla_course'));
    $query->where($db->quoteName('published') . ' = 1');
    $db->setQuery($query);
    $remoteids = $db->loadAssocList();
    $chunked_remoteids = array_chunk($remoteids, 100, true);



    foreach($chunked_remoteids as $chindex => $chremoteids)
    {
      $dataObj['courseids'] = $chremoteids;

      $enrolments = json_decode(MoojlaHelper::sendRequestToMoodle($dataObj)->response);

      foreach($enrolments as $enrolment)
      {

        JPluginHelper::importPlugin("moojlaevents");
        $dispatcher = JEventDispatcher::getInstance();
        foreach($enrolment->enrolments as $enrol)
        {
          $status = $dispatcher->trigger("addEnrolment", array($enrol->courseid, $enrolment->userid, $enrol->roleid, $enrol->timecreated));
          if($status[0])
          {
              $c++;

              if ($c == $total_fetch_enrolment) {
                  break 3;
              }
              if ($number_per_request_fetch_enrolment != -1 && $number_per_request_fetch_enrolment != 0){
                  if ($c % $number_per_request_fetch_enrolment == 0) {
                      echo "<script>window.location = '/administrator/index.php?option=com_moojla&view=enrolments&task=enrolments.fetchEnrolments&c=$c'</script>";
                      return 0;
                  }
              }

          }

        }
      }
    }
    $app = JFactory::getApplication();
    $message = $c . ' ' . JText::_('COM_MOOJLA_ENROLMENTS_FETCHED'); // translate_need
    $app->redirect(JRoute::_("index.php?option=com_moojla&view=enrolments", false), $message, 'message');
    return true;
  }/***[/JCBGUI$$$$]***/

}
