<?php
/**
 * ------------------------------------------------------------------------
 * JA Megafilter Component
 * ------------------------------------------------------------------------
 * Copyright (C) 2004-2016 J.O.O.M Solutions Co., Ltd. All Rights Reserved.
 * @license - GNU/GPL, http://www.gnu.org/licenses/gpl.html
 * Author: J.O.O.M Solutions Co., Ltd
 * Websites: http://www.joomlart.com - http://www.joomlancers.com
 * This file may not be redistributed in whole or significant part.
 * ------------------------------------------------------------------------
 */

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

if (!defined('DS')) {
	define('DS', DIRECTORY_SEPARATOR);
}

if (!JFactory::getUser()->authorise('core.manage', 'com_jamegafilter'))
{
    throw new JAccessExceptionNotallowed(JText::_('JERROR_ALERTNOAUTHOR'), 403);
}

JLoader::register('JaMegafilterHelper', __DIR__.'/helper.php');
JLoader::register('JFormFieldJaMegafilter_FilterFields', __DIR__.'/models/fields/jamegafilter_filterfields.php');

$app = JFactory::getApplication();
$input = $app->input;
$params = JComponentHelper::getParams('com_jamegafilter');
$cronToken = $params->get('crontoken');
$view = $input->get('view');

if (!$cronToken) {
    $app->enqueueMessage(JText::_('COM_JAMEGAFILTER_NEED_CRON_BEFORE_USE'), 'error');
    if ($view !== 'cron') {
        $app->redirect(JRoute::_('index.php?option=com_jamegafilter&view=cron', false));
    }
}

$controller = JControllerLegacy::getInstance('JaMegafilter');
$controller->execute($input->getCmd('task'));

// Redirect if set by the controller
$controller->redirect();
