<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');

jimport( 'joomla.application.component.view');
jimport( 'joomla.html.html');

use Dompdf\Dompdf;
use Dompdf\Options;

class InvoicesViewInvoice extends JViewLegacy
{
	function display($tpl = null)
	{
		require_once(JPATH_SITE.DS.'components'.DS.'com_invoices'.DS.'helpers'.DS.'dompdf'.DS.'autoload.inc.php');

		if(file_exists(JPATH_SITE.DS.'libraries'.DS.'joomla'.DS.'html'.DS.'html.php')) require_once(JPATH_SITE.DS.'libraries'.DS.'joomla'.DS.'html'.DS.'html.php');
		elseif(file_exists(JPATH_SITE.DS.'libraries'.DS.'cms'.DS.'html'.DS.'html.php')) require_once(JPATH_SITE.DS.'libraries'.DS.'cms'.DS.'html'.DS.'html.php');

		if(file_exists(JPATH_SITE.DS.'libraries'.DS.'joomla'.DS.'date'.DS.'date.php')) require_once(JPATH_SITE.DS.'libraries'.DS.'joomla'.DS.'date'.DS.'date.php');
		elseif(file_exists(JPATH_SITE.DS.'libraries'.DS.'cms'.DS.'html'.DS.'date.php')) require_once(JPATH_SITE.DS.'libraries'.DS.'cms'.DS.'html'.DS.'date.php');

		$mainframe = JFactory::getApplication();

		$document	= JFactory::getDocument();
		$uri	= JFactory::getURI();

		$this->invoice		= $this->get( 'Data');
		$this->template		= $this->get( 'Template');
		$this->items		= $this->get( 'Items');
		$this->taxes		= $this->get( 'TaxesInvoice');
		$this->payments		= $this->get( 'PaymentsInvoice');
		$this->payments2		= $this->get( 'PaymentsInvoice2');

		$this->params = JComponentHelper::getParams( 'com_invoices' );

		if($this->template->content_pdf) $this->template->content = $this->template->content_pdf ;

		$plantilla = 'email' ;

		$html = $this->loadTemplate($plantilla);

		$search = array("€", "¢", "£", "¤", "¥");
		$replace = array("&euro;", "&cent;", "&pound;", "&curren;", "&yen;");

		$html = str_replace($search, $replace, $html);

		$html = mb_convert_encoding($html, 'HTML-ENTITIES', 'UTF-8');

		$html = utf8_decode($html);

		$html = '<!DOCTYPE HTML>
				<html>
				<body>
				<style>
				'.$this->template->styles.'
				</style>'
				. $html .
				'</body></html>';

		$options = new Options();
		$options->set( 'isRemoteEnabled', TRUE );

		$dompdf = new Dompdf($options);
		$dompdf->set_paper('a4');
		$dompdf->load_html($html);
		$dompdf->render();
		$font = $dompdf->getFontMetrics()->get_font("helvetica");
		//$dompdf->getCanvas()->page_text(36, 18, "Powered by Invoice Manager for Joomla", $font, 10, array(0,0,0));
		//$dompdf->stream($invoice->invoice_num . ".pdf", array("Attachment" => false));
		$dompdf->stream($this->invoice->invoice_num);

		//trigger event
		$import = JPluginHelper::importPlugin( 'invoices' );
		$dispatcher = JDispatcher::getInstance();
		$dispatcher->trigger( 'onExportPDFInvoice', array( $this->invoice ) );

		exit();
	}

}
?>
