<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author        Germinal Camps
# copyright       Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license        http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites:       http://www.joomlathat.com
# Technical Support:  Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.'); 

$params = JComponentHelper::getParams( 'com_invoices' );

?>

<div class="inner-buttonbar"> 
  <button class="btn btn-primary " onclick="new_payment();return false;" ><span class="glyphicon glyphicon-plus"></span> <?php echo JText::_('ADD_NEW_PAYMENT'); ?></button>
  <button class="btn btn-danger  pull-right" disabled="disabled" onclick="delete_selected_payments();return false;" id="delete_payments_button" ><i class="glyphicon glyphicon-trash"></i> <?php echo JText::_('DELETE_SELECTED_PAYMENTS'); ?></button>
</div>
farhad sh
<table class="table table-striped" id="payments_table">
  <thead>
    <tr class="nodrag">
      <th width="20"></th>
      <th> <?php echo JText::_( 'DESCRIPTION' ); ?> </th>
      <th class="inputduedate"> <?php echo JText::_( 'DUE_DATE' ); ?> </th>
      <th class="hidden-sm"> <?php echo JText::_( 'PAYMENT_DATETIME' ); ?> </th>
      <th width="110"> <?php echo JText::_( 'PAID' ); ?> </th>
      <th width="20"> <?php echo JText::_( 'VALUE' ); ?> </th>
    </tr>
  </thead>
  <tbody id="payments-body">
    <?php
    $k = 0;
    for ($i=0, $n=count( $this->payments ); $i < $n; $i++)  {
      $payment = &$this->payments[$i];
      $checked  = JHTML::_('grid.id',   $i, $payment->id, false, 'pid' );

      $payment->payment_duedate = str_replace(" 00:00:00", "", $payment->payment_duedate);
      if($payment->payment_duedate == "0000-00-00") $payment->payment_duedate = "";

      if($payment->payment_datetime == "0000-00-00 00:00:00") $payment->payment_datetime = "";

      ?>
      <tr id="paymentrow<?php echo $payment->id;?>">
        <td><input type="checkbox" id="pcb<?php echo $payment->id;?>" name="pid[]" value="<?php echo $payment->id;?>" /></td>
        
        <td><input class="form-control" type="text" name="payment_description_<?php echo $payment->id;?>" id="payment_description_<?php echo $payment->id;?>" placeholder="<?php echo JText::_('PAYMENT_DESCRIPTION');?>" maxlength="255" value="<?php echo $payment->payment_description;?>" /></td>
        <td class="inputduedate">

          <div class="input-group" >
            <input  class="form-control " 
            type="text" 
            name="payment_duedate_<?php echo $payment->id; ?>" 
            id="payment_duedate_<?php echo $payment->id; ?>" 
            data-date-format="yyyy-mm-dd"
            value="<?php echo $payment->payment_duedate;?>" 
            placeholder="<?php echo JText::_( 'DUE_DATE' ); ?>"/>

            <span class="input-group-btn">
              <span class="btn btn-default" id="payment_duedate_btn_<?php echo $payment->id; ?>"><span class="glyphicon glyphicon-calendar" aria-hidden="true"></span></span>
            </span>
          </div>

          <script type="text/javascript">

          jQuery('#payment_duedate_<?php echo $payment->id; ?>').datepicker().on('changeDate', function(ev) {
            jQuery('#payment_duedate_<?php echo $payment->id; ?>').datepicker('hide');
          });

          jQuery("#payment_duedate_btn_<?php echo $payment->id; ?>").click(function() {
            jQuery('#payment_duedate_<?php echo $payment->id; ?>').datepicker('show');
          });

          </script>

        </td>
        <td class="hidden-sm inputpaymentdate">

          <div class="input-group" >
            <input  class="form-control " 
            type="text" 
            name="payment_datetime_<?php echo $payment->id; ?>" 
            id="payment_datetime_<?php echo $payment->id; ?>" 
            data-date-format="yyyy-mm-dd"
            value="<?php echo $payment->payment_datetime;?>" 
            placeholder="<?php echo JText::_( 'PAYMENT_DATETIME' ); ?>"/>

            <span class="input-group-btn">
              <span class="btn btn-default" id="payment_datetime_btn_<?php echo $payment->id; ?>"><span class="glyphicon glyphicon-calendar" aria-hidden="true"></span></span>
            </span>
          </div>

          <script type="text/javascript">

          jQuery('#payment_datetime_<?php echo $payment->id; ?>').datepicker().on('changeDate', function(ev) {
            jQuery('#payment_datetime_<?php echo $payment->id; ?>').datepicker('hide');
          });

          jQuery("#payment_datetime_btn_<?php echo $payment->id; ?>").click(function() {
            jQuery('#payment_datetime_<?php echo $payment->id; ?>').datepicker('show');
          });

          </script>

        </td>
        <td><div id="sign_group" class=" btn-group" data-toggle="buttons">
          <label class="btn btn-default <?php if($payment->payment_status) echo "active"; ?>" for="payment_status_<?php echo $payment->id;?>_1"> <? echo JText::_('JYES'); ?>
            <input class="radio_toggle" type="radio" <?php if($payment->payment_status) echo "checked='checked'"; ?> value="1" name="payment_status_<?php echo $payment->id;?>" id="payment_status_<?php echo $payment->id;?>_1" />
          </label>
          <label class="btn btn-default <?php if(!$payment->payment_status) echo "active"; ?>" for="payment_status_<?php echo $payment->id;?>_0"> <? echo JText::_('JNO'); ?>
            <input class="radio_toggle" type="radio" <?php if(!$payment->payment_status) echo "checked='checked'"; ?> value="0" name="payment_status_<?php echo $payment->id;?>" id="payment_status_<?php echo $payment->id;?>_0" />
          </label>
        </div></td>
        <td><div class="input-group"> <span class="input-group-addon currency_before"><?php echo $this->invoice->currency_before;?></span>
          <input class="form-control input-mini payments_amount" onchange="calculate_payments()" type="text" name="payment_value_<?php echo $payment->id;?>" id="payment_value_<?php echo $payment->id;?>" size="10" maxlength="10" value="<?php echo $payment->payment_amount;?>" />
          <span class="input-group-addon currency_after"><?php echo $this->invoice->currency_after;?></span> </div></td>
        </tr>
        <?php
        $k = 1 - $k;
      }
      ?>
    </tbody>
    <tfoot>
      <tr class="nodrag">
        <td ></td>
        <td class="hidden-sm"></td>

        <td  class="invoice_total" colspan="3"><?php echo JText::_( 'PAYMENTS_TOTAL' ); ?></td>
        <td><div class="input-group"> <span class="input-group-addon currency_before"><?php echo $this->invoice->currency_before;?></span>
          <input class="form-control input-mini " readonly  type="text" id="payments_total" size="4" maxlength="10" value="" />
          <span class="input-group-addon currency_after"><?php echo $this->invoice->currency_after;?></span> </div></td>
        </tr>
      </tfoot>
    </table>
    <div class="bs-callout bs-callout-info"><span class="label label-info"><?php echo JText::_('TIP'); ?></span>
      <label for="automatic_payment" class="">
        <input  type="checkbox" value="1" name="automatic_payment" id="automatic_payment" <?php if($this->invoice->id == 0) echo "checked"; ?> />
        <? echo JText::_('CHECKBOX_AUTOMATIC_PAYMENT'); ?></label>
      </div>

  <script type="text/javascript">

    calculate_payments();

    jQuery("#payments_table").tableDnD({dragHandle: ".dragHandle", onDragClass: "info"});

   jQuery("#payments_table input[name^=pid]").each( function() {
      
      jQuery(this).on('click', function() {
        
        if(check_checkboxes_payments()) enable_delete_payment_button();
        else disable_delete_payment_button();
       
      });
    });

  </script>
