<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');

class TemplatesControllerTemplate extends TemplatesController
{

	function __construct()
	{
		parent::__construct();

		// Register Extra tasks
		$this->registerTask( 'add'  , 	'edit' );
		$this->registerTask( 'apply',	'save' );
	}

	function edit()
	{
		$this->input->set( 'view', 'template' );
		
		if($this->input->getVar( 'layout' ) == "editor"){
			 $this->input->set( 'layout', 'editor'  );
			 
		}
		else $this->input->set( 'layout', 'form'  );
		
		$this->input->set('hidemainmenu', 1);

		parent::display();
	}

	function save()
	{
		$model = $this->getModel('template');

		if ($model->store($post)) {
			$msg = JText::_( 'TEMPLATE_SAVED' );
		} else {
			$msg = JText::_( 'ERROR_SAVING_TEMPLATE' );
		}

		$task = $this->input->getCmd( 'task' );
		$id = $this->input->getVar('id');
		$layout = $this->input->getVar( 'layout');

		switch ($task)
		{
			case 'apply':
				$link = 'index.php?option=com_invoices&controller=template&task=edit&layout='.$layout.'&cid[]='. $id ;
				break;

			case 'save':
			default:
				$link = 'index.php?option=com_invoices&controller=templates';
				break;
		}
		
		
		$this->setRedirect($link, $msg);
	}

	function duplicate()
	{
		
		$cids = $this->input->getVar( 'cid', array(0), 'post', 'array' );

		$model = $this->getModel('template');

		if (count( $cids )) {
			foreach($cids as $cid) {
				$model->duplicate($cid);
			}
		}
		
		$msg = JText::_( 'TEMPLATES_DUPLICATED' );

		$this->setRedirect( 'index.php?option=com_invoices&controller=templates', $msg );
	}

	function remove()
	{
		$model = $this->getModel('template');
		if(!$model->delete()) {
			$msg = JText::_( 'ERROR_DELETING_TEMPLATES' );
		} else {
			$msg = JText::_( 'TEMPLATES_DELETED' );
		}

		$this->setRedirect( 'index.php?option=com_invoices&controller=templates', $msg );
	}

	function cancel()
	{
		$msg = JText::_( 'OPERATION_CANCELLED' );
		$this->setRedirect( 'index.php?option=com_invoices&controller=templates', $msg );
	}
}