<?php

/*------------------------------------------------------------------------
# com_invoices - Invoice Manager for Joomla
# ------------------------------------------------------------------------
# author				Germinal Camps
# copyright 			Copyright (C) 2012 - 2016 JoomlaThat.com. All Rights Reserved.
# @license				http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: 			http://www.joomlathat.com
# Technical Support:	Forum - http://www.joomlathat.com/support
-------------------------------------------------------------------------*/

//no direct access
defined('_JEXEC') or die('Restricted access.');

class InvoicesControllerInvoices extends InvoicesController
{

	function __construct()
	{
		parent::__construct();
		$this->input->set('view', 'invoices');

	}

	function export(){

		require_once(JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_invoices'.DS.'views'.DS.'invoices'.DS.'view.html.php');

		$model = $this->getModel('invoices');
		$view = new InvoicesViewInvoices();

		$type = JRequest::getString('exporttype');

		$max = 5000;
		$total = $model->getTotal();
		if($total > $max){
			$link = 'index.php?option=com_invoices';
			$msg = JText::sprintf('YOU_CANONT_EXPORT', $max, $max) ;
			$this->setRedirect($link, $msg, "warning");
		}
		else{

			$filename = "export_" . date('Y_m_d') . ".csv";

			header("Content-Disposition: attachment; filename=\"$filename\"");
			header("Content-Type: text/csv");

			$view->setModel($model);

			$view->pagination = $model->getPagination();
			$view->cal_start = $model->getCalstart();
			$view->cal_end = $model->getCalend();

			if($type == "grouped") $view->items = $model->getDataGrouped();
			else $view->items = $model->getData();

			$view->taxes = InvoicesHelper::getTaxes();
			$view->status = $model->getStatus();
			$view->status_id = $model->getStatusId();

			$content = $view->loadTemplate( 'csv'.$type );

			echo $content;

			die;

		}

	}

	function load_items(){

		$params = JComponentHelper::getParams( 'com_invoices' );

		$model = $this->getModel('invoices');

		$items = $model->getData();
		$summary = $model->getTotals();

		$result = new stdClass();
		$result->items = $items;
		$result->summary = $summary;

		$this->sendJSONResponse($result);

	}

	function get_totals(){

		$params = JComponentHelper::getParams( 'com_invoices' );

		$model = $this->getModel('invoices');

		$summary = $model->getTotals();

		$return = new stdClass();
		$return->notifications = array();

		//we fill the content to return
		$return->content = $summary ;

		$this->sendJSONResponse($result);

	}

	function update_taxes(){

		//function to update taxes method from 2.0 to 2.1

		$model = $this->getModel('invoice');

		$db = JFactory::getDBO();
		$query = " SELECT * FROM #__invoices_invoices WHERE taxes != '' ";
		$db->setQuery($query);
		$invoices = $db->loadObjectList();

		$query = " SELECT * FROM #__invoices_taxes ";
		$db->setQuery($query);
		$alltaxes = $db->loadObjectList('id');

		foreach($invoices as $invoice){
			$taxes = explode(",", $invoice->taxes);
			foreach($taxes as $tax){
				$model->add_tax_to_invoice($tax, $alltaxes[$tax]->value, $invoice->id);
			}

			$invoice_computed_total = InvoicesHelper::get_total_from_id($invoice->id, true) ;

			$query = "UPDATE #__invoices_invoices SET computed_total = '$invoice_computed_total' WHERE id = " . $invoice->id ;
			$db->setQuery($query);
			$db->query();
		}
	}

}
