<?php
/**
 * Form Field class for the Joomla HDP.
 * Supports a message form field
 *
 * @package     Joomla.HDP
 * @subpackage  Form
 */

use OSSolution\HelpdeskPro\Site\Helper\Html as HelpdeskProHelperHtml;

class HDPFormFieldMessage extends HDPFormField
{

	/**
	 * The form field type.
	 *
	 * @var    string
	 *
	 */
	protected $type = 'Message';

	/**
	 * Method to get the field input markup.
	 *
	 * @param   HelpdeskProHelperBootstrap  $bootstrapHelper
	 *
	 * @return  string  The field input markup.
	 *
	 */
	protected function getInput($bootstrapHelper = null)
	{
		$controlGroupAttributes = 'id="field_' . $this->id . '"';

		if (!$this->visible)
		{
			$controlGroupAttributes .= ' style="display:none;" ';
		}

		$data = [
			'controlGroupAttributes' => $controlGroupAttributes,
			'description'            => $this->description,
			'bootstrapHelper'        => $bootstrapHelper,
			'row'                    => $this->row,
		];

		return HelpdeskProHelperHtml::loadCommonLayout('fieldlayout/message.php', $data);
	}

	/**
	 * Get control group used to display on form
	 *
	 * @param   bool                        $tableLess
	 * @param   HelpdeskProHelperBootstrap  $bootstrapHelper
	 *
	 * @return string
	 */
	public function getControlGroup($tableLess = true, $bootstrapHelper = null)
	{
		return $this->getInput($bootstrapHelper);
	}

	/**
	 * Get output used for displaying on email and the detail page
	 *
	 * @param   bool                        $tableLess
	 * @param   HelpdeskProHelperBootstrap  $bootstrapHelper
	 *
	 * @return string
	 */
	public function getOutput($tableLess = true, $bootstrapHelper = null)
	{
		if ($tableLess)
		{
			return $this->getInput($bootstrapHelper);
		}

		return '<tr>' . '<td class="eb-message" colspan="2">' . $this->description . '</td></tr>';
	}
}