<?php
/**
 * Supports a custom field which display a date picker
 *
 * @package     Joomla.HDP
 * @subpackage  Form
 */

use Joomla\CMS\HTML\HTMLHelper;

class HDPFormFieldDate extends HDPFormField
{

	/**
	 * The form field type.
	 *
	 * @var    string
	 *
	 */
	protected $type = 'Date';

	/**
	 * Method to get the field input markup.
	 *
	 * @param HelpdeskProHelperBootstrap $bootstrapHelper
	 *
	 * @return  string  The field input markup.
	 *
	 */
	protected function getInput($bootstrapHelper = null)
	{
		$attributes = $this->buildAttributes();

		return HTMLHelper::_('calendar', $this->value, $this->name, $this->name, '%Y-%m-%d', ".$attributes.");
	}
}