<?php
/**
 * @version        4.3.0
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2021 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Admin\View\Ticket;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\CMS\Uri\Uri;
use OSL\View\ItemView;
use OSSolution\HelpdeskPro\Site\Helper\Database as HelpdeskproHelperDatabase;
use OSSolution\HelpdeskPro\Site\Helper\Helper as HelpdeskproHelper;
use OSSolution\HelpdeskPro\Site\Helper\Html as HelpdeskproHelperHtml;

defined('_JEXEC') or die;

/**
 * @property \OSSolution\HelpdeskPro\Admin\Model\Ticket $model
 */
class Html extends ItemView
{
	/**
	 * Get extra data needed to render the form
	 *
	 * @return void
	 */
	protected function beforeRender()
	{
		parent::beforeRender();

		HelpdeskproHelper::loadEditable();

		// Remove the uploaded files data from section
		$this->container->session->clear('hdp_uploaded_files');
		$this->container->session->clear('hdp_uploaded_files_original_names');

		$layout = $this->getLayout();

		if ($layout == 'form')
		{
			$this->beforeRenderTicketForm();

			return;
		}

		if (empty($this->item->id))
		{
			// Invalid ticket, redirect to ticket list page
			$app = $this->container->app;

			$app->enqueueMessage(Text::_('HDP_TICKET_NOT_EXISTS'), 'warning');
			$app->redirect('index.php?option=com_helpdeskpro&view=tickets');
		}

		$config   = HelpdeskproHelper::getConfig();
		$rows     = HelpdeskproHelperDatabase::getAllCategories();
		$children = [];

		if ($rows)
		{
			// first pass - collect children
			foreach ($rows as $v)
			{
				$pt   = (int) $v->parent_id;
				$list = @$children[$pt] ? $children[$pt] : [];
				array_push($list, $v);
				$children[$pt] = $list;
			}
		}
		$categories = HTMLHelper::_('menu.treerecurse', 0, '', [], $children, 9999, 0, 0);


		PluginHelper::importPlugin('helpdeskpro');

		//Trigger plugins
		$results = $this->container->app->triggerEvent('onViewTicket', [$this->item]);

		if ($config->highlight_code)
		{
			HelpdeskproHelper::loadHighlighter();
		}

		// Add js variables
		$maxNumberOfFiles = $config->max_number_attachments ? (int) $config->max_number_attachments : 1;

		$siteUrl = Uri::base();
		$this->container->document->addScriptDeclaration("
			var maxAttachment = $maxNumberOfFiles;
			var currentCategory = 0;
			var currentNumberAttachment = 1;
			var currentStatus = 0;
			var hdpSiteUrl = '$siteUrl';			
		");

		$canConvertToKb = false;
		$db             = $this->container->db;
		$query          = $db->getQuery(true);
		$query->select('category_type')
			->from('#__helpdeskpro_categories')
			->where('id = ' . (int) $this->item->category_id);
		$db->setQuery($query);
		$categoryType = $db->loadResult();

		if ($categoryType == 0)
		{
			$canConvertToKb = true;
		}

		$db->setQuery($query);
		$this->fields         = HelpdeskproHelper::getFields($this->item->category_id);
		$this->messages       = $this->model->getMessages();
		$this->fieldValues    = $this->model->getFieldsValue();
		$this->rowStatuses    = HelpdeskproHelperDatabase::getAllStatuses();
		$this->rowPriorities  = HelpdeskproHelperDatabase::getAllPriorities();
		$this->rowLabels      = HelpdeskproHelperDatabase::getAllLabels();
		$this->categories     = $categories;
		$this->dateFormat     = $config->date_format;
		$this->config         = $config;
		$this->results        = $results;
		$this->onlineUserIds  = HelpdeskproHelper::getOnlineUsers();
		$this->canConvertToKb = $canConvertToKb;
	}

	/**
	 * Generate form allows admin creating new ticket
	 */
	private function beforeRenderTicketForm()
	{
		$config                     = HelpdeskproHelper::getConfig();
		$this->lists['category_id'] = HelpdeskproHelperHtml::buildCategoryDropdown(0, 'category_id', 'onchange="HDP.showFields(this.form);" class="form-select"');

		$options   = [];
		$options[] = HTMLHelper::_('select.option', 0, Text::_('HDP_CHOOSE_PRIORITY'), 'id', 'title');
		$options   = array_merge($options, HelpdeskproHelperDatabase::getAllPriorities());

		$this->lists['priority_id'] = HTMLHelper::_('select.genericlist', $options, 'priority_id', [
			'option.text.toHtml' => false,
			'option.text'        => 'title',
			'option.key'         => 'id',
			'list.attr'          => 'class="form-select"',
			'list.select'        => $config->default_ticket_priority_id,
		]);

		$options   = [];
		$options[] = HTMLHelper::_('select.option', -1, Text::_('HDP_APPLY_LABEL'), 'id', 'title');
		$options[] = HTMLHelper::_('select.option', 0, Text::_('HDP_NO_LABEL'), 'id', 'title');
		$options   = array_merge($options, HelpdeskproHelperDatabase::getAllLabels());

		$this->lists['label_id'] = HTMLHelper::_('select.genericlist', $options, 'label_id', [
			'option.text.toHtml' => false,
			'option.text'        => 'title',
			'option.key'         => 'id',
			'list.attr'          => 'class="form-select"',
			'list.select'        => $config->default_ticket_priority_id,
		]);


		$rowFields = HelpdeskproHelper::getAllFields();
		$form      = new \HDPForm($rowFields);

		$relation = HelpdeskproHelper::getFieldCategoryRelation();
		$form->prepareFormField(0, $relation);

		$fieldJs = "fields = new Array();\n";
		foreach ($relation as $catId => $fieldList)
		{
			$fieldJs .= ' fields[' . $catId . '] = new Array("' . implode('","', $fieldList) . '");' . "\n";
		}

		$document = $this->container->document;
		$document->addScriptDeclaration($fieldJs);

		$maxNumberOfFiles = $config->max_number_attachments ? (int) $config->max_number_attachments : 1;
		$document->addScriptDeclaration("
			var maxAttachment = $maxNumberOfFiles;
			var currentCategory = 0;
			var currentNumberAttachment = 1; 
		");

		$this->form = $form;


		$this->config = $config;
	}

	/**
	 * Override default toolbar buttons
	 */
	protected function addToolbar()
	{
		if ($this->item->id)
		{
			$toolbarTitle = $this->container->languagePrefix . '_' . $this->name . '_VIEW';
		}
		else
		{
			$toolbarTitle = $this->container->languagePrefix . '_' . $this->name . '_NEW';
		}

		ToolbarHelper::title(Text::_(strtoupper($toolbarTitle)));

		ToolbarHelper::cancel('ticket.cancel');
	}
}