<?php
/**
 * @version        4.3.0
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2021 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

use Joomla\CMS\Editor\Editor;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Multilanguage;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Toolbar\ToolbarHelper;

ToolbarHelper::title(Text::_('Email Messages'), 'generic.png');
ToolbarHelper::apply('apply', 'JTOOLBAR_APPLY');
ToolbarHelper::save('save');
ToolbarHelper::cancel('cancel');

if (HelpdeskproHelper::isJoomla4())
{
	$tabApiPrefix = 'uitab.';
}
else
{
	$tabApiPrefix = 'bootstrap.';
}

$translatable = Multilanguage::isEnabled() && count($this->languages);
$editor       = Editor::getInstance(Factory::getConfig()->get('editor'));
?>
<form action="index.php?option=com_helpdeskpro&view=email" method="post" name="adminForm" id="adminForm" class="form form-horizontal">
    <?php
        if ($translatable)
        {
	        echo HTMLHelper::_($tabApiPrefix . 'startTabSet', 'email', array('active' => 'general-page'));
	        echo HTMLHelper::_($tabApiPrefix . 'addTab', 'email', 'general-page', Text::_('HDP_GENERAL', true));
        }
        ?>
            <div class="control-group">
                <div class="control-label">
                    <?php echo Text::_('HDP_NEW_TICKET_ADMIN_EMAIL_SUBJECT'); ?>
                </div>
                <div class="controls">
                    <input type="text" name="new_ticket_admin_email_subject" class="input-xxlarge form-control"
                           value="<?php echo $this->item->new_ticket_admin_email_subject; ?>" size="50"/>
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo Text::_('HDP_NEW_TICKET_ADMIN_EMAIL_BODY'); ?>
                </div>
                <div class="controls">
                    <?php echo $editor->display('new_ticket_admin_email_body', $this->item->new_ticket_admin_email_body, '100%', '250', '75', '8'); ?>
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo Text::_('HDP_NEW_TICKET_USER_EMAIL_SUBJECT'); ?>
                </div>
                <div class="controls">
                    <input type="text" name="new_ticket_user_email_subject" class="input-xxlarge form-control"
                           value="<?php echo $this->item->new_ticket_user_email_subject; ?>" size="50"/>
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo Text::_('HDP_NEW_TICKET_USER_EMAIL_BODY'); ?>
                </div>
                <div class="controls">
                    <?php echo $editor->display('new_ticket_user_email_body', $this->item->new_ticket_user_email_body, '100%', '250', '75', '8'); ?>
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo Text::_('HDP_TICKET_UPDATED_ADMIN_EMAIL_SUBJECT'); ?>
                </div>
                <div class="controls">
                    <input type="text" name="ticket_updated_admin_email_subject" class="input-xxlarge form-control"
                           value="<?php echo $this->item->ticket_updated_admin_email_subject; ?>" size="50"/>
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo Text::_('HDP_TICKET_UPDATED_ADMIN_EMAIL_BODY'); ?>
                </div>
                <div class="controls">
                    <?php echo $editor->display('ticket_updated_admin_email_body', $this->item->ticket_updated_admin_email_body, '100%', '250', '75', '8'); ?>
                </div>
                <div class="controls">
                    <strong><?php echo Text::_('HDP_AVAILABLE_TAGS'); ?></strong>
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo Text::_('HDP_TICKET_UPDATED_USER_EMAIL_SUBJECT'); ?>
                </div>
                <div class="controls">
                    <input type="text" name="ticket_updated_user_email_subject" class="input-xxlarge form-control"
                           value="<?php echo $this->item->ticket_updated_user_email_subject; ?>" size="50"/>
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo Text::_('HDP_TICKET_UPDATED_USER_EMAIL_BODY'); ?>
                </div>
                <div class="controls">
                    <?php echo $editor->display('ticket_updated_user_email_body', $this->item->ticket_updated_user_email_body, '100%', '250', '75', '8'); ?>
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo Text::_('HDP_TICKET_ASSIGN_EMAIL_SUBJECT'); ?>
                </div>
                <div class="controls">
                    <input type="text" name="ticket_assiged_email_subject" class="input-xxlarge form-control"
                           value="<?php echo $this->item->ticket_assiged_email_subject; ?>" size="50"/>
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo Text::_('HDP_TICKET_ASSIGN_EMAIL_BODY'); ?>
                </div>
                <div class="controls">
                    <?php echo $editor->display('ticket_assiged_email_body', $this->item->ticket_assiged_email_body, '100%', '250', '75', '8'); ?>
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo Text::_('HDP_CUSTOMER_TICKET_ASSIGN_EMAIL_SUBJECT'); ?>
                </div>
                <div class="controls">
                    <input type="text" name="customer_ticket_assigned_email_subject" class="input-xxlarge form-control"
                           value="<?php echo $this->item->customer_ticket_assigned_email_subject; ?>" size="50"/>
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo Text::_('HDP_CUSTOMER_TICKET_ASSIGN_EMAIL_BODY'); ?>
                </div>
                <div class="controls">
                    <?php echo $editor->display('customer_ticket_assigned_email_body', $this->item->customer_ticket_assigned_email_body, '100%', '250', '75', '8'); ?>
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo Text::_('HDP_CUSTOMER_TICKET_CLOSED_EMAIL_SUBJECT'); ?>
                </div>
                <div class="controls">
                    <input type="text" name="customer_ticket_closed_email_subject" class="input-xxlarge form-control"
                           value="<?php echo $this->item->customer_ticket_closed_email_subject; ?>" size="50"/>
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo Text::_('HDP_CUSTOMER_TICKET_CLOSED_EMAIL_BODY'); ?>
                </div>
                <div class="controls">
                    <?php echo $editor->display('customer_ticket_closed_email_body', $this->item->customer_ticket_closed_email_body, '100%', '250', '75', '8'); ?>
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo Text::_('HDP_MANAGER_TICKET_CLOSED_EMAIL_SUBJECT'); ?>
                </div>
                <div class="controls">
                    <input type="text" name="manager_ticket_closed_email_subject" class="input-xxlarge form-control"
                           value="<?php echo $this->item->manager_ticket_closed_email_subject; ?>" size="50"/>
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo Text::_('HDP_MANAGER_TICKET_CLOSED_EMAIL_BODY'); ?>
                </div>
                <div class="controls">
                    <?php echo $editor->display('manager_ticket_closed_email_body', $this->item->manager_ticket_closed_email_body, '100%', '250', '75', '8'); ?>
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo Text::_('HDP_CUSTOMER_TICKET_STATUS_CHANGED_EMAIL_SUBJECT'); ?>
                </div>
                <div class="controls">
                    <input type="text" name="customer_ticket_status_changed_email_subject" class="input-xxlarge form-control"
                           value="<?php echo $this->item->customer_ticket_status_changed_email_subject; ?>" size="50"/>
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo Text::_('HDP_CUSTOMER_TICKET_STATUS_CHANGED_EMAIL_BODY'); ?>
                </div>
                <div class="controls">
                    <?php echo $editor->display('customer_ticket_status_changed_email_body', $this->item->customer_ticket_status_changed_email_body, '100%', '250', '75', '8'); ?>
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo Text::_('HDP_MANAGER_TICKET_STATUS_CHANGED_EMAIL_SUBJECT'); ?>
                </div>
                <div class="controls">
                    <input type="text" name="manager_ticket_status_changed_email_subject" class="input-xxlarge form-control"
                           value="<?php echo $this->item->manager_ticket_status_changed_email_subject; ?>" size="50"/>
                </div>
            </div>
            <div class="control-group">
                <div class="control-label">
                    <?php echo Text::_('HDP_MANAGER_TICKET_STATUS_CHANGED_EMAIL_BODY'); ?>
                </div>
                <div class="controls">
                    <?php echo $editor->display('manager_ticket_status_changed_email_body', $this->item->manager_ticket_status_changed_email_body, '100%', '250', '75', '8'); ?>
                </div>
            </div>
        <?php

        if ($translatable)
        {
	        echo HTMLHelper::_($tabApiPrefix . 'endTab');
	        echo $this->loadTemplate('translation', ['editor' => $editor]);
	        echo HTMLHelper::_($tabApiPrefix . 'endTabSet');
        }
        ?>
		<input type="hidden" name="task" value=""/>
	    <?php echo HTMLHelper::_('form.token'); ?>
</form>