(function ($) {
    $.fn.insertAtCaret = function (text) {
        return this.each(function () {
            if (document.selection && this.tagName == 'TEXTAREA') {
                //IE textarea support
                this.focus();
                sel = document.selection.createRange();
                sel.text = text;
                this.focus();
            } else if (this.selectionStart || this.selectionStart == '0') {
                //MOZILLA/NETSCAPE support
                startPos = this.selectionStart;
                endPos = this.selectionEnd;
                scrollTop = this.scrollTop;
                this.value = this.value.substring(0, startPos) + text + this.value.substring(endPos, this.value.length);
                this.focus();
                this.selectionStart = startPos + text.length;
                this.selectionEnd = startPos + text.length;
                this.scrollTop = scrollTop;
            } else {
                // IE input[type=text] and other browsers
                this.value += text;
                this.focus();
                this.value = this.value;    // forces cursor to end
            }
        });
    };

    $(document).ready(function () {
        $("#ajaxAssign").click(function () {
            var replies_id = $("#replies_id").val();
            var siteUrl = Joomla.getOptions('siteUrl');
            $.ajax({
                type: 'POST',
                url: siteUrl + '/index.php?option=com_helpdeskpro&task=get_reply&reply_id=' + replies_id,
                success: function (msg) {
                    $(".hdp_fullwidth").insertAtCaret(msg);
                }
            });
            return false;
        });
    });
})(jQuery);