var payment_component = Vue.extend({
  template: '#payment-vue-template',
  props: {
    payment: Object,
    extended: {
      type: Boolean,
      default: true
    },
  },
  replace: false,
  computed: {
    status_class: function() {

      var status = "default";

      switch (this.payment.getStatus()) {
        case "paid": case "paid_late":
          status = "success";
          break;
        case "unpaid_ontime":
          status = "warning";
          break;
        case "pastdue":
          status = "danger";
          break;
        case "pending": default:
          status = "default";
          break;
      }

      return status;
    },
    status_name: function() {
      return Joomla.JText._(this.payment.getStatus());
    }
  },
  methods: {
    edit_payment: function () {
      edit_payment(this.payment.id)
    },
  },
  mounted: function(){
    jQuery("#row"+this.payment.id+' [data-toggle="tooltip"]').tooltip();
  }
});
