<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Core\AutoLoader;
use CBLib\Registry\Registry;
use CB\Database\Table\FieldTable;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

AutoLoader::registerExactMap( '%^CB/Plugin/Query/(.+)%i', __DIR__ . '/library/$1.php' );

function plug_cbqueryfield_install()
{
	global $_CB_database;

	$query					=	'SELECT *'
							.	"\n FROM " . $_CB_database->NameQuote( '#__comprofiler_fields' )
							.	"\n WHERE " . $_CB_database->NameQuote( 'params' ) . " LIKE " . $_CB_database->Quote( '%qry_update%' );
	$_CB_database->setQuery( $query );
	$fields					=	$_CB_database->loadObjectList( null, FieldTable::class, [ $_CB_database ] );

	/** @var FieldTable[] $fields */
	foreach ( $fields as $field ) {
		$fieldParams		=	new Registry( $field->params );

		if ( ! $fieldParams->has( 'qry_update' ) ) {
			continue;
		}

		$oldUsage			=	explode( '|*|', $fieldParams->getString( 'qry_update', '' ) );
		$newUsage			=	explode( '|*|', $fieldParams->get( 'ajax_update', '' ) );

		$fieldParams->set( 'ajax_update', implode( '|*|', array_unique( array_merge( $oldUsage, $newUsage ) ) ) );
		$fieldParams->unsetEntry( 'qry_update' );

		$field->set( 'params', $fieldParams->asJson() );

		$field->store();
	}
}