<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Database\Table\TabTable;
use CB\Database\Table\UserTable;
use CB\Plugin\Invites\Table\InviteTable;
use CB\Plugin\Invites\CBInvites;
use CB\Plugin\Invites\Tab\InvitesTab;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * @var InvitesTab    $this
 * @var InviteTable[] $rows
 * @var array         $input
 * @var UserTable     $user
 * @var TabTable      $tab
 *
 * @var bool          $profileOwner
 * @var bool          $cbModerator
 * @var bool          $canSearch
 * @var bool          $canCreateEmail
 * @var bool          $canCreateLink
 * @var bool          $canCreate
 * @var bool          $allowMultiple
 */

global $_CB_framework;
?>
<div class="invitesTab">
	<?php if ( $canCreate || $canSearch ) { ?>
	<div class="row no-gutters mb-3 invitesHeader">
		<?php if ( $canCreate ) { ?>
		<div class="<?php echo ( $canCreateEmail && $canCreateLink ? 'd-sm-flex ' : null ); ?>col-12 <?php echo ( $canSearch ? ( $canCreateEmail && $canCreateLink ? 'col-sm-7' : 'col-sm-6' ) . ' mb-2 mb-sm-0' : null ); ?>">
			<?php if ( $canCreateEmail ) { ?>
			<form action="<?php echo $_CB_framework->pluginClassUrl( $this->element, true, array( 'action' => 'invites', 'func' => 'email' ) ); ?>" method="post" name="inviteForm" class="m-0<?php echo ( $canCreateLink ? ' flex-grow-1 mb-2 mb-sm-0' : null ); ?> cbValidation inviteForm">
				<div class="input-group">
					<input type="text" name="to" class="form-control inviteFormTo" placeholder="<?php echo htmlspecialchars( ( $allowMultiple ? 'tom@example.com, jane@example.com, sam@example.com': 'tom@example.com' ) ); ?>" aria-label="<?php echo htmlspecialchars( ( $allowMultiple ? CBTxt::T( 'Input the email addresses separated by a comma to invite.' ) : CBTxt::T( 'Input the email addess to invite.' ) ) ); ?>" data-rule-inviteemail="true" />
					<?php if ( $input['captcha'] ) { ?>
						<?php if ( $input['captcha_silent'] ) { ?>
						<div class="inviteFormToCaptchaHidden hidden">
							<?php echo $input['captcha']; ?>
						</div>
						<?php } else { ?>
						<div class="position-absolute w-100 d-flex justify-content-end inviteFormToCaptcha hidden">
							<div class="mw-none position-relative d-block popover bs-popover-bottom">
								<div class="border-0 arrow"></div>
								<div class="popover-body">
									<?php echo $input['captcha']; ?>
								</div>
							</div>
						</div>
						<?php } ?>
					<?php } ?>
					<div class="input-group-append">
						<button type="submit" class="btn btn-success inviteFormSend" disabled><span class="fa fa-envelope"></span> <?php echo ( $allowMultiple ? CBTxt::T( 'Send Invites' ) : CBTxt::T( 'Send Invite' ) ); ?></button>
					</div>
				</div>
				<?php if ( $cbModerator && ( ! $profileOwner ) ) { ?>
				<input type="hidden" name="user_id" value="<?php echo $user->getInt( 'id', 0 ); ?>" />
				<?php } ?>
				<?php echo cbGetSpoofInputTag( 'plugin' ); ?>
			</form>
			<?php } ?>
			<?php if ( $canCreateLink ) { ?>
			<a href="<?php echo $_CB_framework->pluginClassUrl( $this->element, true, array( 'action' => 'invites', 'func' => 'link', 'user' => ( $cbModerator && ( ! $profileOwner ) ? $user->getInt( 'id', 0 ) : null ) ) ); ?>" class="<?php echo ( $canCreateEmail ? 'ml-sm-2 text-nowrap ' : null ); ?>btn btn-success btn-sm-block"><span class="fa fa-plus-circle"></span> <?php echo CBTxt::T( 'Create Invite Link' ); ?></a>
			<?php } ?>
		</div>
		<?php } ?>
		<?php if ( $canSearch ) { ?>
		<div class="col-12 <?php echo ( ! $canCreate ? 'offset-sm-6 col-sm-6' : ( $canCreateEmail && $canCreateLink ? 'col-sm-5' : 'col-sm-6' ) . ' pl-sm-3' ); ?> text-sm-right">
			<form action="<?php echo $_CB_framework->userProfileUrl( $user->getInt( 'id', 0 ), true, $tab->getInt( 'tabid', 0 ) ); ?>" method="post" name="inviteSearchForm" class="m-0 inviteSearchForm">
				<div class="input-group">
					<?php echo $input['search']; ?>
					<div class="input-group-append">
						<button type="submit" class="btn btn-light border" aria-label="<?php echo htmlspecialchars( CBTxt::T( 'Search' ) ); ?>"><span class="fa fa-search"></span></button>
					</div>
				</div>
			</form>
		</div>
		<?php } ?>
	</div>
	<?php } ?>
	<div class="table-responsive invitesContainer">
		<table class="table table-hover">
			<thead>
				<tr>
					<th><?php echo ( $canCreateEmail && $canCreateLink ? CBTxt::T( 'Email Address / Invite Link' ) : ( $canCreateEmail ? CBTxt::T( 'Email Address' ) : ( $canCreateLink ? CBTxt::T( 'Invite Link' ) : null  )  ) ); ?></th>
					<th style="width: 20%;" class="d-none d-sm-table-cell text-center"><?php echo CBTxt::T( 'Date' ); ?></th>
					<th style="width: 20%;" class="text-center"><?php echo CBTxt::T( 'Accepted' ); ?></th>
					<?php if ( $cbModerator || $profileOwner ) { ?>
					<th style="width: 1%;"></th>
					<?php } ?>
				</tr>
			</thead>
			<tbody>
				<?php if ( $rows ) { ?>
					<?php foreach ( $rows as $row ) { ?>
						<tr>
							<td class="align-middle">
								<?php if ( $row->getInt( 'user', 0 ) ) { ?>
									<?php echo CBuser::getInstance( $row->getInt( 'user', 0 ), false )->getField( 'formatname', null, 'html', 'none', 'list', 0, true ); ?>
								<?php } elseif ( $row->getString( 'to' ) ) { ?>
								<a href="mailto:<?php echo htmlspecialchars( $row->getString( 'to' ) ); ?>"><?php echo $row->getString( 'to' ); ?></a>
								<?php } else { ?>
								<div class="input-group invitesInviteLink">
									<input type="text" value="<?php echo $row->getLink(); ?>" class="form-control form-control-sm rounded-0 invitesInviteLinkInput" onclick="this.select(); document.execCommand( 'copy' );" readonly aria-label="<?php echo htmlspecialchars( CBTxt::T( 'Invite Link' ) ); ?>" data-hascbtooltip="true" data-cbtooltip-tooltip="<?php echo htmlspecialchars( CBTxt::T( 'Copied!' ) ); ?>" data-cbtooltip-simple="true" data-cbtooltip-open-event="click" data-cbtooltip-close-event="unfocus" data-cbtooltip-button-close="false" />
									<div class="input-group-append">
										<button type="button" class="rounded-0 btn btn-sm btn-secondary invitesInviteLinkCopy"><?php echo CBTxt::T( 'Copy' ); ?></button>
										<?php if ( CBInvites::isHTTPS() ) { ?>
										<button type="button" class="rounded-0 btn btn-sm btn-primary invitesInviteLinkShare"><?php echo CBTxt::T( 'Share' ); ?></button>
										<?php } ?>
									</div>
								</div>
								<?php } ?>
							</td>
							<td style="width: 20%;" class="d-none d-sm-table-cell align-middle text-center">
								<?php if ( $row->isSent() ) { ?>
									<?php echo cbFormatDate( $row->getString( 'sent' ), true, false ); ?>
								<?php } else { ?>
									<div class="text-danger"><?php echo CBTxt::T( 'Please Resend' ); ?></div>
								<?php } ?>
							</td>
							<td style="width: 20%;" class="align-middle text-center">
								<?php if ( $row->isAccepted() ) { ?>
									<?php echo cbFormatDate( $row->getString( 'accepted' ), true, false ); ?>
								<?php } else { ?>
									<div class="text-warning"><?php echo ( $row->isExpired() ? CBTxt::T( 'Expired' ) : CBTxt::T( 'Pending' ) ); ?></div>
								<?php } ?>
							</td>
							<?php if ( $cbModerator || $profileOwner ) { ?>
								<?php if ( $row->canResend() || ( ! $row->isAccepted() ) ) {
									$menuItems		=	'<ul class="list-unstyled dropdown-menu d-block position-relative m-0 invitesMenuItems">';

									if ( $row->canResend() ) {
										$menuItems	.=		'<li class="invitesMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $this->element, true, array( 'action' => 'invites', 'func' => 'send', 'id' => $row->getInt( 'id', 0 ) ) ) . '" class="dropdown-item"><span class="fa fa-share-square-o"></span> ' . CBTxt::T( 'Resend' ) . '</a></li>';
									}

									if ( ! $row->isAccepted() ) {
										$menuItems	.=		'<li class="invitesMenuItem"><a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to delete this Invite?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $this->element, false, array( 'action' => 'invites', 'func' => 'delete', 'id' => $row->getInt( 'id', 0 ) ) ) ) . '\'; })" class="dropdown-item"><span class="fa fa-trash-o"></span> ' . CBTxt::T( 'Delete' ) . '</a></li>';
									}

									$menuItems		.=	'</ul>';
									?>
									<td style="width: 1%;" class="p-0 align-middle">
										<?php echo cbTooltip( null, $menuItems, null, 'auto', null, '<span class="pt-1 pb-1 pl-3 pr-3 text-large fa fa-ellipsis-v"></span>', 'javascript:void(0);', 'class="text-body cbDropdownMenu invitesMenu" data-cbtooltip-menu="true" data-cbtooltip-classes="qtip-nostyle" data-cbtooltip-open-classes="active"' ); ?>
									</td>
								<?php } else { ?>
									<td style="width: 1%;"></td>
								<?php } ?>
							<?php } ?>
						</tr>
					<?php } ?>
				<?php } else { ?>
				<tr>
					<td colspan="4" class="text-left">
						<?php echo $input['results']; ?>
					</td>
				</tr>
				<?php } ?>
			</tbody>
			<?php if ( $input['paging'] ) { ?>
			<tfoot>
				<tr>
					<td colspan="4" class="text-center">
						<?php echo $input['paging']; ?>
					</td>
				</tr>
			</tfoot>
			<?php } ?>
		</table>
	</div>
</div>