<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\Invites\Tab;

use CBLib\Application\Application;
use CB\Database\Table\UserTable;
use CBLib\Language\CBTxt;
use CB\Plugin\Invites\CBInvites;
use CBLib\Registry\ParamsInterface;
use CBLib\Registry\Registry;

defined('CBLIB') or die();

class InvitesTab extends \cbTabHandler
{

	/**
	 * @param \moscomprofilerTabs $tab
	 * @param UserTable          $user
	 * @param int                $ui
	 * @return null|string
	 */
	public function getDisplayTab( $tab, $user, $ui )
	{
		global $_CB_framework, $_CB_database, $_PLUGINS;

		$viewer				=	\CBuser::getMyUserDataInstance();
		$profileOwner		=	( $viewer->getInt( 'id', 0 ) === $user->getInt( 'id', 0 ) );

		if ( ! $profileOwner ) {
			return null;
		}

		if ( ! ( $tab->params instanceof ParamsInterface ) ) {
			$tab->set( 'params', new Registry( $tab->getRaw( 'params' ) ) );
		}

		$prefix				=	'tab_invites_';
		$limit				=	$tab->params->getInt( 'tab_limit', 15 );
		$limitstart			=	$_CB_framework->getUserStateFromRequest( $prefix . 'limitstart{com_comprofiler}', $prefix . 'limitstart' );
		$search				=	$_CB_framework->getUserStateFromRequest( $prefix . 'search{com_comprofiler}', $prefix . 'search' );
		$searching			=	false;
		$where				=	null;
		$join				=	null;

		if ( $search !== '' ) {
			$searching		=	true;

			$where			.=	"\n AND ( a." . $_CB_database->NameQuote( 'to' ) . " LIKE " . $_CB_database->Quote( '%' . $_CB_database->getEscaped( $search, true ) . '%', false )
							.	" OR b." . $_CB_database->NameQuote( 'username' ) . " LIKE " . $_CB_database->Quote( '%' . $_CB_database->getEscaped( $search, true ) . '%', false )
							.	" OR b." . $_CB_database->NameQuote( 'name' ) . " LIKE " . $_CB_database->Quote( '%' . $_CB_database->getEscaped( $search, true ) . '%', false ) . " )";

			$join			.=	"\n LEFT JOIN " . $_CB_database->NameQuote( '#__users' ) . " AS b"
							.	' ON b.' . $_CB_database->NameQuote( 'id' ) . ' = a.' . $_CB_database->NameQuote( 'user' );
		}

		$query				=	'SELECT COUNT(*)'
							.	"\n FROM " . $_CB_database->NameQuote( '#__comprofiler_plugin_invites' ) . " AS a"
							.	$join
							.	"\n WHERE a." . $_CB_database->NameQuote( 'user_id' ) . " = " . $user->getInt( 'id', 0 )
							.	$where
							.	"\n ORDER BY " . $_CB_database->NameQuote( 'sent' ) . " DESC";
		$_CB_database->setQuery( $query );
		$total				=	$_CB_database->loadResult();

		if ( $total <= $limitstart ) {
			$limitstart		=	0;
		}

		$pageNav			=	new \cbPageNav( $total, $limitstart, $limit );

		$pageNav->setInputNamePrefix( $prefix );
		$pageNav->setStaticLimit( true );
		$pageNav->setBaseURL( $_CB_framework->userProfileUrl( $user->getInt( 'id', 0 ), false, $tab->getInt( 'tabid', 0 ), 'html', 0, array( $prefix . 'search' => ( $searching ? $search : null ) ) ) );

		$query				=	'SELECT a.*'
							.	"\n FROM " . $_CB_database->NameQuote( '#__comprofiler_plugin_invites' ) . " AS a"
							.	$join
							.	"\n WHERE a." . $_CB_database->NameQuote( 'user_id' ) . " = " . $user->getInt( 'id', 0 )
							.	$where
							.	"\n ORDER BY " . $_CB_database->NameQuote( 'sent' ) . " DESC";
		if ( $tab->params->getBool( 'tab_paging', true ) ) {
			$_CB_database->setQuery( $query, $pageNav->limitstart, $pageNav->limit );
		} else {
			$_CB_database->setQuery( $query );
		}
		$rows				=	$_CB_database->loadObjectList( null, '\CB\Plugin\Invites\Table\InviteTable', array( $_CB_database ) );

		$input						=	array();
		$input['search']			=	'<input type="text" name="' . htmlspecialchars( $prefix ) . 'search" value="' . htmlspecialchars( $search ) . '" placeholder="' . htmlspecialchars( CBTxt::T( 'Search Invites...' ) ) . '" class="form-control" />';
		$input['captcha']			=	null;
		$input['captcha_silent']	=	false;
		$input['paging']			=	null;

		if ( $searching ) {
			$input['results']		=	CBTxt::T( 'No invite search results found.' );
		} elseif ( $profileOwner ) {
			$input['results']		=	CBTxt::T( 'You have no invites.' );
		} else {
			$input['results']		=	CBTxt::T( 'This user has no invites.' );
		}

		$cbModerator		=	Application::User( $viewer->getInt( 'id', 0 ) )->isGlobalModerator();
		$canSearch			=	( $tab->params->getBool( 'tab_search', true ) && ( $searching || $pageNav->total ) );
		$canCreateEmail		=	CBInvites::canCreateInvite( $user );
		$canCreateLink		=	CBInvites::canCreateInvite( $user, 'links' );
		$canCreate			=	( $canCreateEmail || $canCreateLink );
		$allowMultiple		=	( CBInvites::getGlobalParams()->getBool( 'invite_multiple', true ) || $cbModerator );

		if ( $canCreateEmail && CBInvites::getGlobalParams()->getBool( 'invite_captcha', false ) && ( ! $cbModerator ) ) {
			$captcha							=	$_PLUGINS->trigger( 'onGetCaptchaHtmlElements', array( false ) );

			if ( ! empty( $captcha ) ) {
				$captcha						=	$captcha[0];

				if ( ( ! $captcha[0] )
					 || ( strpos( $captcha[1], 'RecaptchaInvisible' ) === false )
					 || ( strpos( $captcha[1], 'RecaptchaScore' ) === false )
				) {
					$input['captcha_silent']	=	true;
				}

				$input['captcha']				=	$captcha[0] . $captcha[1];
			}
		}

		if ( $tab->params->getBool( 'tab_paging', true ) && ( $pageNav->total > $pageNav->limit ) ) {
			$input['paging']					=	$pageNav->getListLinks();
		}

		$js					=	null;

		if ( $canCreateEmail ) {
			$js				.=	"$( '.inviteFormTo' ).on( 'keyup', function() {"
							.		"if ( $( this ).val() == '' ) {"
							.			"$( '.inviteFormSend' ).prop( 'disabled', true );"
							.			"$( '.inviteFormToCaptcha' ).addClass( 'hidden' );"
							.		"} else {"
							.			"$( '.inviteFormSend' ).prop( 'disabled', false );"
							.			"$( '.inviteFormToCaptcha' ).removeClass( 'hidden' );"
							.		"}"
							.	"});";

			if ( $allowMultiple ) {
				$rule		=	"if ( this.optional( element ) ) {"
							.		"return true;"
							.	"}"
							.	"var that = this;"
							.	"var valid = true;"
							.	"$.each( value.split( ',' ), function( k, v ) {"
							.		"if ( ! $.validator.methods.email.call( that, v.trim(), element ) ) {"
							.			"valid = false;"
							.			"return false;"
							.		"}"
							.	"});"
							.	"return valid;";
				$message	=	CBTxt::T( 'VALIDATION_ERROR_FIELD_EMAILS', 'Please enter valid email addresses.' );
			} else {
				$rule		=	"return this.optional( element ) || $.validator.methods.email.call( this, value, element );";
				$message	=	CBTxt::T( 'VALIDATION_ERROR_FIELD_EMAIL', 'Please enter a valid email address.' );
			}

			\cbValidator::addRule( 'inviteemail', $rule, $message );

			\cbValidator::loadValidation();
		}

		if ( $canCreateLink ) {
			$js				.=	"$( '.invitesInviteLinkCopy' ).on( 'click', function() {"
							.		"$( this ).closest( '.invitesInviteLink' ).find( '.invitesInviteLinkInput' ).click();"
							.	"});";

			if ( CBInvites::isHTTPS() ) {
				$extra		=	array(	'site'		=>	$_CB_framework->getCfg( 'live_site' ),
										'sitename'	=>	$_CB_framework->getCfg( 'sitename' ),
										'sitedesc'	=>	$_CB_framework->getCfg( 'MetaDesc' ),
										'register'	=>	$_CB_framework->viewUrl( 'registers' ),
										'profile'	=>	$_CB_framework->viewUrl( 'userprofile', true, array( 'user' => $user->getInt( 'id', 0 ) ) )
									);

				$cbUser		=	\CBuser::getInstance( $user->getInt( 'id', 0 ), false );
				$linkTitle	=	$cbUser->replaceUserVars( CBInvites::getGlobalParams()->getString( 'invite_link_title', '[sitename]' ), true, false, $extra );
				$linkText	=	$cbUser->replaceUserVars( CBInvites::getGlobalParams()->getString( 'invite_link_text', '[sitedesc]' ), true, false, $extra );

				$js			.=	"if ( typeof navigator.share == 'undefined' ) {"
							.		"$( '.invitesInviteLinkShare' ).addClass( 'hidden' );"
							.	"} else {"
							.		"$( '.invitesInviteLinkShare' ).on( 'click', function() {"
							.			"var link = $( this ).closest( '.invitesInviteLink' ).find( '.invitesInviteLinkInput' ).val();"
							.			"navigator.share({"
							.				( $linkTitle ? "title: " . json_encode( $linkTitle, JSON_HEX_TAG ) . "," : null )
							.				( $linkText ? "text: " . json_encode( $linkText, JSON_HEX_TAG ) . "," : null )
							.				"url: link"
							.			"});"
							.		"});"
							.	"}";
			}
		}

		if ( $js ) {
			$_CB_framework->outputCbJQuery( $js );
		}

		initToolTip();

		ob_start();
		require CBInvites::getTemplate( null, 'tab' );
		$html				=	ob_get_clean();

		$class				=	$this->params->getString( 'general_class' );

		return	'<div class="cbInvites' . ( $class ? ' ' . htmlspecialchars( $class ) : null ) . '">'
			.		$html
			.	'</div>';
	}
}
