<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;
use CB\Plugin\GroupJive\Table\GroupTable;
use CB\Plugin\GroupJiveFile\Table\FileTable;
use CB\Plugin\GroupJive\CBGroupJive;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_groupjiveFile
{

	/**
	 * render frontend files
	 *
	 * @param FileTable[]     $rows
	 * @param cbPageNav       $pageNav
	 * @param bool            $searching
	 * @param array           $input
	 * @param array           $counters
	 * @param GroupTable      $group
	 * @param UserTable       $user
	 * @param cbPluginHandler $plugin
	 * @return string
	 */
	public static function showFiles( $rows, $pageNav, $searching, $input, &$counters, $group, $user, $plugin )
	{
		global $_CB_framework, $_PLUGINS;

		if ( $pageNav->total ) {
			$counters[]						=	'<span class="gjGroupFileIcon fa-before fa-file-o"> ' . CBTxt::T( 'GROUP_FILES_COUNT', '%%COUNT%% File|%%COUNT%% Files', array( '%%COUNT%%' => (int) $pageNav->total ) ) . '</span>';
		}

		initToolTip();

		$isModerator						=	CBGroupJive::isModerator( $user->getInt( 'id', 0 ) );
		$isOwner							=	( $user->getInt( 'id', 0 ) === $group->getInt( 'user_id', 0 ) );
		$userStatus							=	CBGroupJive::getGroupStatus( $user, $group );
		$canCreate							=	CBGroupJive::canCreateGroupContent( $user, $group, 'file' );
		$canSearch							=	( $plugin->params->getInt( 'groups_file_search', 1 ) && ( $searching || $pageNav->total ) );
		$return								=	null;

		$_PLUGINS->trigger( 'gj_onBeforeDisplayFiles', array( &$return, &$rows, $group, $user ) );

		$return								.=	'<div class="gjGroupFile">';

		if ( $canCreate || $canSearch ) {
			$return							.=		'<div class="row no-gutters mb-3 gjHeader gjGroupFileHeader">';

			if ( $canCreate ) {
				$return						.=			'<div class="col-12 ' . ( $canSearch ? 'col-sm-6 mb-2 mb-sm-0' : null ) . '">'
											.				'<a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'file', 'func' => 'new', 'group' => $group->getInt( 'id', 0 ) ) ) . '" class="btn btn-success btn-sm-block gjButton gjButtonNewFile"><span class="fa fa-plus-circle"></span> ' . CBTxt::T( 'Upload New File' ) . '</a>'
											.			'</div>';
			}

			if ( $canSearch ) {
				$return						.=			'<div class="col-12 ' . ( ! $canCreate ? 'offset-sm-6 ' : null ) . 'col-sm-6 text-sm-right">'
											.				'<form action="' . $_CB_framework->pluginClassUrl( 'cbgroupjive', true, array( 'action' => 'groups', 'func' => 'show', 'id' => $group->getInt( 'id', 0 ) ) ) . '" method="post" name="gjGroupFileSearchForm" class="m-0 gjGroupFileSearchForm">'
											.					'<div class="input-group">'
											.						$input['search']
											.						'<div class="input-group-append">'
											.							'<button type="submit" class="btn btn-light border" aria-label="' . htmlspecialchars( CBTxt::T( 'Search' ) ) . '"><span class="fa fa-search"></span></button>'
											.						'</div>'
											.					'</div>'
											.				'</form>'
											.			'</div>';
			}

			$return							.=		'</div>';
		}

		$return								.=		'<div class="table-responsive gjGroupFileRows">'
											.			'<table class="table table-hover">'
											.				'<thead>'
											.					'<tr>'
											.						'<th colspan="2">&nbsp;</th>'
											.						'<th style="width: 15%;" class="text-center">' . CBTxt::T( 'Type' ) . '</th>'
											.						'<th style="width: 15%;">' . CBTxt::T( 'Size' ) . '</th>'
											.						'<th style="width: 20%;" class="d-none d-sm-table-cell" colspan="2">' . CBTxt::T( 'Date' ) . '</th>'
											.					'</tr>'
											.				'</thead>'
											.				'<tbody>';

		if ( $rows ) {
			foreach ( $rows as $row ) {
				$rowOwner					=	( $user->getInt( 'id', 0 ) === $row->getInt( 'user_id', 0 ) );
				$isModOrOwner				=	( $isModerator || $isOwner || $rowOwner || ( $userStatus >= 2 ) );
				$extension					=	null;
				$size						=	0;
				$title						=	( $row->getString( 'title' ) ? htmlspecialchars( $row->getString( 'title' ) ) : $row->name() );
				$item						=	$title;

				if ( $row->exists() ) {
					$downloadPath			=	$_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'file', 'func' => 'download', 'id' => $row->getInt( 'id', 0 ) ), 'raw', 0, true );
					$extension				=	$row->extension();
					$size					=	$row->size();

					switch ( $extension ) {
						case 'txt':
						case 'pdf':
						case 'jpg':
						case 'jpeg':
						case 'png':
						case 'gif':
						case 'js':
						case 'css':
						case 'mp4':
						case 'mp3':
						case 'wav':
							$item			=	'<a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'file', 'func' => 'show', 'id' => $row->getInt( 'id', 0 ) ), 'raw', 0, true ) . '" target="_blank">'
											.		$item
											.	'</a>';
							break;
						default:
							$item			=	'<a href="' . $downloadPath . '" target="_blank">'
											.		$item
											.	'</a>';
							break;
					}

					$download				=	'<a href="' . $downloadPath . '" target="_blank" title="' . htmlspecialchars( CBTxt::T( 'Click to Download' ) ) . '" class="btn btn-sm btn-primary gjGroupDownloadIcon">'
											.		'<span class="fa fa-download"></span>'
											.	'</a>';
				} else {
					$download				=	'<button type="button" class="btn btn-sm btn-secondary gjButton gjButtonDownloadFile disabled">'
											.		'<span class="fa fa-download"></span>'
											.	'</button>';
				}

				if ( $row->getString( 'description' ) ) {
					$item					=	cbTooltip( null, $row->getString( 'description' ), ( $row->getString( 'title' ) ? $row->name() : null ), null, null, $item );
				}

				$menu						=	array();

				$_PLUGINS->trigger( 'gj_onDisplayFile', array( &$row, &$menu, $group, $user ) );

				$return						.=					'<tr>'
											.						'<td style="width: 1%;" class="align-middle text-center">' . $download . '</td>'
											.						'<td class="align-middle text-wrap">'
											.							$item;

				if ( $isModOrOwner && ( ( $row->getInt( 'published', 0 ) === -1 ) && ( $group->params()->getInt( 'file', 1 ) === 2 ) ) ) {
					$return					.=							' <span class="gjGroupPendingIcon fa fa-clock-o text-warning" title="' . htmlspecialchars( CBTxt::T( 'Awaiting Approval' ) ) . '"></span>';
				}

				$return						.=							'<div class="gjGroupFileUploader small">' . CBuser::getInstance( $row->getInt( 'user_id', 0 ), false )->getField( 'formatname', null, 'html', 'none', 'list', 0, true ) . '</div>'
											.						'</td>'
											.						'<td style="width: 15%;" class="align-middle text-center"><span class="gjGroupFileTypeIcon fa fa-' . $row->icon() . '" title="' . htmlspecialchars( ( $extension ? strtoupper( $extension ) : CBTxt::T( 'Unknown' ) ) ) . '"></span></td>'
											.						'<td style="width: 15%;" class="align-middle">' . $size . '</td>'
											.						'<td style="width: 20%;" class="align-middle d-none d-sm-table-cell clearfix">'
											.							'<span title="' . htmlspecialchars( $row->getString( 'date' ) ) . '">'
											.								cbFormatDate( $row->getString( 'date' ), true, false, CBTxt::T( 'GROUP_FILE_DATE_FORMAT', 'M j, Y' ) )
											.							'</span>'
											.						'</td>';

				if ( $isModOrOwner || $menu ) {
					$menuItems				=	'<ul class="list-unstyled dropdown-menu d-block position-relative m-0 gjMenuItems gjFileMenuItems">';

					if ( $isModOrOwner ) {
						$menuItems			.=		'<li class="gjMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'file', 'func' => 'edit', 'id' => $row->getInt( 'id', 0 ) ) ) . '" class="dropdown-item"><span class="fa fa-edit"></span> ' . CBTxt::T( 'Edit' ) . '</a></li>';

						if ( ( $row->getInt( 'published', 0 ) === -1 ) && ( $group->params()->getInt( 'file', 1 ) === 2 ) ) {
							if ( $isModerator || $isOwner || ( $userStatus >= 2 ) ) {
								$menuItems	.=		'<li class="gjMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'file', 'func' => 'publish', 'id' => $row->getInt( 'id', 0 ) ) ) . '" class="dropdown-item"><span class="fa fa-check"></span> ' . CBTxt::T( 'Approve' ) . '</a></li>';
							}
						} elseif ( $row->getInt( 'published', 0 ) === 1 ) {
							$menuItems		.=		'<li class="gjMenuItem"><a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to unpublish this File?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'file', 'func' => 'unpublish', 'id' => $row->getInt( 'id', 0 ) ) ) ) . '\'; })" class="dropdown-item"><span class="fa fa-times-circle"></span> ' . CBTxt::T( 'Unpublish' ) . '</a></li>';
						} else {
							$menuItems		.=		'<li class="gjMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'file', 'func' => 'publish', 'id' => $row->getInt( 'id', 0 ) ) ) . '" class="dropdown-item"><span class="fa fa-check"></span> ' . CBTxt::T( 'Publish' ) . '</a></li>';
						}
					}

					if ( $menu ) {
						$menuItems			.=		'<li class="gjMenuItem">' . implode( '</li><li class="gjMenuItem">', $menu ) . '</li>';
					}

					if ( $isModOrOwner ) {
						$menuItems			.=		'<li class="gjMenuItem"><a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to delete this File?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'file', 'func' => 'delete', 'id' => $row->getInt( 'id', 0 ) ) ) ) . '\'; })" class="dropdown-item"><span class="fa fa-trash-o"></span> ' . CBTxt::T( 'Delete' ) . '</a></li>';
					}

					$menuItems				.=	'</ul>';

					$return					.=						'<td style="width: 1%;" class="p-0 align-middle">'
											.							cbTooltip( null, $menuItems, null, 'auto', null, '<span class="pt-1 pb-1 pl-3 pr-3 text-large fa fa-ellipsis-v"></span>', 'javascript:void(0);', 'class="text-body cbDropdownMenu gjFileMenu" data-cbtooltip-menu="true" data-cbtooltip-classes="qtip-nostyle" data-cbtooltip-open-classes="active"' )
											.						'</td>';
				}

				$return						.=					'</tr>';
			}
		} else {
			$return							.=					'<tr>'
											.						'<td colspan="6" class="gjGroupFileEmpty">';

			if ( $searching ) {
				$return						.=							CBTxt::T( 'No group file search results found.' );
			} else {
				$return						.=							CBTxt::T( 'This group currently has no files.' );
			}

			$return							.=						'</td>'
											.					'</tr>';
		}

		$return								.=				'</tbody>';

		if ( $plugin->params->getInt( 'groups_file_paging', 1 ) && ( $pageNav->total > $pageNav->limit ) ) {
			$return							.=				'<tfoot>'
											.					'<tr>'
											.						'<td colspan="6" class="gjGroupFilePaging">'
											.							$pageNav->getListLinks()
											.						'</td>'
											.					'</tr>'
											.				'</tfoot>';
		}

		$return								.=			'</table>'
											.		'</div>'
											.	'</div>';

		$_PLUGINS->trigger( 'gj_onAfterDisplayFiles', array( &$return, $rows, $group, $user ) );

		return $return;
	}
}