<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\GroupJiveFile;

use CB\Plugin\GroupJiveFile\Table\FileTable;
use CBLib\Registry\Registry;

defined('CBLIB') or die();

class CBGroupJiveFile
{
	/** @var FileTable[]  */
	private static $fileCache	=	array();

	/**
	 * @return Registry
	 */
	public static function getGlobalParams()
	{
		global $_PLUGINS;

		static $params	=	null;

		if ( $params === null ) {
			$plugin		=	$_PLUGINS->getLoadedPlugin( 'user/plug_cbgroupjive/plugins', 'cbgroupjivefile' );
			$params		=	new Registry();

			if ( $plugin ) {
				$params->load( $plugin->params );
			}
		}

		/** @var Registry $params */
		return $params;
	}

	/**
	 * Caches a prefetched array of files for reuse
	 *
	 * @param FileTable[] $files
	 */
	public static function prefetchFiles( $files )
	{
		foreach ( $files as $file ) {
			$rowId						=	$file->getInt( 'id', 0 );

			if ( ! $rowId ) {
				continue;
			}

			self::$fileCache[$rowId]	=	$file;
		}
	}

	/**
	 * returns a cached file object
	 *
	 * @param int $id
	 * @return FileTable
	 */
	public static function getFile( $id )
	{
		if ( ! $id ) {
			return new FileTable();
		}

		if ( ! isset( self::$fileCache[$id] ) ) {
			$row					=	new FileTable();

			$row->load( (int) $id );

			self::$fileCache[$id]	=	$row;
		}

		return self::$fileCache[$id];
	}
}