<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;
use CB\Plugin\GroupJive\Table\GroupTable;
use CB\Plugin\GroupJiveVideo\Table\VideoTable;
use CB\Plugin\GroupJive\CBGroupJive;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_groupjiveVideo
{

	/**
	 * render frontend videos
	 *
	 * @param VideoTable[]    $rows
	 * @param cbPageNav       $pageNav
	 * @param bool            $searching
	 * @param array           $input
	 * @param array           $counters
	 * @param GroupTable      $group
	 * @param UserTable       $user
	 * @param cbPluginHandler $plugin
	 * @return string
	 */
	public static function showVideos( $rows, $pageNav, $searching, $input, &$counters, $group, $user, $plugin )
	{
		global $_CB_framework, $_PLUGINS;

		if ( $pageNav->total ) {
			$counters[]						=	'<span class="fa-before fa-film gjGroupVideoIcon"> ' . CBTxt::T( 'GROUP_VIDEOS_COUNT', '%%COUNT%% Video|%%COUNT%% Videos', array( '%%COUNT%%' => (int) $pageNav->total ) ) . '</span>';
		}

		$js									=	"$( '.gjGroupVideo .cbMoreLess' ).cbmoreless();"
											.	"$( '.gjVideoToggle' ).on( 'click', function() {"
											.		"if ( $( this ).hasClass( 'gjVideoToggleOpen' ) ) {"
											.			"return;"
											.		"}"
											.		"$( this ).addClass( 'gjVideoToggleOpen' );"
											.		"$( this ).find( '.gjVideoPreview' ).addClass( 'hidden' );"
											.		"$( this ).find( 'iframe' ).attr( 'src', $( this ).data( 'gjvideo' ) ).removeClass( 'hidden' );"
											.	"});";

		$_CB_framework->outputCbJQuery($js, 'cbmoreless' );

		initToolTip();

		$isModerator						=	CBGroupJive::isModerator( $user->getInt( 'id', 0 ) );
		$isOwner							=	( $user->getInt( 'id', 0 ) === $group->getInt( 'user_id', 0 ) );
		$userStatus							=	CBGroupJive::getGroupStatus( $user, $group );
		$canCreate							=	CBGroupJive::canCreateGroupContent( $user, $group, 'video' );
		$canSearch							=	( $plugin->params->getInt( 'groups_video_search', 1 ) && ( $searching || $pageNav->total ) );
		$return								=	null;

		$_PLUGINS->trigger( 'gj_onBeforeDisplayVideos', array( &$return, &$rows, $group, $user ) );

		$return								.=	'<div class="gjGroupVideo">';

		if ( $canCreate || $canSearch ) {
			$return							.=		'<div class="row no-gutters mb-3 gjHeader gjGroupVideoHeader">';

			if ( $canCreate ) {
				$return						.=			'<div class="col-12 ' . ( $canSearch ? 'col-sm-6 mb-2 mb-sm-0' : null ) . '">'
											.				'<a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'video', 'func' => 'new', 'group' => $group->getInt( 'id', 0 ) ) ) . '" class="btn btn-success btn-sm-block gjButton gjButtonNewVideo"><span class="fa fa-plus-circle"></span> ' . CBTxt::T( 'Link New Video' ) . '</a>'
											.			'</div>';
			}

			if ( $canSearch ) {
				$return						.=			'<div class="col-12 ' . ( ! $canCreate ? 'offset-sm-6 ' : null ) . 'col-sm-6 text-sm-right">'
											.				'<form action="' . $_CB_framework->pluginClassUrl( 'cbgroupjive', true, array( 'action' => 'groups', 'func' => 'show', 'id' => $group->getInt( 'id', 0 ) ) ) . '" method="post" name="gjGroupVideoSearchForm" class="m-0 gjGroupVideoSearchForm">'
											.					'<div class="input-group">'
											.						$input['search']
											.						'<div class="input-group-append">'
											.							'<button type="submit" class="btn btn-light border" aria-label="' . htmlspecialchars( CBTxt::T( 'Search' ) ) . '"><span class="fa fa-search"></span></button>'
											.						'</div>'
											.					'</div>'
											.				'</form>'
											.			'</div>';
			}

			$return							.=		'</div>';
		}

		if ( $rows ) {
			$return							.=		'<div class="ml-n2 mr-n2 mb-n3 row no-gutters gjGroupVideoRows">';

			foreach ( $rows as $row ) {
				$rowOwner					=	( $user->getInt( 'id', 0 ) === $row->getInt( 'user_id', 0 ) );
				$isModOrOwner				=	( $isModerator || $isOwner || $rowOwner || ( $userStatus >= 2 ) );
				$rowCounters				=	array();
				$content					=	null;
				$menu						=	array();

				$_PLUGINS->trigger( 'gj_onDisplayVideo', array( &$row, &$rowCounters, &$content, &$menu, $group, $user ) );

				$buttons					=	array();
				$hoverMenu					=	true;

				if ( ( $isModerator || $isOwner || ( $userStatus >= 2 ) ) && ( $row->getInt( 'published', 0 ) === -1 ) && ( $group->params()->getInt( 'video', 1 ) === 2 ) ) {
					$hoverMenu				=	false;

					$buttons[]				=	'<a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'video', 'func' => 'publish', 'id' => $row->getInt( 'id', 0 ) ) ) . '" class="btn btn-sm btn-success gjButton gjButtonApprove">' . CBTxt::T( 'Approve' ) . '</a>';
				}

				if ( $isModOrOwner || $menu ) {
					$menuItems				=	'<ul class="list-unstyled dropdown-menu d-block position-relative m-0 gjMenuItems gjGroupVideoMenuItems">';

					if ( $isModOrOwner ) {
						$menuItems			.=		'<li class="gjMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'video', 'func' => 'edit', 'id' => $row->getInt( 'id', 0 ) ) ) . '" class="dropdown-item"><span class="fa fa-edit"></span> ' . CBTxt::T( 'Edit' ) . '</a></li>';

						if ( ( $row->getInt( 'published', 0 ) === -1 ) && ( $group->params()->getInt( 'video', 1 ) === 2 ) ) {
							if ( $isModerator || $isOwner || ( $userStatus >= 2 ) ) {
								$menuItems	.=		'<li class="gjMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'video', 'func' => 'publish', 'id' => $row->getInt( 'id', 0 ) ) ) . '" class="dropdown-item"><span class="fa fa-check"></span> ' . CBTxt::T( 'Approve' ) . '</a></li>';
							}
						} elseif ( $row->getInt( 'published', 0 ) === 1 ) {
							$menuItems		.=		'<li class="gjMenuItem"><a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to unpublish this Video?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'video', 'func' => 'unpublish', 'id' => $row->getInt( 'id', 0 ) ) ) ) . '\'; })" class="dropdown-item"><span class="fa fa-times-circle"></span> ' . CBTxt::T( 'Unpublish' ) . '</a></li>';
						} else {
							$menuItems		.=		'<li class="gjMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'video', 'func' => 'publish', 'id' => $row->getInt( 'id', 0 ) ) ) . '" class="dropdown-item"><span class="fa fa-check"></span> ' . CBTxt::T( 'Publish' ) . '</a></li>';
						}
					}

					if ( $menu ) {
						$menuItems			.=		'<li class="gjMenuItem">' . implode( '</li><li class="gjMenuItem">', $menu ) . '</li>';
					}

					if ( $isModOrOwner ) {
						$menuItems			.=		'<li class="gjMenuItem"><a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to delete this Video?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'video', 'func' => 'delete', 'id' => $row->getInt( 'id', 0 ) ) ) ) . '\'; })" class="dropdown-item"><span class="fa fa-trash-o"></span> ' . CBTxt::T( 'Delete' ) . '</a></li>';
					}

					$menuItems				.=	'</ul>';

					$menuAttr				=	cbTooltip( null, $menuItems, null, 'auto', null, null, null, 'class="border btn btn-light btn-sm cbCanvasLayoutMenu' . ( $hoverMenu ? ' cbCanvasLayoutHoverMenu' : null ) . ' gjGroupVideoMenu" data-cbtooltip-menu="true" data-cbtooltip-classes="qtip-nostyle" data-cbtooltip-open-classes="active"' );

					$buttons[]				=	'<button type="button" ' . trim( $menuAttr ) . '><span class="pl-2 pr-2 align-bottom text-large fa fa-ellipsis-v"></span></button>';
				}

				$return						.=			'<div class="col-12 col-lg-6 pb-3 pl-2 pr-2 gjGroupVideoRow gjGroupVideoRow' . $row->getInt( 'id', 0 ) . '">'
											.				'<div class="h-100 card gjGroupVideoRow cbCanvasLayout cbCanvasLayoutHover">'
											.					'<div class="card-header p-0 position-relative cbCanvasLayoutTop">';

				if ( $row->mimeType() === 'video/youtube' ) {
					if ( preg_match( '%(?:(?:watch\?v=)|(?:embed/)|(?:shorts/)|(?:be/))([A-Za-z0-9_-]+)%', $row->getString( 'url' ), $matches ) ) {
						$return				.=						'<div class="position-relative w-100 mh-100 gjGroupVideoEmbed gjVideoToggle" data-gjvideo="https://www.youtube.com/embed/' . htmlspecialchars( $matches[1] ) . '?autoplay=1">'
											.							'<div class="d-flex flex-column justify-content-center position-absolute w-100 h-100 gjVideoPreview">'
											.								'<div class="position-absolute display-1 align-middle text-white text-center w-100 gjVideoTogglePlay">'
											.									'<span class="fa fa-play gjVideoToggleIcon"></span>'
											.								'</div>'
											.								'<img src="https://img.youtube.com/vi/' . ( isset( $matches[1] ) ? htmlspecialchars( $matches[1] ) : 'unknown' ) . '/0.jpg" loading="lazy" class="flex-auto mh-100 mw-none img-fluid gjVideoThumbnail" />'
											.							'</div>'
											.							'<iframe loading="lazy" width="100%" height="100%" style="width: 100%; height: 100%;" frameborder="0" allow="autoplay; fullscreen; picture-in-picture" allowfullscreen class="position-absolute gjVideoPlayer"></iframe>'
											.						'</div>';
					}
				} else {
					$return					.=						'<div class="gjGroupVideoEmbed">'
											.							'<video loading="lazy" width="100%" height="100%" style="width: 100%; height: 100%;" src="' . htmlspecialchars( $row->getString( 'url' ) ) . '" type="' . htmlspecialchars( $row->mimeType() ) . '" controls preload="auto" class="position-absolute gjVideoPlayer"></video>'
											.						'</div>';
				}

				if ( $buttons ) {
					$return					.=						'<div class="position-absolute text-right p-1 cbCanvasLayoutActions">'
											.							implode( ' ', $buttons )
											.						'</div>';
				}

				$return						.=					'</div>'
											.					'<div class="d-flex flex-column card-body p-0 position-relative cbCanvasLayoutBody">'
											.						'<div class="flex-grow-1 ml-2 mr-2 mt-2 cbCanvasLayoutContent">';

				if ( $isModOrOwner && ( ( $row->getInt( 'published', 0 ) === -1 ) && ( $group->params()->getInt( 'video', 1 ) === 2 ) ) ) {
					$return					.=							'<span class="gjGroupPendingIcon fa fa-lg fa-clock-o text-warning" title="' . htmlspecialchars( CBTxt::T( 'Awaiting Approval' ) ) . '"></span> ';
				}

				$return						.=							'<a href="' . htmlspecialchars( $row->getString( 'url' ) ) . '" class="d-inline-block mw-100 text-truncate text-large" target="_blank" rel="nofollow">' . htmlspecialchars( ( $row->getString( 'title' ) ? $row->getString( 'title' ) : $row->name() ) ) . '</a>';

				if ( $row->getString( 'caption' ) ) {
					$return					.=							'<div class="text-small gjGroupVideoDescription cbMoreLess">'
											.								'<div class="cbMoreLessContent">'
											.									htmlspecialchars( $row->getString( 'caption' ) )
											.								'</div>'
											.								'<div class="fade-edge cbMoreLessOpen hidden">'
											.									'<a href="javascript: void(0);" class="cbMoreLessButton">' . CBTxt::T( 'See More' ) . '</a>'
											.								'</div>'
											.							'</div>';
				}

				$return						.=						'</div>'
											.						'<div class="border-top pl-2 pr-2 pt-2 mt-2 mb-2 text-small text-muted row no-gutters cbCanvasLayoutContent">'
											.							'<div class="mw-100 col-md-6 flex-grow-1 text-truncate cbCanvasLayoutContent gjGroupVideoPublisher">' . CBuser::getInstance( $row->getInt( 'user_id', 0 ), false )->getField( 'formatname', null, 'html', 'none', 'list', 0, true ) . '</div>'
											.							'<div class="mw-100 col-md-6 flex-grow-1 text-truncate cbCanvasLayoutContent gjGroupVideoDate">'
											.								'<span title="' . htmlspecialchars( $row->getString( 'date' ) ) . '">'
											.									cbFormatDate( $row->getString( 'date' ), true, false, CBTxt::T( 'GROUP_VIDEO_DATE_FORMAT', 'M j, Y' ) )
											.								'</span>'
											.							'</div>'
											.							( $rowCounters ? '<div class="mw-100 col-md-6 flex-grow-1 text-truncate cbCanvasLayoutContent">' . implode( '</div><div class="mw-100 col-md-6 flex-grow-1 text-truncate cbCanvasLayoutContent">', $rowCounters ) . '</div>' : null )
											.						'</div>'
											.						( $content ? '<div class="cbCanvasLayoutContent gjGroupVideoIntegrations">' . $content . '</div>' : null )
											.					'</div>'
											.				'</div>'
											.			'</div>';
			}

			$return							.=		'</div>';

			if ( $plugin->params->getInt( 'groups_video_paging', 1 ) && ( $pageNav->total > $pageNav->limit ) ) {
				$return						.=		'<div class="mt-3 gjGroupVideoPaging">'
											.			$pageNav->getListLinks()
											.		'</div>';
			}
		} else {
			$return							.=		'<div class="gjGroupVideoEmpty">';

			if ( $searching ) {
				$return						.=			CBTxt::T( 'No group video search results found.' );
			} else {
				$return						.=			CBTxt::T( 'This group currently has no videos.' );
			}

			$return							.=		'</div>';
		}

		$return								.=	'</div>';

		$_PLUGINS->trigger( 'gj_onAfterDisplayVideos', array( &$return, $rows, $group, $user ) );

		return $return;
	}
}