<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;
use CB\Plugin\GroupJive\Table\GroupTable;
use CB\Plugin\GroupJive\CBGroupJive;
use CB\Plugin\GroupJiveVideo\Table\VideoTable;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_groupjiveVideoEdit
{

	/**
	 * render frontend video edit
	 *
	 * @param VideoTable      $row
	 * @param array           $input
	 * @param GroupTable      $group
	 * @param UserTable       $user
	 * @param cbPluginHandler $plugin
	 */
	public static function showVideoEdit( $row, $input, $group, $user, $plugin )
	{
		global $_CB_framework, $_PLUGINS;

		$pageTitle					=	( $row->getInt( 'id', 0 ) ? CBTxt::T( 'Edit Video' ) : CBTxt::T( 'New Video' ) );

		$_CB_framework->setPageTitle( $pageTitle );

		cbValidator::loadValidation();
		initToolTip();

		$isModerator				=	CBGroupJive::isModerator( $user->getInt( 'id', 0 ) );
		$canModerate				=	( CBGroupJive::getGroupStatus( $user, $group ) >= 2 );
		$return						=	null;

		$_PLUGINS->trigger( 'gj_onBeforeDisplayVideoEdit', array( &$return, &$row, &$input, $group, $user ) );

		$videoExists				=	( $row->getInt( 'id', 0 ) && $row->exists() );

		$return						.=	'<div class="gjVideoEdit">'
									.		'<form action="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'video', 'func' => 'save', 'group' => ( ! $row->getInt( 'id', 0 ) ? $group->getInt( 'id' ) : null ), 'id' => $row->getInt( 'id', 0 ) ) ) . '" method="post" enctype="multipart/form-data" name="gjVideoEditForm" id="gjVideoEditForm" class="form-auto m-0 cb_form gjVideoEditForm cbValidation">'
									.			( $pageTitle ? '<div class="mb-3 border-bottom cb-page-header gjVideoEditTitle"><h3 class="m-0 p-0 mb-2 cb-page-header-title">' . $pageTitle . '</h3></div>' : null );

		if ( $isModerator || $canModerate || ( $row->getInt( 'id', 0 ) && ( $row->getInt( 'published', 0 ) !== -1 ) ) || ( $group->params()->getInt( 'video', 1 ) !== 2 ) ) {
			$return					.=			'<div class="cbft_select cbtt_select form-group row no-gutters cb_form_line">'
									.				'<label for="published" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Published' ) . '</label>'
									.				'<div class="cb_field col-sm-9">'
									.					$input['published']
									.					getFieldIcons( null, 0, null, CBTxt::T( 'Select publish state of this video. Unpublished videos will not be visible to the public.' ) )
									.				'</div>'
									.			'</div>';
		}

		$return						.=			'<div class="cbft_text cbtt_input form-group row no-gutters cb_form_line">'
									.				'<label for="title" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Title' ) . '</label>'
									.				'<div class="cb_field col-sm-9">'
									.					$input['title']
									.					getFieldIcons( null, 0, null, CBTxt::T( 'Optionally input a video title to display instead of url.' ) )
									.				'</div>'
									.			'</div>';

		if ( $videoExists ) {
			$return					.=			'<div class="cbft_delimiter form-group row no-gutters cb_form_line">'
									.				'<label for="url" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Video' ) . '</label>'
									.				'<div class="cb_field col-sm-9">'
									.					'<div class="form-control-plaintext">'
									.						'<div class="position-relative gjGroupVideoEmbed">';

			if ( $row->mimeType() === 'video/youtube' ) {
				if ( preg_match( '%(?:(?:watch\?v=)|(?:embed/)|(?:shorts/)|(?:be/))([A-Za-z0-9_-]+)%', $row->getString( 'url' ), $matches ) ) {
					$return			.=							'<iframe width="100%" height="100%" style="width: 100%; height: 100%;" src="https://www.youtube-nocookie.com/embed/' . htmlspecialchars( $matches[1] ) . '" frameborder="0" allow="encrypted-media" allowfullscreen class="position-absolute gjVideoPlayer"></iframe>';
				}
			} else {
				$return				.=							'<video width="100%" height="100%" style="width: 100%; height: 100%;" src="' . htmlspecialchars( $row->getString( 'url' ) ) . '" type="' . htmlspecialchars( $row->mimeType() ) . '" controls="controls" preload="auto" class="position-absolute gjVideoPlayer"></video>';
			}

			$return					.=						'</div>'
									.					'</div>'
									.				'</div>'
									.			'</div>';
		}

		$return						.=			'<div class="cbft_text cbtt_input form-group row no-gutters cb_form_line">'
									.				( ! $videoExists ? '<label for="url" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Video' ) . '</label>' : null )
									.				'<div class="cb_field' . ( $videoExists ? ' offset-sm-3' : null ) . ' col-sm-9">'
									.					$input['url']
									.					getFieldIcons( null, ( ! $row->getInt( 'id', 0 ) ? 1 : 0 ), null, CBTxt::T( 'Input the URL to the video to publish.' ) )
									.					( $input['url_limits'] ? '<div class="form-text">' . $input['url_limits'] . '</div>' : null )
									.				'</div>'
									.			'</div>'
									.			'<div class="cbft_textarea cbtt_textarea form-group row no-gutters cb_form_line">'
									.				'<label for="caption" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Caption' ) . '</label>'
									.				'<div class="cb_field col-sm-9">'
									.					$input['caption']
									.					getFieldIcons( null, 0, null, CBTxt::T( 'Optionally input a video caption.' ) )
									.				'</div>'
									.			'</div>';

		if ( $isModerator ) {
			$return					.=			'<div class="cbft_text cbtt_input form-group row no-gutters cb_form_line">'
									.				'<label for="user_id" class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Owner' ) . '</label>'
									.				'<div class="cb_field col-sm-9">'
									.					$input['user_id']
									.					getFieldIcons( null, 1, null, CBTxt::T( 'Input the video owner id. Video owner determines the creator of the video specified as User ID.' ) )
									.				'</div>'
									.			'</div>';
		}

		if ( ( ! $isModerator ) && $plugin->params->getInt( 'groups_video_captcha', 0 ) ) {
			$_PLUGINS->loadPluginGroup( 'user' );

			$captcha				=	$_PLUGINS->trigger( 'onGetCaptchaHtmlElements', array( false ) );

			if ( ! empty( $captcha ) ) {
				$captcha			=	$captcha[0];

				$return				.=			'<div class="cbft_delimiter form-group row no-gutters cb_form_line">'
									.				'<label class="col-form-label col-sm-3 pr-sm-2">' . CBTxt::T( 'Captcha' ) . '</label>'
									.				'<div class="cb_field col-sm-9">'
									.					( isset( $captcha[0] ) ? $captcha[0] : null )
									.				'</div>'
									.			'</div>'
									.			'<div class="cbft_text cbtt_input form-group row no-gutters cb_form_line">'
									.				'<div class="cb_field offset-sm-3 col-sm-9">'
									.					str_replace( 'inputbox', 'form-control', ( isset( $captcha[1] ) ? $captcha[1] : null ) )
									.					getFieldIcons( null, 1, null )
									.				'</div>'
									.			'</div>';
			}
		}

		$return						.=			'<div class="row no-gutters">'
									.				'<div class="offset-sm-3 col-sm-9">'
									.					'<input type="submit" value="' . htmlspecialchars( ( $row->getInt( 'id', 0 ) ? CBTxt::T( 'Update Video' ) : CBTxt::T( 'Publish Video' ) ) ) . '" class="btn btn-primary btn-sm-block gjButton gjButtonSubmit" ' . cbValidator::getSubmitBtnHtmlAttributes() . ' />'
									.					' <input type="button" value="' . htmlspecialchars( CBTxt::T( 'Cancel' ) ) . '" class="btn btn-secondary btn-sm-block gjButton gjButtonCancel " onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to cancel? All unsaved data will be lost!' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( 'cbgroupjive', true, array( 'action' => 'groups', 'func' => 'show', 'id' => $group->getInt( 'id', 0 ) ) ) ) . '\'; })" />'
									.				'</div>'
									.			'</div>'
									.			( ! $row->getInt( 'id', 0 ) ? '<input type="hidden" id="group" name="group" value="' . $group->getInt( 'id', 0 ) . '" />' : null )
									.			cbGetSpoofInputTag( 'plugin' )
									.		'</form>'
									.	'</div>';

		$_CB_framework->setMenuMeta();

		$_PLUGINS->trigger( 'gj_onAfterDisplayVideoEdit', array( &$return, $row, $input, $group, $user ) );

		echo $return;
	}
}