<?php
/**
 * Community Builder (TM)
 * @version $Id: $
 * @package CommunityBuilder
 * @copyright (C) 2004-2022 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
 * @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
 */

defined( '_JEXEC' ) or die;

/**
 * @var stdClass $module
 * @var JRegistry $params
 */

require_once( __DIR__ . '/helper.php' );

global $_CB_framework, $_PLUGINS;

CBContentModuleHelper::loadCB( $params );

$prepareContent							=	(bool) $params->get( 'prepare_content', false );

if ( CBContentModuleHelper::isCB() ) {
	$templateClass						=	'cb_template cb_template_' . selectTemplate( 'dir' ) . ' cbContent';
} else {
	$templateClass						=	'cbContent';
}

static $cache							=	[];

$cacheId								=	$module->id;

if ( ! array_key_exists( $cacheId, $cache ) ) {
	$mainCSSURLs						=	$params->get( 'maincssurls', '' );

	if ( $mainCSSURLs ) {
		foreach ( explode( "\n", $mainCSSURLs ) as $mainCSSURL ) {
			CBContentModuleHelper::addHeadStyleSheet( $mainCSSURL, $prepareContent );
		}
	}

	CBContentModuleHelper::addHeadStyleInline( $params->get( 'maincss', '' ), $prepareContent );

	$mainJSURLs							=	$params->get( 'mainjsurls', '' );

	if ( $mainJSURLs ) {
		foreach ( explode( "\n", $mainJSURLs ) as $mainJSURL ) {
			CBContentModuleHelper::addHeadScriptUrl( $mainJSURL, $prepareContent );
		}
	}

	CBContentModuleHelper::addHeadScriptDeclaration( $params->get( 'mainjs', '' ), $prepareContent );

	$mainJquery							=	$params->get( 'mainjquery', '' );
	$mainJqueryPlgs						=	$params->get( 'mainjquery_plgs', '' );

	if ( $mainJqueryPlgs ) {
		$mainJqueryPlgs					=	explode( ',', $mainJqueryPlgs );
	} else {
		$mainJqueryPlgs					=	[];
	}

	CBContentModuleHelper::addHeadJqueryDeclaration( $mainJquery, $mainJqueryPlgs );

	$cache[$cacheId]					=	true;
}

$moduleContent							=	CBContentModuleHelper::prepareContent( CBContentModuleHelper::T( $params->get( 'maintext', '' ) ), $prepareContent );
$startMode								=	$params->get( 'timed_start_mode', '' );
$endMode								=	$params->get( 'timed_end_mode', '' );
$repeat									=	(int) $params->get( 'timed_repeat', 0 );

switch ( $startMode ) {
	case 'field':
		$start							=	CBContentModuleHelper::fieldValue( $params->get( 'timed_field_start', '' ) );
		break;
	case 'relative':
		$start							=	CBContentModuleHelper::parseSubstitutions( $params->get( 'timed_relative_start', '' ) );
		break;
	case 'datetime_server':
		$start							=	$params->get( 'timed_server_start', '' );
		break;
	case 'datetime_user':
		$start							=	$params->get( 'timed_user_start', '' );
		break;
	case 'datetime':
	default:
		$start							=	$params->get( 'timed_start', '' );
		break;
}

switch ( $endMode ) {
	case 'field':
		$end							=	CBContentModuleHelper::fieldValue( $params->get( 'timed_field_end', '' ) );
		break;
	case 'relative':
		$end							=	CBContentModuleHelper::parseSubstitutions( $params->get( 'timed_relative_end', '' ) );
		break;
	case 'datetime_server':
		$end							=	$params->get( 'timed_server_end', '' );
		break;
	case 'datetime_user':
		$end							=	$params->get( 'timed_user_end', '' );
		break;
	case 'datetime':
	default:
		$end							=	$params->get( 'timed_end', '' );
		break;
}

if ( $start ) {
	$templateClass						.=	' cbContentTimed';
	$currentDatetime					=	CBContentModuleHelper::dateTimestamp( 'now' );

	if ( $startMode === 'relative' ) {
		$startDatetime					=	CBContentModuleHelper::dateTimestamp( 'now', $start );
	} else {
		$startDatetime					=	CBContentModuleHelper::dateTimestamp( $start );
	}

	$endDatetime						=	$startDatetime;

	$isBefore							=	false;
	$isDuring							=	false;
	$isAfter							=	false;
	$compare							=	true;

	if ( $end ) {
		if ( $endMode === 'relative' ) {
			$endDatetime				=	CBContentModuleHelper::dateTimestamp( $startDatetime, $end );
		} else {
			$endDatetime				=	CBContentModuleHelper::dateTimestamp( $end );
		}

		switch ( $repeat ) {
			case 1: // Daily: repeat daily so reset the month, day, and year to current so we're only comparing time
				$startDatetime			=	CBContentModuleHelper::dateTimestamp( CBContentModuleHelper::formatDate( 'now', 'Y-m-d' ) . ' ' . CBContentModuleHelper::formatDate( $start, 'H:i:s' ) );
				$endDatetime			=	CBContentModuleHelper::dateTimestamp( CBContentModuleHelper::formatDate( 'now', 'Y-m-d' ) . ' ' . CBContentModuleHelper::formatDate( $end, 'H:i:s' ) );
				break;
			case 2: // Weekly: repeat weekly so reset the month, day, and year to current so we're only comparing time and weekdays
			case 3: // Weekdays: repeat every week day so reset the month, day, and year to current so we're only comparing time and weekdays
				$currentWeekday			=	(int) CBContentModuleHelper::formatDate( 'now', 'N' );
				$startWeekday			=	(int) CBContentModuleHelper::formatDate( $start, 'N' );
				$endWeekday				=	(int) CBContentModuleHelper::formatDate( $end, 'N' );

				$startDatetime			=	CBContentModuleHelper::dateTimestamp( CBContentModuleHelper::formatDate( 'now', 'Y-m-d' ) . ' ' . CBContentModuleHelper::formatDate( $start, 'H:i:s' ) );
				$endDatetime			=	CBContentModuleHelper::dateTimestamp( CBContentModuleHelper::formatDate( 'now', 'Y-m-d' ) . ' ' . CBContentModuleHelper::formatDate( $end, 'H:i:s' ) );

				if ( $repeat === 3 ) {
					// Weekdays
					if ( ( $currentWeekday < $startWeekday ) || ( ( $currentWeekday >= $startWeekday ) && ( $currentDatetime < $startDatetime ) ) ) {
						$isBefore		=	true;
					} elseif ( ( ( $currentWeekday >= $startWeekday ) && ( $currentDatetime >= $startDatetime ) ) && ( ( $currentWeekday <= $endWeekday ) && ( $currentDatetime <= $endDatetime ) ) ) {
						$isDuring		=	true;
					} elseif ( ( $currentWeekday > $endWeekday ) || ( ( $currentWeekday <= $endWeekday ) && ( $currentDatetime > $endDatetime ) ) ) {
						$isAfter		=	true;
					}
				} else {
					// Weekly
					if ( ( $currentWeekday < $startWeekday ) || ( ( $currentWeekday === $startWeekday ) && ( $currentDatetime < $startDatetime ) ) ) {
						$isBefore		=	true;
					} elseif ( ( ( $currentWeekday > $startWeekday ) || ( ( $currentWeekday === $startWeekday ) && ( $currentDatetime >= $startDatetime ) ) ) && ( ( $currentWeekday < $endWeekday ) || ( ( $currentWeekday === $endWeekday ) && ( $currentDatetime <= $endDatetime ) ) ) ) {
						$isDuring		=	true;
					} elseif ( ( $currentWeekday > $endWeekday ) || ( ( $currentWeekday === $endWeekday ) && ( $currentDatetime > $endDatetime ) ) ) {
						$isAfter		=	true;
					}

					$startDatetime		=	CBContentModuleHelper::dateTimestamp( $start ); // Reset these back for display purposes
					$endDatetime		=	CBContentModuleHelper::dateTimestamp( $end ); // Reset these back for display purposes
				}

				$compare				=	false; // Custom comparison above so skip generic
				break;
			case 4: // Monthly: repeat monthly so reset the month and year to current so we're only comparing day, and time
				$startDatetime			=	CBContentModuleHelper::dateTimestamp( CBContentModuleHelper::formatDate( 'now', 'Y-m' ) . CBContentModuleHelper::formatDate( $start, '-d H:i:s' ) );
				$endDatetime			=	CBContentModuleHelper::dateTimestamp( CBContentModuleHelper::formatDate( 'now', 'Y-m' ) . CBContentModuleHelper::formatDate( $end, '-d H:i:s' ) );
				break;
			case 5: // Yearly: repeat yearly so reset the year to current so we're only comparing month, day, and time
				$startDatetime			=	CBContentModuleHelper::dateTimestamp( CBContentModuleHelper::formatDate( 'now', 'Y' ) . CBContentModuleHelper::formatDate( $start, '-m-d H:i:s' ) );
				$endDatetime			=	CBContentModuleHelper::dateTimestamp( CBContentModuleHelper::formatDate( 'now', 'Y' ) . CBContentModuleHelper::formatDate( $end, '-m-d H:i:s' ) );
				break;
		}

		if ( $compare ) {
			if ( $currentDatetime < $startDatetime ) {
				$isBefore				=	true;
			} elseif ( ( $currentDatetime >= $startDatetime ) && ( $currentDatetime <= $endDatetime ) ) {
				$isDuring				=	true;
			} elseif ( $currentDatetime > $endDatetime ) {
				$isAfter				=	true;
			}
		}
	} else {
		switch ( $repeat ) {
			case 1: // Daily: repeat daily so reset the month, day, and year to current so we're only comparing time
				$startDatetime			=	CBContentModuleHelper::dateTimestamp( CBContentModuleHelper::formatDate( 'now', 'Y-m-d' ) . ' ' . CBContentModuleHelper::formatDate( $start, 'H:i:s' ) );
				break;
			case 2: // Weekly: repeat weekly so reset the month, day, and year to current so we're only comparing time and weekdays
			case 3: // Weekdays: repeat every week day so reset the month, day, and year to current so we're only comparing time and weekdays
				$currentWeekday			=	(int) CBContentModuleHelper::formatDate( 'now', 'N' );
				$startWeekday			=	(int) CBContentModuleHelper::formatDate( $start, 'N' );

				$startDatetime			=	CBContentModuleHelper::dateTimestamp( CBContentModuleHelper::formatDate( 'now', 'Y-m-d' ) . ' ' . CBContentModuleHelper::formatDate( $start, 'H:i:s' ) );

				if ( $repeat === 3 ) {
					// Weekdays
					if ( ( $currentWeekday < $startWeekday ) || ( ( $currentWeekday >= $startWeekday ) && ( $currentDatetime < $startDatetime ) ) ) {
						$isBefore		=	true;
					} elseif ( ( $currentWeekday === $startWeekday ) && ( $currentDatetime === $startDatetime ) ) {
						$isDuring		=	true;
					} elseif ( ( $currentWeekday > $startWeekday ) || ( ( $currentWeekday <= $startWeekday ) && ( $currentDatetime > $startDatetime ) ) ) {
						$isAfter		=	true;
					}
				} else {
					// Weekly
					if ( ( $currentWeekday < $startWeekday ) || ( ( $currentWeekday === $startWeekday ) && ( $currentDatetime < $startDatetime ) ) ) {
						$isBefore		=	true;
					} elseif ( ( $currentWeekday === $startWeekday ) && ( $currentDatetime === $startDatetime ) ) {
						$isDuring		=	true;
					} elseif ( ( $currentWeekday > $startWeekday ) || ( ( $currentWeekday === $startWeekday ) && ( $currentDatetime > $startDatetime ) ) ) {
						$isAfter		=	true;
					}

					$startDatetime		=	CBContentModuleHelper::dateTimestamp( $start ); // Reset these back for display purposes
				}

				$compare				=	false; // Custom comparison above so skip generic
				break;
			case 4: // Monthly: repeat monthly so reset the month and year to current so we're only comparing day, and time
				$startDatetime			=	CBContentModuleHelper::dateTimestamp( CBContentModuleHelper::formatDate( 'now', 'Y-m' ) . CBContentModuleHelper::formatDate( $start, '-d H:i:s' ) );
				break;
			case 5: // Yearly: repeat yearly so reset the year to current so we're only comparing month, day, and time
				$startDatetime			=	CBContentModuleHelper::dateTimestamp( CBContentModuleHelper::formatDate( 'now', 'Y' ) . CBContentModuleHelper::formatDate( $start, '-m-d H:i:s' ) );
				break;
		}

		if ( $compare ) {
			if ( $currentDatetime < $startDatetime ) {
				$isBefore				=	true;
			} elseif ( $currentDatetime === $startDatetime ) {
				$isDuring				=	true;
			} elseif ( $currentDatetime > $startDatetime ) {
				$isAfter				=	true;
			}
		}
	}

	$timedContent						=	'';

	if ( $isBefore ) {
		$timedContent					=	CBContentModuleHelper::T( $params->get( 'timed_content_before', '' ) );
	} elseif ( $isDuring ) {
		$timedContent					=	CBContentModuleHelper::T( $params->get( 'timed_content_during', '' ) );
	} elseif ( $isAfter ) {
		$timedContent					=	CBContentModuleHelper::T( $params->get( 'timed_content_after', '' ) );
	}

	if ( $timedContent ) {
		$startDateFormat				=	$params->get( 'timed_start_date_format', '' );

		if ( ! $startDateFormat ) {
			$startDateFormat			=	CBContentModuleHelper::T( 'TIMED_START_DATE_FORMAT', 'F j, Y' );
		}

		$startTimeFormat				=	$params->get( 'timed_start_time_format', '' );

		if ( ! $startTimeFormat ) {
			$startTimeFormat			=	CBContentModuleHelper::T( 'TIMED_START_TIME_FORMAT', ' g:i A' );
		}

		$endDateFormat					=	$params->get( 'timed_end_date_format', '' );

		if ( ! $endDateFormat ) {
			$endDateFormat				=	CBContentModuleHelper::T( 'TIMED_END_DATE_FORMAT', 'F j, Y' );
		}

		$endTimeFormat					=	$params->get( 'timed_end_time_format', '' );

		if ( ! $endTimeFormat ) {
			$endTimeFormat				=	CBContentModuleHelper::T( 'TIMED_END_TIME_FORMAT', ' g:i A' );
		}

		$extra							=	[	'start_mode'			=>	( $startMode ?: 'datetime' ),
												'start'					=>	CBContentModuleHelper::displayDate( $startDatetime, true, $startDateFormat, $startTimeFormat ),
												'start_date'			=>	CBContentModuleHelper::displayDate( $startDatetime, false, $startDateFormat ),
												'start_time'			=>	CBContentModuleHelper::displayDate( $startDatetime, true, '', $startTimeFormat ),
												'start_ago'				=>	null,
												'start_exactago'		=>	null,
												'start_utc'				=>	CBContentModuleHelper::displayDate( $startDatetime, true, $startDateFormat, $startTimeFormat, false ),
												'start_utc_date'		=>	CBContentModuleHelper::displayDate( $startDatetime, false, $startDateFormat, null, false ),
												'start_utc_time'		=>	CBContentModuleHelper::displayDate( $startDatetime, true, '', $startTimeFormat, false ),
												'start_utc_ago'			=>	null,
												'start_utc_exactago'	=>	null,
												'end_mode'				=>	( $endMode ?: 'datetime' ),
												'end'					=>	( $end ? CBContentModuleHelper::displayDate( $endDatetime, true, $endDateFormat, $endTimeFormat ) : null ),
												'end_date'				=>	( $end ? CBContentModuleHelper::displayDate( $endDatetime, false, $endDateFormat ) : null ),
												'end_time'				=>	( $end ? CBContentModuleHelper::displayDate( $endDatetime, true, '', $endTimeFormat ) : null ),
												'end_ago'				=>	null,
												'end_exactago'			=>	null,
												'end_utc'				=>	( $end ? CBContentModuleHelper::displayDate( $endDatetime, true, $endDateFormat, $endTimeFormat, false ) : null ),
												'end_utc_date'			=>	( $end ? CBContentModuleHelper::displayDate( $endDatetime, false, $endDateFormat, null, false ) : null ),
												'end_utc_time'			=>	( $end ? CBContentModuleHelper::displayDate( $endDatetime, true, '', $endTimeFormat, false ) : null ),
												'end_utc_ago'			=>	null,
												'end_utc_exactago'		=>	null,
											];

		if ( strpos( $timedContent, '[start_ago]' ) !== false ) {
			$extra['start_ago']				=	CBContentModuleHelper::displayDate( $startDatetime, 'timeago' );
		}

		if ( strpos( $timedContent, '[start_utc_ago]' ) !== false ) {
			$extra['start_utc_ago']			=	CBContentModuleHelper::displayDate( $startDatetime, 'timeago', null, null, false );
		}

		if ( strpos( $timedContent, '[start_exactago]' ) !== false ) {
			$extra['start_exactago']		=	CBContentModuleHelper::displayDate( $startDatetime, 'exacttimeago' );
		}

		if ( strpos( $timedContent, '[start_utc_exactago]' ) !== false ) {
			$extra['start_utc_exactago']	=	CBContentModuleHelper::displayDate( $startDatetime, 'exacttimeago', null, null, false );
		}

		if ( strpos( $timedContent, '[end_ago]' ) !== false ) {
			$extra['end_ago']				=	( $end ? CBContentModuleHelper::displayDate( $endDatetime, 'timeago' ) : null );
		}

		if ( strpos( $timedContent, '[end_utc_ago]' ) !== false ) {
			$extra['end_utc_ago']			=	( $end ? CBContentModuleHelper::displayDate( $endDatetime, 'timeago', null, null, false ) : null );
		}

		if ( strpos( $timedContent, '[end_exactago]' ) !== false ) {
			$extra['end_exactago']			=	( $end ? CBContentModuleHelper::displayDate( $endDatetime, 'exacttimeago' ) : null );
		}

		if ( strpos( $timedContent, '[end_utc_exactago]' ) !== false ) {
			$extra['end_utc_exactago']		=	( $end ? CBContentModuleHelper::displayDate( $endDatetime, 'exacttimeago', null, null, false ) : null );
		}

		$moduleContent 					.=	CBContentModuleHelper::prepareContent( $timedContent, $prepareContent, $extra );
	}
}

if ( ! $moduleContent ) {
	return;
}

$module->content						=	$moduleContent;

require JModuleHelper::getLayoutPath( 'mod_cbcontent', $params->get( 'layout', 'default' ) );
