<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;
use CB\Plugin\Gallery\CBGallery;
use CB\Plugin\Gallery\Gallery;
use CB\Plugin\Gallery\Table\ItemTable;
use CBLib\Registry\ParamsInterface;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_cbgalleryItem
{

	/**
	 * @param ItemTable        $row
	 * @param UserTable        $viewer
	 * @param Gallery          $gallery
	 * @param CBplug_cbgallery $plugin
	 */
	public static function showItem( $row, $viewer, $gallery, $plugin )
	{
		global $_CB_framework, $_PLUGINS;

		if ( ! $row->exists() ) {
			return;
		}

		static $JS_LOADED				=	0;

		if ( ! $JS_LOADED++ ) {
			initToolTip();
		}

		$cbUser							=	CBuser::getInstance( $row->getInt( 'user_id', 0 ), false );
		$canModerate					=	CBGallery::canModerate( $gallery );
		$owner							=	( $viewer->getInt( 'id', 0 ) === $row->getInt( 'user_id', 0 ) );
		$folder							=	null;

		$title							=	( $row->getString( 'title' ) ? $row->getString( 'title' ) : $row->name() );
		$date							=	null;
		$menu							=	array();

		$integrations					=	implode( '', $_PLUGINS->trigger( 'gallery_onDisplayModal', array( &$row, &$title, &$date, &$menu, $gallery ) ) );

		$type							=	$row->getString( 'type' );
		$isFileImage					=	false;
		$isFileVideo					=	false;
		$isFileMusic					=	false;

		if ( $type === 'files' ) {
			$fileExtensionType			=	CBGallery::getExtensionType( $row->extension() );

			$isFileImage				=	( ( $row->extension() === 'svg' ) || ( $fileExtensionType === 'photos' ) );
			$isFileVideo				=	( $fileExtensionType === 'videos' );
			$isFileMusic				=	( $fileExtensionType === 'music' );
		}

		if ( $row->domain() ) {
			$showPath					=	htmlspecialchars( $row->path() );
			$downloadPath				=	null;
			$canDownload				=	false;
		} else {
			$showPath					=	$_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'item', 'func' => 'show', 'id' => $row->getInt( 'id', 0 ), 'gallery' => $gallery->id(), 'v' => ( ( $type === 'photos' ) || $isFileImage ? $row->modified( false, true ) : null ) ), 'raw', 0, true );
			$downloadPath				=	$_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'item', 'func' => 'download', 'id' => $row->getInt( 'id', 0 ), 'gallery' => $gallery->id() ), 'raw', 0, true );
			$canDownload				=	( $isFileImage || $isFileVideo || $isFileMusic || ( ( $type !== 'files' ) && $gallery->getBool( $type . '_download', false ) ) );
		}

		$previous						=	$plugin->getInput()->getString( 'previous' );
		$next							=	$plugin->getInput()->getString( 'next' );
		$returnUrl						=	CBGallery::getReturn( true );

		$metadata						=	null;

		$return							=	'<div class="d-flex flex-wrap no-gutters h-100 w-100 bg-dark border border-dark rounded auto-overflow galleryModalContainer">'
										.		'<div class="position-relative d-flex flex-wrap no-gutters col-sm-7 col-md-8 col-lg-9 h-100 galleryModalDisplay">';

		if ( $previous !== null ) {
			$return						.=			'<div class="d-flex flex-column justify-content-center h-100 p-2 text-white text-large galleryModalScrollLeft">'
										.				'<span class="fa fa-chevron-left galleryModalScrollLeftIcon" data-cbgallery-previous="' . htmlspecialchars( $previous ) . '"></span>'
										.			'</div>';
		}

		$return							.=			'<div class="d-flex flex-column col justify-content-center align-items-center h-100 p-2 no-overflow galleryModalItem galleryModalItem' . htmlspecialchars( ucfirst( $type ) ) . '">';

		switch ( ( $isFileImage ? 'photos' : ( $isFileVideo ? 'videos' : ( $isFileMusic ? 'music' : $type ) ) ) ) {
			case 'photos':
				if ( $gallery->getBool( 'photos_metadata', false ) && $row->params()->subTree( 'metadata' )->count() ) {
					$metadata			=	'<div class="galleryMediaMetadata">'
										.		'<table class="table table-sm table-striped table-dark m-0 galleryMediaMetadataTable">'
										.			'<tbody>';

					foreach ( $row->params()->subTree( 'metadata' ) as $dataType => $data ) {
						/** @var ParamsInterface $data */
						if ( ! $data->count() ) {
							continue;
						}

						$metadata		.=				'<tr>'
										.					'<th colspan="2" class="bg-transparent" scope="row">' . htmlspecialchars( $dataType ) . '</th>'
										.				'</tr>';

						foreach ( array_keys( $data->asArray() ) as $dataKey ) {
							$metadata	.=				'<tr>'
										.					'<th style="width: 150px;" class="bg-transparent" scope="row">' . htmlspecialchars( $dataKey ) . '</th>'
										.					'<td class="bg-transparent text-wrap">' . htmlspecialchars( $data->getString( $dataKey ) ) . '</td>'
										.				'</tr>';
						}
					}

					$metadata			.=			'</tbody>'
										.		'</table>'
										.	'</div>';
				}

				$return					.=				'<img alt="' . htmlspecialchars( $title ) . '" src="' . $showPath . '" class="mh-100 mw-100 cbImgPict cbFullPict" />';
				break;
			case 'files':
				$return					.=				'<div class="bg-light table-responsive galleryMediaFile">'
										.					'<table class="table table-sm table-bordered w-100 m-0 galleryMediaFileTable">'
										.						'<tbody>'
										.							'<tr>'
										.								'<th style="width: 150px;" class="d-block d-md-table-cell w-md-100" scope="row">' . CBTxt::T( 'File' ) . '</th>'
										.								'<td class="d-block d-md-table-cell w-md-100 text-wrap"><a href="' . $showPath . '" target="_blank" rel="nofollow noopener">' . $row->name() . '</a></td>'
										.							'</tr>'
										.							'<tr>'
										.								'<th style="width: 150px;" class="d-block d-md-table-cell w-md-100" scope="row">' . CBTxt::T( 'Extension' ) . '</th>'
										.								'<td class="d-block d-md-table-cell w-md-100 text-wrap">' . $row->extension() . '</td>'
										.							'</tr>'
										.							'<tr>'
										.								'<th style="width: 150px;" class="d-block d-md-table-cell w-md-100" scope="row">' . CBTxt::T( 'Size' ) . '</th>'
										.								'<td class="d-block d-md-table-cell w-md-100 text-wrap">' . $row->size() . '</td>'
										.							'</tr>'
										.							'<tr>'
										.								'<th style="width: 150px;" class="d-block d-md-table-cell w-md-100" scope="row">' . CBTxt::T( 'Modified' ) . '</th>'
										.								'<td class="d-block d-md-table-cell w-md-100 text-wrap">' . cbFormatDate( $row->modified() ) . '</td>'
										.							'</tr>';

				if ( $gallery->getBool( 'files_md5', false ) && $row->params()->getString( 'checksum.md5' ) ) {
					$return				.=							'<tr>'
										.								'<th style="width: 150px;" class="d-block d-md-table-cell w-md-100" scope="row">' . CBTxt::T( 'MD5 Checksum' ) . '</th>'
										.								'<td class="d-block d-md-table-cell w-md-100 text-wrap">' . $row->params()->getString( 'checksum.md5' ) . '</td>'
										.							'</tr>';
				}

				if ( $gallery->getBool( 'files_sha1', false ) && $row->params()->getString( 'checksum.sha1' ) ) {
					$return				.=							'<tr>'
										.								'<th style="width: 150px;" class="d-block d-md-table-cell w-md-100" scope="row">' . CBTxt::T( 'SHA1 Checksum' ) . '</th>'
										.								'<td class="d-block d-md-table-cell w-md-100 text-wrap">' . $row->params()->getString( 'checksum.sha1' ) . '</td>'
										.							'</tr>';
				}

				if ( $downloadPath ) {
					$return				.=							'<tr>'
										.								'<td colspan="2" class="d-block d-md-table-cell w-md-100 text-right"><a href="' . $downloadPath . '" class="btn btn-sm btn-primary">' . CBTxt::T( 'Download' ) . '</a></td>'
										.							'</tr>';
				}

				$return					.=						'</tbody>'
										.					'</table>'
										.				'</div>';
				break;
			case 'videos':
				$return					.=				'<div class="position-relative w-100 mh-100 galleryMediaVideo">';

				if ( $row->mimeType() === 'video/x-youtube' ) {
					if ( preg_match( '%(?:(?:watch\?v=)|(?:embed/)|(?:shorts/)|(?:be/))([A-Za-z0-9_-]+)%', $showPath, $matches ) ) {
						$return			.=					'<iframe width="100%" height="100%" style="width: 100%; height: 100%;" src="https://www.youtube.com/embed/' . htmlspecialchars( $matches[1] ) . '" frameborder="0" allow="fullscreen; picture-in-picture" class="position-absolute galleryVideoPlayer"></iframe>';
					}
				} elseif ( $row->mimeType() === 'video/x-vimeo' ) {
					if ( preg_match( '%/(\d+)$%i', $showPath, $matches ) ) {
						$return			.=					'<iframe width="100%" height="100%" style="width: 100%; height: 100%;" src="https://player.vimeo.com/video/' . htmlspecialchars( $matches[1] ) . '" frameborder="0" allow="fullscreen; picture-in-picture" class="position-absolute galleryVideoPlayer"></iframe>';
					}
				} elseif ( $row->mimeType() === 'video/x-facebook' ) {
					$return				.=					'<iframe width="100%" height="100%" style="width: 100%; height: 100%;" src="https://www.facebook.com/plugins/video.php?href=' . htmlspecialchars( $showPath ) . '&show_text=false" frameborder="0" allow="fullscreen; picture-in-picture" class="position-absolute galleryVideoPlayer"></iframe>';
				} else {
					$return				.=					'<video width="100%" height="100%" style="width: 100%; height: 100%;" src="' . $showPath . '" type="' . htmlspecialchars( $row->mimeType() ) . '" controls="controls" controlsList="nodownload" preload="auto" class="position-absolute galleryVideoPlayer"></video>';
				}

				$return					.=				'</div>';
				break;
			case 'music':
				if ( $row->getString( 'thumbnail' ) || ( $row->domain() && $row->params()->getString( 'link_thumbnail' ) ) ) {
					$return				.=				'<div class="d-flex flex-column justify-content-center position-relative w-100 mh-100">'
										.					'<div class="d-flex flex-column justify-content-center w-100 h-100">'
										.						$row->thumbnail( $gallery )
										.					'</div>'
										.					'<div class="position-absolute p-3 w-100">'
										.						'<audio style="width: 100%;" src="' . $showPath . '" type="' . htmlspecialchars( $row->mimeType() ) . '" controls="controls" controlsList="nodownload" preload="auto" class="galleryAudioPlayer"></audio>'
										.					'</div>'
										.				'</div>';
				} else {
					$return				.=				'<audio style="width: 100%;" src="' . $showPath . '" type="' . htmlspecialchars( $row->mimeType() ) . '" controls="controls" controlsList="nodownload" preload="auto" class="galleryAudioPlayer"></audio>';
				}
				break;
		}

		$return							.=			'</div>';

		if ( $next !== null ) {
			$return						.=			'<div class="d-flex flex-column justify-content-center h-100 p-2 text-white text-large text-right galleryModalScrollRight">'
										.				'<span class="fa fa-chevron-right galleryModalScrollRightIcon" data-cbgallery-next="' . htmlspecialchars( $next ) . '"></span>'
										.			'</div>';
		}

		$return							.=			'<div class="d-block d-sm-none position-absolute p-2 pr-5 w-100 text-white text-truncate font-weight-bold galleryModalInfo">'
										.				( count( $gallery->types() ) > 1 ? cbTooltip( null, CBGallery::translateType( $type ), null, 'auto', null, '<span class="fa ' . CBGallery::getTypeIcon( $row ) . '"></span>', null, 'class="galleryModalType" data-cbtooltip-position-my="bottom center" data-cbtooltip-position-at="top center" data-cbtooltip-classes="qtip-simple"' ) . ' ' : null )
										.				$title;

		if ( $row->getInt( 'folder', 0 ) ) {
			$folder						=	$row->folder( $gallery );

			if ( $folder->getInt( 'id', 0 ) && ( ( $folder->getInt( 'published', 1 ) ) || ( ( $viewer->getInt( 'id', 0 ) === $folder->getInt( 'user_id', 0 ) ) || $canModerate ) ) ) {
				$inFolder				=	'<a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'folder', 'func' => 'show', 'id' => $folder->getInt( 'id', 0 ), 'gallery' => $gallery->id(), 'return' => $returnUrl ) ) . '">'
										.		( $folder->getString( 'title' ) ? $folder->getString( 'title' ) : cbFormatDate( $folder->getString( 'date' ), true, false, CBTxt::T( 'GALLERY_SHORT_DATE_FORMAT', 'M j, Y' ) ) )
										.	'</a>';

				$return					.=				' <span class="text-small">' . CBTxt::T( 'IN_FOLDER', 'in [folder]', array( '[folder]' => $inFolder ) ) . '</span>';
			}
		}

		$return							.=			'</div>'
										.			'<div class="position-absolute p-2 galleryModalClose">'
										.				'<span class="fa fa-times text-large text-white cbTooltipClose"></span>'
										.			'</div>';

		if ( $row->getError() || $row->getRaw( '_success' ) ) {
			$return						.=			'<div class="position-absolute p-2 galleryModalAlert">'
										.				'<div class="m-0 p-2 alert alert-' . ( $row->getError() ? 'danger' : 'success' ) . '">' . ( $row->getError() ? $row->getError() : $row->getRaw( '_success' ) ) . '</div>'
										.			'</div>';
		}

		if ( $canDownload || $metadata ) {
			$buttons					=	array();

			if ( $canDownload ) {
				$buttons[]				=	'<a href="' . $downloadPath . '" rel="nofollow noopener" class="btn btn-light border btn-sm galleryButton galleryButtonDownload"><span class="fa fa-download"></span></a>';
			}

			if ( $metadata ) {
				$metadataAttr			=	cbTooltip( null, $metadata, null, array( 400, 400 ), null, null, null, 'class="btn btn-light border btn-sm galleryButton galleryButtonMetadata" data-cbtooltip-open-event="click" data-cbtooltip-close-event="click unfocus" data-cbtooltip-position-my="top center" data-cbtooltip-position-at="bottom center" data-cbtooltip-button-close="false" data-cbtooltip-classes="qtip-simple galleryMetadata" data-cbtooltip-content-classes="p-0 h-100 mw-100"' );

				$buttons[]				=	'<button type="button" ' . trim( $metadataAttr ) . '><span class="fa fa-camera-retro"></span></button>';
			}

			$return						.=			'<div class="position-absolute p-2 galleryModalActions">'
										.				implode( ' ', $buttons )
										.			'</div>';
		}

		$return							.=		'</div>'
										.		'<div class="d-flex flex-column col-sm-5 col-md-4 col-lg-3 h-100 mh-100 bg-white border-left galleryModalDetails">'
										.			'<div class="position-relative p-2 galleryModalHeader">'
										.				'<div class="media">'
										.					'<div class="media-left galleryModalHeaderAvatar">'
										.						$cbUser->getField( 'avatar', null, 'html', 'none', 'list', 0, true )
										.					'</div>'
										.					'<div class="pl-2 pr-5 media-body galleryModalHeaderBody">'
										.						'<div class="text-wrap text-normal galleryModalHeaderPublisher">'
										.							'<strong>' . $cbUser->getField( 'formatname', null, 'html', 'none', 'list', 0, true ) . '</strong>'
										.						'</div>'
										.						'<div class="text-muted text-small galleryModalHeaderDate">'
										.							cbFormatDate( $row->getString( 'date' ), true, 'timeago' )
										.							( $date ? ' ' . $date : null )
										.						'</div>'
										.					'</div>'
										.				'</div>';

		if ( $canModerate || $owner || $menu ) {
			$menuItems					=	'<ul class="list-unstyled dropdown-menu d-block position-relative m-0 galleryMenuItems">';

			if ( $menu ) {
				$menuItems				.=		'<li class="galleryMenuItem">' . implode( '</li><li class="galleryMenuItem">', $menu ) . '</li>';
			}

			if ( $canModerate || $owner ) {
				if ( $menu ) {
					$menuItems			.=		'<li class="galleryMenuItem"><div class="dropdown-divider"></div></li>';
				}

				$canThumbnail			=	( $folder && ( $folder->getInt( 'thumbnail', 0 ) !== $row->getInt( 'id', 0 ) ) );

				if ( $canThumbnail ) {
					$menuItems			.=		'<li class="galleryMenuItem galleryModalAction"><a href="javascript: void(0);" data-cbgallery-action-url="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'folder', 'func' => 'cover', 'id' => $folder->getInt( 'id', 0 ), 'item' => $row->getInt( 'id', 0 ), 'gallery' => $gallery->id() ), 'raw', 0, true ) . '" class="dropdown-item"><span class="fa fa-exchange"></span> ' . CBTxt::T( 'Make Album Cover' ) . '</a></li>';
				}

				if ( ( $type === 'photos' ) && ( ! $row->domain() ) ) {
					$menuItems			.=		'<li class="galleryMenuItem galleryModalAction"><a href="javascript: void(0);" data-cbgallery-action-url="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'item', 'func' => 'rotate', 'direction' => 'left', 'id' => $row->getInt( 'id', 0 ), 'gallery' => $gallery->id() ), 'raw', 0, true ) . '" class="dropdown-item"><span class="fa fa-rotate-left"></span> ' . CBTxt::T( 'Rotate Left' ) . '</a></li>'
										.		'<li class="galleryMenuItem galleryModalAction"><a href="javascript: void(0);" data-cbgallery-action-url="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'item', 'func' => 'rotate', 'direction' => 'right', 'id' => $row->getInt( 'id', 0 ), 'gallery' => $gallery->id() ), 'raw', 0, true ) . '" class="dropdown-item"><span class="fa fa-rotate-right"></span> ' . CBTxt::T( 'Rotate Right' ) . '</a></li>';

					if ( $owner && ( $row->getInt( 'published', 1 ) !== -1 ) && ( $gallery->getBool( 'photos_avatar', false ) || $gallery->getBool( 'photos_canvas', false ) ) ) {
						$menuItems		.=		'<li class="galleryMenuItem"><div class="dropdown-divider"></div></li>';

						if ( $gallery->getBool( 'photos_avatar', false ) ) {
							$menuItems	.=		'<li class="galleryMenuItem galleryModalAction"><a href="javascript: void(0);" data-cbgallery-action-url="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'item', 'func' => 'avatar', 'id' => $row->getInt( 'id', 0 ), 'gallery' => $gallery->id() ), 'raw', 0, true ) . '" data-cbgallery-confirm="' . htmlspecialchars( CBTxt::T( 'Are you sure you want to make this photo your profile avatar?' ) ) . '" class="dropdown-item"><span class="fa fa-exchange"></span> ' . CBTxt::T( 'Make Profile Avatar' ) . '</a></li>';
						}

						if ( $gallery->getBool( 'photos_canvas', false ) ) {
							$menuItems	.=		'<li class="galleryMenuItem galleryModalAction"><a href="javascript: void(0);" data-cbgallery-action-url="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'item', 'func' => 'canvas', 'id' => $row->getInt( 'id', 0 ), 'gallery' => $gallery->id() ), 'raw', 0, true ) . '" data-cbgallery-confirm="' . htmlspecialchars( CBTxt::T( 'Are you sure you want to make this photo your profile canvas?' ) ) . '" class="dropdown-item"><span class="fa fa-exchange"></span> ' . CBTxt::T( 'Make Profile Canvas' ) . '</a></li>';
						}
					}
				}

				if ( $canThumbnail || ( ( ( $type === 'photos' ) || $isFileImage ) && ( ! $row->domain() ) ) ) {
					$menuItems			.=		'<li class="galleryMenuItem"><div class="dropdown-divider"></div></li>';
				}

				$menuItems				.=		'<li class="galleryMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'item', 'func' => 'edit', 'id' => $row->getInt( 'id', 0 ), 'gallery' => $gallery->id(), 'return' => $returnUrl ) ) . '" class="dropdown-item"><span class="fa fa-edit"></span> ' . CBTxt::T( 'Edit' ) . '</a></li>';

				if ( ( $row->getInt( 'published', 1 ) === -1 ) && $gallery->getBool( $type . '_create_approval', false ) ) {
					if ( $canModerate ) {
						$menuItems		.=		'<li class="galleryMenuItem galleryModalAction"><a href="javascript: void(0);" data-cbgallery-action-url="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'item', 'func' => 'publish', 'id' => $row->getInt( 'id', 0 ), 'gallery' => $gallery->id() ), 'raw', 0, true ) . '" class="dropdown-item"><span class="fa fa-check"></span> ' . CBTxt::T( 'Approve' ) . '</a></li>';
					}
				} elseif ( $row->getInt( 'published', 1 ) > 0 ) {
					// CBTxt::T( 'ARE_YOU_SURE_UNPUBLISH_TYPE', 'Are you sure you want to unpublish this [type]?', array( '[type]' => CBGallery::translateType( $type, false, true ) ) )
					$menuItems			.=		'<li class="galleryMenuItem galleryModalAction"><a href="javascript: void(0);" data-cbgallery-action-url="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'item', 'func' => 'unpublish', 'id' => $row->getInt( 'id', 0 ), 'gallery' => $gallery->id() ), 'raw', 0, true ) . '" data-cbgallery-confirm="' . htmlspecialchars( CBTxt::T( 'ARE_YOU_SURE_UNPUBLISH_' . strtoupper( $type ) . ' ARE_YOU_SURE_UNPUBLISH_TYPE', 'Are you sure you want to unpublish this [type]?', array( '[type]' => CBGallery::translateType( $type, false, true ) ) ) ) . '" class="dropdown-item"><span class="fa fa-times-circle"></span> ' . CBTxt::T( 'Unpublish' ) . '</a></li>';
				} else {
					$menuItems			.=		'<li class="galleryMenuItem galleryModalAction"><a href="javascript: void(0);" data-cbgallery-action-url="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'item', 'func' => 'publish', 'id' => $row->getInt( 'id', 0 ), 'gallery' => $gallery->id() ), 'raw', 0, true ) . '" class="dropdown-item"><span class="fa fa-check"></span> ' . CBTxt::T( 'Publish' ) . '</a></li>';
				}

				// CBTxt::T( 'ARE_YOU_SURE_DELETE_TYPE', 'Are you sure you want to delete this [type]?', array( '[type]' => CBGallery::translateType( $type, false, true ) ) )
				$menuItems				.=		'<li class="galleryMenuItem"><a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'ARE_YOU_SURE_DELETE_' . strtoupper( $type ) . ' ARE_YOU_SURE_DELETE_TYPE', 'Are you sure you want to delete this [type]?', array( '[type]' => CBGallery::translateType( $type, false, true ) ) ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'item', 'func' => 'delete', 'id' => $row->getInt( 'id', 0 ), 'gallery' => $gallery->id(), 'return' => $returnUrl ) ) ) . '\'; })" class="dropdown-item"><span class="fa fa-trash-o"></span> ' . CBTxt::T( 'Delete' ) . '</a></li>';
			}

			$menuItems					.=	'</ul>';

			$return						.=					'<div class="position-absolute pt-2 text-normal galleryModalMenu">'
										.						cbTooltip( null, $menuItems, null, 'auto', null, '<span class="pt-1 pb-1 pl-3 pr-3 text-large fa fa-ellipsis-v"></span>', 'javascript:void(0);', 'class="text-body cbDropdownMenu galleryModalMenuToggle" data-cbtooltip-menu="true" data-cbtooltip-classes="qtip-nostyle" data-cbtooltip-open-classes="active" aria-label="' . htmlspecialchars( CBTxt::T( 'Media Menu' ) ) . '"' )
										.					'</div>';
		}

		$return							.=			'</div>'
										.			( $row->getString( 'description' ) ? '<div class="p-2' . ( $integrations ? ' mh-25' : null ) . ' text-wrap text-small galleryModalDescription">' . $row->getDescription() . '</div>' : null )
										.			( $integrations ? '<div class="p-2 d-flex flex-column flex-grow-1 bg-light border-top galleryModalIntegrations">' . $integrations . '</div>' : null )
										.			CBGallery::reloadHeaders()
										.		'</div>'
										.	'</div>';

		echo $return;
	}
}