<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;
use CB\Plugin\Gallery\CBGallery;
use CB\Plugin\Gallery\Gallery;
use CB\Plugin\Gallery\Table\FolderTable;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_cbgalleryFolder
{

	/**
	 * @param FolderTable      $row
	 * @param UserTable        $viewer
	 * @param Gallery          $gallery
	 * @param CBplug_cbgallery $plugin
	 * @param string           $output
	 * @return string
	 */
	public static function showFolder( $row, $viewer, $gallery, $plugin, $output = null )
	{
		global $_CB_framework, $_PLUGINS;

		$menu							=	array();

		$integrations					=	$_PLUGINS->trigger( 'gallery_onBeforeDisplayFolder', array( &$row, &$menu, $viewer, $gallery, $output ) );

		$cbUser							=	CBuser::getInstance( $row->getInt( 'user_id', 0 ), false );
		$canModerate					=	CBGallery::canModerate( $gallery );
		$owner							=	( $viewer->getInt( 'id', 0 ) === $row->getInt( 'user_id', 0 ) );
		$returnUrl						=	CBGallery::getReturn( true );

		$return							=	'<div class="mb-3 border-bottom galleryFolderHeader">'
										.		implode( '', $integrations )
										.		'<h3 class="d-flex flex-wrap no-gutters m-0 p-0 mb-3">'
										.			'<div class="col-10 col-sm-8">'
										.				( $row->getString( 'title' ) ? htmlspecialchars( $row->getString( 'title' ) ) . ( $row->getInt( 'id', 0 ) !== 0 ? ' <span class="d-none d-sm-inline-block text-small text-muted galleryFolderHeaderDate">' . cbFormatDate( $row->getString( 'date' ), true, 'timeago' ) . '</span>' : null ) : cbFormatDate( $row->getString( 'date' ), true, false, CBTxt::T( 'GALLERY_LONG_DATE_FORMAT', 'F j, Y' ) ) )
										.			'</div>'
										.			'<div class="col-2 col-sm-4 text-normal">'
										.				'<div class="h-100 d-flex align-items-center justify-content-end">'
										.					'<div class="mr-2 d-none d-sm-block galleryFolderHeaderUser">'
										.						$cbUser->getField( 'formatname', null, 'html', 'none', 'list', 0, true )
										.					'</div>'
										.					'<div class="mr-2 d-none d-sm-block galleryFolderHeaderAvatar">'
										.						$cbUser->getField( 'avatar', null, 'html', 'none', 'list', 0, true )
										.					'</div>';

		if ( $canModerate || $owner || $menu ) {
			$menuItems					=	'<ul class="list-unstyled dropdown-menu d-block position-relative m-0 galleryMenuItems">';

			if ( $menu ) {
				$menuItems				.=		'<li class="galleryMenuItem">' . implode( '</li><li class="galleryMenuItem">', $menu ) . '</li>';
			}

			if ( $canModerate || $owner ) {
				$menuItems				.=		'<li class="galleryMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'folder', 'func' => 'edit', 'id' => $row->getInt( 'id', 0 ), 'gallery' => $gallery->id(), 'return' => $returnUrl ) ) . '" class="dropdown-item"><span class="fa fa-edit"></span> ' . CBTxt::T( 'Edit' ) . '</a></li>';

				if ( ( $row->getInt( 'published', 1 ) === -1 ) && $gallery->getBool( 'folders_create_approval', false ) ) {
					if ( $canModerate ) {
						$menuItems		.=		'<li class="galleryMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'folder', 'func' => 'publish', 'id' => $row->getInt( 'id', 0 ), 'gallery' => $gallery->id(), 'return' => $returnUrl ) ) . '" class="dropdown-item"><span class="fa fa-check"></span> ' . CBTxt::T( 'Approve' ) . '</a></li>';
					}
				} elseif ( $row->getInt( 'published', 1 ) > 0 ) {
					$menuItems			.=		'<li class="galleryMenuItem"><a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to unpublish this album?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'folder', 'func' => 'unpublish', 'id' => $row->getInt( 'id', 0 ), 'gallery' => $gallery->id(), 'return' => $returnUrl ) ) ) . '\'; })" class="dropdown-item"><span class="fa fa-times-circle"></span> ' . CBTxt::T( 'Unpublish' ) . '</a></li>';
				} else {
					$menuItems			.=		'<li class="galleryMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'folder', 'func' => 'publish', 'id' => $row->getInt( 'id', 0 ), 'gallery' => $gallery->id(), 'return' => $returnUrl ) ) . '" class="dropdown-item"><span class="fa fa-check"></span> ' . CBTxt::T( 'Publish' ) . '</a></li>';
				}

				$menuItems				.=		'<li class="galleryMenuItem"><a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to delete this album and all its files?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'folder', 'func' => 'delete', 'id' => $row->getInt( 'id', 0 ), 'gallery' => $gallery->id(), 'return' => base64_encode( $gallery->reset()->location() ) ) ) ) . '\'; })" class="dropdown-item"><span class="fa fa-trash-o"></span> ' . CBTxt::T( 'Delete' ) . '</a></li>';
			}

			$menuItems					.=	'</ul>';

			$return						.=					'<div class="galleryFolderHeaderMenu">'
										.						cbTooltip( null, $menuItems, null, 'auto', null, '<span class="pt-1 pb-1 pl-3 pr-3 text-large fa fa-ellipsis-v"></span>', 'javascript:void(0);', 'class="text-body cbDropdownMenu galleryFolderMenu" data-cbtooltip-menu="true" data-cbtooltip-classes="qtip-nostyle" data-cbtooltip-open-classes="active" aria-label="' . htmlspecialchars( CBTxt::T( 'Album Menu' ) ) . '"' )
										.					'</div>';
		}

		$return							.=				'</div>'
										.			'</div>'
										.			( $row->getString( 'description' ) ? '<div class="col-12 mt-1 text-small text-muted galleryFolderHeaderDescription">' . $row->getString( 'description' ) . '</div>' : null )
										.		'</h3>'
										.		implode( '', $_PLUGINS->trigger( 'gallery_onAfterDisplayFolder', array( $row, $viewer, $gallery, $output ) ) )
										.	'</div>';

		return $return;
	}
}