<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Application\Application;
use CBLib\Language\CBTxt;
use CB\Plugin\Gallery\Table\ItemTable;
use CB\Plugin\Gallery\CBGallery;
use CB\Plugin\Gallery\Gallery;
use CB\Plugin\Activity\Table\ActivityTable;
use CB\Plugin\Activity\Table\NotificationTable;
use CB\Plugin\Activity\Table\CommentTable;
use CB\Plugin\Activity\Activity;
use CB\Plugin\Activity\Notifications;
use CB\Plugin\Activity\NotificationsInterface;
use CB\Plugin\Activity\Comments;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_cbgalleryActivity
{

	/**
	 * render frontend gallery activity
	 *
	 * @param ActivityTable|CommentTable|NotificationTable $row
	 * @param null|string                                  $title
	 * @param null|string                                  $date
	 * @param null|string                                  $message
	 * @param null|string                                  $insert
	 * @param null|string                                  $footer
	 * @param array                                        $menu
	 * @param Activity|Comments|Notifications              $stream
	 * @param array                                        $assetMatches
	 * @param ItemTable[]                                  $items
	 * @param Gallery                                      $gallery
	 * @param cbPluginHandler                              $plugin
	 * @param string                                       $output
	 */
	static function showActivity( &$row, &$title, &$date, &$message, &$insert, &$footer, &$menu, $stream, $assetMatches, $items, $gallery, $plugin, $output = null )
	{
		global $_CB_framework;

		static $JS_LOADED				=	0;

		if ( ! $JS_LOADED++ ) {
			$js							=	"$( '.galleryModalToggle' ).cbgallery();"
										.	"$( '.galleryActivityModalToggle' ).on( 'click', function () {"
										.		"$( this ).closest( '.streamItem' ).find( '.galleryModalToggle:first' ).click();"
										.	"});";

			$_CB_framework->outputCbJQuery( $js, 'cbgallery' );
		}

		$notification					=	( $stream instanceof NotificationsInterface );
		$type							=	( isset( $assetMatches[2] ) ? $assetMatches[2] : null );

		// Check if this is a mixed type output:
		if ( $type ) {
			foreach ( $items as $item ) {
				if ( $type !== $item->getString( 'type' ) ) {
					$type				=	'files';
					break;
				}
			}
		} else {
			// There's no title and the media is uploads so lets goahead and set a title:
			foreach ( $items as $item ) {
				if ( ! $type ) {
					$type				=	$item->getString( 'type' );
				} elseif ( $type !== $item->getString( 'type' ) ) {
					$type				=	'files';
					break;
				}
			}
		}

		$typeTranslated					=	CBGallery::translateType( $type, false, true );
		$typeLangKey					=	$type;
		$totalItems						=	count( $items );

		if ( $totalItems > 1 ) {
			$typeTranslated				=	CBTxt::T( 'COUNT_TYPES', '%%COUNT%% [types]', array( '%%COUNT%%' => $totalItems, '[types]' => CBGallery::translateType( $type, true, true ) ) );
		} else {
			switch( $type ) {
				case 'photos':
					$typeLangKey		=	'photo';
					break;
				case 'videos':
					$typeLangKey		=	'video';
					break;
				case 'files':
					$typeLangKey		=	'file';
					break;
			}
		}

		$viewer							=	CBuser::getMyUserDataInstance();
		$typeModal						=	null;
		$titleModal						=	null;
		$folderId						=	null;
		$folder							=	null;
		$owner							=	false;
		$class							=	$plugin->params->getString( 'general_class' );
		$returnUrl						=	base64_encode( $gallery->location() );

		$return							=	'<div class="cbGallery' . ( $class ? ' ' . htmlspecialchars( $class ) : null ) . ( $notification ? ' hidden' : null ) . '">'
										.		'<div class="' . ( $totalItems > 1 ? 'd-flex flex-wrap no-gutters ' : null ) . 'galleryActivity">';

		$i								=	0;

		foreach ( $items as $item ) {
			if ( ! $item->exists() ) {
				continue;
			}

			$data						=	array();

			if ( $totalItems > 1 ) {
				$data['previous']		=	( $i === 0 ? ( $totalItems - 1 ) : ( $i - 1 ) );
				$data['next']			=	( ( $i + 1 ) <= ( $totalItems - 1 )  ? ( $i + 1 ) : 0 );
			}

			$isFileImage				=	( ( $item->getString( 'type' ) === 'files' ) && ( ( $item->extension() === 'svg' ) || ( CBGallery::getExtensionType( $item->extension() ) === 'photos' ) ) );
			$displayPath				=	$_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'item', 'func' => 'display', 'id' => $item->getInt( 'id', 0 ), 'gallery' => $gallery->id(), 'return' => $returnUrl ), 'raw', 0, true );
			$modal						=	cbTooltip( null, null, null, array( '90%', '90%' ), null, null, null, 'data-hascbtooltip="true" data-cbtooltip-modal="true" data-cbtooltip-open-solo=".galleryModal" data-cbtooltip-classes="galleryModal" data-cbtooltip-content-classes="p-0" data-cbtooltip-button-close="false" data-cbgallery-url="' . $displayPath . '" data-cbgallery-request="' . htmlspecialchars( json_encode( $data ) ) . '"' );

			if ( ( ( $totalItems > 1 ) || ( ( ( $item->getString( 'type' ) === 'photos' ) || $isFileImage ) && ( ! $notification ) ) ) ) {
				if ( ! $typeModal ) {
					$typeModal			=	'<a href="javascript: void(0);" class="galleryActivityModalToggle">' . $typeTranslated . '</a>';
				}

				if ( ! $titleModal ) {
					$titleModal			=	'<a href="javascript: void(0);" class="galleryActivityModalToggle">' . ( $item->getString( 'title' ) ? $item->getString( 'title' ) : $item->name() ) . '</a>';
				}
			} else {
				if ( ! $typeModal ) {
					$typeModal			=	'<a href="javascript: void(0);" class="galleryItemName galleryModalToggle"' . $modal . '>' . $typeTranslated . '</a>';
				}

				if ( ! $titleModal ) {
					$titleModal			=	'<a href="javascript: void(0);" class="galleryItemName galleryModalToggle"' . $modal . '>' . ( $item->getString( 'title' ) ? $item->getString( 'title' ) : $item->name() ) . '</a>';
				}
			}

			if ( ! $owner ) {
				$owner					=	( $viewer->getInt( 'id', 0 ) === $item->getInt( 'user_id', 0 ) );
			}

			$itemFolderId				=	$item->getInt( 'folder', 0 );

			if ( $folderId !== null ) {
				if ( $itemFolderId !== $folderId ) {
					$folderId		=	0;
					$folder			=	null;
				}
			} elseif ( $itemFolderId > 0 ) {
				$itemFolder			=	$item->folder( $gallery );

				if ( $itemFolder->getInt( 'id', 0 ) && ( ( $itemFolder->getInt( 'published', 1 ) ) || ( ( Application::MyUser()->getUserId() === $itemFolder->getInt( 'user_id', 0 ) ) || CBGallery::canModerate( $gallery ) ) ) ) {
					$folderId		=	$itemFolderId;

					$folder			=	'<a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'folder', 'func' => 'show', 'id' => $itemFolder->getInt( 'id', 0 ), 'gallery' => $gallery->id(), 'return' => $returnUrl ) ) . '">'
									.		( $itemFolder->getString( 'title' ) ? $itemFolder->getString( 'title' ) : cbFormatDate( $itemFolder->getString( 'date' ), true, false, CBTxt::T( 'GALLERY_SHORT_DATE_FORMAT', 'M j, Y' ) ) )
									.	'</a>';
				} else {
					$folderId		=	0;
					$folder			=	null;
				}
			} else {
				$folderId			=	0;
				$folder				=	null;
			}

			if ( ( ! $message ) && ( $totalItems === 1 ) ) {
				$message				=	( $item->getString( 'description' ) ? $item->getString( 'description' ) : null );
			}

			$itemId						=	md5( $gallery->id() . '_' . $item->getInt( 'id', 0 ) );

			if ( $totalItems === 1 ) {
				if ( ( $item->getString( 'type' ) === 'photos' ) || $isFileImage ) {
					$return				.=			'<a href="javascript: void(0);" class="galleryItemEmbed galleryModalToggle"' . $modal . '>'
										.				HTML_cbgalleryEmbed::showEmbed( $item, $viewer, $gallery, $plugin, true )
										.			'</a>';
				} else {
					$return				.=			HTML_cbgalleryEmbed::showEmbed( $item, $viewer, $gallery, $plugin );
				}
			} else {
				$embed					=	$item->thumbnail( $gallery );
				$solid					=	( ( ! in_array( $item->getString( 'type' ), array( 'photos', 'videos' ), true ) ) && ( ! $isFileImage ) && ( ! $item->getString( 'thumbnail' ) ) );

				if ( ( $i === 5 ) && ( $totalItems > 6 ) ) {
					$embed				.=	'<div class="position-absolute d-flex h-100 w-100 justify-content-center align-items-center bg-dark galleryContainerMore">'
										.		'<span class="display-4 align-middle text-white galleryImageIcon">+' . ( $totalItems - 5 ) . '</span>'
										.	'</div>';

					$solid				=	false;
				}

				$return					.=			'<div class="position-relative col-6 col-sm-4 galleryItemContainer galleryContainer galleryContainer' . htmlspecialchars( ucfirst( $item->getString( 'type' ) ) ) . ( $i === 0 ? ' galleryContainerFirst' : null ) . ' galleryContainer' . $itemId . ( $solid ? ' galleryContainerSolid' : null ) . ( $i > 5 ? ' hidden' : null ) . '">'
										.				'<div class="card position-absolute w-100 h-100 no-overflow rounded-0 cbCanvasLayout cbCanvasLayoutHover">'
										.					'<div class="card-header rounded-0 p-0 border-0 w-100 h-100 cbCanvasLayoutTop">'
										.						'<a href="javascript: void(0);" class="d-flex h-100 w-100 justify-content-center align-items-center galleryItemEmbed galleryModalToggle"' . $modal . '>' . $embed . '</a>'
										.					'</div>';

				if ( $solid ) {
					$itemTitle			=	( $item->getString( 'title' ) ? $item->getString( 'title' ) : $item->name() );

					$return				.=					'<div class="position-absolute card-footer rounded-0 p-1 bg-white cbCanvasLayoutFooter">'
										.						'<div class="text-truncate cbCanvasLayoutContent">'
										.							'<a href="javascript: void(0);" class="galleryItemName galleryModalToggle"' . $modal . '>' . $itemTitle . '</a>'
										.						'</div>'
										.					'</div>';
				}

				$return					.=				'</div>'
										.			'</div>';
			}

			$i++;
		}

		$return							.=		'</div>'
										.	'</div>';

		if ( ! ( isset( $assetMatches[2] ) ? $assetMatches[2] : null ) ) {
			// Don't append the folder link when it's just to the Uploads folder:
			$folder						=	0;
		}

		$action							=	( isset( $assetMatches[4] ) ? $assetMatches[4] : '' );

		if ( $notification ) {
			$row->set( 'link', '.galleryModalToggle:first' );
		}

		if ( ! $type ) {
			if ( ( ! $notification ) || ( $totalItems > 1 ) ) {
				$insert					.=	$return;
			}
		} elseif ( ( $notification && ( $action || $row->getInt( '_notification_id', 0 ) ) ) || $action ) {
			switch ( $action ) {
				case 'like':
					if ( $owner ) {
						if ( $folder ) {
							// CBTxt::T( 'LIKED_YOUR_TYPE_TITLE_IN_ALBUM', 'liked your [type] [title] in album [album]', array( '[type]' => $typeTranslated, '[title]' => $titleModal, '[album]' => $folder ) )
							$title		=	CBTxt::T( 'LIKED_YOUR_' . strtoupper( $typeLangKey ) . '_TITLE_IN_ALBUM LIKED_YOUR_TYPE_TITLE_IN_ALBUM', 'liked your [type] [title] in album [album]', array( '[type]' => $typeTranslated, '[title]' => $titleModal, '[album]' => $folder ) );
						} else {
							// CBTxt::T( 'LIKED_YOUR_TYPE_TITLE', 'liked your [type] [title]', array( '[type]' => $typeTranslated, '[title]' => $titleModal ) )
							$title		=	CBTxt::T( 'LIKED_YOUR_' . strtoupper( $typeLangKey ) . '_TITLE LIKED_YOUR_TYPE_TITLE', 'liked your [type] [title]', array( '[type]' => $typeTranslated, '[title]' => $titleModal ) );
						}
					} else {
						if ( $folder ) {
							// CBTxt::T( 'LIKED_TYPE_TITLE_IN_ALBUM', 'liked [type] [title] in album [album]', array( '[type]' => $typeTranslated, '[title]' => $titleModal, '[album]' => $folder ) )
							$title		=	CBTxt::T( 'LIKED_' . strtoupper( $typeLangKey ) . '_TITLE_IN_ALBUM LIKED_TYPE_TITLE_IN_ALBUM', 'liked [type] [title] in album [album]', array( '[type]' => $typeTranslated, '[title]' => $titleModal, '[album]' => $folder ) );
						} else {
							// CBTxt::T( 'LIKED_TYPE_TITLE', 'liked [type] [title]', array( '[type]' => $typeTranslated, '[title]' => $titleModal ) )
							$title		=	CBTxt::T( 'LIKED_' . strtoupper( $typeLangKey ) . '_TITLE LIKED_TYPE_TITLE', 'liked [type] [title]', array( '[type]' => $typeTranslated, '[title]' => $titleModal ) );
						}
					}
					break;
				case 'tag':
					if ( ! $owner ) {
						if ( $folder ) {
							// CBTxt::T( 'TAGGED_YOU_IN_TYPE_TITLE_IN_ALBUM', 'tagged you in [type] [title] in album [album]', array( '[type]' => $typeTranslated, '[title]' => $titleModal, '[album]' => $folder ) )
							$title		=	CBTxt::T( 'TAGGED_YOU_IN_' . strtoupper( $typeLangKey ) . '_TITLE_IN_ALBUM TAGGED_YOU_IN_TYPE_TITLE_IN_ALBUM', 'tagged you in [type] [title] in album [album]', array( '[type]' => $typeTranslated, '[title]' => $titleModal, '[album]' => $folder ) );
						} else {
							// CBTxt::T( 'TAGGED_YOU_IN_TYPE_TITLE', 'tagged you in [type] [title]', array( '[type]' => $typeTranslated, '[title]' => $titleModal ) )
							$title		=	CBTxt::T( 'TAGGED_YOU_IN_' . strtoupper( $typeLangKey ) . '_TITLE TAGGED_YOU_IN_TYPE_TITLE', 'tagged you in [type] [title]', array( '[type]' => $typeTranslated, '[title]' => $titleModal ) );
						}
					} else {
						if ( $folder ) {
							// CBTxt::T( 'TAGGED_IN_TYPE_TITLE_IN_ALBUM', 'tagged in [type] [title] in album [album]', array( '[type]' => $typeTranslated, '[title]' => $titleModal, '[album]' => $folder ) )
							$title		=	CBTxt::T( 'TAGGED_IN_' . strtoupper( $typeLangKey ) . '_TITLE_IN_ALBUM TAGGED_IN_TYPE_TITLE_IN_ALBUM', 'tagged in [type] [title] in album [album]', array( '[type]' => $typeTranslated, '[title]' => $titleModal, '[album]' => $folder ) );
						} else {
							// CBTxt::T( 'TAGGED_IN_TYPE_TITLE', 'tagged in [type] [title]', array( '[type]' => $typeTranslated, '[title]' => $titleModal ) )
							$title		=	CBTxt::T( 'TAGGED_IN_' . strtoupper( $typeLangKey ) . '_TITLE TAGGED_IN_TYPE_TITLE', 'tagged in [type] [title]', array( '[type]' => $typeTranslated, '[title]' => $titleModal ) );
						}
					}
					break;
				case 'comment':
					if ( $owner ) {
						if ( $folder ) {
							// CBTxt::T( 'COMMENTED_ON_YOUR_TYPE_TITLE_IN_ALBUM', 'commented on your [type] [title] in album [album]', array( '[type]' => $typeTranslated, '[title]' => $titleModal, '[album]' => $folder ) )
							$title		=	CBTxt::T( 'COMMENTED_ON_YOUR_' . strtoupper( $typeLangKey ) . '_TITLE_IN_ALBUM COMMENTED_ON_YOUR_TYPE_TITLE_IN_ALBUM', 'commented on your [type] [title] in album [album]', array( '[type]' => $typeTranslated, '[title]' => $titleModal, '[album]' => $folder ) );
						} else {
							// CBTxt::T( 'COMMENTED_ON_YOUR_TYPE_TITLE', 'commented on your [type] [title]', array( '[type]' => $typeTranslated, '[title]' => $titleModal ) )
							$title		=	CBTxt::T( 'COMMENTED_ON_YOUR_' . strtoupper( $typeLangKey ) . '_TITLE COMMENTED_ON_YOUR_TYPE_TITLE', 'commented on your [type] [title]', array( '[type]' => $typeTranslated, '[title]' => $titleModal ) );
						}
					} else {
						if ( $folder ) {
							// CBTxt::T( 'COMMENTED_ON_TYPE_TITLE_IN_ALBUM', 'commented on [type] [title] in album [album]', array( '[type]' => $typeTranslated, '[title]' => $titleModal, '[album]' => $folder ) )
							$title		=	CBTxt::T( 'COMMENTED_ON_' . strtoupper( $typeLangKey ) . '_TITLE_IN_ALBUM COMMENTED_ON_TYPE_TITLE_IN_ALBUM', 'commented on [type] [title] in album [album]', array( '[type]' => $typeTranslated, '[title]' => $titleModal, '[album]' => $folder ) );
						} else {
							// CBTxt::T( 'COMMENTED_ON_TYPE_TITLE', 'commented on [type] [title]', array( '[type]' => $typeTranslated, '[title]' => $titleModal ) )
							$title		=	CBTxt::T( 'COMMENTED_ON_' . strtoupper( $typeLangKey ) . '_TITLE COMMENTED_ON_TYPE_TITLE', 'commented on [type] [title]', array( '[type]' => $typeTranslated, '[title]' => $titleModal ) );
						}
					}
					break;
				default:
					if ( $notification && $row->getInt( '_notification_id', 0 ) ) {
						// Generic Activity or Comment notification title handling:
						if ( $owner ) {
							if ( $folder ) {
								// CBTxt::T( 'ABOUT_YOUR_TYPE_TITLE_IN_ALBUM', 'about your [type] [title] in album [album]', array( '[type]' => $typeTranslated, '[title]' => $titleModal, '[album]' => $folder ) )
								$title	=	CBTxt::T( 'ABOUT_YOUR_' . strtoupper( $typeLangKey ) . '_TITLE_IN_ALBUM ABOUT_YOUR_TYPE_TITLE_IN_ALBUM', 'about your [type] [title] in album [album]', array( '[type]' => $typeTranslated, '[title]' => $titleModal, '[album]' => $folder ) );
							} else {
								// CBTxt::T( 'ABOUT_YOUR_TYPE_TITLE', 'about your [type] [title]', array( '[type]' => $typeTranslated, '[title]' => $titleModal ) )
								$title	=	CBTxt::T( 'ABOUT_YOUR_' . strtoupper( $typeLangKey ) . '_TITLE ABOUT_YOUR_TYPE_TITLE', 'about your [type] [title]', array( '[type]' => $typeTranslated, '[title]' => $titleModal ) );
							}
						} else {
							if ( $folder ) {
								// CBTxt::T( 'ABOUT_TYPE_TITLE_IN_ALBUM', 'about [type] [title] in album [album]', array( '[type]' => $typeTranslated, '[title]' => $titleModal, '[album]' => $folder ) )
								$title	=	CBTxt::T( 'ABOUT_' . strtoupper( $typeLangKey ) . '_TITLE_IN_ALBUM ABOUT_TYPE_TITLE_IN_ALBUM', 'about [type] [title] in album [album]', array( '[type]' => $typeTranslated, '[title]' => $titleModal, '[album]' => $folder ) );
							} else {
								// CBTxt::T( 'ABOUT_TYPE_TITLE', 'about [type] [title]', array( '[type]' => $typeTranslated, '[title]' => $titleModal ) )
								$title	=	CBTxt::T( 'ABOUT_' . strtoupper( $typeLangKey ) . '_TITLE ABOUT_TYPE_TITLE', 'about [type] [title]', array( '[type]' => $typeTranslated, '[title]' => $titleModal ) );
							}
						}
					}
					break;
			}

			if ( ( ! $notification ) || ( $totalItems > 1 ) ) {
				$insert					=	$return;
			}
		} else {
			if ( $folder ) {
				if ( $totalItems > 1 ) {
					// CBTxt::T( 'SHARED_COUNT_TYPES_IN_ALBUM', 'shared [types] in album [album]', array( '[types]' => $typeModal, '[album]' => $folder ) )
					$title				=	CBTxt::T( 'SHARED_COUNT_' . strtoupper( $typeLangKey ) . '_IN_ALBUM SHARED_COUNT_TYPES_IN_ALBUM', 'shared [types] in album [album]', array( '[types]' => $typeModal, '[album]' => $folder ) );
				} elseif ( $notification ) {
					// CBTxt::T( 'SHARED_TYPE_TITLE_IN_ALBUM', 'shared [type] [title] in album [album]', array( '[type]' => $typeTranslated, '[title]' => $titleModal, '[album]' => $folder ) )
					$title				=	CBTxt::T( 'SHARED_' . strtoupper( $typeLangKey ) . '_TITLE_IN_ALBUM SHARED_TYPE_TITLE_IN_ALBUM', 'shared [type] [title] in album [album]', array( '[type]' => $typeTranslated, '[title]' => $titleModal, '[album]' => $folder ) );
				} elseif ( $type !== 'music' ) {
					// CBTxt::T( 'SHARED_A_TYPE_IN_ALBUM', 'shared a [type] in album [album]', array( '[type]' => $typeModal, '[album]' => $folder ) )
					$title				=	CBTxt::T( 'SHARED_A_' . strtoupper( $typeLangKey ) . '_IN_ALBUM SHARED_A_TYPE_IN_ALBUM', 'shared a [type] in album [album]', array( '[type]' => $typeModal, '[album]' => $folder ) );
				} else {
					// CBTxt::T( 'SHARED_TYPE_IN_ALBUM', 'shared [type] in album [album]', array( '[type]' => $typeModal, '[album]' => $folder ) )
					$title				=	CBTxt::T( 'SHARED_' . strtoupper( $typeLangKey ) . '_IN_ALBUMS HARED_TYPE_IN_ALBUM', 'shared [type] in album [album]', array( '[type]' => $typeModal, '[album]' => $folder ) );
				}
			} else {
				if ( $totalItems > 1 ) {
					// CBTxt::T( 'SHARED_COUNT_TYPES', 'shared [types]', array( '[types]' => $typeModal ) )
					$title				=	CBTxt::T( 'SHARED_COUNT_' . strtoupper( $typeLangKey ) . ' SHARED_COUNT_TYPES', 'shared [types]', array( '[types]' => $typeModal ) );
				} elseif ( $notification ) {
					// CBTxt::T( 'SHARED_TYPE_TITLE', 'shared [type] [title]', array( '[type]' => $typeTranslated, '[title]' => $titleModal ) )
					$title				=	CBTxt::T( 'SHARED_' . strtoupper( $typeLangKey ) . '_TITLE SHARED_TYPE_TITLE', 'shared [type] [title]', array( '[type]' => $typeTranslated, '[title]' => $titleModal ) );
				} elseif ( $type !== 'music' ) {
					// CBTxt::T( 'SHARED_A_TYPE', 'shared a [type]', array( '[type]' => $typeModal ) )
					$title				=	CBTxt::T( 'SHARED_A_' . strtoupper( $typeLangKey ) . ' SHARED_A_TYPE', 'shared a [type]', array( '[type]' => $typeModal ) );
				} else {
					// CBTxt::T( 'SHARED_TYPE', 'shared [type]', array( '[type]' => $typeModal ) )
					$title				=	CBTxt::T( 'SHARED_' . strtoupper( $typeLangKey ) . ' SHARED_TYPE', 'shared [type]', array( '[type]' => $typeModal ) );
				}
			}

			if ( ( ! $notification ) || ( $totalItems > 1 ) ) {
				$insert					=	$return;
			}
		}
	}
}