<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;
use CB\Plugin\GroupJive\Table\GroupTable;
use CB\Plugin\GroupJivePhoto\Table\PhotoTable;
use CB\Plugin\GroupJive\CBGroupJive;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_groupjivePhoto
{

	/**
	 * render frontend photos
	 *
	 * @param PhotoTable[]    $rows
	 * @param cbPageNav       $pageNav
	 * @param bool            $searching
	 * @param array           $input
	 * @param array           $counters
	 * @param GroupTable      $group
	 * @param UserTable       $user
	 * @param cbPluginHandler $plugin
	 * @return string
	 */
	public static function showPhotos( $rows, $pageNav, $searching, $input, &$counters, $group, $user, $plugin )
	{
		global $_CB_framework, $_PLUGINS;

		$js									=	"$( document ).on( 'click', '.gjGroupPhotoModalScrollLeft', function( e ) {"
											.		"var previous = $( this ).find( '.gjGroupPhotoModalScrollLeftIcon' ).data( 'previous-photo' );"
											.		"if ( previous ) {"
											.			"$( previous ).find( '.gjGroupPhotoItem' ).click();"
											.			"e.preventDefault();"
											.		"}"
											.	"});"
											.	"$( document ).on( 'click', '.gjGroupPhotoModalScrollRight', function( e ) {"
											.		"var next = $( this ).find( '.gjGroupPhotoModalScrollRightIcon' ).data( 'next-photo' );"
											.		"if ( next ) {"
											.			"$( next ).find( '.gjGroupPhotoItem' ).click();"
											.			"e.preventDefault();"
											.		"}"
											.	"});"
											.	"$( '.gjGroupPhotoItem.cbTooltip,.gjGroupPhotoLogo.cbTooltip' ).on( 'cbtooltip.render', function( e, cbtooltip, event, api ) {"
											.		"$( api.elements.content ).find( '.cbDateTimeago' ).cbtimeago();"
											.	"});";

		$_CB_framework->outputCbJQuery( $js );

		if ( $pageNav->total ) {
			$counters[]						=	'<span class="fa-before fa-photo gjGroupPhotoIcon"> ' . CBTxt::T( 'GROUP_PHOTOS_COUNT', '%%COUNT%% Photo|%%COUNT%% Photos', array( '%%COUNT%%' => (int) $pageNav->total ) ) . '</span>';
		}

		initToolTip();

		$isModerator						=	CBGroupJive::isModerator( $user->getInt( 'id', 0 ) );
		$isOwner							=	( $user->getInt( 'id', 0 ) === $group->getInt( 'user_id', 0 ) );
		$userStatus							=	CBGroupJive::getGroupStatus( $user, $group );
		$canCreate							=	CBGroupJive::canCreateGroupContent( $user, $group, 'photo' );
		$canSearch							=	( $plugin->params->getInt( 'groups_photo_search', 1 ) && ( $searching || $pageNav->total ) );
		$return								=	null;

		$_PLUGINS->trigger( 'gj_onBeforeDisplayPhotos', array( &$return, &$rows, $group, $user ) );

		$return								.=	'<div class="gjGroupPhoto">';

		if ( $canCreate || $canSearch ) {
			$return							.=		'<div class="row no-gutters mb-3 gjHeader gjGroupPhotoHeader">';

			if ( $canCreate ) {
				$return						.=			'<div class="col-12 ' . ( $canSearch ? 'col-sm-6 mb-2 mb-sm-0' : null ) . '">'
											.				'<a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'photo', 'func' => 'new', 'group' => $group->getInt( 'id', 0 ) ) ) . '" class="btn btn-success btn-sm-block gjButton gjButtonNewPhoto "><span class="fa fa-plus-circle"></span> ' . CBTxt::T( 'Upload New Photo' ) . '</a>'
											.			'</div>';
			}

			if ( $canSearch ) {
				$return						.=			'<div class="col-12 ' . ( ! $canCreate ? 'offset-sm-6 ' : null ) . 'col-sm-6 text-sm-right">'
											.				'<form action="' . $_CB_framework->pluginClassUrl( 'cbgroupjive', true, array( 'action' => 'groups', 'func' => 'show', 'id' => $group->getInt( 'id', 0 ) ) ) . '" method="post" name="gjGroupPhotoSearchForm" class="m-0 gjGroupPhotoSearchForm">'
											.					'<div class="input-group">'
											.						$input['search']
											.						'<div class="input-group-append">'
											.							'<button type="submit" class="btn btn-light border" aria-label="' . htmlspecialchars( CBTxt::T( 'Search' ) ) . '"><span class="fa fa-search"></span></button>'
											.						'</div>'
											.					'</div>'
											.				'</form>'
											.			'</div>';
			}

			$return							.=		'</div>';
		}

		if ( $rows ) {
			$return							.=		'<div class="row no-gutters gjGroupPhotoRows">';

			$i								=	0;

			foreach ( $rows as $row ) {
				$cbUser						=	CBuser::getInstance( $row->getInt( 'user_id', 0 ), false );
				$rowOwner					=	( $user->getInt( 'id', 0 ) === $row->getInt( 'user_id', 0 ) );
				$isModOrOwner				=	( $isModerator || $isOwner || $rowOwner || ( $userStatus >= 2 ) );
				$rowCounters				=	array();
				$content					=	null;
				$menu						=	array();

				$_PLUGINS->trigger( 'gj_onDisplayPhoto', array( &$row, &$rowCounters, &$content, &$menu, $group, $user ) );

				$title						=	( $row->getString( 'title' ) ? htmlspecialchars( $row->getString( 'title' ) ) : $row->name() );
				$item						=	$title;
				$logo						=	null;

				if ( $row->exists() ) {
					$showPath				=	$_CB_framework->pluginClassUrl( $plugin->element, false, array( 'action' => 'photo', 'func' => 'show', 'id' => $row->getInt( 'id', 0 ) ), 'raw', 0, true );

					$image					=	'<div class="row no-gutters h-100 w-100 bg-dark border border-dark rounded auto-overflow gjGroupPhotoModalContainer">'
											.		'<div class="row no-gutters col-sm-7 col-md-8 col-lg-9 h-100 gjGroupPhotoModalImage">';

					if ( $pageNav->total > 1 ) {
						$image				.=			'<div class="d-flex flex-column justify-content-center h-100 p-2 text-white text-large gjGroupPhotoModalScrollLeft">'
											.				'<span class="fa fa-chevron-left gjGroupPhotoModalScrollLeftIcon" data-previous-photo=".gjGroupPhotoRow' . ( $i === 0 ? ( count( $rows ) - 1 ) : ( $i - 1 ) ) . '"></span>'
											.			'</div>';
					}

					$image					.=			'<div class="d-flex flex-column col justify-content-center align-items-center h-100 p-2 no-overflow gjGroupPhotoImage">'
											.				'<img alt="' . htmlspecialchars( $title ) . '" src="' . htmlspecialchars( $showPath ) . '" class="mh-100 mw-100 cbImgPict cbFullPict" />'
											.			'</div>';

					if ( $pageNav->total > 1 ) {
						$image				.=			'<div class="d-flex flex-column justify-content-center h-100 p-2 text-white text-large text-right gjGroupPhotoModalScrollRight">'
											.				'<span class="fa fa-chevron-right gjGroupPhotoModalScrollRightIcon" data-next-photo=".gjGroupPhotoRow' . ( isset( $rows[$i+1] ) ? ( $i + 1 ) : 0 ) . '"></span>'
											.			'</div>';
					}

					$image					.=			'<div class="position-absolute p-2 gjGroupPhotoModalClose">'
											.				'<span class="fa fa-times text-large text-white cbTooltipClose"></span>'
											.			'</div>'
											.		'</div>'
											.		'<div class="d-flex flex-column col-sm-5 col-md-4 col-lg-3 h-100 mh-100 bg-white border-left gjGroupPhotoModalDetails">'
											.			'<div class="p-2 gjGroupPhotoModalHeader">'
											.				'<div class="media">'
											.					'<div class="media-left gjGroupPhotoModalHeaderAvatar">'
											.						$cbUser->getField( 'avatar', null, 'html', 'none', 'list', 0, true )
											.					'</div>'
											.					'<div class="pl-2 pr-4 media-body gjGroupPhotoModalHeaderBody">'
											.						'<div class="text-wrap text-normal gjGroupPhotoModalHeaderAuthor">'
											.							'<strong>' . $cbUser->getField( 'formatname', null, 'html', 'none', 'list', 0, true ) . '</strong>'
											.						'</div>'
											.						'<div class="text-muted text-small gjGroupPhotoModalHeaderDate">'
											.							cbFormatDate( $row->getString( 'date' ), true, 'timeago' )
											.						'</div>'
											.					'</div>'
											.				'</div>'
											.			'</div>';

					if ( $row->getString( 'description' ) ) {
						$image				.=			'<div class="p-2 text-wrap text-small gjGroupPhotoModalDescription">'
											.				htmlspecialchars( $row->getString( 'description' ) )
											.			'</div>';
					}

					$image					.=		'</div>'
											.	'</div>';

					if ( $row->height( true ) > $row->width( true ) ) {
						$orientation		=	' mw-100 mh-none';
					} elseif ( $row->width( true ) > $row->height( true ) ) {
						$orientation		=	' mh-100 mw-none';
					} else {
						$orientation		=	' mh-100 mw-100';
					}

					$item					=	cbTooltip( null, $image, null, array( '90%', '90%' ), null, $item, 'javascript: void(0);', 'class="gjGroupPhotoItem" data-cbtooltip-modal="true" data-cbtooltip-open-solo=".gjGroupPhotoModal" data-cbtooltip-classes="gjGroupPhotoModal" data-cbtooltip-content-classes="p-0" data-cbtooltip-button-close="false"' );
					$logo					=	cbTooltip( null, $image, null, array( '90%', '90%' ), null, '<img alt="' . htmlspecialchars( $title ) . '" src="' . htmlspecialchars( $_CB_framework->pluginClassUrl( $plugin->element, false, array( 'action' => 'photo', 'func' => 'preview', 'id' => $row->getInt( 'id', 0 ) ), 'raw', 0, true ) ) . '" class="flex-auto' . $orientation . ' cbImgPict cbThumbPict" />', 'javascript: void(0);', 'class="d-flex h-100 w-100 justify-content-center align-items-center gjGroupPhotoLogo" data-cbtooltip-modal="true" data-cbtooltip-classes="gjGroupPhotoModal" data-cbtooltip-content-classes="bg-dark p-0" data-cbtooltip-button-close="false"' );
				}

				$buttons					=	array();
				$hoverMenu					=	true;

				if ( ( $isModerator || $isOwner || ( $userStatus >= 2 ) ) && ( $row->getInt( 'published', 0 ) === -1 ) && ( $group->params()->getInt( 'photo', 1 ) === 2 ) ) {
					$hoverMenu				=	false;

					$buttons[]				=	'<a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'photo', 'func' => 'publish', 'id' => $row->getInt( 'id', 0 ) ) ) . '" class="btn btn-sm btn-success gjButton gjButtonApprove">' . CBTxt::T( 'Approve Photo' ) . '</a>';
				}

				if ( $isModOrOwner || $menu ) {
					$menuItems				=	'<ul class="list-unstyled dropdown-menu d-block position-relative m-0 gjMenuItems gjGroupPhotoMenuItems">';

					if ( $isModOrOwner ) {
						$menuItems			.=		'<li class="gjMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'photo', 'func' => 'edit', 'id' => $row->getInt( 'id', 0 ) ) ) . '" class="dropdown-item"><span class="fa fa-edit"></span> ' . CBTxt::T( 'Edit' ) . '</a></li>';

						if ( ( $row->getInt( 'published', 0 ) === -1 ) && ( $group->params()->getInt( 'photo', 1 ) === 2 ) ) {
							if ( $isModerator || $isOwner || ( $userStatus >= 2 ) ) {
								$menuItems	.=		'<li class="gjMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'photo', 'func' => 'publish', 'id' => $row->getInt( 'id', 0 ) ) ) . '" class="dropdown-item"><span class="fa fa-check"></span> ' . CBTxt::T( 'Approve' ) . '</a></li>';
							}
						} elseif ( $row->getInt( 'published', 0 ) === 1 ) {
							$menuItems		.=		'<li class="gjMenuItem"><a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to unpublish this Photo?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'photo', 'func' => 'unpublish', 'id' => $row->getInt( 'id', 0 ) ) ) ) . '\'; })" class="dropdown-item"><span class="fa fa-times-circle"></span> ' . CBTxt::T( 'Unpublish' ) . '</a></li>';
						} else {
							$menuItems		.=		'<li class="gjMenuItem"><a href="' . $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'photo', 'func' => 'publish', 'id' => $row->getInt( 'id', 0 ) ) ) . '" class="dropdown-item"><span class="fa fa-check"></span> ' . CBTxt::T( 'Publish' ) . '</a></li>';
						}
					}

					if ( $menu ) {
						$menuItems			.=		'<li class="gjMenuItem">' . implode( '</li><li class="gjMenuItem">', $menu ) . '</li>';
					}

					if ( $isModOrOwner ) {
						$menuItems			.=		'<li class="gjMenuItem"><a href="javascript: void(0);" onclick="cbjQuery.cbconfirm( \'' . addslashes( CBTxt::T( 'Are you sure you want to delete this Photo?' ) ) . '\' ).done( function() { window.location.href = \'' . addslashes( $_CB_framework->pluginClassUrl( $plugin->element, true, array( 'action' => 'photo', 'func' => 'delete', 'id' => $row->getInt( 'id', 0 ) ) ) ) . '\'; })" class="dropdown-item"><span class="fa fa-trash-o"></span> ' . CBTxt::T( 'Delete' ) . '</a></li>';
					}

					$menuItems				.=	'</ul>';

					$menuAttr				=	cbTooltip( null, $menuItems, null, 'auto', null, null, null, 'class="border btn btn-light btn-sm cbCanvasLayoutMenu' . ( $hoverMenu ? ' cbCanvasLayoutHoverMenu' : null ) . ' gjGroupPhotoMenu" data-cbtooltip-menu="true" data-cbtooltip-classes="qtip-nostyle" data-cbtooltip-open-classes="active"' );

					$buttons[]				=	'<button type="button" ' . trim( $menuAttr ) . '><span class="pl-2 pr-2 align-bottom text-large fa fa-ellipsis-v"></span></button>';
				}

				$return						.=			'<div class="position-relative col-6 col-sm-4 col-lg-3 gjGroupPhotoRow gjGroupPhotoRow' . $i . '">'
											.				'<div class="card position-absolute w-100 h-100 no-overflow rounded-0 cbCanvasLayout cbCanvasLayoutHover">'
											.					'<div class="card-header rounded-0 p-0 border-0 w-100 h-100 cbCanvasLayoutTop">'
											.						$logo;

				if ( $buttons ) {
					$return					.=						'<div class="position-absolute text-right p-1 cbCanvasLayoutActions">'
											.							implode( ' ', $buttons )
											.						'</div>';
				}

				$return						.=					'</div>'
											.					'<div class="position-absolute card-footer rounded-0 p-1 bg-white cbCanvasLayoutHoverShow cbCanvasLayoutFooter">'
											.						'<div class="text-truncate cbCanvasLayoutContent">';

				if ( $isModOrOwner && ( ( $row->getInt( 'published', 0 ) === -1 ) && ( $group->params()->getInt( 'photo', 1 ) === 2 ) ) ) {
					$return					.=							'<span class="fa fa-clock-o text-warning gjGroupPhotoIconPending" title="' . htmlspecialchars( CBTxt::T( 'Awaiting Approval' ) ) . '"></span> ';
				}

				$return						.=							$item
											.						'</div>'
											.						'<div class="text-small text-muted row no-gutters cbCanvasLayoutContent">'
											.							'<div class="text-truncate col-sm-6 cbCanvasLayoutContent gjGroupPhotoPublisher">' . $cbUser->getField( 'formatname', null, 'html', 'none', 'list', 0, true ) . '</div>'
											.							'<div class="text-truncate col-sm-6 text-sm-right cbCanvasLayoutContent gjGroupPhotoDate">'
											.								'<span title="' . htmlspecialchars( $row->getString( 'date' ) ) . '">'
											.									cbFormatDate( $row->getString( 'date' ), true, false, CBTxt::T( 'GROUP_PHOTO_DATE_FORMAT', 'M j, Y' ) )
											.								'</span>'
											.							'</div>'
											.							( $rowCounters ? '<div class="text-truncate col-sm-6 cbCanvasLayoutContent">' . implode( '</div><div class="text-truncate col-sm-6 cbCanvasLayoutContent">', $rowCounters ) . '</div>' : null )
											.						'</div>'
											.						( $content ? '<div class="cbCanvasLayoutContent gjGroupPhotoIntegrations">' . $content . '</div>' : null )
											.					'</div>'
											.				'</div>'
											.			'</div>';

				$i++;
			}

			$return							.=		'</div>';

			if ( $plugin->params->getInt( 'groups_photo_paging', 1 ) && ( $pageNav->total > $pageNav->limit ) ) {
				$return						.=		'<div class="mt-3 gjGroupPhotoPaging">'
											.			$pageNav->getListLinks()
											.		'</div>';
			}
		} else {
			$return							.=		'<div class="gjGroupPhotoEmpty">';

			if ( $searching ) {
				$return						.=			CBTxt::T( 'No group photo search results found.' );
			} else {
				$return						.=			CBTxt::T( 'This group currently has no photos.' );
			}

			$return							.=		'</div>';
		}

		$return								.=	'</div>';

		$_PLUGINS->trigger( 'gj_onAfterDisplayPhotos', array( &$return, $rows, $group, $user ) );

		return $return;
	}
}