<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Language\CBTxt;
use CB\Plugin\GroupJive\CBGroupJive;
use CB\Plugin\GroupJivePhoto\Table\PhotoTable;
use CB\Plugin\Activity\Table\ActivityTable;
use CB\Plugin\Activity\Table\NotificationTable;
use CB\Plugin\Activity\Activity;
use CB\Plugin\Activity\Notifications;
use CB\Plugin\Activity\NotificationsInterface;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class HTML_groupjivePhotoActivity
{

	/**
	 * render frontend photo activity
	 *
	 * @param ActivityTable|NotificationTable $row
	 * @param null|string                     $title
	 * @param null|string                     $date
	 * @param null|string                     $message
	 * @param null|string                     $insert
	 * @param null|string                     $footer
	 * @param array                           $menu
	 * @param Activity|Notifications          $stream
	 * @param array                           $assetMatches
	 * @param PhotoTable                      $photo
	 * @param cbPluginHandler                 $plugin
	 * @param string                          $output
	 */
	public static function showPhotoActivity( &$row, &$title, &$date, &$message, &$insert, &$footer, &$menu, $stream, $assetMatches, $photo, $plugin, $output )
	{
		global $_CB_framework, $_PLUGINS;

		$type					=	( isset( $assetMatches[3] ) ? $assetMatches[3] : '' );
		$user					=	CBuser::getMyUserDataInstance();
		$groupOwner				=	( $user->getInt( 'id', 0 ) === $photo->group()->getInt( 'user_id', 0 ) );

		if ( CBGroupJive::canAccessGroup( $photo->group(), $user ) ) {
			$groupName			=	'<a href="' . $_CB_framework->pluginClassUrl( 'cbgroupjive', true, array( 'action' => 'groups', 'func' => 'show', 'id' => $photo->group()->getInt( 'id', 0 ) ) ) . '">' . htmlspecialchars( CBTxt::T( $photo->group()->getString( 'name' ) ) ) . '</a>';
		} else {
			$groupName			=	htmlspecialchars( CBTxt::T( $photo->group()->getString( 'name' ) ) );
		}

		if ( $stream instanceof NotificationsInterface ) {
			if ( CBGroupJive::canAccessGroup( $photo->group(), $user ) ) {
				$row->set( 'link', $_CB_framework->pluginClassUrl( 'cbgroupjive', false, array( 'action' => 'groups', 'func' => 'show', 'id' => $photo->group()->getInt( 'id', 0 ), 'tab' => 'grouptabphoto' ) ) );

				$photoName		=	'<a href="' . $_CB_framework->pluginClassUrl( 'cbgroupjive', true, array( 'action' => 'groups', 'func' => 'show', 'id' => $photo->group()->getInt( 'id', 0 ), 'tab' => 'grouptabphoto' ) ) . '">' . ( $photo->getString( 'title' ) ? htmlspecialchars( $photo->getString( 'title' ) ) : $photo->name() ) . '</a>';
			} else {
				$photoName		=	( $photo->getString( 'title' ) ? htmlspecialchars( $photo->getString( 'title' ) ) : $photo->name() );
			}

			switch ( $type ) {
				case 'photo_approve':
					if ( $groupOwner ) {
						$title	=	CBTxt::T( 'PHOTO_AWAITING_APPROVAL_IN_YOUR_GROUP', 'photo [photo] is awaiting approval in your group [group]', array( '[group]' => $groupName, '[photo]' => $photoName ) );
					} else {
						$title	=	CBTxt::T( 'PHOTO_AWAITING_APPROVAL_IN_GROUP', 'photo [photo] is awaiting approval in group [group]', array( '[group]' => $groupName, '[photo]' => $photoName ) );
					}
					break;
				case 'photo_approved':
					if ( $groupOwner ) {
						$title	=	CBTxt::T( 'PHOTO_APPROVED_IN_YOUR_GROUP', 'photo [photo] approved in your group [group]', array( '[group]' => $groupName, '[photo]' => $photoName ) );
					} else {
						$title	=	CBTxt::T( 'PHOTO_APPROVED_IN_GROUP', 'photo [photo] approved in group [group]', array( '[group]' => $groupName, '[photo]' => $photoName ) );
					}
					break;
				case 'photo_new':
				default:
					if ( $groupOwner ) {
						$title	=	CBTxt::T( 'SHARED_PHOTO_IN_YOUR_GROUP', 'shared photo [photo] in your group [group]', array( '[group]' => $groupName, '[photo]' => $photoName ) );
					} else {
						$title	=	CBTxt::T( 'SHARED_PHOTO_IN_GROUP', 'shared photo [photo] in group [group]', array( '[group]' => $groupName, '[photo]' => $photoName ) );
					}
					break;
			}
		} else {
			static $loaded		=	0;

			if ( ! $loaded++ ) {
				$js				=	"$( '.gjGroupPhotoItem.cbTooltip,.gjGroupPhotoLogo.cbTooltip' ).on( 'cbtooltip.render', function( e, cbtooltip, event, api ) {"
								.		"$( api.elements.content ).find( '.cbDateTimeago' ).cbtimeago();"
								.	"});";

				$_CB_framework->outputCbJQuery( $js );
			}

			if ( $stream->getInt( 'groupjive.ingroup', 0 ) === $photo->group()->getInt( 'id', 0 ) ) {
				$title			=	CBTxt::T( 'shared a photo' );
			} elseif ( $groupOwner ) {
				$title			=	CBTxt::T( 'SHARED_A_PHOTO_IN_YOUR_GROUP', 'shared a photo in your group [group]', array( '[group]' => $groupName ) );
			} else {
				$title			=	CBTxt::T( 'SHARED_A_PHOTO_IN_GROUP', 'shared a photo in group [group]', array( '[group]' => $groupName ) );
			}

			$logo				=	null;

			if ( $photo->exists() ) {
				$cbUser			=	CBuser::getInstance( $photo->getInt( 'user_id', 0 ), false );

				$showPath		=	$_CB_framework->pluginClassUrl( $plugin->element, false, array( 'action' => 'photo', 'func' => 'show', 'id' => $photo->getInt( 'id', 0 ) ), 'raw', 0, true );

				$image			=	'<div class="row no-gutters h-100 w-100 bg-dark border border-dark rounded auto-overflow gjGroupPhotoModalContainer">'
								.		'<div class="row no-gutters col-sm-9 h-100 gjGroupPhotoModalImage">'
								.			'<div class="d-flex flex-column col justify-content-center align-items-center h-100 p-2 gjGroupPhotoImage">'
								.				'<img alt="' . htmlspecialchars( ( $photo->getString( 'title' ) ? $photo->getString( 'title' ) : $photo->name() ) ) . '" src="' . htmlspecialchars( $showPath ) . '" class="mh-100 mw-100 cbImgPict cbFullPict" />'
								.			'</div>'
								.			'<div class="position-absolute p-2 gjGroupPhotoModalClose">'
								.				'<span class="fa fa-times text-large text-white cbTooltipClose"></span>'
								.			'</div>'
								.		'</div>'
								.		'<div class="d-flex flex-column col-sm-3 h-100 mh-100 p-2 bg-white border-left gjGroupPhotoModalDetails">'
								.			'<div class="gjGroupPhotoModalHeader">'
								.				'<div class="media">'
								.					'<div class="media-left gjGroupPhotoModalHeaderAvatar">'
								.						$cbUser->getField( 'avatar', null, 'html', 'none', 'list', 0, true )
								.					'</div>'
								.					'<div class="pl-2 pr-4 media-body gjGroupPhotoModalHeaderBody">'
								.						'<div class="text-wrap text-normal gjGroupPhotoModalHeaderAuthor">'
								.							'<strong>' . $cbUser->getField( 'formatname', null, 'html', 'none', 'list', 0, true ) . '</strong>'
								.						'</div>'
								.						'<div class="text-muted text-small gjGroupPhotoModalHeaderDate">'
								.							cbFormatDate( $photo->getString( 'date' ), true, 'timeago' )
								.						'</div>'
								.					'</div>'
								.				'</div>'
								.			'</div>';

				if ( $photo->getString( 'description' ) ) {
					$image		.=			'<div class="mt-1 text-wrap text-small gjGroupPhotoModalDescription">'
								.				htmlspecialchars( $photo->getString( 'description' ) )
								.			'</div>';
				}

				$image			.=		'</div>'
								.	'</div>';

				$logo			=	cbTooltip( null, $image, null, array( '90%', '90%' ), null, '<img alt="' . htmlspecialchars( ( $photo->getString( 'title' ) ? $photo->getString( 'title' ) : $photo->name() ) ) . '" src="' . htmlspecialchars( $_CB_framework->pluginClassUrl( $plugin->element, false, array( 'action' => 'photo', 'func' => 'preview', 'id' => $photo->getInt( 'id', 0 ) ), 'raw', 0, true ) ) . '" class="img-fluid cbImgPict cbThumbPict" />', 'javascript: void(0);', 'class="gjGroupPhotoLogo" data-cbtooltip-modal="true" data-cbtooltip-open-solo=".gjGroupPhotoModal" data-cbtooltip-classes="gjGroupPhotoModal" data-cbtooltip-content-classes="p-0" data-cbtooltip-button-close="false"' );
			}

			$insert				=	'<div class="gjPhotoActivity">'
								.		$logo
								.	'</div>';
		}

		$_PLUGINS->trigger( 'gj_onAfterPhotoActivity', array( &$row, &$title, &$date, &$message, &$insert, &$footer, &$menu, $stream, $assetMatches, $photo, $plugin, $output ) );
	}
}