<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\AutoActions\Trigger;

use CBLib\Language\CBTxt;

\defined( 'CBLIB' ) or die();

class AdminTrigger extends \cbPluginHandler
{

	/**
	 * Displays backend menu items
	 *
	 * @param array $menu
	 * @param bool  $disabled
	 */
	public function adminMenu( &$menu, $disabled )
	{
		global $_CB_framework;

		if ( ! $this->params->getBool( 'general_menu', true ) ) {
			return;
		}

		$prevStateBase				=	'option=com_comprofiler&view=editPlugin&pluginid=' . $this->getPluginId();

		$galleryMenu				=	[];

		$galleryMenu['component']	=	[ 'title' => CBTxt::T( 'Auto Actions' ) ];
		$galleryMenu['menu']		=	[	[ 'title'   => CBTxt::T( 'Auto Action' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, [ 'action' => 'showautoactions', 'cid' => $this->getPluginId() ] ), 'icon' => 'cbautoactions-autoactions',
												'submenu' => [ [ 'title' => CBTxt::Th( 'Add New Auto Action' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, [ 'cid' => $this->getPluginId(), 'table' => 'autoactionsbrowser', 'action' => 'editrow', 'cbprevstate' => base64_encode( $prevStateBase . '&action=showautoactions' ) ] ), 'icon' => 'cb-new' ] ]
											],
											[	'title' => CBTxt::T( 'System Actions' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, [ 'action' => 'showsystemactions', 'cid' => $this->getPluginId() ] ), 'icon' => 'cbautoactions-systemactions' ],
											[	'title' => CBTxt::T( 'Uses' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, [ 'action' => 'showautoactionuses', 'cid' => $this->getPluginId() ] ), 'icon' => 'cbautoactions-autoactionuses' ],
											[	'title' => CBTxt::T( 'Batches' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, [ 'action' => 'showautoactionbatches', 'cid' => $this->getPluginId() ] ), 'icon' => 'cbautoactions-autoactionbatches',
												'submenu' => [ [ 'title' => CBTxt::Th( 'Add New Batch' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, [ 'cid' => $this->getPluginId(), 'table' => 'autoactionbatchesbrowser', 'action' => 'editrow', 'cbprevstate' => base64_encode( $prevStateBase . '&action=showautoactionbatches' ) ] ), 'icon' => 'cb-new' ] ]
											],
											[	'title' => CBTxt::T( 'Configuration' ), 'link' => $_CB_framework->backendViewUrl( 'editrow', true, [ 'table' => 'pluginsbrowser', 'action' => 'editrow', 'cid' => $this->getPluginId(), 'cbprevstate' => base64_encode( 'option=com_comprofiler&view=showPlugins' ) ] ), 'icon' => 'cbautoactions-config' ]
										];

		$menu['autoactions']		=	$galleryMenu;
	}
}