<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\AutoActions\Action;

use CB\Database\Table\UserTable;
use CBLib\Application\Application;
use CBLib\Language\CBTxt;
use CBLib\Registry\ParamsInterface;

\defined( 'CBLIB' ) or die();

class UsergroupAction extends Action
{

	/**
	 * @param UserTable $user
	 */
	public function execute( UserTable $user ): void
	{
		$session									=	\JFactory::getSession();
		$jUser										=	$session->get( 'user' );

		foreach ( $this->autoaction()->getParams()->subTree( 'usergroup' ) as $row ) {
			/** @var ParamsInterface $row */
			$userId									=	$row->getString( 'user', '' );

			if ( ! $userId ) {
				$userId								=	$user->getInt( 'id', 0 );
			} else {
				$userId								=	(int) $this->string( $user, $userId );
			}

			if ( $user->getInt( 'id', 0 ) !== $userId ) {
				$actionUser							=	\CBuser::getUserDataInstance( $userId );
			} else {
				$actionUser							=	$user;
			}

			$mode									=	$row->getString( 'mode', 'add' );

			if ( ( ! $actionUser->getInt( 'id', 0 ) ) && ( $mode !== 'create' ) ) {
				$this->error( CBTxt::T( 'AUTO_ACTION_USERGROUP_NO_USER', ':: Action [action] :: Usergroup skipped due to missing user', [ '[action]' => $this->autoaction()->getId() ] ) );
				continue;
			}

			$isMe									=	( $jUser && ( $jUser->id === $actionUser->getInt( 'id', 0 ) ) );
			$myGroups								=	$actionUser->getRaw( 'gids', [] );

			if ( ! $myGroups ) {
				$myGroups							=	Application::User( $actionUser->getInt( 'id', 0 ) )->getAuthorisedGroups( false );
			}

			$myGroups								=	cbToArrayOfInt( $myGroups );
			$groups									=	cbToArrayOfInt( explode( '|*|', $row->getString( 'groups', '' ) ) );

			switch ( $mode ) {
				case 'create':
					$title							=	$this->string( $actionUser, $row->getString( 'title', '' ) );

					if ( ! $title ) {
						$this->error( CBTxt::T( 'AUTO_ACTION_USERGROUP_NO_TITLE', ':: Action [action] :: Usergroup skipped due to missing title', [ '[action]' => $this->autoaction()->getId() ] ) );
						continue 2;
					}

					/** @var \JTableUsergroup $usergroup */
					$usergroup						=	\JTable::getInstance( 'usergroup' );

					$usergroup->load( [ 'title' => $title ] );

					if ( ! $usergroup->id ) {
						$usergroup->parent_id		=	$row->getInt( 'parent', 0 );
						$usergroup->title			=	$title;

						if ( ! $usergroup->store() ) {
							$this->error( CBTxt::T( 'AUTO_ACTION_USERGROUP_CREATE_FAILED', ':: Action [action] :: Usergroup failed to create', [ '[action]' => $this->autoaction()->getId() ] ) );
							continue 2;
						}
					}

					if ( $row->getBool( 'add', true ) && $actionUser->getInt( 'id', 0 ) && ( ! \in_array( (int) $usergroup->id, $myGroups, true ) ) ) {
						$myGroups[]					=	(int) $usergroup->id;

						$actionUser->set( 'gids', array_unique( $myGroups ) );

						if ( ! $actionUser->store() ) {
							$this->error( CBTxt::T( 'AUTO_ACTION_USERGROUP_FAILED', ':: Action [action] :: Usergroup failed to save. Error: [error]', [ '[action]' => $this->autoaction()->getId(), '[error]' => $actionUser->getError() ] ) );
							continue 2;
						}

						if ( $isMe ) {
							\JAccess::clearStatics();

							$session->set( 'user', new \JUser( $actionUser->getInt( 'id', 0 ) ) );
						}
					}
					break;
				case 'replace':
					if ( ! $groups ) {
						$this->error( CBTxt::T( 'AUTO_ACTION_USERGROUP_NO_GROUPS', ':: Action [action] :: Usergroup skipped due to missing groups', [ '[action]' => $this->autoaction()->getId() ] ) );
						continue 2;
					}

					$actionUser->set( 'gids', $groups );

					if ( ! $actionUser->store() ) {
						$this->error( CBTxt::T( 'AUTO_ACTION_USERGROUP_FAILED', ':: Action [action] :: Usergroup failed to save. Error: [error]', [ '[action]' => $this->autoaction()->getId(), '[error]' => $actionUser->getError() ] ) );
						continue 2;
					}

					if ( $isMe ) {
						\JAccess::clearStatics();

						$session->set( 'user', new \JUser( $actionUser->getInt( 'id', 0 ) ) );
					}
					break;
				case 'remove':
					if ( ! $groups ) {
						$this->error( CBTxt::T( 'AUTO_ACTION_USERGROUP_NO_GROUPS', ':: Action [action] :: Usergroup skipped due to missing groups', [ '[action]' => $this->autoaction()->getId() ] ) );
						continue 2;
					}

					$usergroups						=	[];
					$removed						=	false;

					foreach( $myGroups as $gid ) {
						if ( \in_array( $gid, $groups, true ) ) {
							$removed				=	true;

							continue;
						}

						$usergroups[]				=	$gid;
					}

					if ( $removed ) {
						$actionUser->set( 'gids', $usergroups );

						if ( ! $actionUser->store() ) {
							$this->error( CBTxt::T( 'AUTO_ACTION_USERGROUP_FAILED', ':: Action [action] :: Usergroup failed to save. Error: [error]', [ '[action]' => $this->autoaction()->getId(), '[error]' => $actionUser->getError() ] ) );
							continue 2;
						}

						if ( $isMe ) {
							\JAccess::clearStatics();

							$session->set( 'user', new \JUser( $actionUser->getInt( 'id', 0 ) ) );
						}
					}
					break;
				case 'add':
				default:
					if ( ! $groups ) {
						$this->error( CBTxt::T( 'AUTO_ACTION_USERGROUP_NO_GROUPS', ':: Action [action] :: Usergroup skipped due to missing groups', [ '[action]' => $this->autoaction()->getId() ] ) );
						continue 2;
					}

					$usergroups						=	$groups;

					foreach( $usergroups as $k => $usergroup ) {
						if ( \in_array( $usergroup, $myGroups, true ) ) {
							unset( $usergroups[$k] );
						}
					}

					if ( $usergroups ) {
						$actionUser->set( 'gids', array_unique( array_merge( $myGroups, $groups ) ) );

						if ( ! $actionUser->store() ) {
							$this->error( CBTxt::T( 'AUTO_ACTION_USERGROUP_FAILED', ':: Action [action] :: Usergroup failed to save. Error: [error]', [ '[action]' => $this->autoaction()->getId(), '[error]' => $actionUser->getError() ] ) );
							continue 2;
						}

						if ( $isMe ) {
							\JAccess::clearStatics();

							$session->set( 'user', new \JUser( $actionUser->getInt( 'id', 0 ) ) );
						}
					}
					break;
			}
		}
	}
}