<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\AutoActions\Action;

use CB\Database\Table\UserTable;
use CBLib\Application\Application;
use CBLib\Language\CBTxt;

\defined( 'CBLIB' ) or die();

class LoginlogoutAction extends Action
{

	/**
	 * @param UserTable $user
	 */
	public function execute( UserTable $user ): void
	{
		$params								=	$this->autoaction()->getParams()->subTree( 'loginlogout' );

		cbimport( 'cb.authentication' );

		$cbAuthenticate						=	new \CBAuthentication();

		$isHttps							=	( isset( $_SERVER['HTTPS'] ) && ( ! empty( $_SERVER['HTTPS'] ) ) && ( $_SERVER['HTTPS'] !== 'off' ) );
		$returnUrl							=	'http' . ( $isHttps ? 's' : '' ) . '://' . $_SERVER['HTTP_HOST'];

		if ( ( ! empty( $_SERVER['PHP_SELF'] ) ) && ( ! empty( $_SERVER['REQUEST_URI'] ) ) ) {
			$returnUrl						.=	$_SERVER['REQUEST_URI'];
		} else {
			$returnUrl						.=	$_SERVER['SCRIPT_NAME'];

			if ( isset( $_SERVER['QUERY_STRING'] ) && ( ! empty( $_SERVER['QUERY_STRING'] ) ) ) {
				$returnUrl					.=	'?' . $_SERVER['QUERY_STRING'];
			}
		}

		$returnUrl							=	cbUnHtmlspecialchars( preg_replace( '/[\\\"\\\'][\\s]*javascript:(.*)[\\\"\\\']/', '""', preg_replace( '/eval\((.*)\)/', '', htmlspecialchars( urldecode( $returnUrl ) ) ) ) );

		if ( preg_match( '/index.php\?option=com_comprofiler&task=confirm&confirmCode=|index.php\?option=com_comprofiler&view=confirm&confirmCode=|index.php\?option=com_comprofiler&task=login|index.php\?option=com_comprofiler&view=login/', $returnUrl ) ) {
			$returnUrl						=	'index.php';
		}

		$redirect							=	$this->string( $user, $params->getString( 'redirect', '' ), ( preg_match( '/^\[[a-zA-Z0-9-_]+\]$/', $params->getString( 'redirect', '' ) ) ? false : [ '\CB\Plugin\AutoActions\CBAutoActions', 'escapeURL' ] ) );
		$message							=	$this->string( $user, $params->getRaw( 'message', '' ), false );
		$messageType						=	$params->getString( 'message_type', 'message' );

		if ( $messageType === 'custom' ) {
			$messageType					=	$this->string( $user, $params->getString( 'custom_message_type', '' ) );
		}

		if ( $params->getBool( 'mode', true ) ) {
			if ( ! Application::MyUser()->getUserId() ) {
				$messagesToUser				=	[];
				$alertMessages				=	[];

				switch ( $params->getInt( 'method', 1 ) ) {
					case 2:
						$userId				=	$this->string( $user, $params->getString( 'user_id', '' ) );

						if ( ! $userId ) {
							$credentials	=	$user->getString( 'username', '' );
						} else {
							$credentials	=	\CBuser::getUserDataInstance( (int) $userId )->getString( 'username', '' );
						}

						$method				=	0;
						break;
					case 0:
						$credentials		=	$this->string( $user, $params->getString( 'email', '' ) );

						if ( ! $credentials ) {
							$credentials	=	$user->getString( 'email', '' );
						}

						$method				=	1;
						break;
					case 1:
					default:
						$credentials		=	$this->string( $user, $params->getString( 'username', '' ) );

						if ( ! $credentials ) {
							$credentials	=	$user->getString( 'username', '' );
						}

						$method				=	0;
						break;
				}

				$password					=	$params->getString( 'password', '' );

				if ( $password ) {
					$password				=	$this->string( $user, $password );
				} else {
					$password				=	false;
				}

				$resultError				=	$cbAuthenticate->login( $credentials, $password, 0, 1, $returnUrl, $messagesToUser, $alertMessages, $method );

				$message					=	( $resultError ?: ( $message ?: ( $alertMessages && $params->getBool( 'alerts', true ) ? stripslashes( implode( '<br />', $alertMessages ) ) : null ) ) );
				$messageType				=	( $resultError ? 'error' : ( $messageType ?: 'message' ) );
			} else {
				// Silently redirect if user is already logged in:
				$message					=	null;
				$messageType				=	null;
			}

			$this->redirect( $returnUrl, $redirect, $message, $messageType );
		} else {
			if ( Application::MyUser()->getUserId() ) {
				$resultError				=	$cbAuthenticate->logout( $returnUrl );

				$message					=	( $resultError ?: ( $message ?: ( $params->getBool( 'alerts', true ) ? CBTxt::T( 'LOGOUT_SUCCESS', 'You have successfully logged out' ) : null ) ) );
				$messageType				=	( $resultError ? 'error' : ( $messageType ?: 'message' ) );
			} else {
				// Silently redirect if user is already logged out:
				$message					=	null;
				$messageType				=	null;
			}

			$this->redirect( $returnUrl, $redirect, $message, $messageType );
		}
	}

	/**
	 * @param null|string $returnUrl
	 * @param null|string $redirect
	 * @param null|string $message
	 * @param null|string $messageType
	 */
	private function redirect( ?string $returnUrl, ?string $redirect, ?string $message, ?string $messageType ): void
	{
		global $_CB_framework;

		if ( stripos( $redirect, 'goback' ) === 0 ) {
			$back				=	(int) strtolower( substr( $redirect, 6 ) );

			if ( $message ) {
				$_CB_framework->enqueueMessage( $message, $messageType );
			}

			$_CB_framework->document->addHeadScriptDeclaration( ( $back && ( $back > 0 ) ? "window.history.go( -$back );" : "window.history.back();" ) );
		} elseif ( strtolower( $redirect ) === 'reload' ) {
			if ( $message ) {
				$_CB_framework->enqueueMessage( $message, $messageType );
			}

			$_CB_framework->document->addHeadScriptDeclaration( "window.location.reload();" );
		} else {
			if ( strtolower( $redirect ) === 'return' ) {
				$redirect		=	$returnUrl;
			}

			if ( $redirect ) {
				if ( strpos( $redirect, 'index.php?Itemid=' ) === 0 ) {
					// We're linking to another menu item so lets run through SEF before redirecting so we have the ACTUAL menu URL:
					$redirect	=	cbSef( $redirect, false );
				}

				cbRedirect( $redirect, $message, $messageType );
			} elseif ( $message ) {
				$_CB_framework->enqueueMessage( $message, $messageType );
			}
		}
	}
}