<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2021 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\AutoActions\Action;

use CB\Database\Table\UserTable;
use CBLib\Application\Application;
use CBLib\Language\CBTxt;
use CBLib\Registry\ParamsInterface;

\defined( 'CBLIB' ) or die();

class ConnectionAction extends Action
{

	/**
	 * @param UserTable $user
	 */
	public function execute( UserTable $user ): void
	{
		global $ueConfig;

		foreach ( $this->autoaction()->getParams()->subTree( 'connection' ) as $row ) {
			/** @var ParamsInterface $row */
			$userId									=	$row->getString( 'user', '' );

			if ( ! $userId ) {
				$userId								=	$user->getInt( 'id', 0 );
			} else {
				$userId								=	(int) $this->string( $user, $userId );
			}

			if ( $user->getInt( 'id', 0 ) !== $userId ) {
				$actionUser							=	\CBuser::getUserDataInstance( $userId );
			} else {
				$actionUser							=	$user;
			}

			if ( ! $actionUser->getInt( 'id', 0 ) ) {
				$this->error( CBTxt::T( 'AUTO_ACTION_CONNECTION_NO_USER', ':: Action [action] :: Connection skipped due to missing user', [ '[action]' => $this->autoaction()->getId() ] ) );
				continue;
			}

			$users									=	$this->string( $actionUser, $row->getString( 'users', '' ) );

			if ( ! $users ) {
				$this->error( CBTxt::T( 'AUTO_ACTION_CONNECTION_NO_USERS', ':: Action [action] :: Connection skipped due to missing users', [ '[action]' => $this->autoaction()->getId() ] ) );
				continue;
			}

			$users									=	cbToArrayOfInt( explode( ',', $users ) );
			$message								=	$this->string( $actionUser, $row->getRaw( 'message', '' ), false );
			$mutual									=	$row->getInt( 'mutual', 2 );
			$cross									=	$row->getInt( 'cross', 1 );
			$notify									=	$row->getBool( 'notify', false );

			$oldMutual								=	Application::Config()->getInt( 'useMutualConnections', 1 );
			$oldCross								=	Application::Config()->getInt( 'autoAddConnections', 1 );

			if ( $mutual ) {
				$ueConfig['useMutualConnections']	=	( $mutual === 1 ? '1' : '0' );
			}

			if ( $cross ) {
				$ueConfig['autoAddConnections']		=	( $cross === 1 ? '1' : '0' );
			}

			if ( $row->getBool( 'direction', false ) ) {
				foreach ( $users as $connectionId ) {
					if ( $connectionId === $userId ) {
						continue;
					}

					$connections					=	new \cbConnection( $connectionId );

					if ( $connections->getConnectionDetails( $connectionId, $userId ) ) {
						continue;
					}

					$connections->addConnection( $userId, $message, $notify );
				}
			} else {
				$connections						=	new \cbConnection( $userId );

				foreach ( $users as $connectionId ) {
					if ( ( $connectionId === $userId ) || $connections->getConnectionDetails( $userId, $connectionId ) ) {
						continue;
					}

					$connections->addConnection( $connectionId, $message, $notify );
				}
			}

			if ( $mutual ) {
				$ueConfig['useMutualConnections']	=	$oldMutual;
			}

			if ( $cross ) {
				$ueConfig['autoAddConnections']		=	$oldCross;
			}
		}
	}
}