CREATE TABLE IF NOT EXISTS `#__rsmembership_categories` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `published` tinyint(1) NOT NULL,
  `ordering` int(11) NOT NULL,
  PRIMARY KEY  (`id`)
) DEFAULT CHARSET=utf8;


CREATE TABLE IF NOT EXISTS `#__rsmembership_configuration` (
  `name` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY  (`name`)
) DEFAULT CHARSET=utf8;

INSERT IGNORE INTO `#__rsmembership_configuration` (`name`, `value`) VALUES
('global_register_code', ''),
('date_format', 'd.m.Y H:i:s'),
('currency', 'EUR'),
('delete_pending_after', '168'),
('show_login', '1'),
('create_user_instantly', '1'),
('disable_registration', '0'),
('registration_page', ''),
('price_format', '{price} {currency}'),
('format_decimals', '2'),
('format_decimals_point', '.'),
('format_thousands_sep', ''),
('price_show_free', '1'),
('expire_last_run', '0'),
('expire_emails', '10'),
('expire_check_in', '10'),
('choose_username', '0'),
('captcha_enabled', '0'),
('captcha_enabled_for', '1,0'),
('captcha_characters', '5'),
('captcha_lines', '1'),
('captcha_case_sensitive', '0'),
('recaptcha_public_key', ''),
('recaptcha_private_key', ''),
('recaptcha_theme', 'red'),
('idev_enable', '0'),
('idev_url', ''),
('idev_track_renewals', '0'),
('last_check', '0'),
('choose_password', '0'),
('one_page_checkout', '0'),
('replace_gid', '1'),
('interval', '5'),
('load_bootstrap', '1'),
('footer_enable', '1'),
('full_email_username', '0'),
('allow_resubscribe', '1'),
('footer_content', '<p><small>This message has been automatically sent by <a href="{siteurl}" title="{sitename}"><strong>{sitename}</strong></a></small></p>'),
('trigger_content_plugins', '0'),
('recaptcha_new_site_key', ''),
('recaptcha_new_secret_key', ''),
('recaptcha_new_theme', 'light'),
('recaptcha_new_type', 'image'),
('allow_renew_in_advance', '1'),
('store_ip', '1'),
('allow_self_anonymisation', '0'),
('send_user_account_email', '2'),
('general_invoice_title', 'Invoice #{invoice_id}'),
('general_invoice_padding', '7'),
('general_invoice_layout', '<h1>Invoice #{invoice_id}</h1>\r\n<h3>Date of issue {date_purchased}</h3>\r\n\r\n<table width=\"100%\">\r\n	<tr>\r\n		<td>\r\n			<h3>Billed To</h3>\r\n			<p>{name}</p>\r\n			<p>{email}</p>\r\n		</td>\r\n		<td>\r\n			<h3>My Company</h3>\r\n			<p>{site_name}</p>\r\n			<p>{site_url}</p>\r\n		</td>\r\n	</tr>\r\n</table>\r\n\r\n\r\n{invoice_transaction_table}'),
('general_invoice_pdf_font', 'freesans'),
('general_invoice_pdf_font_size', '12');

CREATE TABLE IF NOT EXISTS `#__rsmembership_countries` (
  `name` varchar(255) NOT NULL,
  UNIQUE KEY `name` (`name`)
) DEFAULT CHARSET=utf8;

INSERT IGNORE INTO `#__rsmembership_countries` (`name`) VALUES
('Afghanistan'),
('Akrotiri'),
('Albania'),
('Algeria'),
('American Samoa'),
('Andorra'),
('Angola'),
('Anguilla'),
('Antarctica'),
('Antigua and Barbuda'),
('Argentina'),
('Armenia'),
('Aruba'),
('Ashmore and Cartier Islands'),
('Australia'),
('Austria'),
('Azerbaijan'),
('Bahamas, The'),
('Bahrain'),
('Bangladesh'),
('Barbados'),
('Bassas da India'),
('Belarus'),
('Belgium'),
('Belize'),
('Benin'),
('Bermuda'),
('Bhutan'),
('Bolivia'),
('Bosnia and Herzegovina'),
('Botswana'),
('Bouvet Island'),
('Brazil'),
('British Indian Ocean Territory'),
('British Virgin Islands'),
('Brunei'),
('Bulgaria'),
('Burkina Faso'),
('Burma'),
('Burundi'),
('Cambodia'),
('Cameroon'),
('Canada'),
('Cape Verde'),
('Cayman Islands'),
('Central African Republic'),
('Chad'),
('Chile'),
('China'),
('Christmas Island'),
('Clipperton Island'),
('Cocos (Keeling) Islands'),
('Colombia'),
('Comoros'),
('Congo, Democratic Republic of the'),
('Congo, Republic of the'),
('Cook Islands'),
('Coral Sea Islands'),
('Costa Rica'),
('Cote d''Ivoire'),
('Croatia'),
('Cuba'),
('Cyprus'),
('Czech Republic'),
('Denmark'),
('Dhekelia'),
('Djibouti'),
('Dominica'),
('Dominican Republic'),
('Ecuador'),
('Egypt'),
('El Salvador'),
('Equatorial Guinea'),
('Eritrea'),
('Estonia'),
('Ethiopia'),
('Europa Island'),
('Falkland Islands (Islas Malvinas)'),
('Faroe Islands'),
('Fiji'),
('Finland'),
('France'),
('French Guiana'),
('French Polynesia'),
('French Southern and Antarctic Lands'),
('Gabon'),
('Gambia, The'),
('Gaza Strip'),
('Georgia'),
('Germany'),
('Ghana'),
('Gibraltar'),
('Glorioso Islands'),
('Greece'),
('Greenland'),
('Grenada'),
('Guadeloupe'),
('Guam'),
('Guatemala'),
('Guernsey'),
('Guinea'),
('Guinea-Bissau'),
('Guyana'),
('Haiti'),
('Heard Island and McDonald Islands'),
('Holy See (Vatican City)'),
('Honduras'),
('Hong Kong'),
('Hungary'),
('Iceland'),
('India'),
('Indonesia'),
('Iran'),
('Iraq'),
('Ireland'),
('Isle of Man'),
('Israel'),
('Italy'),
('Jamaica'),
('Jan Mayen'),
('Japan'),
('Jersey'),
('Jordan'),
('Juan de Nova Island'),
('Kazakhstan'),
('Kenya'),
('Kiribati'),
('Korea, North'),
('Korea, South'),
('Kuwait'),
('Kyrgyzstan'),
('Laos'),
('Latvia'),
('Lebanon'),
('Lesotho'),
('Liberia'),
('Libya'),
('Liechtenstein'),
('Lithuania'),
('Luxembourg'),
('Macau'),
('Macedonia'),
('Madagascar'),
('Malawi'),
('Malaysia'),
('Maldives'),
('Mali'),
('Malta'),
('Marshall Islands'),
('Martinique'),
('Mauritania'),
('Mauritius'),
('Mayotte'),
('Mexico'),
('Micronesia, Federated States of'),
('Moldova'),
('Monaco'),
('Mongolia'),
('Montserrat'),
('Morocco'),
('Mozambique'),
('Namibia'),
('Nauru'),
('Navassa Island'),
('Nepal'),
('Netherlands'),
('Netherlands Antilles'),
('New Caledonia'),
('New Zealand'),
('Nicaragua'),
('Niger'),
('Nigeria'),
('Niue'),
('Norfolk Island'),
('Northern Mariana Islands'),
('Norway'),
('Oman'),
('Pakistan'),
('Palau'),
('Panama'),
('Papua New Guinea'),
('Paracel Islands'),
('Paraguay'),
('Peru'),
('Philippines'),
('Pitcairn Islands'),
('Poland'),
('Portugal'),
('Puerto Rico'),
('Qatar'),
('Reunion'),
('Romania'),
('Russia'),
('Rwanda'),
('Saint Helena'),
('Saint Kitts and Nevis'),
('Saint Lucia'),
('Saint Pierre and Miquelon'),
('Saint Vincent and the Grenadines'),
('Samoa'),
('San Marino'),
('Sao Tome and Principe'),
('Saudi Arabia'),
('Senegal'),
('Serbia and Montenegro'),
('Seychelles'),
('Sierra Leone'),
('Singapore'),
('Slovakia'),
('Slovenia'),
('Solomon Islands'),
('Somalia'),
('South Africa'),
('South Georgia and the South Sandwich Islands'),
('Spain'),
('Spratly Islands'),
('Sri Lanka'),
('Sudan'),
('Suriname'),
('Svalbard'),
('Swaziland'),
('Sweden'),
('Switzerland'),
('Syria'),
('Taiwan'),
('Tajikistan'),
('Tanzania'),
('Thailand'),
('Timor-Leste'),
('Togo'),
('Tokelau'),
('Tonga'),
('Trinidad and Tobago'),
('Tromelin Island'),
('Tunisia'),
('Turkey'),
('Turkmenistan'),
('Turks and Caicos Islands'),
('Tuvalu'),
('Uganda'),
('Ukraine'),
('United Arab Emirates'),
('United Kingdom'),
('United States'),
('Uruguay'),
('Uzbekistan'),
('Vanuatu'),
('Venezuela'),
('Vietnam'),
('Virgin Islands'),
('Wake Island'),
('Wallis and Futuna'),
('West Bank'),
('Western Sahara'),
('Yemen'),
('Zambia'),
('Zimbabwe');

CREATE TABLE IF NOT EXISTS `#__rsmembership_coupons` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `date_added` DATETIME NOT NULL,
  `date_start` DATETIME NOT NULL,
  `date_end` DATETIME NOT NULL,
  `discount_type` tinyint(1) NOT NULL,
  `discount_price` decimal(10,2) NOT NULL,
  `max_uses` int(11) NOT NULL,
  `published` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `name` (`name`)
)  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__rsmembership_coupon_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `coupon_id` int(11) NOT NULL,
  `membership_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `coupon_id` (`coupon_id`,`membership_id`)
)  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__rsmembership_extras` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `type` enum('dropdown','radio','checkbox') NOT NULL,
  `published` tinyint(1) NOT NULL,
  `ordering` int(11) NOT NULL,
  PRIMARY KEY  (`id`)
) DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__rsmembership_extra_values` (
  `id` int(11) NOT NULL auto_increment,
  `extra_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `sku` varchar(255) NOT NULL,
  `price` decimal(10, 2) NOT NULL,
  `share_redirect` text NOT NULL,
  `checked` tinyint(1) NOT NULL,
  `published` tinyint(1) NOT NULL,
  `ordering` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `extra_id` (`extra_id`)
) DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__rsmembership_extra_value_shared` (
  `id` int(11) NOT NULL auto_increment,
  `extra_value_id` int(11) NOT NULL,
  `params` text NOT NULL,
  `type` varchar(255) NOT NULL,
  `published` tinyint(1) NOT NULL,
  `ordering` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `extra_value_id` (`extra_value_id`)
) DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__rsmembership_fields` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL,
  `values` text NOT NULL,
  `datetimeformat` varchar(255) NOT NULL,
  `additional` text NOT NULL,
  `validation` text NOT NULL,
  `rule` varchar(64) NOT NULL,
  `required` tinyint(1) NOT NULL,
  `published` tinyint(1) NOT NULL,
  `ordering` int(11) NOT NULL,
  `showinsubscribers` tinyint(1) NOT NULL,
  PRIMARY KEY  (`id`)
) DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__rsmembership_files` (
  `id` int(11) NOT NULL auto_increment,
  `path` text NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `term_id` int(11) NOT NULL,
  `visits` int(11) NOT NULL,
  `downloads` int(11) NOT NULL,
  `thumb` varchar(255) NOT NULL,
  `thumb_w` int(11) NOT NULL,
  PRIMARY KEY  (`id`)
) DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__rsmembership_logs` (
  `id` int(11) NOT NULL auto_increment,
  `date` DATETIME NOT NULL,
  `user_id` int(11) NOT NULL,
  `path` text NOT NULL,
  `ip` varchar(16) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `user_id` (`user_id`)
) DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__rsmembership_memberships` (
  `id` int(11) NOT NULL auto_increment,
  `category_id` int(11) NOT NULL default '0',
  `name` text NOT NULL,
  `description` text NOT NULL,
  `term_id` int(11) NOT NULL,
  `thumb` text NOT NULL,
  `thumb_w` int(11) NOT NULL,
  `sku` text NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `use_renewal_price` tinyint(1) NOT NULL,
  `renewal_price` decimal(10,2) NOT NULL,
  `recurring` tinyint(1) NOT NULL,
  `recurring_times` int(11) NOT NULL,
  `share_redirect` text NOT NULL,
  `period` int(11) NOT NULL,
  `period_type` varchar(1) NOT NULL,
  `use_trial_period` tinyint(1) NOT NULL,
  `trial_period` int(11) NOT NULL,
  `trial_period_type` varchar(1) NOT NULL,
  `trial_price` decimal(10,2) NOT NULL,
  `unique` tinyint(1) NOT NULL default '0',
  `no_renew` tinyint(1) NOT NULL default '0',
  `stock` int(11) NOT NULL,
  `activation` tinyint(1) NOT NULL,
  `action` tinyint(1) NOT NULL,
  `thankyou` text NOT NULL,
  `redirect` text NOT NULL,
  `user_email_use_global` tinyint(1) NOT NULL,
  `user_email_mode` tinyint(1) NOT NULL,
  `user_email_from` text NOT NULL,
  `user_email_from_addr` text NOT NULL,
  `user_email_new_subject` text NOT NULL,
  `user_email_new_text` text NOT NULL,
  `user_email_approved_subject` text NOT NULL,
  `user_email_approved_text` text NOT NULL,
  `user_email_denied_subject` text NOT NULL,
  `user_email_denied_text` text NOT NULL,
  `user_email_renew_subject` text NOT NULL,
  `user_email_renew_text` text NOT NULL,
  `user_email_upgrade_subject` text NOT NULL,
  `user_email_upgrade_text` text NOT NULL,
  `user_email_addextra_subject` text NOT NULL,
  `user_email_addextra_text` text NOT NULL,
  `user_email_expire_subject` text NOT NULL,
  `user_email_expire_text` text NOT NULL,
  `expire_notify_interval` int(3) NOT NULL default '3',
  `admin_email_mode` tinyint(1) NOT NULL,
  `admin_email_from_addr` text NOT NULL,
  `admin_email_to_addr` text NOT NULL,
  `admin_email_new_subject` text NOT NULL,
  `admin_email_new_text` text NOT NULL,
  `admin_email_approved_subject` text NOT NULL,
  `admin_email_approved_text` text NOT NULL,
  `admin_email_denied_subject` text NOT NULL,
  `admin_email_denied_text` text NOT NULL,
  `admin_email_renew_subject` text NOT NULL,
  `admin_email_renew_text` text NOT NULL,
  `admin_email_upgrade_subject` text NOT NULL,
  `admin_email_upgrade_text` text NOT NULL,
  `admin_email_addextra_subject` text NOT NULL,
  `admin_email_addextra_text` text NOT NULL,
  `admin_email_expire_subject` text NOT NULL,
  `admin_email_expire_text` text NOT NULL,
  `use_membership_invoice` tinyint(1) NOT NULL,
  `add_membership_invoice_to_approval` tinyint(1) NOT NULL default '1',
  `membership_invoice_type` varchar(6) NOT NULL,
  `membership_invoice_padding` int(10) NOT NULL,
  `membership_invoice_title` text NOT NULL,
  `membership_invoice_layout` text NOT NULL,
  `membership_invoice_pdf_font` varchar(15) NOT NULL,
  `membership_invoice_pdf_font_size` int(3) NOT NULL,
  `custom_code_transaction` text NOT NULL,
  `custom_code` text NOT NULL,
  `gid_enable` tinyint(1) NOT NULL default '0',
  `gid_subscribe` text NOT NULL,
  `gid_expire` text NOT NULL,
  `disable_expired_account` tinyint(1) NOT NULL,
  `fixed_expiry` tinyint(1) NOT NULL,
  `fixed_day` int(2) NOT NULL,
  `fixed_month` tinyint(2) NOT NULL,
  `fixed_year` smallint(4) NOT NULL,
  `published` tinyint(1) NOT NULL,
  `ordering` int(11) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__rsmembership_membership_attachments` (
  `id` int(11) NOT NULL auto_increment,
  `membership_id` int(11) NOT NULL,
  `email_type` varchar( 64 ) NOT NULL,
  `path` text NOT NULL,
  `published` tinyint(1) NOT NULL,
  `ordering` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `membership_id` (`membership_id`)
) DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__rsmembership_membership_extras` (
  `membership_id` int(11) NOT NULL,
  `extra_id` int(11) NOT NULL,
  PRIMARY KEY  (`membership_id`,`extra_id`)
) DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__rsmembership_membership_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `membership_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL,
  `values` text NOT NULL,
  `datetimeformat` varchar(255) NOT NULL,
  `additional` text NOT NULL,
  `validation` text NOT NULL,
  `rule` varchar(64) NOT NULL,
  `required` tinyint(1) NOT NULL,
  `published` tinyint(1) NOT NULL,
  `ordering` int(11) NOT NULL,
  PRIMARY KEY (`id`)
)  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__rsmembership_membership_shared` (
  `id` int(11) NOT NULL auto_increment,
  `membership_id` int(11) NOT NULL,
  `params` text NOT NULL,
  `type` varchar(255) NOT NULL,
  `published` tinyint(1) NOT NULL,
  `ordering` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `membership_id` (`membership_id`)
) DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__rsmembership_membership_upgrades` (
  `id` int(11) NOT NULL auto_increment,
  `membership_from_id` int(11) NOT NULL,
  `membership_to_id` int(11) NOT NULL,
  `price` decimal(10, 2) NOT NULL,
  `published` tinyint(1) NOT NULL,
  PRIMARY KEY  (`id`)
) DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__rsmembership_membership_subscribers` (
  `id` int(11) NOT NULL auto_increment,
  `user_id` int(11) NOT NULL,
  `membership_id` int(11) NOT NULL,
  `membership_start` DATETIME NOT NULL,
  `membership_end` DATETIME NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `currency` varchar(4) NOT NULL,
  `status` tinyint(4) NOT NULL,
  `extras` varchar(255) NOT NULL,
  `notes` text NOT NULL,
  `from_transaction_id` int(11) NOT NULL,
  `last_transaction_id` int(11) NOT NULL,
  `custom_1` varchar(255) NOT NULL,
  `custom_2` varchar(255) NOT NULL,
  `custom_3` varchar(255) NOT NULL,
  `notified` DATETIME NOT NULL,
  `published` tinyint(1) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `user_id` (`user_id`,`membership_id`)
) DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__rsmembership_payments` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL,
  `details` text NOT NULL,
  `tax_type` tinyint( 1 ) NOT NULL,
  `tax_value` int(11) NOT NULL,
  `published` tinyint(1) NOT NULL,
  `ordering` int(11) NOT NULL,
  PRIMARY KEY  (`id`)
) DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__rsmembership_terms` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `published` tinyint(1) NOT NULL,
  `ordering` int(11) NOT NULL,
  PRIMARY KEY  (`id`)
) DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__rsmembership_transactions` (
  `id` int(11) NOT NULL auto_increment,
  `user_id` int(11) NOT NULL,
  `user_email` varchar(255) NOT NULL,
  `user_data` text NOT NULL,
  `type` varchar(32) NOT NULL,
  `params` text NOT NULL,
  `date` DATETIME NOT NULL,
  `ip` varchar(16) NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `tax_type` tinyint( 1 ) NOT NULL,
  `tax_value` decimal(10,2) NOT NULL,
  `coupon` varchar(64) NOT NULL,
  `currency` varchar(4) NOT NULL,
  `hash` varchar(255) NOT NULL,
  `custom` varchar(255) NOT NULL,
  `gateway` varchar(64) NOT NULL,
  `status` varchar(64) NOT NULL,
  `response_log` text NOT NULL,
  `transaction_data` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `user_id` (`user_id`),
  KEY `coupon` (`coupon`)
) DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__rsmembership_subscribers` (
  `user_id` int(11) NOT NULL,
  PRIMARY KEY  (`user_id`)
) DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__rsmembership_syslog` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(300) NOT NULL,
  `message` text NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
)  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__rsmembership_tokens` (
  `user_id` int(11) NOT NULL,
  `token` varchar(100) NOT NULL,
  PRIMARY KEY  (`user_id`)
) DEFAULT CHARSET=utf8;