<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				fdsh 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.39
	@build			4th April, 2023
	@created		17th December, 2020
	@package		Reservation
	@subpackage		script.php
	@author			farhad shahbazi <http://farhad.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Filesystem\File;
use Joomla\CMS\Filesystem\Folder;
JHTML::_('behavior.modal');

/**
 * Script File of Reservation Component
 */
class com_reservationInstallerScript
{
	/**
	 * Constructor
	 *
	 * @param   JAdapterInstance  $parent  The object responsible for running this script
	 */
	public function __construct(JAdapterInstance $parent) {}

	/**
	 * Called on installation
	 *
	 * @param   JAdapterInstance  $parent  The object responsible for running this script
	 *
	 * @return  boolean  True on success
	 */
	public function install(JAdapterInstance $parent) {}

	/**
	 * Called on uninstallation
	 *
	 * @param   JAdapterInstance  $parent  The object responsible for running this script
	 */
	public function uninstall(JAdapterInstance $parent)
	{
		// Get Application object
		$app = JFactory::getApplication();

		// Get The Database object
		$db = JFactory::getDbo();

		// Create a new query object.
		$query = $db->getQuery(true);
		// Select id from content type table
		$query->select($db->quoteName('type_id'));
		$query->from($db->quoteName('#__content_types'));
		// Where Reserve alias is found
		$query->where( $db->quoteName('type_alias') . ' = '. $db->quote('com_reservation.reserve') );
		$db->setQuery($query);
		// Execute query to see if alias is found
		$db->execute();
		$reserve_found = $db->getNumRows();
		// Now check if there were any rows
		if ($reserve_found)
		{
			// Since there are load the needed  reserve type ids
			$reserve_ids = $db->loadColumn();
			// Remove Reserve from the content type table
			$reserve_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_reservation.reserve') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__content_types'));
			$query->where($reserve_condition);
			$db->setQuery($query);
			// Execute the query to remove Reserve items
			$reserve_done = $db->execute();
			if ($reserve_done)
			{
				// If successfully remove Reserve add queued success message.
				$app->enqueueMessage(JText::_('The (com_reservation.reserve) type alias was removed from the <b>#__content_type</b> table'));
			}

			// Remove Reserve items from the contentitem tag map table
			$reserve_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_reservation.reserve') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__contentitem_tag_map'));
			$query->where($reserve_condition);
			$db->setQuery($query);
			// Execute the query to remove Reserve items
			$reserve_done = $db->execute();
			if ($reserve_done)
			{
				// If successfully remove Reserve add queued success message.
				$app->enqueueMessage(JText::_('The (com_reservation.reserve) type alias was removed from the <b>#__contentitem_tag_map</b> table'));
			}

			// Remove Reserve items from the ucm content table
			$reserve_condition = array( $db->quoteName('core_type_alias') . ' = ' . $db->quote('com_reservation.reserve') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__ucm_content'));
			$query->where($reserve_condition);
			$db->setQuery($query);
			// Execute the query to remove Reserve items
			$reserve_done = $db->execute();
			if ($reserve_done)
			{
				// If successfully removed Reserve add queued success message.
				$app->enqueueMessage(JText::_('The (com_reservation.reserve) type alias was removed from the <b>#__ucm_content</b> table'));
			}

			// Make sure that all the Reserve items are cleared from DB
			foreach ($reserve_ids as $reserve_id)
			{
				// Remove Reserve items from the ucm base table
				$reserve_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $reserve_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_base'));
				$query->where($reserve_condition);
				$db->setQuery($query);
				// Execute the query to remove Reserve items
				$db->execute();

				// Remove Reserve items from the ucm history table
				$reserve_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $reserve_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_history'));
				$query->where($reserve_condition);
				$db->setQuery($query);
				// Execute the query to remove Reserve items
				$db->execute();
			}
		}

		// Create a new query object.
		$query = $db->getQuery(true);
		// Select id from content type table
		$query->select($db->quoteName('type_id'));
		$query->from($db->quoteName('#__content_types'));
		// Where Bbbclass alias is found
		$query->where( $db->quoteName('type_alias') . ' = '. $db->quote('com_reservation.bbbclass') );
		$db->setQuery($query);
		// Execute query to see if alias is found
		$db->execute();
		$bbbclass_found = $db->getNumRows();
		// Now check if there were any rows
		if ($bbbclass_found)
		{
			// Since there are load the needed  bbbclass type ids
			$bbbclass_ids = $db->loadColumn();
			// Remove Bbbclass from the content type table
			$bbbclass_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_reservation.bbbclass') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__content_types'));
			$query->where($bbbclass_condition);
			$db->setQuery($query);
			// Execute the query to remove Bbbclass items
			$bbbclass_done = $db->execute();
			if ($bbbclass_done)
			{
				// If successfully remove Bbbclass add queued success message.
				$app->enqueueMessage(JText::_('The (com_reservation.bbbclass) type alias was removed from the <b>#__content_type</b> table'));
			}

			// Remove Bbbclass items from the contentitem tag map table
			$bbbclass_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_reservation.bbbclass') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__contentitem_tag_map'));
			$query->where($bbbclass_condition);
			$db->setQuery($query);
			// Execute the query to remove Bbbclass items
			$bbbclass_done = $db->execute();
			if ($bbbclass_done)
			{
				// If successfully remove Bbbclass add queued success message.
				$app->enqueueMessage(JText::_('The (com_reservation.bbbclass) type alias was removed from the <b>#__contentitem_tag_map</b> table'));
			}

			// Remove Bbbclass items from the ucm content table
			$bbbclass_condition = array( $db->quoteName('core_type_alias') . ' = ' . $db->quote('com_reservation.bbbclass') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__ucm_content'));
			$query->where($bbbclass_condition);
			$db->setQuery($query);
			// Execute the query to remove Bbbclass items
			$bbbclass_done = $db->execute();
			if ($bbbclass_done)
			{
				// If successfully removed Bbbclass add queued success message.
				$app->enqueueMessage(JText::_('The (com_reservation.bbbclass) type alias was removed from the <b>#__ucm_content</b> table'));
			}

			// Make sure that all the Bbbclass items are cleared from DB
			foreach ($bbbclass_ids as $bbbclass_id)
			{
				// Remove Bbbclass items from the ucm base table
				$bbbclass_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $bbbclass_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_base'));
				$query->where($bbbclass_condition);
				$db->setQuery($query);
				// Execute the query to remove Bbbclass items
				$db->execute();

				// Remove Bbbclass items from the ucm history table
				$bbbclass_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $bbbclass_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_history'));
				$query->where($bbbclass_condition);
				$db->setQuery($query);
				// Execute the query to remove Bbbclass items
				$db->execute();
			}
		}

		// Create a new query object.
		$query = $db->getQuery(true);
		// Select id from content type table
		$query->select($db->quoteName('type_id'));
		$query->from($db->quoteName('#__content_types'));
		// Where Doctor alias is found
		$query->where( $db->quoteName('type_alias') . ' = '. $db->quote('com_reservation.doctor') );
		$db->setQuery($query);
		// Execute query to see if alias is found
		$db->execute();
		$doctor_found = $db->getNumRows();
		// Now check if there were any rows
		if ($doctor_found)
		{
			// Since there are load the needed  doctor type ids
			$doctor_ids = $db->loadColumn();
			// Remove Doctor from the content type table
			$doctor_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_reservation.doctor') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__content_types'));
			$query->where($doctor_condition);
			$db->setQuery($query);
			// Execute the query to remove Doctor items
			$doctor_done = $db->execute();
			if ($doctor_done)
			{
				// If successfully remove Doctor add queued success message.
				$app->enqueueMessage(JText::_('The (com_reservation.doctor) type alias was removed from the <b>#__content_type</b> table'));
			}

			// Remove Doctor items from the contentitem tag map table
			$doctor_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_reservation.doctor') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__contentitem_tag_map'));
			$query->where($doctor_condition);
			$db->setQuery($query);
			// Execute the query to remove Doctor items
			$doctor_done = $db->execute();
			if ($doctor_done)
			{
				// If successfully remove Doctor add queued success message.
				$app->enqueueMessage(JText::_('The (com_reservation.doctor) type alias was removed from the <b>#__contentitem_tag_map</b> table'));
			}

			// Remove Doctor items from the ucm content table
			$doctor_condition = array( $db->quoteName('core_type_alias') . ' = ' . $db->quote('com_reservation.doctor') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__ucm_content'));
			$query->where($doctor_condition);
			$db->setQuery($query);
			// Execute the query to remove Doctor items
			$doctor_done = $db->execute();
			if ($doctor_done)
			{
				// If successfully removed Doctor add queued success message.
				$app->enqueueMessage(JText::_('The (com_reservation.doctor) type alias was removed from the <b>#__ucm_content</b> table'));
			}

			// Make sure that all the Doctor items are cleared from DB
			foreach ($doctor_ids as $doctor_id)
			{
				// Remove Doctor items from the ucm base table
				$doctor_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $doctor_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_base'));
				$query->where($doctor_condition);
				$db->setQuery($query);
				// Execute the query to remove Doctor items
				$db->execute();

				// Remove Doctor items from the ucm history table
				$doctor_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $doctor_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_history'));
				$query->where($doctor_condition);
				$db->setQuery($query);
				// Execute the query to remove Doctor items
				$db->execute();
			}
		}

		// Create a new query object.
		$query = $db->getQuery(true);
		// Select id from content type table
		$query->select($db->quoteName('type_id'));
		$query->from($db->quoteName('#__content_types'));
		// Where Doctor catid alias is found
		$query->where( $db->quoteName('type_alias') . ' = '. $db->quote('com_reservation.doctor.category') );
		$db->setQuery($query);
		// Execute query to see if alias is found
		$db->execute();
		$doctor_catid_found = $db->getNumRows();
		// Now check if there were any rows
		if ($doctor_catid_found)
		{
			// Since there are load the needed  doctor_catid type ids
			$doctor_catid_ids = $db->loadColumn();
			// Remove Doctor catid from the content type table
			$doctor_catid_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_reservation.doctor.category') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__content_types'));
			$query->where($doctor_catid_condition);
			$db->setQuery($query);
			// Execute the query to remove Doctor catid items
			$doctor_catid_done = $db->execute();
			if ($doctor_catid_done)
			{
				// If successfully remove Doctor catid add queued success message.
				$app->enqueueMessage(JText::_('The (com_reservation.doctor.category) type alias was removed from the <b>#__content_type</b> table'));
			}

			// Remove Doctor catid items from the contentitem tag map table
			$doctor_catid_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_reservation.doctor.category') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__contentitem_tag_map'));
			$query->where($doctor_catid_condition);
			$db->setQuery($query);
			// Execute the query to remove Doctor catid items
			$doctor_catid_done = $db->execute();
			if ($doctor_catid_done)
			{
				// If successfully remove Doctor catid add queued success message.
				$app->enqueueMessage(JText::_('The (com_reservation.doctor.category) type alias was removed from the <b>#__contentitem_tag_map</b> table'));
			}

			// Remove Doctor catid items from the ucm content table
			$doctor_catid_condition = array( $db->quoteName('core_type_alias') . ' = ' . $db->quote('com_reservation.doctor.category') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__ucm_content'));
			$query->where($doctor_catid_condition);
			$db->setQuery($query);
			// Execute the query to remove Doctor catid items
			$doctor_catid_done = $db->execute();
			if ($doctor_catid_done)
			{
				// If successfully removed Doctor catid add queued success message.
				$app->enqueueMessage(JText::_('The (com_reservation.doctor.category) type alias was removed from the <b>#__ucm_content</b> table'));
			}

			// Make sure that all the Doctor catid items are cleared from DB
			foreach ($doctor_catid_ids as $doctor_catid_id)
			{
				// Remove Doctor catid items from the ucm base table
				$doctor_catid_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $doctor_catid_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_base'));
				$query->where($doctor_catid_condition);
				$db->setQuery($query);
				// Execute the query to remove Doctor catid items
				$db->execute();

				// Remove Doctor catid items from the ucm history table
				$doctor_catid_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $doctor_catid_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_history'));
				$query->where($doctor_catid_condition);
				$db->setQuery($query);
				// Execute the query to remove Doctor catid items
				$db->execute();
			}
		}

		// Create a new query object.
		$query = $db->getQuery(true);
		// Select id from content type table
		$query->select($db->quoteName('type_id'));
		$query->from($db->quoteName('#__content_types'));
		// Where Appointment alias is found
		$query->where( $db->quoteName('type_alias') . ' = '. $db->quote('com_reservation.appointment') );
		$db->setQuery($query);
		// Execute query to see if alias is found
		$db->execute();
		$appointment_found = $db->getNumRows();
		// Now check if there were any rows
		if ($appointment_found)
		{
			// Since there are load the needed  appointment type ids
			$appointment_ids = $db->loadColumn();
			// Remove Appointment from the content type table
			$appointment_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_reservation.appointment') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__content_types'));
			$query->where($appointment_condition);
			$db->setQuery($query);
			// Execute the query to remove Appointment items
			$appointment_done = $db->execute();
			if ($appointment_done)
			{
				// If successfully remove Appointment add queued success message.
				$app->enqueueMessage(JText::_('The (com_reservation.appointment) type alias was removed from the <b>#__content_type</b> table'));
			}

			// Remove Appointment items from the contentitem tag map table
			$appointment_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_reservation.appointment') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__contentitem_tag_map'));
			$query->where($appointment_condition);
			$db->setQuery($query);
			// Execute the query to remove Appointment items
			$appointment_done = $db->execute();
			if ($appointment_done)
			{
				// If successfully remove Appointment add queued success message.
				$app->enqueueMessage(JText::_('The (com_reservation.appointment) type alias was removed from the <b>#__contentitem_tag_map</b> table'));
			}

			// Remove Appointment items from the ucm content table
			$appointment_condition = array( $db->quoteName('core_type_alias') . ' = ' . $db->quote('com_reservation.appointment') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__ucm_content'));
			$query->where($appointment_condition);
			$db->setQuery($query);
			// Execute the query to remove Appointment items
			$appointment_done = $db->execute();
			if ($appointment_done)
			{
				// If successfully removed Appointment add queued success message.
				$app->enqueueMessage(JText::_('The (com_reservation.appointment) type alias was removed from the <b>#__ucm_content</b> table'));
			}

			// Make sure that all the Appointment items are cleared from DB
			foreach ($appointment_ids as $appointment_id)
			{
				// Remove Appointment items from the ucm base table
				$appointment_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $appointment_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_base'));
				$query->where($appointment_condition);
				$db->setQuery($query);
				// Execute the query to remove Appointment items
				$db->execute();

				// Remove Appointment items from the ucm history table
				$appointment_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $appointment_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_history'));
				$query->where($appointment_condition);
				$db->setQuery($query);
				// Execute the query to remove Appointment items
				$db->execute();
			}
		}

		// Create a new query object.
		$query = $db->getQuery(true);
		// Select id from content type table
		$query->select($db->quoteName('type_id'));
		$query->from($db->quoteName('#__content_types'));
		// Where Capital alias is found
		$query->where( $db->quoteName('type_alias') . ' = '. $db->quote('com_reservation.capital') );
		$db->setQuery($query);
		// Execute query to see if alias is found
		$db->execute();
		$capital_found = $db->getNumRows();
		// Now check if there were any rows
		if ($capital_found)
		{
			// Since there are load the needed  capital type ids
			$capital_ids = $db->loadColumn();
			// Remove Capital from the content type table
			$capital_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_reservation.capital') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__content_types'));
			$query->where($capital_condition);
			$db->setQuery($query);
			// Execute the query to remove Capital items
			$capital_done = $db->execute();
			if ($capital_done)
			{
				// If successfully remove Capital add queued success message.
				$app->enqueueMessage(JText::_('The (com_reservation.capital) type alias was removed from the <b>#__content_type</b> table'));
			}

			// Remove Capital items from the contentitem tag map table
			$capital_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_reservation.capital') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__contentitem_tag_map'));
			$query->where($capital_condition);
			$db->setQuery($query);
			// Execute the query to remove Capital items
			$capital_done = $db->execute();
			if ($capital_done)
			{
				// If successfully remove Capital add queued success message.
				$app->enqueueMessage(JText::_('The (com_reservation.capital) type alias was removed from the <b>#__contentitem_tag_map</b> table'));
			}

			// Remove Capital items from the ucm content table
			$capital_condition = array( $db->quoteName('core_type_alias') . ' = ' . $db->quote('com_reservation.capital') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__ucm_content'));
			$query->where($capital_condition);
			$db->setQuery($query);
			// Execute the query to remove Capital items
			$capital_done = $db->execute();
			if ($capital_done)
			{
				// If successfully removed Capital add queued success message.
				$app->enqueueMessage(JText::_('The (com_reservation.capital) type alias was removed from the <b>#__ucm_content</b> table'));
			}

			// Make sure that all the Capital items are cleared from DB
			foreach ($capital_ids as $capital_id)
			{
				// Remove Capital items from the ucm base table
				$capital_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $capital_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_base'));
				$query->where($capital_condition);
				$db->setQuery($query);
				// Execute the query to remove Capital items
				$db->execute();

				// Remove Capital items from the ucm history table
				$capital_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $capital_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_history'));
				$query->where($capital_condition);
				$db->setQuery($query);
				// Execute the query to remove Capital items
				$db->execute();
			}
		}

		// Create a new query object.
		$query = $db->getQuery(true);
		// Select id from content type table
		$query->select($db->quoteName('type_id'));
		$query->from($db->quoteName('#__content_types'));
		// Where Comment alias is found
		$query->where( $db->quoteName('type_alias') . ' = '. $db->quote('com_reservation.comment') );
		$db->setQuery($query);
		// Execute query to see if alias is found
		$db->execute();
		$comment_found = $db->getNumRows();
		// Now check if there were any rows
		if ($comment_found)
		{
			// Since there are load the needed  comment type ids
			$comment_ids = $db->loadColumn();
			// Remove Comment from the content type table
			$comment_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_reservation.comment') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__content_types'));
			$query->where($comment_condition);
			$db->setQuery($query);
			// Execute the query to remove Comment items
			$comment_done = $db->execute();
			if ($comment_done)
			{
				// If successfully remove Comment add queued success message.
				$app->enqueueMessage(JText::_('The (com_reservation.comment) type alias was removed from the <b>#__content_type</b> table'));
			}

			// Remove Comment items from the contentitem tag map table
			$comment_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_reservation.comment') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__contentitem_tag_map'));
			$query->where($comment_condition);
			$db->setQuery($query);
			// Execute the query to remove Comment items
			$comment_done = $db->execute();
			if ($comment_done)
			{
				// If successfully remove Comment add queued success message.
				$app->enqueueMessage(JText::_('The (com_reservation.comment) type alias was removed from the <b>#__contentitem_tag_map</b> table'));
			}

			// Remove Comment items from the ucm content table
			$comment_condition = array( $db->quoteName('core_type_alias') . ' = ' . $db->quote('com_reservation.comment') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__ucm_content'));
			$query->where($comment_condition);
			$db->setQuery($query);
			// Execute the query to remove Comment items
			$comment_done = $db->execute();
			if ($comment_done)
			{
				// If successfully removed Comment add queued success message.
				$app->enqueueMessage(JText::_('The (com_reservation.comment) type alias was removed from the <b>#__ucm_content</b> table'));
			}

			// Make sure that all the Comment items are cleared from DB
			foreach ($comment_ids as $comment_id)
			{
				// Remove Comment items from the ucm base table
				$comment_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $comment_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_base'));
				$query->where($comment_condition);
				$db->setQuery($query);
				// Execute the query to remove Comment items
				$db->execute();

				// Remove Comment items from the ucm history table
				$comment_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $comment_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_history'));
				$query->where($comment_condition);
				$db->setQuery($query);
				// Execute the query to remove Comment items
				$db->execute();
			}
		}

		// Create a new query object.
		$query = $db->getQuery(true);
		// Select id from content type table
		$query->select($db->quoteName('type_id'));
		$query->from($db->quoteName('#__content_types'));
		// Where Session alias is found
		$query->where( $db->quoteName('type_alias') . ' = '. $db->quote('com_reservation.session') );
		$db->setQuery($query);
		// Execute query to see if alias is found
		$db->execute();
		$session_found = $db->getNumRows();
		// Now check if there were any rows
		if ($session_found)
		{
			// Since there are load the needed  session type ids
			$session_ids = $db->loadColumn();
			// Remove Session from the content type table
			$session_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_reservation.session') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__content_types'));
			$query->where($session_condition);
			$db->setQuery($query);
			// Execute the query to remove Session items
			$session_done = $db->execute();
			if ($session_done)
			{
				// If successfully remove Session add queued success message.
				$app->enqueueMessage(JText::_('The (com_reservation.session) type alias was removed from the <b>#__content_type</b> table'));
			}

			// Remove Session items from the contentitem tag map table
			$session_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_reservation.session') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__contentitem_tag_map'));
			$query->where($session_condition);
			$db->setQuery($query);
			// Execute the query to remove Session items
			$session_done = $db->execute();
			if ($session_done)
			{
				// If successfully remove Session add queued success message.
				$app->enqueueMessage(JText::_('The (com_reservation.session) type alias was removed from the <b>#__contentitem_tag_map</b> table'));
			}

			// Remove Session items from the ucm content table
			$session_condition = array( $db->quoteName('core_type_alias') . ' = ' . $db->quote('com_reservation.session') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__ucm_content'));
			$query->where($session_condition);
			$db->setQuery($query);
			// Execute the query to remove Session items
			$session_done = $db->execute();
			if ($session_done)
			{
				// If successfully removed Session add queued success message.
				$app->enqueueMessage(JText::_('The (com_reservation.session) type alias was removed from the <b>#__ucm_content</b> table'));
			}

			// Make sure that all the Session items are cleared from DB
			foreach ($session_ids as $session_id)
			{
				// Remove Session items from the ucm base table
				$session_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $session_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_base'));
				$query->where($session_condition);
				$db->setQuery($query);
				// Execute the query to remove Session items
				$db->execute();

				// Remove Session items from the ucm history table
				$session_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $session_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_history'));
				$query->where($session_condition);
				$db->setQuery($query);
				// Execute the query to remove Session items
				$db->execute();
			}
		}

		// Create a new query object.
		$query = $db->getQuery(true);
		// Select id from content type table
		$query->select($db->quoteName('type_id'));
		$query->from($db->quoteName('#__content_types'));
		// Where Sick alias is found
		$query->where( $db->quoteName('type_alias') . ' = '. $db->quote('com_reservation.sick') );
		$db->setQuery($query);
		// Execute query to see if alias is found
		$db->execute();
		$sick_found = $db->getNumRows();
		// Now check if there were any rows
		if ($sick_found)
		{
			// Since there are load the needed  sick type ids
			$sick_ids = $db->loadColumn();
			// Remove Sick from the content type table
			$sick_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_reservation.sick') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__content_types'));
			$query->where($sick_condition);
			$db->setQuery($query);
			// Execute the query to remove Sick items
			$sick_done = $db->execute();
			if ($sick_done)
			{
				// If successfully remove Sick add queued success message.
				$app->enqueueMessage(JText::_('The (com_reservation.sick) type alias was removed from the <b>#__content_type</b> table'));
			}

			// Remove Sick items from the contentitem tag map table
			$sick_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_reservation.sick') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__contentitem_tag_map'));
			$query->where($sick_condition);
			$db->setQuery($query);
			// Execute the query to remove Sick items
			$sick_done = $db->execute();
			if ($sick_done)
			{
				// If successfully remove Sick add queued success message.
				$app->enqueueMessage(JText::_('The (com_reservation.sick) type alias was removed from the <b>#__contentitem_tag_map</b> table'));
			}

			// Remove Sick items from the ucm content table
			$sick_condition = array( $db->quoteName('core_type_alias') . ' = ' . $db->quote('com_reservation.sick') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__ucm_content'));
			$query->where($sick_condition);
			$db->setQuery($query);
			// Execute the query to remove Sick items
			$sick_done = $db->execute();
			if ($sick_done)
			{
				// If successfully removed Sick add queued success message.
				$app->enqueueMessage(JText::_('The (com_reservation.sick) type alias was removed from the <b>#__ucm_content</b> table'));
			}

			// Make sure that all the Sick items are cleared from DB
			foreach ($sick_ids as $sick_id)
			{
				// Remove Sick items from the ucm base table
				$sick_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $sick_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_base'));
				$query->where($sick_condition);
				$db->setQuery($query);
				// Execute the query to remove Sick items
				$db->execute();

				// Remove Sick items from the ucm history table
				$sick_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $sick_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_history'));
				$query->where($sick_condition);
				$db->setQuery($query);
				// Execute the query to remove Sick items
				$db->execute();
			}
		}

		// Create a new query object.
		$query = $db->getQuery(true);
		// Select id from content type table
		$query->select($db->quoteName('type_id'));
		$query->from($db->quoteName('#__content_types'));
		// Where Plan alias is found
		$query->where( $db->quoteName('type_alias') . ' = '. $db->quote('com_reservation.plan') );
		$db->setQuery($query);
		// Execute query to see if alias is found
		$db->execute();
		$plan_found = $db->getNumRows();
		// Now check if there were any rows
		if ($plan_found)
		{
			// Since there are load the needed  plan type ids
			$plan_ids = $db->loadColumn();
			// Remove Plan from the content type table
			$plan_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_reservation.plan') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__content_types'));
			$query->where($plan_condition);
			$db->setQuery($query);
			// Execute the query to remove Plan items
			$plan_done = $db->execute();
			if ($plan_done)
			{
				// If successfully remove Plan add queued success message.
				$app->enqueueMessage(JText::_('The (com_reservation.plan) type alias was removed from the <b>#__content_type</b> table'));
			}

			// Remove Plan items from the contentitem tag map table
			$plan_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_reservation.plan') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__contentitem_tag_map'));
			$query->where($plan_condition);
			$db->setQuery($query);
			// Execute the query to remove Plan items
			$plan_done = $db->execute();
			if ($plan_done)
			{
				// If successfully remove Plan add queued success message.
				$app->enqueueMessage(JText::_('The (com_reservation.plan) type alias was removed from the <b>#__contentitem_tag_map</b> table'));
			}

			// Remove Plan items from the ucm content table
			$plan_condition = array( $db->quoteName('core_type_alias') . ' = ' . $db->quote('com_reservation.plan') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__ucm_content'));
			$query->where($plan_condition);
			$db->setQuery($query);
			// Execute the query to remove Plan items
			$plan_done = $db->execute();
			if ($plan_done)
			{
				// If successfully removed Plan add queued success message.
				$app->enqueueMessage(JText::_('The (com_reservation.plan) type alias was removed from the <b>#__ucm_content</b> table'));
			}

			// Make sure that all the Plan items are cleared from DB
			foreach ($plan_ids as $plan_id)
			{
				// Remove Plan items from the ucm base table
				$plan_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $plan_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_base'));
				$query->where($plan_condition);
				$db->setQuery($query);
				// Execute the query to remove Plan items
				$db->execute();

				// Remove Plan items from the ucm history table
				$plan_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $plan_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_history'));
				$query->where($plan_condition);
				$db->setQuery($query);
				// Execute the query to remove Plan items
				$db->execute();
			}
		}

		// Create a new query object.
		$query = $db->getQuery(true);
		// Select id from content type table
		$query->select($db->quoteName('type_id'));
		$query->from($db->quoteName('#__content_types'));
		// Where Consultant alias is found
		$query->where( $db->quoteName('type_alias') . ' = '. $db->quote('com_reservation.consultant') );
		$db->setQuery($query);
		// Execute query to see if alias is found
		$db->execute();
		$consultant_found = $db->getNumRows();
		// Now check if there were any rows
		if ($consultant_found)
		{
			// Since there are load the needed  consultant type ids
			$consultant_ids = $db->loadColumn();
			// Remove Consultant from the content type table
			$consultant_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_reservation.consultant') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__content_types'));
			$query->where($consultant_condition);
			$db->setQuery($query);
			// Execute the query to remove Consultant items
			$consultant_done = $db->execute();
			if ($consultant_done)
			{
				// If successfully remove Consultant add queued success message.
				$app->enqueueMessage(JText::_('The (com_reservation.consultant) type alias was removed from the <b>#__content_type</b> table'));
			}

			// Remove Consultant items from the contentitem tag map table
			$consultant_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_reservation.consultant') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__contentitem_tag_map'));
			$query->where($consultant_condition);
			$db->setQuery($query);
			// Execute the query to remove Consultant items
			$consultant_done = $db->execute();
			if ($consultant_done)
			{
				// If successfully remove Consultant add queued success message.
				$app->enqueueMessage(JText::_('The (com_reservation.consultant) type alias was removed from the <b>#__contentitem_tag_map</b> table'));
			}

			// Remove Consultant items from the ucm content table
			$consultant_condition = array( $db->quoteName('core_type_alias') . ' = ' . $db->quote('com_reservation.consultant') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__ucm_content'));
			$query->where($consultant_condition);
			$db->setQuery($query);
			// Execute the query to remove Consultant items
			$consultant_done = $db->execute();
			if ($consultant_done)
			{
				// If successfully removed Consultant add queued success message.
				$app->enqueueMessage(JText::_('The (com_reservation.consultant) type alias was removed from the <b>#__ucm_content</b> table'));
			}

			// Make sure that all the Consultant items are cleared from DB
			foreach ($consultant_ids as $consultant_id)
			{
				// Remove Consultant items from the ucm base table
				$consultant_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $consultant_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_base'));
				$query->where($consultant_condition);
				$db->setQuery($query);
				// Execute the query to remove Consultant items
				$db->execute();

				// Remove Consultant items from the ucm history table
				$consultant_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $consultant_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_history'));
				$query->where($consultant_condition);
				$db->setQuery($query);
				// Execute the query to remove Consultant items
				$db->execute();
			}
		}

		// Create a new query object.
		$query = $db->getQuery(true);
		// Select id from content type table
		$query->select($db->quoteName('type_id'));
		$query->from($db->quoteName('#__content_types'));
		// Where Consultant catid alias is found
		$query->where( $db->quoteName('type_alias') . ' = '. $db->quote('com_reservation.consultant.category') );
		$db->setQuery($query);
		// Execute query to see if alias is found
		$db->execute();
		$consultant_catid_found = $db->getNumRows();
		// Now check if there were any rows
		if ($consultant_catid_found)
		{
			// Since there are load the needed  consultant_catid type ids
			$consultant_catid_ids = $db->loadColumn();
			// Remove Consultant catid from the content type table
			$consultant_catid_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_reservation.consultant.category') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__content_types'));
			$query->where($consultant_catid_condition);
			$db->setQuery($query);
			// Execute the query to remove Consultant catid items
			$consultant_catid_done = $db->execute();
			if ($consultant_catid_done)
			{
				// If successfully remove Consultant catid add queued success message.
				$app->enqueueMessage(JText::_('The (com_reservation.consultant.category) type alias was removed from the <b>#__content_type</b> table'));
			}

			// Remove Consultant catid items from the contentitem tag map table
			$consultant_catid_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_reservation.consultant.category') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__contentitem_tag_map'));
			$query->where($consultant_catid_condition);
			$db->setQuery($query);
			// Execute the query to remove Consultant catid items
			$consultant_catid_done = $db->execute();
			if ($consultant_catid_done)
			{
				// If successfully remove Consultant catid add queued success message.
				$app->enqueueMessage(JText::_('The (com_reservation.consultant.category) type alias was removed from the <b>#__contentitem_tag_map</b> table'));
			}

			// Remove Consultant catid items from the ucm content table
			$consultant_catid_condition = array( $db->quoteName('core_type_alias') . ' = ' . $db->quote('com_reservation.consultant.category') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__ucm_content'));
			$query->where($consultant_catid_condition);
			$db->setQuery($query);
			// Execute the query to remove Consultant catid items
			$consultant_catid_done = $db->execute();
			if ($consultant_catid_done)
			{
				// If successfully removed Consultant catid add queued success message.
				$app->enqueueMessage(JText::_('The (com_reservation.consultant.category) type alias was removed from the <b>#__ucm_content</b> table'));
			}

			// Make sure that all the Consultant catid items are cleared from DB
			foreach ($consultant_catid_ids as $consultant_catid_id)
			{
				// Remove Consultant catid items from the ucm base table
				$consultant_catid_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $consultant_catid_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_base'));
				$query->where($consultant_catid_condition);
				$db->setQuery($query);
				// Execute the query to remove Consultant catid items
				$db->execute();

				// Remove Consultant catid items from the ucm history table
				$consultant_catid_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $consultant_catid_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_history'));
				$query->where($consultant_catid_condition);
				$db->setQuery($query);
				// Execute the query to remove Consultant catid items
				$db->execute();
			}
		}

		// Create a new query object.
		$query = $db->getQuery(true);
		// Select id from content type table
		$query->select($db->quoteName('type_id'));
		$query->from($db->quoteName('#__content_types'));
		// Where Message alias is found
		$query->where( $db->quoteName('type_alias') . ' = '. $db->quote('com_reservation.message') );
		$db->setQuery($query);
		// Execute query to see if alias is found
		$db->execute();
		$message_found = $db->getNumRows();
		// Now check if there were any rows
		if ($message_found)
		{
			// Since there are load the needed  message type ids
			$message_ids = $db->loadColumn();
			// Remove Message from the content type table
			$message_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_reservation.message') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__content_types'));
			$query->where($message_condition);
			$db->setQuery($query);
			// Execute the query to remove Message items
			$message_done = $db->execute();
			if ($message_done)
			{
				// If successfully remove Message add queued success message.
				$app->enqueueMessage(JText::_('The (com_reservation.message) type alias was removed from the <b>#__content_type</b> table'));
			}

			// Remove Message items from the contentitem tag map table
			$message_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_reservation.message') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__contentitem_tag_map'));
			$query->where($message_condition);
			$db->setQuery($query);
			// Execute the query to remove Message items
			$message_done = $db->execute();
			if ($message_done)
			{
				// If successfully remove Message add queued success message.
				$app->enqueueMessage(JText::_('The (com_reservation.message) type alias was removed from the <b>#__contentitem_tag_map</b> table'));
			}

			// Remove Message items from the ucm content table
			$message_condition = array( $db->quoteName('core_type_alias') . ' = ' . $db->quote('com_reservation.message') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__ucm_content'));
			$query->where($message_condition);
			$db->setQuery($query);
			// Execute the query to remove Message items
			$message_done = $db->execute();
			if ($message_done)
			{
				// If successfully removed Message add queued success message.
				$app->enqueueMessage(JText::_('The (com_reservation.message) type alias was removed from the <b>#__ucm_content</b> table'));
			}

			// Make sure that all the Message items are cleared from DB
			foreach ($message_ids as $message_id)
			{
				// Remove Message items from the ucm base table
				$message_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $message_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_base'));
				$query->where($message_condition);
				$db->setQuery($query);
				// Execute the query to remove Message items
				$db->execute();

				// Remove Message items from the ucm history table
				$message_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $message_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_history'));
				$query->where($message_condition);
				$db->setQuery($query);
				// Execute the query to remove Message items
				$db->execute();
			}
		}

		// If All related items was removed queued success message.
		$app->enqueueMessage(JText::_('All related items was removed from the <b>#__ucm_base</b> table'));
		$app->enqueueMessage(JText::_('All related items was removed from the <b>#__ucm_history</b> table'));

		// Remove reservation assets from the assets table
		$reservation_condition = array( $db->quoteName('name') . ' LIKE ' . $db->quote('com_reservation%') );

		// Create a new query object.
		$query = $db->getQuery(true);
		$query->delete($db->quoteName('#__assets'));
		$query->where($reservation_condition);
		$db->setQuery($query);
		$message_done = $db->execute();
		if ($message_done)
		{
			// If successfully removed reservation add queued success message.
			$app->enqueueMessage(JText::_('All related items was removed from the <b>#__assets</b> table'));
		}

		// little notice as after service, in case of bad experience with component.
		echo '<h2>Did something go wrong? Are you disappointed?</h2>
		<p>Please let me know at <a href="mailto:farhad.shahbazi0010@gmail.com">farhad.shahbazi0010@gmail.com</a>.
		<br />We at fdsh are committed to building extensions that performs proficiently! You can help us, really!
		<br />Send me your thoughts on improvements that is needed, trust me, I will be very grateful!
		<br />Visit us at <a href="http://farhad.com" target="_blank">http://farhad.com</a> today!</p>';
	}

	/**
	 * Called on update
	 *
	 * @param   JAdapterInstance  $parent  The object responsible for running this script
	 *
	 * @return  boolean  True on success
	 */
	public function update(JAdapterInstance $parent){}

	/**
	 * Called before any type of action
	 *
	 * @param   string  $type  Which action is happening (install|uninstall|discover_install|update)
	 * @param   JAdapterInstance  $parent  The object responsible for running this script
	 *
	 * @return  boolean  True on success
	 */
	public function preflight($type, JAdapterInstance $parent)
	{
		// get application
		$app = JFactory::getApplication();
		// is redundant or so it seems ...hmmm let me know if it works again
		if ($type === 'uninstall')
		{
			return true;
		}
		// the default for both install and update
		$jversion = new JVersion();
		if (!$jversion->isCompatible('3.8.0'))
		{
			$app->enqueueMessage('Please upgrade to at least Joomla! 3.8.0 before continuing!', 'error');
			return false;
		}
		// do any updates needed
		if ($type === 'update')
		{
		}
		// do any install needed
		if ($type === 'install')
		{
		}
		// check if the PHPExcel stuff is still around
		if (File::exists(JPATH_ADMINISTRATOR . '/components/com_reservation/helpers/PHPExcel.php'))
		{
			// We need to remove this old PHPExcel folder
			$this->removeFolder(JPATH_ADMINISTRATOR . '/components/com_reservation/helpers/PHPExcel');
			// We need to remove this old PHPExcel file
			File::delete(JPATH_ADMINISTRATOR . '/components/com_reservation/helpers/PHPExcel.php');
		}
		return true;
	}

	/**
	 * Called after any type of action
	 *
	 * @param   string  $type  Which action is happening (install|uninstall|discover_install|update)
	 * @param   JAdapterInstance  $parent  The object responsible for running this script
	 *
	 * @return  boolean  True on success
	 */
	public function postflight($type, JAdapterInstance $parent)
	{
		// get application
		$app = JFactory::getApplication();
		// We check if we have dynamic folders to copy
		$this->setDynamicF0ld3rs($app, $parent);
		// set the default component settings
		if ($type === 'install')
		{

			// Get The Database object
			$db = JFactory::getDbo();

			// Create the reserve content type object.
			$reserve = new stdClass();
			$reserve->type_title = 'Reservation Reserve';
			$reserve->type_alias = 'com_reservation.reserve';
			$reserve->table = '{"special": {"dbtable": "#__reservation_reserve","key": "id","type": "Reserve","prefix": "reservationTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$reserve->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "appointmentid","core_state": "published","core_alias": "null","core_created_time": "created","core_modified_time": "modified","core_body": "null","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "access","core_params": "params","core_featured": "null","core_metadata": "null","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "null","core_metadesc": "null","core_catid": "null","core_xreference": "null","asset_id": "asset_id"},"special": {"appointmentid":"appointmentid","sickid":"sickid","full_price":"full_price","doctor_quota":"doctor_quota","system_quota":"system_quota","status":"status","payment_method":"payment_method","tracking_code":"tracking_code"}}';
			$reserve->router = 'ReservationHelperRoute::getReserveRoute';
			$reserve->content_history_options = '{"formFile": "administrator/components/com_reservation/models/forms/reserve.xml","hideFields": ["asset_id","checked_out","checked_out_time","version"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","appointmentid","sickid"],"displayLookup": [{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "access","targetTable": "#__viewlevels","targetColumn": "id","displayColumn": "title"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "appointmentid","targetTable": "#__reservation_appointment","targetColumn": "id","displayColumn": "appointment"},{"sourceColumn": "sickid","targetTable": "#__reservation_sick","targetColumn": "id","displayColumn": "phonenumber"}]}';

			// Set the object into the content types table.
			$reserve_Inserted = $db->insertObject('#__content_types', $reserve);

			// Create the bbbclass content type object.
			$bbbclass = new stdClass();
			$bbbclass->type_title = 'Reservation Bbbclass';
			$bbbclass->type_alias = 'com_reservation.bbbclass';
			$bbbclass->table = '{"special": {"dbtable": "#__reservation_bbbclass","key": "id","type": "Bbbclass","prefix": "reservationTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$bbbclass->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "name","core_state": "published","core_alias": "null","core_created_time": "created","core_modified_time": "modified","core_body": "null","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "access","core_params": "params","core_featured": "null","core_metadata": "null","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "null","core_metadesc": "null","core_catid": "null","core_xreference": "null","asset_id": "asset_id"},"special": {"name":"name","planid":"planid","seid":"seid","exmid":"exmid","inmid":"inmid","mpass":"mpass","vpass":"vpass"}}';
			$bbbclass->router = 'ReservationHelperRoute::getBbbclassRoute';
			$bbbclass->content_history_options = '{"formFile": "administrator/components/com_reservation/models/forms/bbbclass.xml","hideFields": ["asset_id","checked_out","checked_out_time","version"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","planid","seid"],"displayLookup": [{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "access","targetTable": "#__viewlevels","targetColumn": "id","displayColumn": "title"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "planid","targetTable": "#__reservation_plan","targetColumn": "id","displayColumn": "id"}]}';

			// Set the object into the content types table.
			$bbbclass_Inserted = $db->insertObject('#__content_types', $bbbclass);

			// Create the doctor content type object.
			$doctor = new stdClass();
			$doctor->type_title = 'Reservation Doctor';
			$doctor->type_alias = 'com_reservation.doctor';
			$doctor->table = '{"special": {"dbtable": "#__reservation_doctor","key": "id","type": "Doctor","prefix": "reservationTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$doctor->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "userid","core_state": "published","core_alias": "null","core_created_time": "created","core_modified_time": "modified","core_body": "address","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "access","core_params": "params","core_featured": "null","core_metadata": "null","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "null","core_metadesc": "null","core_catid": "catid","core_xreference": "null","asset_id": "asset_id"},"special": {"userid":"userid","msn":"msn","phonenumber":"phonenumber","officephone":"officephone","address":"address","presence":"presence","image":"image","capitalid":"capitalid","cityid":"cityid","alt":"alt"}}';
			$doctor->router = 'ReservationHelperRoute::getDoctorRoute';
			$doctor->content_history_options = '{"formFile": "administrator/components/com_reservation/models/forms/doctor.xml","hideFields": ["asset_id","checked_out","checked_out_time","version"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","userid","catid","capitalid","cityid"],"displayLookup": [{"sourceColumn": "catid","targetTable": "#__categories","targetColumn": "id","displayColumn": "title"},{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "access","targetTable": "#__viewlevels","targetColumn": "id","displayColumn": "title"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "capitalid","targetTable": "#__reservation_capital","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "cityid","targetTable": "#__reservation_capital","targetColumn": "id","displayColumn": "name"}]}';

			// Set the object into the content types table.
			$doctor_Inserted = $db->insertObject('#__content_types', $doctor);

			// Create the doctor category content type object.
			$doctor_category = new stdClass();
			$doctor_category->type_title = 'Reservation Doctor Catid';
			$doctor_category->type_alias = 'com_reservation.doctor.category';
			$doctor_category->table = '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}';
			$doctor_category->field_mappings = '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}, "special":{"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}}';
			$doctor_category->router = 'ReservationHelperRoute::getCategoryRoute';
			$doctor_category->content_history_options = '{"formFile":"administrator\/components\/com_categories\/models\/forms\/category.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"],"convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}';

			// Set the object into the content types table.
			$doctor_category_Inserted = $db->insertObject('#__content_types', $doctor_category);

			// Create the appointment content type object.
			$appointment = new stdClass();
			$appointment->type_title = 'Reservation Appointment';
			$appointment->type_alias = 'com_reservation.appointment';
			$appointment->table = '{"special": {"dbtable": "#__reservation_appointment","key": "id","type": "Appointment","prefix": "reservationTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$appointment->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "title","core_state": "published","core_alias": "null","core_created_time": "created","core_modified_time": "modified","core_body": "null","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "access","core_params": "params","core_featured": "null","core_metadata": "null","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "null","core_metadesc": "null","core_catid": "null","core_xreference": "null","asset_id": "asset_id"},"special": {"title":"title","appointment":"appointment","doctorid":"doctorid"}}';
			$appointment->router = 'ReservationHelperRoute::getAppointmentRoute';
			$appointment->content_history_options = '{"formFile": "administrator/components/com_reservation/models/forms/appointment.xml","hideFields": ["asset_id","checked_out","checked_out_time","version"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","doctorid"],"displayLookup": [{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "access","targetTable": "#__viewlevels","targetColumn": "id","displayColumn": "title"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "doctorid","targetTable": "#__reservation_consultant","targetColumn": "id","displayColumn": "id"}]}';

			// Set the object into the content types table.
			$appointment_Inserted = $db->insertObject('#__content_types', $appointment);

			// Create the capital content type object.
			$capital = new stdClass();
			$capital->type_title = 'Reservation Capital';
			$capital->type_alias = 'com_reservation.capital';
			$capital->table = '{"special": {"dbtable": "#__reservation_capital","key": "id","type": "Capital","prefix": "reservationTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$capital->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "name","core_state": "published","core_alias": "null","core_created_time": "created","core_modified_time": "modified","core_body": "null","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "access","core_params": "params","core_featured": "null","core_metadata": "null","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "null","core_metadesc": "null","core_catid": "null","core_xreference": "null","asset_id": "asset_id"},"special": {"name":"name","capitalid":"capitalid"}}';
			$capital->router = 'ReservationHelperRoute::getCapitalRoute';
			$capital->content_history_options = '{"formFile": "administrator/components/com_reservation/models/forms/capital.xml","hideFields": ["asset_id","checked_out","checked_out_time","version"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","capitalid"],"displayLookup": [{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "access","targetTable": "#__viewlevels","targetColumn": "id","displayColumn": "title"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "capitalid","targetTable": "#__reservation_capital","targetColumn": "id","displayColumn": "name"}]}';

			// Set the object into the content types table.
			$capital_Inserted = $db->insertObject('#__content_types', $capital);

			// Create the comment content type object.
			$comment = new stdClass();
			$comment->type_title = 'Reservation Comment';
			$comment->type_alias = 'com_reservation.comment';
			$comment->table = '{"special": {"dbtable": "#__reservation_comment","key": "id","type": "Comment","prefix": "reservationTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$comment->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "text","core_state": "published","core_alias": "null","core_created_time": "created","core_modified_time": "modified","core_body": "null","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "access","core_params": "params","core_featured": "null","core_metadata": "null","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "null","core_metadesc": "null","core_catid": "null","core_xreference": "null","asset_id": "asset_id"},"special": {"text":"text","consultantid":"consultantid","sickid":"sickid","rate":"rate","seid":"seid","token":"token"}}';
			$comment->router = 'ReservationHelperRoute::getCommentRoute';
			$comment->content_history_options = '{"formFile": "administrator/components/com_reservation/models/forms/comment.xml","hideFields": ["asset_id","checked_out","checked_out_time","version"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","consultantid","sickid","seid"],"displayLookup": [{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "access","targetTable": "#__viewlevels","targetColumn": "id","displayColumn": "title"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "consultantid","targetTable": "#__reservation_consultant","targetColumn": "id","displayColumn": "id"},{"sourceColumn": "sickid","targetTable": "#__reservation_sick","targetColumn": "id","displayColumn": "phonenumber"}]}';

			// Set the object into the content types table.
			$comment_Inserted = $db->insertObject('#__content_types', $comment);

			// Create the session content type object.
			$session = new stdClass();
			$session->type_title = 'Reservation Session';
			$session->type_alias = 'com_reservation.session';
			$session->table = '{"special": {"dbtable": "#__reservation_session","key": "id","type": "Session","prefix": "reservationTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$session->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "sickid","core_state": "published","core_alias": "null","core_created_time": "created","core_modified_time": "modified","core_body": "null","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "access","core_params": "params","core_featured": "null","core_metadata": "null","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "null","core_metadesc": "null","core_catid": "null","core_xreference": "null","asset_id": "asset_id"},"special": {"sickid":"sickid","planid":"planid","pay":"pay","finish":"finish","channel_token":"channel_token","firsttext":"firsttext"}}';
			$session->router = 'ReservationHelperRoute::getSessionRoute';
			$session->content_history_options = '{"formFile": "administrator/components/com_reservation/models/forms/session.xml","hideFields": ["asset_id","checked_out","checked_out_time","version"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","sickid","planid","pay","finish"],"displayLookup": [{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "access","targetTable": "#__viewlevels","targetColumn": "id","displayColumn": "title"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "sickid","targetTable": "#__reservation_sick","targetColumn": "id","displayColumn": "phonenumber"},{"sourceColumn": "planid","targetTable": "#__reservation_plan","targetColumn": "id","displayColumn": "id"}]}';

			// Set the object into the content types table.
			$session_Inserted = $db->insertObject('#__content_types', $session);

			// Create the sick content type object.
			$sick = new stdClass();
			$sick->type_title = 'Reservation Sick';
			$sick->type_alias = 'com_reservation.sick';
			$sick->table = '{"special": {"dbtable": "#__reservation_sick","key": "id","type": "Sick","prefix": "reservationTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$sick->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "userid","core_state": "published","core_alias": "null","core_created_time": "created","core_modified_time": "modified","core_body": "null","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "access","core_params": "params","core_featured": "null","core_metadata": "null","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "null","core_metadesc": "null","core_catid": "null","core_xreference": "null","asset_id": "asset_id"},"special": {"userid":"userid","phonenumber":"phonenumber","capitalid":"capitalid","cityid":"cityid","image":"image","cardnumber":"cardnumber","alt":"alt"}}';
			$sick->router = 'ReservationHelperRoute::getSickRoute';
			$sick->content_history_options = '{"formFile": "administrator/components/com_reservation/models/forms/sick.xml","hideFields": ["asset_id","checked_out","checked_out_time","version"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","userid","capitalid","cityid"],"displayLookup": [{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "access","targetTable": "#__viewlevels","targetColumn": "id","displayColumn": "title"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "capitalid","targetTable": "#__reservation_capital","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "cityid","targetTable": "#__reservation_capital","targetColumn": "id","displayColumn": "name"}]}';

			// Set the object into the content types table.
			$sick_Inserted = $db->insertObject('#__content_types', $sick);

			// Create the plan content type object.
			$plan = new stdClass();
			$plan->type_title = 'Reservation Plan';
			$plan->type_alias = 'com_reservation.plan';
			$plan->table = '{"special": {"dbtable": "#__reservation_plan","key": "id","type": "Plan","prefix": "reservationTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$plan->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "plantype","core_state": "published","core_alias": "null","core_created_time": "created","core_modified_time": "modified","core_body": "null","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "access","core_params": "params","core_featured": "null","core_metadata": "null","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "null","core_metadesc": "null","core_catid": "null","core_xreference": "null","asset_id": "asset_id"},"special": {"plantype":"plantype","time":"time","price":"price","waitingtime":"waitingtime","consultantid":"consultantid"}}';
			$plan->router = 'ReservationHelperRoute::getPlanRoute';
			$plan->content_history_options = '{"formFile": "administrator/components/com_reservation/models/forms/plan.xml","hideFields": ["asset_id","checked_out","checked_out_time","version"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","consultantid"],"displayLookup": [{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "access","targetTable": "#__viewlevels","targetColumn": "id","displayColumn": "title"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "consultantid","targetTable": "#__reservation_consultant","targetColumn": "id","displayColumn": "id"}]}';

			// Set the object into the content types table.
			$plan_Inserted = $db->insertObject('#__content_types', $plan);

			// Create the consultant content type object.
			$consultant = new stdClass();
			$consultant->type_title = 'Reservation Consultant';
			$consultant->type_alias = 'com_reservation.consultant';
			$consultant->table = '{"special": {"dbtable": "#__reservation_consultant","key": "id","type": "Consultant","prefix": "reservationTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$consultant->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "userid","core_state": "published","core_alias": "null","core_created_time": "created","core_modified_time": "modified","core_body": "address","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "access","core_params": "params","core_featured": "null","core_metadata": "null","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "null","core_metadesc": "null","core_catid": "catid","core_xreference": "null","asset_id": "asset_id"},"special": {"userid":"userid","nationalnumber":"nationalnumber","image":"image","experience":"experience","msn":"msn","phonenumber":"phonenumber","shortlink":"shortlink","account":"account","address":"address","presence":"presence","video":"video","alt":"alt","officephone":"officephone","capitalid":"capitalid","cityid":"cityid","introduction":"introduction"}}';
			$consultant->router = 'ReservationHelperRoute::getConsultantRoute';
			$consultant->content_history_options = '{"formFile": "administrator/components/com_reservation/models/forms/consultant.xml","hideFields": ["asset_id","checked_out","checked_out_time","version"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","userid","catid","capitalid","cityid"],"displayLookup": [{"sourceColumn": "catid","targetTable": "#__categories","targetColumn": "id","displayColumn": "title"},{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "access","targetTable": "#__viewlevels","targetColumn": "id","displayColumn": "title"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "capitalid","targetTable": "#__reservation_capital","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "cityid","targetTable": "#__reservation_capital","targetColumn": "id","displayColumn": "name"}]}';

			// Set the object into the content types table.
			$consultant_Inserted = $db->insertObject('#__content_types', $consultant);

			// Create the consultant category content type object.
			$consultant_category = new stdClass();
			$consultant_category->type_title = 'Reservation Consultant Catid';
			$consultant_category->type_alias = 'com_reservation.consultant.category';
			$consultant_category->table = '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}';
			$consultant_category->field_mappings = '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}, "special":{"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}}';
			$consultant_category->router = 'ReservationHelperRoute::getCategoryRoute';
			$consultant_category->content_history_options = '{"formFile":"administrator\/components\/com_categories\/models\/forms\/category.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"],"convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}';

			// Set the object into the content types table.
			$consultant_category_Inserted = $db->insertObject('#__content_types', $consultant_category);

			// Create the message content type object.
			$message = new stdClass();
			$message->type_title = 'Reservation Message';
			$message->type_alias = 'com_reservation.message';
			$message->table = '{"special": {"dbtable": "#__reservation_message","key": "id","type": "Message","prefix": "reservationTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$message->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "null","core_state": "published","core_alias": "null","core_created_time": "created","core_modified_time": "modified","core_body": "null","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "access","core_params": "params","core_featured": "null","core_metadata": "null","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "null","core_metadesc": "null","core_catid": "null","core_xreference": "null","asset_id": "asset_id"},"special": {"from":"from","to":"to","reply":"reply","message":"message","read":"read","seen":"seen","seid":"seid"}}';
			$message->router = 'ReservationHelperRoute::getMessageRoute';
			$message->content_history_options = '{"formFile": "administrator/components/com_reservation/models/forms/message.xml","hideFields": ["asset_id","checked_out","checked_out_time","version"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","from","to","reply","read","seen","seid"],"displayLookup": [{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "access","targetTable": "#__viewlevels","targetColumn": "id","displayColumn": "title"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "reply","targetTable": "#__reservation_message","targetColumn": "id","displayColumn": "message"}]}';

			// Set the object into the content types table.
			$message_Inserted = $db->insertObject('#__content_types', $message);


			// Install the global extenstion params.
			$query = $db->getQuery(true);
			// Field to update.
			$fields = array(
				$db->quoteName('params') . ' = ' . $db->quote('{"autorName":"farhad shahbazi","autorEmail":"farhad.shahbazi0010@gmail.com","consultantgroup":"0","doctorgroup":"0","sickgroup":"0","imgext":"jpg,jpeg,png,gif,bmp,jfif,pjpeg,webp,tif,tiff","check_in":"-1 day","save_history":"1","history_limit":"10"}'),
			);
			// Condition.
			$conditions = array(
				$db->quoteName('element') . ' = ' . $db->quote('com_reservation')
			);
			$query->update($db->quoteName('#__extensions'))->set($fields)->where($conditions);
			$db->setQuery($query);
			$allDone = $db->execute();

			echo '<a target="_blank" href="http://farhad.com" title="Reservation">
				<img src="components/com_reservation/assets/images/vdm-component.jpg"/>
				</a>';
		}
		// do any updates needed
		if ($type === 'update')
		{

			// Get The Database object
			$db = JFactory::getDbo();

			// Create the reserve content type object.
			$reserve = new stdClass();
			$reserve->type_title = 'Reservation Reserve';
			$reserve->type_alias = 'com_reservation.reserve';
			$reserve->table = '{"special": {"dbtable": "#__reservation_reserve","key": "id","type": "Reserve","prefix": "reservationTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$reserve->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "appointmentid","core_state": "published","core_alias": "null","core_created_time": "created","core_modified_time": "modified","core_body": "null","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "access","core_params": "params","core_featured": "null","core_metadata": "null","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "null","core_metadesc": "null","core_catid": "null","core_xreference": "null","asset_id": "asset_id"},"special": {"appointmentid":"appointmentid","sickid":"sickid","full_price":"full_price","doctor_quota":"doctor_quota","system_quota":"system_quota","status":"status","payment_method":"payment_method","tracking_code":"tracking_code"}}';
			$reserve->router = 'ReservationHelperRoute::getReserveRoute';
			$reserve->content_history_options = '{"formFile": "administrator/components/com_reservation/models/forms/reserve.xml","hideFields": ["asset_id","checked_out","checked_out_time","version"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","appointmentid","sickid"],"displayLookup": [{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "access","targetTable": "#__viewlevels","targetColumn": "id","displayColumn": "title"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "appointmentid","targetTable": "#__reservation_appointment","targetColumn": "id","displayColumn": "appointment"},{"sourceColumn": "sickid","targetTable": "#__reservation_sick","targetColumn": "id","displayColumn": "phonenumber"}]}';

			// Check if reserve type is already in content_type DB.
			$reserve_id = null;
			$query = $db->getQuery(true);
			$query->select($db->quoteName(array('type_id')));
			$query->from($db->quoteName('#__content_types'));
			$query->where($db->quoteName('type_alias') . ' LIKE '. $db->quote($reserve->type_alias));
			$db->setQuery($query);
			$db->execute();

			// Set the object into the content types table.
			if ($db->getNumRows())
			{
				$reserve->type_id = $db->loadResult();
				$reserve_Updated = $db->updateObject('#__content_types', $reserve, 'type_id');
			}
			else
			{
				$reserve_Inserted = $db->insertObject('#__content_types', $reserve);
			}

			// Create the bbbclass content type object.
			$bbbclass = new stdClass();
			$bbbclass->type_title = 'Reservation Bbbclass';
			$bbbclass->type_alias = 'com_reservation.bbbclass';
			$bbbclass->table = '{"special": {"dbtable": "#__reservation_bbbclass","key": "id","type": "Bbbclass","prefix": "reservationTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$bbbclass->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "name","core_state": "published","core_alias": "null","core_created_time": "created","core_modified_time": "modified","core_body": "null","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "access","core_params": "params","core_featured": "null","core_metadata": "null","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "null","core_metadesc": "null","core_catid": "null","core_xreference": "null","asset_id": "asset_id"},"special": {"name":"name","planid":"planid","seid":"seid","exmid":"exmid","inmid":"inmid","mpass":"mpass","vpass":"vpass"}}';
			$bbbclass->router = 'ReservationHelperRoute::getBbbclassRoute';
			$bbbclass->content_history_options = '{"formFile": "administrator/components/com_reservation/models/forms/bbbclass.xml","hideFields": ["asset_id","checked_out","checked_out_time","version"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","planid","seid"],"displayLookup": [{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "access","targetTable": "#__viewlevels","targetColumn": "id","displayColumn": "title"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "planid","targetTable": "#__reservation_plan","targetColumn": "id","displayColumn": "id"}]}';

			// Check if bbbclass type is already in content_type DB.
			$bbbclass_id = null;
			$query = $db->getQuery(true);
			$query->select($db->quoteName(array('type_id')));
			$query->from($db->quoteName('#__content_types'));
			$query->where($db->quoteName('type_alias') . ' LIKE '. $db->quote($bbbclass->type_alias));
			$db->setQuery($query);
			$db->execute();

			// Set the object into the content types table.
			if ($db->getNumRows())
			{
				$bbbclass->type_id = $db->loadResult();
				$bbbclass_Updated = $db->updateObject('#__content_types', $bbbclass, 'type_id');
			}
			else
			{
				$bbbclass_Inserted = $db->insertObject('#__content_types', $bbbclass);
			}

			// Create the doctor content type object.
			$doctor = new stdClass();
			$doctor->type_title = 'Reservation Doctor';
			$doctor->type_alias = 'com_reservation.doctor';
			$doctor->table = '{"special": {"dbtable": "#__reservation_doctor","key": "id","type": "Doctor","prefix": "reservationTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$doctor->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "userid","core_state": "published","core_alias": "null","core_created_time": "created","core_modified_time": "modified","core_body": "address","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "access","core_params": "params","core_featured": "null","core_metadata": "null","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "null","core_metadesc": "null","core_catid": "catid","core_xreference": "null","asset_id": "asset_id"},"special": {"userid":"userid","msn":"msn","phonenumber":"phonenumber","officephone":"officephone","address":"address","presence":"presence","image":"image","capitalid":"capitalid","cityid":"cityid","alt":"alt"}}';
			$doctor->router = 'ReservationHelperRoute::getDoctorRoute';
			$doctor->content_history_options = '{"formFile": "administrator/components/com_reservation/models/forms/doctor.xml","hideFields": ["asset_id","checked_out","checked_out_time","version"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","userid","catid","capitalid","cityid"],"displayLookup": [{"sourceColumn": "catid","targetTable": "#__categories","targetColumn": "id","displayColumn": "title"},{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "access","targetTable": "#__viewlevels","targetColumn": "id","displayColumn": "title"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "capitalid","targetTable": "#__reservation_capital","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "cityid","targetTable": "#__reservation_capital","targetColumn": "id","displayColumn": "name"}]}';

			// Check if doctor type is already in content_type DB.
			$doctor_id = null;
			$query = $db->getQuery(true);
			$query->select($db->quoteName(array('type_id')));
			$query->from($db->quoteName('#__content_types'));
			$query->where($db->quoteName('type_alias') . ' LIKE '. $db->quote($doctor->type_alias));
			$db->setQuery($query);
			$db->execute();

			// Set the object into the content types table.
			if ($db->getNumRows())
			{
				$doctor->type_id = $db->loadResult();
				$doctor_Updated = $db->updateObject('#__content_types', $doctor, 'type_id');
			}
			else
			{
				$doctor_Inserted = $db->insertObject('#__content_types', $doctor);
			}

			// Create the doctor category content type object.
			$doctor_category = new stdClass();
			$doctor_category->type_title = 'Reservation Doctor Catid';
			$doctor_category->type_alias = 'com_reservation.doctor.category';
			$doctor_category->table = '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}';
			$doctor_category->field_mappings = '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}, "special":{"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}}';
			$doctor_category->router = 'ReservationHelperRoute::getCategoryRoute';
			$doctor_category->content_history_options = '{"formFile":"administrator\/components\/com_categories\/models\/forms\/category.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"],"convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}';

			// Check if doctor category type is already in content_type DB.
			$doctor_category_id = null;
			$query = $db->getQuery(true);
			$query->select($db->quoteName(array('type_id')));
			$query->from($db->quoteName('#__content_types'));
			$query->where($db->quoteName('type_alias') . ' LIKE '. $db->quote($doctor_category->type_alias));
			$db->setQuery($query);
			$db->execute();

			// Set the object into the content types table.
			if ($db->getNumRows())
			{
				$doctor_category->type_id = $db->loadResult();
				$doctor_category_Updated = $db->updateObject('#__content_types', $doctor_category, 'type_id');
			}
			else
			{
				$doctor_category_Inserted = $db->insertObject('#__content_types', $doctor_category);
			}

			// Create the appointment content type object.
			$appointment = new stdClass();
			$appointment->type_title = 'Reservation Appointment';
			$appointment->type_alias = 'com_reservation.appointment';
			$appointment->table = '{"special": {"dbtable": "#__reservation_appointment","key": "id","type": "Appointment","prefix": "reservationTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$appointment->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "title","core_state": "published","core_alias": "null","core_created_time": "created","core_modified_time": "modified","core_body": "null","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "access","core_params": "params","core_featured": "null","core_metadata": "null","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "null","core_metadesc": "null","core_catid": "null","core_xreference": "null","asset_id": "asset_id"},"special": {"title":"title","appointment":"appointment","doctorid":"doctorid"}}';
			$appointment->router = 'ReservationHelperRoute::getAppointmentRoute';
			$appointment->content_history_options = '{"formFile": "administrator/components/com_reservation/models/forms/appointment.xml","hideFields": ["asset_id","checked_out","checked_out_time","version"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","doctorid"],"displayLookup": [{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "access","targetTable": "#__viewlevels","targetColumn": "id","displayColumn": "title"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "doctorid","targetTable": "#__reservation_consultant","targetColumn": "id","displayColumn": "id"}]}';

			// Check if appointment type is already in content_type DB.
			$appointment_id = null;
			$query = $db->getQuery(true);
			$query->select($db->quoteName(array('type_id')));
			$query->from($db->quoteName('#__content_types'));
			$query->where($db->quoteName('type_alias') . ' LIKE '. $db->quote($appointment->type_alias));
			$db->setQuery($query);
			$db->execute();

			// Set the object into the content types table.
			if ($db->getNumRows())
			{
				$appointment->type_id = $db->loadResult();
				$appointment_Updated = $db->updateObject('#__content_types', $appointment, 'type_id');
			}
			else
			{
				$appointment_Inserted = $db->insertObject('#__content_types', $appointment);
			}

			// Create the capital content type object.
			$capital = new stdClass();
			$capital->type_title = 'Reservation Capital';
			$capital->type_alias = 'com_reservation.capital';
			$capital->table = '{"special": {"dbtable": "#__reservation_capital","key": "id","type": "Capital","prefix": "reservationTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$capital->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "name","core_state": "published","core_alias": "null","core_created_time": "created","core_modified_time": "modified","core_body": "null","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "access","core_params": "params","core_featured": "null","core_metadata": "null","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "null","core_metadesc": "null","core_catid": "null","core_xreference": "null","asset_id": "asset_id"},"special": {"name":"name","capitalid":"capitalid"}}';
			$capital->router = 'ReservationHelperRoute::getCapitalRoute';
			$capital->content_history_options = '{"formFile": "administrator/components/com_reservation/models/forms/capital.xml","hideFields": ["asset_id","checked_out","checked_out_time","version"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","capitalid"],"displayLookup": [{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "access","targetTable": "#__viewlevels","targetColumn": "id","displayColumn": "title"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "capitalid","targetTable": "#__reservation_capital","targetColumn": "id","displayColumn": "name"}]}';

			// Check if capital type is already in content_type DB.
			$capital_id = null;
			$query = $db->getQuery(true);
			$query->select($db->quoteName(array('type_id')));
			$query->from($db->quoteName('#__content_types'));
			$query->where($db->quoteName('type_alias') . ' LIKE '. $db->quote($capital->type_alias));
			$db->setQuery($query);
			$db->execute();

			// Set the object into the content types table.
			if ($db->getNumRows())
			{
				$capital->type_id = $db->loadResult();
				$capital_Updated = $db->updateObject('#__content_types', $capital, 'type_id');
			}
			else
			{
				$capital_Inserted = $db->insertObject('#__content_types', $capital);
			}

			// Create the comment content type object.
			$comment = new stdClass();
			$comment->type_title = 'Reservation Comment';
			$comment->type_alias = 'com_reservation.comment';
			$comment->table = '{"special": {"dbtable": "#__reservation_comment","key": "id","type": "Comment","prefix": "reservationTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$comment->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "text","core_state": "published","core_alias": "null","core_created_time": "created","core_modified_time": "modified","core_body": "null","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "access","core_params": "params","core_featured": "null","core_metadata": "null","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "null","core_metadesc": "null","core_catid": "null","core_xreference": "null","asset_id": "asset_id"},"special": {"text":"text","consultantid":"consultantid","sickid":"sickid","rate":"rate","seid":"seid","token":"token"}}';
			$comment->router = 'ReservationHelperRoute::getCommentRoute';
			$comment->content_history_options = '{"formFile": "administrator/components/com_reservation/models/forms/comment.xml","hideFields": ["asset_id","checked_out","checked_out_time","version"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","consultantid","sickid","seid"],"displayLookup": [{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "access","targetTable": "#__viewlevels","targetColumn": "id","displayColumn": "title"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "consultantid","targetTable": "#__reservation_consultant","targetColumn": "id","displayColumn": "id"},{"sourceColumn": "sickid","targetTable": "#__reservation_sick","targetColumn": "id","displayColumn": "phonenumber"}]}';

			// Check if comment type is already in content_type DB.
			$comment_id = null;
			$query = $db->getQuery(true);
			$query->select($db->quoteName(array('type_id')));
			$query->from($db->quoteName('#__content_types'));
			$query->where($db->quoteName('type_alias') . ' LIKE '. $db->quote($comment->type_alias));
			$db->setQuery($query);
			$db->execute();

			// Set the object into the content types table.
			if ($db->getNumRows())
			{
				$comment->type_id = $db->loadResult();
				$comment_Updated = $db->updateObject('#__content_types', $comment, 'type_id');
			}
			else
			{
				$comment_Inserted = $db->insertObject('#__content_types', $comment);
			}

			// Create the session content type object.
			$session = new stdClass();
			$session->type_title = 'Reservation Session';
			$session->type_alias = 'com_reservation.session';
			$session->table = '{"special": {"dbtable": "#__reservation_session","key": "id","type": "Session","prefix": "reservationTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$session->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "sickid","core_state": "published","core_alias": "null","core_created_time": "created","core_modified_time": "modified","core_body": "null","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "access","core_params": "params","core_featured": "null","core_metadata": "null","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "null","core_metadesc": "null","core_catid": "null","core_xreference": "null","asset_id": "asset_id"},"special": {"sickid":"sickid","planid":"planid","pay":"pay","finish":"finish","channel_token":"channel_token","firsttext":"firsttext"}}';
			$session->router = 'ReservationHelperRoute::getSessionRoute';
			$session->content_history_options = '{"formFile": "administrator/components/com_reservation/models/forms/session.xml","hideFields": ["asset_id","checked_out","checked_out_time","version"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","sickid","planid","pay","finish"],"displayLookup": [{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "access","targetTable": "#__viewlevels","targetColumn": "id","displayColumn": "title"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "sickid","targetTable": "#__reservation_sick","targetColumn": "id","displayColumn": "phonenumber"},{"sourceColumn": "planid","targetTable": "#__reservation_plan","targetColumn": "id","displayColumn": "id"}]}';

			// Check if session type is already in content_type DB.
			$session_id = null;
			$query = $db->getQuery(true);
			$query->select($db->quoteName(array('type_id')));
			$query->from($db->quoteName('#__content_types'));
			$query->where($db->quoteName('type_alias') . ' LIKE '. $db->quote($session->type_alias));
			$db->setQuery($query);
			$db->execute();

			// Set the object into the content types table.
			if ($db->getNumRows())
			{
				$session->type_id = $db->loadResult();
				$session_Updated = $db->updateObject('#__content_types', $session, 'type_id');
			}
			else
			{
				$session_Inserted = $db->insertObject('#__content_types', $session);
			}

			// Create the sick content type object.
			$sick = new stdClass();
			$sick->type_title = 'Reservation Sick';
			$sick->type_alias = 'com_reservation.sick';
			$sick->table = '{"special": {"dbtable": "#__reservation_sick","key": "id","type": "Sick","prefix": "reservationTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$sick->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "userid","core_state": "published","core_alias": "null","core_created_time": "created","core_modified_time": "modified","core_body": "null","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "access","core_params": "params","core_featured": "null","core_metadata": "null","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "null","core_metadesc": "null","core_catid": "null","core_xreference": "null","asset_id": "asset_id"},"special": {"userid":"userid","phonenumber":"phonenumber","capitalid":"capitalid","cityid":"cityid","image":"image","cardnumber":"cardnumber","alt":"alt"}}';
			$sick->router = 'ReservationHelperRoute::getSickRoute';
			$sick->content_history_options = '{"formFile": "administrator/components/com_reservation/models/forms/sick.xml","hideFields": ["asset_id","checked_out","checked_out_time","version"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","userid","capitalid","cityid"],"displayLookup": [{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "access","targetTable": "#__viewlevels","targetColumn": "id","displayColumn": "title"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "capitalid","targetTable": "#__reservation_capital","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "cityid","targetTable": "#__reservation_capital","targetColumn": "id","displayColumn": "name"}]}';

			// Check if sick type is already in content_type DB.
			$sick_id = null;
			$query = $db->getQuery(true);
			$query->select($db->quoteName(array('type_id')));
			$query->from($db->quoteName('#__content_types'));
			$query->where($db->quoteName('type_alias') . ' LIKE '. $db->quote($sick->type_alias));
			$db->setQuery($query);
			$db->execute();

			// Set the object into the content types table.
			if ($db->getNumRows())
			{
				$sick->type_id = $db->loadResult();
				$sick_Updated = $db->updateObject('#__content_types', $sick, 'type_id');
			}
			else
			{
				$sick_Inserted = $db->insertObject('#__content_types', $sick);
			}

			// Create the plan content type object.
			$plan = new stdClass();
			$plan->type_title = 'Reservation Plan';
			$plan->type_alias = 'com_reservation.plan';
			$plan->table = '{"special": {"dbtable": "#__reservation_plan","key": "id","type": "Plan","prefix": "reservationTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$plan->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "plantype","core_state": "published","core_alias": "null","core_created_time": "created","core_modified_time": "modified","core_body": "null","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "access","core_params": "params","core_featured": "null","core_metadata": "null","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "null","core_metadesc": "null","core_catid": "null","core_xreference": "null","asset_id": "asset_id"},"special": {"plantype":"plantype","time":"time","price":"price","waitingtime":"waitingtime","consultantid":"consultantid"}}';
			$plan->router = 'ReservationHelperRoute::getPlanRoute';
			$plan->content_history_options = '{"formFile": "administrator/components/com_reservation/models/forms/plan.xml","hideFields": ["asset_id","checked_out","checked_out_time","version"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","consultantid"],"displayLookup": [{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "access","targetTable": "#__viewlevels","targetColumn": "id","displayColumn": "title"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "consultantid","targetTable": "#__reservation_consultant","targetColumn": "id","displayColumn": "id"}]}';

			// Check if plan type is already in content_type DB.
			$plan_id = null;
			$query = $db->getQuery(true);
			$query->select($db->quoteName(array('type_id')));
			$query->from($db->quoteName('#__content_types'));
			$query->where($db->quoteName('type_alias') . ' LIKE '. $db->quote($plan->type_alias));
			$db->setQuery($query);
			$db->execute();

			// Set the object into the content types table.
			if ($db->getNumRows())
			{
				$plan->type_id = $db->loadResult();
				$plan_Updated = $db->updateObject('#__content_types', $plan, 'type_id');
			}
			else
			{
				$plan_Inserted = $db->insertObject('#__content_types', $plan);
			}

			// Create the consultant content type object.
			$consultant = new stdClass();
			$consultant->type_title = 'Reservation Consultant';
			$consultant->type_alias = 'com_reservation.consultant';
			$consultant->table = '{"special": {"dbtable": "#__reservation_consultant","key": "id","type": "Consultant","prefix": "reservationTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$consultant->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "userid","core_state": "published","core_alias": "null","core_created_time": "created","core_modified_time": "modified","core_body": "address","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "access","core_params": "params","core_featured": "null","core_metadata": "null","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "null","core_metadesc": "null","core_catid": "catid","core_xreference": "null","asset_id": "asset_id"},"special": {"userid":"userid","nationalnumber":"nationalnumber","image":"image","experience":"experience","msn":"msn","phonenumber":"phonenumber","shortlink":"shortlink","account":"account","address":"address","presence":"presence","video":"video","alt":"alt","officephone":"officephone","capitalid":"capitalid","cityid":"cityid","introduction":"introduction"}}';
			$consultant->router = 'ReservationHelperRoute::getConsultantRoute';
			$consultant->content_history_options = '{"formFile": "administrator/components/com_reservation/models/forms/consultant.xml","hideFields": ["asset_id","checked_out","checked_out_time","version"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","userid","catid","capitalid","cityid"],"displayLookup": [{"sourceColumn": "catid","targetTable": "#__categories","targetColumn": "id","displayColumn": "title"},{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "access","targetTable": "#__viewlevels","targetColumn": "id","displayColumn": "title"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "capitalid","targetTable": "#__reservation_capital","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "cityid","targetTable": "#__reservation_capital","targetColumn": "id","displayColumn": "name"}]}';

			// Check if consultant type is already in content_type DB.
			$consultant_id = null;
			$query = $db->getQuery(true);
			$query->select($db->quoteName(array('type_id')));
			$query->from($db->quoteName('#__content_types'));
			$query->where($db->quoteName('type_alias') . ' LIKE '. $db->quote($consultant->type_alias));
			$db->setQuery($query);
			$db->execute();

			// Set the object into the content types table.
			if ($db->getNumRows())
			{
				$consultant->type_id = $db->loadResult();
				$consultant_Updated = $db->updateObject('#__content_types', $consultant, 'type_id');
			}
			else
			{
				$consultant_Inserted = $db->insertObject('#__content_types', $consultant);
			}

			// Create the consultant category content type object.
			$consultant_category = new stdClass();
			$consultant_category->type_title = 'Reservation Consultant Catid';
			$consultant_category->type_alias = 'com_reservation.consultant.category';
			$consultant_category->table = '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}';
			$consultant_category->field_mappings = '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}, "special":{"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}}';
			$consultant_category->router = 'ReservationHelperRoute::getCategoryRoute';
			$consultant_category->content_history_options = '{"formFile":"administrator\/components\/com_categories\/models\/forms\/category.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"],"convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}';

			// Check if consultant category type is already in content_type DB.
			$consultant_category_id = null;
			$query = $db->getQuery(true);
			$query->select($db->quoteName(array('type_id')));
			$query->from($db->quoteName('#__content_types'));
			$query->where($db->quoteName('type_alias') . ' LIKE '. $db->quote($consultant_category->type_alias));
			$db->setQuery($query);
			$db->execute();

			// Set the object into the content types table.
			if ($db->getNumRows())
			{
				$consultant_category->type_id = $db->loadResult();
				$consultant_category_Updated = $db->updateObject('#__content_types', $consultant_category, 'type_id');
			}
			else
			{
				$consultant_category_Inserted = $db->insertObject('#__content_types', $consultant_category);
			}

			// Create the message content type object.
			$message = new stdClass();
			$message->type_title = 'Reservation Message';
			$message->type_alias = 'com_reservation.message';
			$message->table = '{"special": {"dbtable": "#__reservation_message","key": "id","type": "Message","prefix": "reservationTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$message->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "null","core_state": "published","core_alias": "null","core_created_time": "created","core_modified_time": "modified","core_body": "null","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "access","core_params": "params","core_featured": "null","core_metadata": "null","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "null","core_metadesc": "null","core_catid": "null","core_xreference": "null","asset_id": "asset_id"},"special": {"from":"from","to":"to","reply":"reply","message":"message","read":"read","seen":"seen","seid":"seid"}}';
			$message->router = 'ReservationHelperRoute::getMessageRoute';
			$message->content_history_options = '{"formFile": "administrator/components/com_reservation/models/forms/message.xml","hideFields": ["asset_id","checked_out","checked_out_time","version"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","from","to","reply","read","seen","seid"],"displayLookup": [{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "access","targetTable": "#__viewlevels","targetColumn": "id","displayColumn": "title"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "reply","targetTable": "#__reservation_message","targetColumn": "id","displayColumn": "message"}]}';

			// Check if message type is already in content_type DB.
			$message_id = null;
			$query = $db->getQuery(true);
			$query->select($db->quoteName(array('type_id')));
			$query->from($db->quoteName('#__content_types'));
			$query->where($db->quoteName('type_alias') . ' LIKE '. $db->quote($message->type_alias));
			$db->setQuery($query);
			$db->execute();

			// Set the object into the content types table.
			if ($db->getNumRows())
			{
				$message->type_id = $db->loadResult();
				$message_Updated = $db->updateObject('#__content_types', $message, 'type_id');
			}
			else
			{
				$message_Inserted = $db->insertObject('#__content_types', $message);
			}


			echo '<a target="_blank" href="http://farhad.com" title="Reservation">
				<img src="components/com_reservation/assets/images/vdm-component.jpg"/>
				</a>
				<h3>Upgrade to Version 1.0.39 Was Successful! Let us know if anything is not working as expected.</h3>';
		}
		return true;
	}

	/**
	 * Remove folders with files
	 * 
	 * @param   string   $dir     The path to folder to remove
	 * @param   boolean  $ignore  The folders and files to ignore and not remove
	 *
	 * @return  boolean   True in all is removed
	 * 
	 */
	protected function removeFolder($dir, $ignore = false)
	{
		if (Folder::exists($dir))
		{
			$it = new RecursiveDirectoryIterator($dir);
			$it = new RecursiveIteratorIterator($it, RecursiveIteratorIterator::CHILD_FIRST);
			// remove ending /
			$dir = rtrim($dir, '/');
			// now loop the files & folders
			foreach ($it as $file)
			{
				if ('.' === $file->getBasename() || '..' ===  $file->getBasename()) continue;
				// set file dir
				$file_dir = $file->getPathname();
				// check if this is a dir or a file
				if ($file->isDir())
				{
					$keeper = false;
					if ($this->checkArray($ignore))
					{
						foreach ($ignore as $keep)
						{
							if (strpos($file_dir, $dir.'/'.$keep) !== false)
							{
								$keeper = true;
							}
						}
					}
					if ($keeper)
					{
						continue;
					}
					Folder::delete($file_dir);
				}
				else
				{
					$keeper = false;
					if ($this->checkArray($ignore))
					{
						foreach ($ignore as $keep)
						{
							if (strpos($file_dir, $dir.'/'.$keep) !== false)
							{
								$keeper = true;
							}
						}
					}
					if ($keeper)
					{
						continue;
					}
					File::delete($file_dir);
				}
			}
			// delete the root folder if not ignore found
			if (!$this->checkArray($ignore))
			{
				return Folder::delete($dir);
			}
			return true;
		}
		return false;
	}

	/**
	 * Check if have an array with a length
	 *
	 * @input	array   The array to check
	 *
	 * @returns bool/int  number of items in array on success
	 */
	protected function checkArray($array, $removeEmptyString = false)
	{
		if (isset($array) && is_array($array) && ($nr = count((array)$array)) > 0)
		{
			// also make sure the empty strings are removed
			if ($removeEmptyString)
			{
				foreach ($array as $key => $string)
				{
					if (empty($string))
					{
						unset($array[$key]);
					}
				}
				return $this->checkArray($array, false);
			}
			return $nr;
		}
		return false;
	}

	/**
	 * Method to set/copy dynamic folders into place (use with caution)
	 *
	 * @return void
	 */
	protected function setDynamicF0ld3rs($app, $parent)
	{
		// get the instalation path
		$installer = $parent->getParent();
		$installPath = $installer->getPath('source');
		// get all the folders
		$folders = Folder::folders($installPath);
		// check if we have folders we may want to copy
		$doNotCopy = array('media','admin','site'); // Joomla already deals with these
		if (count((array) $folders) > 1)
		{
			foreach ($folders as $folder)
			{
				// Only copy if not a standard folders
				if (!in_array($folder, $doNotCopy))
				{
					// set the source path
					$src = $installPath.'/'.$folder;
					// set the destination path
					$dest = JPATH_ROOT.'/'.$folder;
					// now try to copy the folder
					if (!Folder::copy($src, $dest, '', true))
					{
						$app->enqueueMessage('Could not copy '.$folder.' folder into place, please make sure destination is writable!', 'error');
					}
				}
			}
		}
	}
}
