<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				fdsh 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.39
	@build			4th April, 2023
	@created		17th December, 2020
	@package		Reservation
	@subpackage		reservation.php
	@author			farhad shahbazi <http://farhad.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

/**
 * Reservation Model
 */
class ReservationModelReservation extends JModelList
{
	public function getIcons()
	{
		// load user for access menus
		$user = JFactory::getUser();
		// reset icon array
		$icons  = array();
		// view groups array
		$viewGroups = array(
			'main' => array('png.reserves', 'png.bbbclasses', 'png.doctors', 'png.doctors.catid_qpo0O0oqp_com_reservation', 'png.appointments', 'png.capitals', 'png.comments', 'png.sessions', 'png.sicks', 'png.plans', 'png.consultants', 'png.consultants.catid_qpo0O0oqp_com_reservation', 'png.messages')
		);
		// view access array
		$viewAccess = array(
			'reserves.access' => 'reserve.access',
			'reserve.access' => 'reserve.access',
			'reserves.submenu' => 'reserve.submenu',
			'reserves.dashboard_list' => 'reserve.dashboard_list',
			'bbbclasses.access' => 'bbbclass.access',
			'bbbclass.access' => 'bbbclass.access',
			'bbbclasses.submenu' => 'bbbclass.submenu',
			'bbbclasses.dashboard_list' => 'bbbclass.dashboard_list',
			'doctors.access' => 'doctor.access',
			'doctor.access' => 'doctor.access',
			'doctors.submenu' => 'doctor.submenu',
			'doctors.dashboard_list' => 'doctor.dashboard_list',
			'appointments.access' => 'appointment.access',
			'appointment.access' => 'appointment.access',
			'appointments.submenu' => 'appointment.submenu',
			'appointments.dashboard_list' => 'appointment.dashboard_list',
			'capitals.access' => 'capital.access',
			'capital.access' => 'capital.access',
			'capitals.submenu' => 'capital.submenu',
			'capitals.dashboard_list' => 'capital.dashboard_list',
			'comments.access' => 'comment.access',
			'comment.access' => 'comment.access',
			'comments.submenu' => 'comment.submenu',
			'comments.dashboard_list' => 'comment.dashboard_list',
			'sessions.access' => 'session.access',
			'session.access' => 'session.access',
			'sessions.submenu' => 'session.submenu',
			'sessions.dashboard_list' => 'session.dashboard_list',
			'sicks.access' => 'sick.access',
			'sick.access' => 'sick.access',
			'sicks.submenu' => 'sick.submenu',
			'sicks.dashboard_list' => 'sick.dashboard_list',
			'plans.access' => 'plan.access',
			'plan.access' => 'plan.access',
			'plans.submenu' => 'plan.submenu',
			'plans.dashboard_list' => 'plan.dashboard_list',
			'consultants.access' => 'consultant.access',
			'consultant.access' => 'consultant.access',
			'consultants.submenu' => 'consultant.submenu',
			'consultants.dashboard_list' => 'consultant.dashboard_list',
			'messages.access' => 'message.access',
			'message.access' => 'message.access',
			'messages.submenu' => 'message.submenu',
			'messages.dashboard_list' => 'message.dashboard_list');
		// loop over the $views
		foreach($viewGroups as $group => $views)
		{
			$i = 0;
			if (ReservationHelper::checkArray($views))
			{
				foreach($views as $view)
				{
					$add = false;
					// external views (links)
					if (strpos($view,'||') !== false)
					{
						$dwd = explode('||', $view);
						if (count($dwd) == 3)
						{
							list($type, $name, $url) = $dwd;
							$viewName 	= $name;
							$alt 		= $name;
							$url 		= $url;
							$image 		= $name . '.' . $type;
							$name 		= 'COM_RESERVATION_DASHBOARD_' . ReservationHelper::safeString($name,'U');
						}
					}
					// internal views
					elseif (strpos($view,'.') !== false)
					{
						$dwd = explode('.', $view);
						if (count($dwd) == 3)
						{
							list($type, $name, $action) = $dwd;
						}
						elseif (count($dwd) == 2)
						{
							list($type, $name) = $dwd;
							$action = false;
						}
						if ($action)
						{
							$viewName = $name;
							switch($action)
							{
								case 'add':
									$url	= 'index.php?option=com_reservation&view=' . $name . '&layout=edit';
									$image	= $name . '_' . $action.  '.' . $type;
									$alt	= $name . '&nbsp;' . $action;
									$name	= 'COM_RESERVATION_DASHBOARD_'.ReservationHelper::safeString($name,'U').'_ADD';
									$add	= true;
								break;
								default:
									// check for new convention (more stable)
									if (strpos($action, '_qpo0O0oqp_') !== false)
									{
										list($action, $extension) = (array) explode('_qpo0O0oqp_', $action);
										$extension = str_replace('_po0O0oq_', '.', $extension);
									}
									else
									{
										$extension = 'com_reservation.' . $name;
									}
									$url	= 'index.php?option=com_categories&view=categories&extension=' . $extension;
									$image	= $name . '_' . $action . '.' . $type;
									$alt	= $viewName . '&nbsp;' . $action;
									$name	= 'COM_RESERVATION_DASHBOARD_' . ReservationHelper::safeString($name,'U') . '_' . ReservationHelper::safeString($action,'U');
								break;
							}
						}
						else
						{
							$viewName 	= $name;
							$alt 		= $name;
							$url 		= 'index.php?option=com_reservation&view=' . $name;
							$image 		= $name . '.' . $type;
							$name 		= 'COM_RESERVATION_DASHBOARD_' . ReservationHelper::safeString($name,'U');
							$hover		= false;
						}
					}
					else
					{
						$viewName 	= $view;
						$alt 		= $view;
						$url 		= 'index.php?option=com_reservation&view=' . $view;
						$image 		= $view . '.png';
						$name 		= ucwords($view).'<br /><br />';
						$hover		= false;
					}
					// first make sure the view access is set
					if (ReservationHelper::checkArray($viewAccess))
					{
						// setup some defaults
						$dashboard_add = false;
						$dashboard_list = false;
						$accessTo = '';
						$accessAdd = '';
						// access checking start
						$accessCreate = (isset($viewAccess[$viewName.'.create'])) ? ReservationHelper::checkString($viewAccess[$viewName.'.create']):false;
						$accessAccess = (isset($viewAccess[$viewName.'.access'])) ? ReservationHelper::checkString($viewAccess[$viewName.'.access']):false;
						// set main controllers
						$accessDashboard_add = (isset($viewAccess[$viewName.'.dashboard_add'])) ? ReservationHelper::checkString($viewAccess[$viewName.'.dashboard_add']):false;
						$accessDashboard_list = (isset($viewAccess[$viewName.'.dashboard_list'])) ? ReservationHelper::checkString($viewAccess[$viewName.'.dashboard_list']):false;
						// check for adding access
						if ($add && $accessCreate)
						{
							$accessAdd = $viewAccess[$viewName.'.create'];
						}
						elseif ($add)
						{
							$accessAdd = 'core.create';
						}
						// check if access to view is set
						if ($accessAccess)
						{
							$accessTo = $viewAccess[$viewName.'.access'];
						}
						// set main access controllers
						if ($accessDashboard_add)
						{
							$dashboard_add	= $user->authorise($viewAccess[$viewName.'.dashboard_add'], 'com_reservation');
						}
						if ($accessDashboard_list)
						{
							$dashboard_list = $user->authorise($viewAccess[$viewName.'.dashboard_list'], 'com_reservation');
						}
						if (ReservationHelper::checkString($accessAdd) && ReservationHelper::checkString($accessTo))
						{
							// check access
							if($user->authorise($accessAdd, 'com_reservation') && $user->authorise($accessTo, 'com_reservation') && $dashboard_add)
							{
								$icons[$group][$i]			= new StdClass;
								$icons[$group][$i]->url 	= $url;
								$icons[$group][$i]->name 	= $name;
								$icons[$group][$i]->image 	= $image;
								$icons[$group][$i]->alt 	= $alt;
							}
						}
						elseif (ReservationHelper::checkString($accessTo))
						{
							// check access
							if($user->authorise($accessTo, 'com_reservation') && $dashboard_list)
							{
								$icons[$group][$i]			= new StdClass;
								$icons[$group][$i]->url 	= $url;
								$icons[$group][$i]->name 	= $name;
								$icons[$group][$i]->image 	= $image;
								$icons[$group][$i]->alt 	= $alt;
							}
						}
						elseif (ReservationHelper::checkString($accessAdd))
						{
							// check access
							if($user->authorise($accessAdd, 'com_reservation') && $dashboard_add)
							{
								$icons[$group][$i]			= new StdClass;
								$icons[$group][$i]->url 	= $url;
								$icons[$group][$i]->name 	= $name;
								$icons[$group][$i]->image 	= $image;
								$icons[$group][$i]->alt 	= $alt;
							}
						}
						else
						{
							$icons[$group][$i]			= new StdClass;
							$icons[$group][$i]->url 	= $url;
							$icons[$group][$i]->name 	= $name;
							$icons[$group][$i]->image 	= $image;
							$icons[$group][$i]->alt 	= $alt;
						}
					}
					else
					{
						$icons[$group][$i]			= new StdClass;
						$icons[$group][$i]->url 	= $url;
						$icons[$group][$i]->name 	= $name;
						$icons[$group][$i]->image 	= $image;
						$icons[$group][$i]->alt 	= $alt;
					}
					$i++;
				}
			}
			else
			{
					$icons[$group][$i] = false;
			}
		}
		return $icons;
	}
}
