<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				fdsh 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.31
	@build			8th May, 2021
	@created		17th December, 2020
	@package		Reservation
	@subpackage		orders.php
	@author			farhad shahbazi <http://farhad.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\Utilities\ArrayHelper;

/**
 * Orders Controller
 */
class ReservationControllerOrders extends JControllerAdmin
{
	/**
	 * The prefix to use with controller messages.
	 *
	 * @var    string
	 * @since  1.6
	 */
	protected $text_prefix = 'COM_RESERVATION_ORDERS';

	/**
	 * Method to get a model object, loading it if required.
	 *
	 * @param   string  $name    The model name. Optional.
	 * @param   string  $prefix  The class prefix. Optional.
	 * @param   array   $config  Configuration array for model. Optional.
	 *
	 * @return  JModelLegacy  The model.
	 *
	 * @since   1.6
	 */
	public function getModel($name = 'Order', $prefix = 'ReservationModel', $config = array('ignore_request' => true))
	{
		return parent::getModel($name, $prefix, $config);
	}

	public function exportData()
	{
		// Check for request forgeries
		JSession::checkToken() or die(JText::_('JINVALID_TOKEN'));
		// check if export is allowed for this user.
		$user = JFactory::getUser();
		if ($user->authorise('order.export', 'com_reservation') && $user->authorise('core.export', 'com_reservation'))
		{
			// Get the input
			$input = JFactory::getApplication()->input;
			$pks = $input->post->get('cid', array(), 'array');
			// Sanitize the input
			$pks = ArrayHelper::toInteger($pks);
			// Get the model
			$model = $this->getModel('Orders');
			// get the data to export
			$data = $model->getExportData($pks);
			if (ReservationHelper::checkArray($data))
			{
				// now set the data to the spreadsheet
				$date = JFactory::getDate();
				ReservationHelper::xls($data,'Orders_'.$date->format('jS_F_Y'),'Orders exported ('.$date->format('jS F, Y').')','orders');
			}
		}
		// Redirect to the list screen with error.
		$message = JText::_('COM_RESERVATION_EXPORT_FAILED');
		$this->setRedirect(JRoute::_('index.php?option=com_reservation&view=orders', false), $message, 'error');
		return;
	}


	public function importData()
	{
		// Check for request forgeries
		JSession::checkToken() or die(JText::_('JINVALID_TOKEN'));
		// check if import is allowed for this user.
		$user = JFactory::getUser();
		if ($user->authorise('order.import', 'com_reservation') && $user->authorise('core.import', 'com_reservation'))
		{
			// Get the import model
			$model = $this->getModel('Orders');
			// get the headers to import
			$headers = $model->getExImPortHeaders();
			if (ReservationHelper::checkObject($headers))
			{
				// Load headers to session.
				$session = JFactory::getSession();
				$headers = json_encode($headers);
				$session->set('order_VDM_IMPORTHEADERS', $headers);
				$session->set('backto_VDM_IMPORT', 'orders');
				$session->set('dataType_VDM_IMPORTINTO', 'order');
				// Redirect to import view.
				$message = JText::_('COM_RESERVATION_IMPORT_SELECT_FILE_FOR_ORDERS');
				$this->setRedirect(JRoute::_('index.php?option=com_reservation&view=import', false), $message);
				return;
			}
		}
		// Redirect to the list screen with error.
		$message = JText::_('COM_RESERVATION_IMPORT_FAILED');
		$this->setRedirect(JRoute::_('index.php?option=com_reservation&view=orders', false), $message, 'error');
		return;
	}
}
