<?php
/*----------------------------------------------------------------------------------|  www.vdm.io  |----/
				fdsh 
/-------------------------------------------------------------------------------------------------------/

	@version		1.0.39
	@build			4th April, 2023
	@created		17th December, 2020
	@package		Reservation
	@subpackage		bbbclasses.php
	@author			farhad shahbazi <http://farhad.com>	
	@copyright		Copyright (C) 2015. All Rights Reserved
	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
  ____  _____  _____  __  __  __      __       ___  _____  __  __  ____  _____  _  _  ____  _  _  ____ 
 (_  _)(  _  )(  _  )(  \/  )(  )    /__\     / __)(  _  )(  \/  )(  _ \(  _  )( \( )( ___)( \( )(_  _)
.-_)(   )(_)(  )(_)(  )    (  )(__  /(__)\   ( (__  )(_)(  )    (  )___/ )(_)(  )  (  )__)  )  (   )(  
\____) (_____)(_____)(_/\/\_)(____)(__)(__)   \___)(_____)(_/\/\_)(__)  (_____)(_)\_)(____)(_)\_) (__) 

/------------------------------------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\Utilities\ArrayHelper;

/**
 * Bbbclasses Controller
 */
class ReservationControllerBbbclasses extends JControllerAdmin
{
	/**
	 * The prefix to use with controller messages.
	 *
	 * @var    string
	 * @since  1.6
	 */
	protected $text_prefix = 'COM_RESERVATION_BBBCLASSES';

	/**
	 * Method to get a model object, loading it if required.
	 *
	 * @param   string  $name    The model name. Optional.
	 * @param   string  $prefix  The class prefix. Optional.
	 * @param   array   $config  Configuration array for model. Optional.
	 *
	 * @return  JModelLegacy  The model.
	 *
	 * @since   1.6
	 */
	public function getModel($name = 'Bbbclass', $prefix = 'ReservationModel', $config = array('ignore_request' => true))
	{
		return parent::getModel($name, $prefix, $config);
	}

	public function exportData()
	{
		// Check for request forgeries
		JSession::checkToken() or die(JText::_('JINVALID_TOKEN'));
		// check if export is allowed for this user.
		$user = JFactory::getUser();
		if ($user->authorise('bbbclass.export', 'com_reservation') && $user->authorise('core.export', 'com_reservation'))
		{
			// Get the input
			$input = JFactory::getApplication()->input;
			$pks = $input->post->get('cid', array(), 'array');
			// Sanitize the input
			$pks = ArrayHelper::toInteger($pks);
			// Get the model
			$model = $this->getModel('Bbbclasses');
			// get the data to export
			$data = $model->getExportData($pks);
			if (ReservationHelper::checkArray($data))
			{
				// now set the data to the spreadsheet
				$date = JFactory::getDate();
				ReservationHelper::xls($data,'Bbbclasses_'.$date->format('jS_F_Y'),'Bbbclasses exported ('.$date->format('jS F, Y').')','bbbclasses');
			}
		}
		// Redirect to the list screen with error.
		$message = JText::_('COM_RESERVATION_EXPORT_FAILED');
		$this->setRedirect(JRoute::_('index.php?option=com_reservation&view=bbbclasses', false), $message, 'error');
		return;
	}


	public function importData()
	{
		// Check for request forgeries
		JSession::checkToken() or die(JText::_('JINVALID_TOKEN'));
		// check if import is allowed for this user.
		$user = JFactory::getUser();
		if ($user->authorise('bbbclass.import', 'com_reservation') && $user->authorise('core.import', 'com_reservation'))
		{
			// Get the import model
			$model = $this->getModel('Bbbclasses');
			// get the headers to import
			$headers = $model->getExImPortHeaders();
			if (ReservationHelper::checkObject($headers))
			{
				// Load headers to session.
				$session = JFactory::getSession();
				$headers = json_encode($headers);
				$session->set('bbbclass_VDM_IMPORTHEADERS', $headers);
				$session->set('backto_VDM_IMPORT', 'bbbclasses');
				$session->set('dataType_VDM_IMPORTINTO', 'bbbclass');
				// Redirect to import view.
				$message = JText::_('COM_RESERVATION_IMPORT_SELECT_FILE_FOR_BBBCLASSES');
				$this->setRedirect(JRoute::_('index.php?option=com_reservation&view=import', false), $message);
				return;
			}
		}
		// Redirect to the list screen with error.
		$message = JText::_('COM_RESERVATION_IMPORT_FAILED');
		$this->setRedirect(JRoute::_('index.php?option=com_reservation&view=bbbclasses', false), $message, 'error');
		return;
	}
}
