<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_notifly
 *
 * @copyright   Copyright (C) 2005 - 2017 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\Registry\Registry;

// Include the component HTML helpers.
JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');
JHtml::_('behavior.formvalidator');
JHtml::_('behavior.keepalive');
JHtml::_('formbehavior.chosen', '#jform_catid', null, array('disable_search_threshold' => 0 ));
JHtml::_('formbehavior.chosen', 'select');

// Create shortcut to parameters.
$params = clone($this->state->get('params'));
$params->merge(new Registry($this->item->attribs));

$app = JFactory::getApplication();
$input = $app->input;

JFactory::getDocument()->addScriptDeclaration('
	Joomla.submitbutton = function(task)
	{
		if (task == "template.cancel" || document.formvalidator.isValid(document.getElementById("item-form")))
		{
			jQuery("#permissions-sliders select").attr("disabled", "disabled");
			Joomla.submitform(task, document.getElementById("item-form"));

			// @deprecated 4.0  The following js is not needed since 3.7.0.
			if (task !== "template.apply")
			{
				window.parent.jQuery("#templateEdit' . (int) $this->item->id . 'Modal").modal("hide");
			}
		}
	};
');

// In case of modal
$isModal = $input->get('layout') == 'modal' ? true : false;
$layout  = $isModal ? 'modal' : 'edit';
$tmpl    = $isModal || $input->get('tmpl', '', 'cmd') === 'component' ? '&tmpl=component' : '';

JFactory::getDocument()->addScript('https://cdnjs.cloudflare.com/ajax/libs/showdown/1.8.1/showdown.min.js');
JFactory::getDocument()->addScript('https://rawgit.com/janl/mustache.js/master/mustache.min.js');
?>

<script>
	jQuery(function() {
		parseMessage();
		jQuery('#jform_message').bind('input propertychange', function(){
			parseMessage();
		});
  });
  var sample = {
		  title: "Awesome Product",
		  name: 'Parvez Akther',
		  country: 'BD',
		  city: 'Dhaka',
		  province: 'Dhaka',
		  url: 'https://www.themexpert.com',
		  time: "2h ago",
		  image_url : 'https://www.gravatar.com/avatar/8c9aaae8b39d1036f844f218caf3995e?s=80&d=mm&r=g',
		};
  function parseMessage(){
		var msg = jQuery('#jform_message').val();
		// Markdown converter
		var converter 		= new showdown.Converter(),
    		renderedHtml 	= converter.makeHtml(Mustache.render(msg, sample));
    jQuery('#preview > .notifly-image > img').attr('src', sample.image_url);
		jQuery('#preview .notifly-content').html(renderedHtml);
		jQuery('#preview time').html(sample.time);
	}
</script>

<form action="<?php echo JRoute::_('index.php?option=com_notifly&view=template&layout=' . $layout . $tmpl . '&id=' . (int) $this->item->id); ?>" method="post" name="adminForm" id="item-form" class="form-validate">
<div id="cf" class="template-edit tx-flex">
	<?php if (!empty( $this->sidebar)) : ?>
		<div class="tx-sidebar">
			<?php echo $this->sidebar; ?>
		</div>
	<?php endif;?>
	<div class="tx-main">
		<div class="page-header">
		  <h1>Edit Template</h1>
		  <!-- Nav tabs -->
		  <ul class="nav nav-tabs" role="tablist">
		    <li class="active"><a href="#message" aria-controls="home" role="tab" data-toggle="tab">Message</a></li>
		    <!-- <li><a href="#image" aria-controls="profile" role="tab" data-toggle="tab">Image</a></li> -->
		  </ul>
		</div> <!-- page header -->
		<div class="page-content">
			<div class="tab-content">
				<div class="tab-pane active" id="message">
					<div class="row">
						<div class="col-md-8">
							<div class="panel panel-default">
								<div class="panel-heading">Message Template</div>
								<div class="panel-body">
									<?php echo $this->form->renderField('name'); ?>
									<?php echo $this->form->renderField('message'); ?>
									<p><strong>Markdown supported</strong>: <code>*emphasized* _underline_ [Link Text](http://mycompany.com/url) **strong**</code></p>
									<p>
										<strong>Variables: </strong>
										<span class="label label-default">{{ name }}</span> 
										<span class="label label-default">{{ city }}</span> 
										<span class="label label-default">{{ province }}</span> 
										<span class="label label-default">{{ country }}</span> 
										<span class="label label-default">{{ title }}</span> 
										<span class="label label-default">{{ title_with_link }}</span> 
										<span class="label label-default">{{ url }}</span> 
										<span class="label label-default">{{ time_ago }}</span>
									</p>
									<?php echo $this->form->renderField('alias'); ?>
									<?php echo $this->form->renderField('extension_id'); ?>

								</div>
							</div>
						</div>
						<div class="col-md-4">
							<!-- 
							<h4>Preview</h4>
							<div class="panel panel-default">
								<div class="panel-body">
									Coming soon...
								</div>
							</div>
							 -->
						</div>
					</div>
				</div>
				<!-- 
				<div class="tab-pane" id="image">
					<div class="panel panel-default">
						<div class="panel-heading">Image Options</div>
						<div class="panel-body">
							<?php echo $this->form->renderField('image_disable'); ?>
							<?php echo $this->form->renderField('avatar'); ?>
							<?php echo $this->form->renderField('image_url'); ?>
						</div>
					</div>
				</div>
				 -->
			</div>
		</div>
	</div>
</div>

	<input type="hidden" name="task" value="" />
	<input type="hidden" name="return" value="<?php echo $input->getCmd('return'); ?>" />
	<?php echo JHtml::_('form.token'); ?>
</form>
