<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_notifly
 *
 * @copyright   Copyright (C) 2005 - 2017 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;
/**
 * Feature model.
 *
 * @since  1.6
 */
class NotiflyModelDesign extends JModelForm
{

	/**
	 * Method to get a form object.
	 *
	 * @param   array    $data      Data for the form.
	 * @param   boolean  $loadData  True if the form is to load its own data (default case), false if not.
	 *
	 * @return  mixed  A JForm object on success, false on failure
	 *
	 * @since	1.0.0
	 */
	public function getForm($data = array(), $loadData = true)
	{
		$form = $this->loadForm('com_notifly.design', 'design', array('control' => 'jform', 'load_data' => $loadData));
		
		if (empty($form))
		{
			return false;
		}

		return $form;
	}

	/**
	 * Get the component information.
	 *
	 * @return	object
	 *
	 * @since	1.0.0
	 */
	public function getComponent()
	{
		$state = $this->getState();
		$option = 'com_notifly';
		// Load common and local language files.
		$lang = JFactory::getLanguage();
		$lang->load($option, JPATH_BASE, null, false, true)
		|| $lang->load($option, JPATH_BASE . "/components/com_notifly", null, false, true);

		$result = JComponentHelper::getComponent($option);
		
		return $result;
	}

	/**
	 * Method to save the configuration data.
	 *
	 * @param   array  $data  An array containing all global design data.
	 *
	 * @return  boolean  True on success, false on failure.
	 *
	 * @since	1.0.0
	 * @throws  RuntimeException
	 */
	public function save($data)
	{
		$table	= JTable::getInstance('extension');

		// Load the previous Data
		if (!$table->load($data['id']))
		{
			throw new RuntimeException($table->getError());
		}

		unset($data['id']);

		// Bind the data.
		if (!$table->bind($data))
		{
			throw new RuntimeException($table->getError());
		}

		// Check the data.
		if (!$table->check())
		{
			throw new RuntimeException($table->getError());
		}

		// Store the data.
		if (!$table->store())
		{
			throw new RuntimeException($table->getError());
		}

		$this->cleanCache();
		return true;
	}

	/**
	 * Custom clean cache method, plugins are cached in 2 places for different clients.
	 *
	 * @param   string   $group      Cache group name.
	 * @param   integer  $client_id  Application client id.
	 *
	 * @return  void
	 *
	 * @since   1.6
	 */
	protected function cleanCache($group = null, $client_id = 0)
	{
		parent::cleanCache('_system', 0);
		parent::cleanCache('_system', 1);
		parent::cleanCache('com_notifly');
	}

	public static function getConfigs(){
		$comInfo = JComponentHelper::getComponent('com_notifly');
		return $comInfo->params;
	}
}
