<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_notifly
 *
 * @copyright   Copyright (C) 2005 - 2017 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

/**
 * Notifly component helper.
 *
 * @since  1.6
 */
class NotiflyEventsHelper
{

	public static function getList($random = false)
	{
		$events = NotiflyEventsHelper::getEvents($random);
		$results = [];
		foreach ($events as $key => $event) {
			$item = [];
			$item['message'] = NotiflyMessageHelper::parseMessage($event->message, $event);
			$item['image'] = $event->image_url;
			$item['url'] = $event->url;
			$results[] = $item;
		}
		// print_r($results);die;

		return $results;
	}

	public static function getEvents($random = false)
	{
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select("a.*, m.message")
			  ->from('#__notifly_events as a')			  
			  ->join('LEFT', '#__notifly_templates AS m ON m.id = a.template_id')
			  ->where($db->quoteName('a.published') . ' = 1');
		if($random){
			$query->order('rand() DESC');
		}else{
			$query->order($db->quoteName('a.id') . ' DESC');
		}

		// get the setLimit form config
		$query->setLimit('20');
		$db->setQuery($query);
		$result = $db->loadObjectList();
		return $result;
	}

}
