<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_notifly
 *
 * @copyright   Copyright (C) 2005 - 2017 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

// Autoload Composer
require __DIR__ . '/vendor/autoload.php';

/**
 * Component Controller
 *
 * @since  1.5
 */
class NotiflyController extends JControllerLegacy
{
	/**
	 * The default view.
	 *
	 * @var    string
	 * @since  1.6
	 */
	protected $default_view = 'dashboard';

	/**
	 * Method to display a view.
	 *
	 * @param   boolean  $cachable   If true, the view output will be cached
	 * @param   array    $urlparams  An array of safe URL parameters and their variable types, for valid values see {@link JFilterInput::clean()}.
	 *
	 * @return  NotiflyController  This object to support chaining.
	 *
	 * @since   1.5
	 */
	public function display($cachable = false, $urlparams = array())
	{
		JHtml::_('script', 'com_notifly/admin-notifly.js', array('version' => 'auto', 'relative' => true));
		// JHtml::_('stylesheet', 'com_notifly/admin-notifly.css', array('version' => 'auto', 'relative' => true));
		JHtml::_('stylesheet', 'com_notifly/notifly-admin.css', array('version' => 'auto', 'relative' => true));
		// JFactory::getDocument()->addStyleSheet( JUri::root(). '/media/com_notifly/css/notifly-admin.css');

		// $view   = $this->input->get('view', 'articles');
		// $layout = $this->input->get('layout', 'articles');
		// $id     = $this->input->getInt('id');

		// // Check for edit form.
		// if ($view == 'article' && $layout == 'edit' && !$this->checkEditId('com_notifly.edit.article', $id))
		// {
		// 	// Somehow the person just went to the form - we don't allow that.
		// 	$this->setError(JText::sprintf('JLIB_APPLICATION_ERROR_UNHELD_ID', $id));
		// 	$this->setMessage($this->getError(), 'error');
		// 	$this->setRedirect(JRoute::_('index.php?option=com_notifly&view=articles', false));

		// 	return false;
		// }
		
		return parent::display();
	}
}
